/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import util.DJ;
import util.LogEditor;
import util.TimeStamp;
import view.ColorPaletPanel;
import view.Console;
import view.PropertyViewer;
import view.SomDrawer;
import view.SomGraphViewer_button_actionAdapter;
import view.SomGraphViewer_rangeTextField_actionAdapter;
import view.SomGraphViewer_setButton_actionAdapter;
import view.SomGraphViewer_settingTextField_actionAdapter;
import view.Viewer;

public class SomViewer
extends Viewer {
    public static final String BOUNDS_NAME = "somBounds";
    public static final int SOM_GENERAL = 0;
    public static final int SOM_ANIMAL = 1;
    public static final int SOM_PLANT = 2;
    public static final int SOM_LETTER = 3;
    public static final int SOM_VOICE = 4;
    public static final String VIEWER_TITLE = "SOM viewer";
    StringBuffer comment;
    boolean packFrame = false;
    SomDrawer graph = new SomDrawer();
    float[] dataValue;
    String[] nodeNames;
    static final Point DEFAULT_LOCATION = new Point(595, 10);
    static final Dimension DEFAULT_DIMENSION = new Dimension(470, 640);
    static final int MAX_DATA = 16;
    static final int MAX_CONTOUR = 100;
    static final int TYPE_NOTHING = 0;
    static final int TYPE_RESIDUE = 1;
    static final int TYPE_QUOTIENT = 2;
    static final int TYPE_LABEL = 3;
    String[] factorNames;
    int numOfFactor;
    double[][] factorVectors;
    String[] factorLabels;
    double[][] codeVectorArray;
    int dimOfFactor;
    int dimOfCodeX;
    int dimOfCodeY;
    int numOfCodeVector;
    double[][] elemetMap;
    double learningCount;
    double[][] uMatrix;
    int dimOfUX;
    int dimOfUY;
    boolean umapFlag;
    boolean elementFlag;
    boolean evaluateFlag;
    boolean borderFlag;
    String[][] labelMap;
    String elementName;
    int elementNo;
    Color buttonColor;
    int numOfTrial = 0;
    int evaluationType = 0;
    int numOfContour = 10;
    int baseContour = 10;
    double borderContour = 0.2;
    int uMapXSize = 400;
    int uMapYSize = 400;
    SomGraphViewer_button_actionAdapter buttonAdapter = new SomGraphViewer_button_actionAdapter(this);
    SomGraphViewer_setButton_actionAdapter setButtonAdapter = new SomGraphViewer_setButton_actionAdapter(this);
    SomGraphViewer_settingTextField_actionAdapter settingTextFieldAdapter = new SomGraphViewer_settingTextField_actionAdapter(this);
    SomGraphViewer_rangeTextField_actionAdapter rangeTextFieldAdapter = new SomGraphViewer_rangeTextField_actionAdapter(this);
    BorderLayout graphViewerBorderLayout = new BorderLayout();
    Panel mainPanel = new Panel();
    BorderLayout mainPanelBorderLayout = new BorderLayout();
    Panel graphPanel = new Panel();
    BorderLayout graphBorderLayout = new BorderLayout();
    Panel graphTitlePanel = new Panel();
    Label graphTitileLabel = new Label();
    BorderLayout graphTitlePanelBorderLayout = new BorderLayout();
    JPanel graphsubPanel = new JPanel();
    BorderLayout graphsubBorderLayout = new BorderLayout();
    Panel operatePanel = new Panel();
    BorderLayout operatePanelBorderLayout = new BorderLayout();
    Panel modePanel = new Panel();
    GridLayout modePanelGridLayout = new GridLayout();
    Panel contorlPanel = new Panel();
    BorderLayout controlBorderLayout = new BorderLayout();
    ColorPaletPanel colorPaletPanel = new ColorPaletPanel(this.graph);
    Panel settingPanel = new Panel();
    GridLayout settingPanelGridLayout = new GridLayout();
    Label modeLabel = new Label();
    Button umapButton = new Button();
    Button elementButton = new Button();
    Panel valuePanel = new Panel();
    GridLayout valueGridLayout = new GridLayout();
    Label valueLabel = new Label();
    TextField elementNameTextField = new TextField();
    TextField onValueTextField = new TextField();
    TextField offValueTextField = new TextField();
    Panel timePanel = new Panel();
    GridLayout timeGridLayout = new GridLayout();
    Button firstButton = new Button();
    Button backButton = new Button();
    Button nextButton = new Button();
    Button lastButton = new Button();
    Panel trialPanel = new Panel();
    GridLayout trialGridLayout = new GridLayout();
    Label trialLabel = new Label();
    TextField trialTextField = new TextField();
    Panel mapSetPanel = new Panel();
    GridLayout mapGridLayout = new GridLayout();
    Label contourLabel = new Label();
    Panel contourSetPanel = new Panel();
    GridLayout gridLayout0 = new GridLayout();
    Panel rangePanel = new Panel();
    GridLayout rengPanelGridLayout = new GridLayout();
    Panel setRangPanel = new Panel();
    GridLayout rangGridLayout = new GridLayout();
    Button evaluateButton = new Button();
    Button borderButton = new Button();
    Button setButton = new Button();
    Button saveButton = new Button();
    Panel xRangePanel = new Panel();
    GridLayout gridLayout1 = new GridLayout();
    Label xLabel = new Label();
    TextField uMapXSizeTextField = new TextField();
    Label typeLabel = new Label();
    TextField evaluationTypeTextField = new TextField();
    Panel yRangePanel = new Panel();
    GridLayout gridLayout2 = new GridLayout();
    Label yLabel = new Label();
    TextField uMapYSizeTextField = new TextField();
    Label baseLabel = new Label();
    TextField baseTextField = new TextField();
    Panel borderSetPanel = new Panel();
    GridLayout gridLayout3 = new GridLayout();
    Label borderLabel = new Label();
    Panel borderPanel = new Panel();
    GridLayout borderGridLayout = new GridLayout();
    Button upBorderButton = new Button();
    Button downBorderButton = new Button();
    TextField zMinTextField = new TextField();
    TextField borderContourTextField = new TextField();
    Panel contourPanel = new Panel();
    GridLayout contourGridLayout = new GridLayout();
    Button upContourButton = new Button();
    Button downContourButton = new Button();
    TextField numOfContourTextField = new TextField();
    Panel baseSetPanel = new Panel();
    GridLayout baseGridLayout = new GridLayout();
    Panel typeSetPanel = new Panel();
    GridLayout typeGridLayout = new GridLayout();

    public SomViewer() {
        this.comment = new StringBuffer();
        this.comment.append("Data : ");
        this.initialize();
        this.setBounds();
    }

    public void appendComment(String comment) {
        this.comment.append(comment);
        this.graphTitileLabel.setText(this.comment.toString());
    }

    public void setComment(String comment) {
        this.graphTitileLabel.setText(comment);
    }

    public final void setBounds() {
        PropertyViewer propertyViewer = DJ.getPropertyViewer();
        Rectangle rect = propertyViewer.getBoundsValue(BOUNDS_NAME);
        if (rect != null) {
            this.setBounds(rect);
        } else {
            this.setLocation(DEFAULT_LOCATION);
            this.setSize(DEFAULT_DIMENSION);
        }
    }

    private void initialize() {
        try {
            this.initComponents();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.elementName = "Item Name";
        this.elementNo = 0;
        this.umapFlag = true;
        this.elementFlag = false;
        this.evaluateFlag = false;
        this.borderFlag = false;
        this.buttonColor = this.borderButton.getBackground();
    }

    private void initComponents() throws Exception {
        this.setIconImage(Console.icon16);
        this.setTitle("DaiJa : SOM viewer");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLayout(this.graphViewerBorderLayout);
        this.mainPanel.setLayout(this.mainPanelBorderLayout);
        this.mainPanelBorderLayout.setVgap(5);
        this.graphPanel.setLayout(this.graphBorderLayout);
        this.graphTitileLabel.setFont(new Font("Dialog", 1, 14));
        this.graphTitileLabel.setText(this.comment.toString());
        this.graphTitlePanel.setLayout(this.graphTitlePanelBorderLayout);
        this.operatePanel.setLayout(this.operatePanelBorderLayout);
        this.operatePanelBorderLayout.setHgap(5);
        this.evaluateButton.setLabel("Evaluate");
        this.evaluateButton.addActionListener(this.setButtonAdapter);
        this.borderButton.setLabel("Border");
        this.borderButton.addActionListener(this.setButtonAdapter);
        this.saveButton.setLabel("Save SOM");
        this.saveButton.addActionListener(this.setButtonAdapter);
        this.setButton.setLabel("SET");
        this.setButton.addActionListener(this.setButtonAdapter);
        this.rangePanel.setLayout(this.rengPanelGridLayout);
        this.evaluationTypeTextField.setText("1");
        this.evaluationTypeTextField.addActionListener(this.rangeTextFieldAdapter);
        this.uMapXSizeTextField.setText("400");
        this.uMapXSizeTextField.addActionListener(this.rangeTextFieldAdapter);
        this.baseTextField.setText("16");
        this.baseTextField.addActionListener(this.rangeTextFieldAdapter);
        this.uMapYSizeTextField.setText("400");
        this.uMapYSizeTextField.addActionListener(this.rangeTextFieldAdapter);
        this.zMinTextField.setText("0.0");
        this.zMinTextField.addActionListener(this.rangeTextFieldAdapter);
        this.borderContourTextField.setText("0.5");
        this.borderContourTextField.addActionListener(this.rangeTextFieldAdapter);
        this.contourLabel.setAlignment(1);
        this.contourLabel.setText("Contour");
        this.upContourButton.setLabel("\u25b2");
        this.upContourButton.addActionListener(this.setButtonAdapter);
        this.downContourButton.setLabel("\u25bc");
        this.downContourButton.addActionListener(this.setButtonAdapter);
        this.numOfContourTextField.setText("15");
        this.numOfContourTextField.addActionListener(this.rangeTextFieldAdapter);
        this.xLabel.setAlignment(1);
        this.xLabel.setText("X");
        this.yLabel.setAlignment(1);
        this.yLabel.setText("Y");
        this.typeLabel.setAlignment(1);
        this.typeLabel.setText("Type");
        this.baseLabel.setAlignment(1);
        this.baseLabel.setText("Base");
        this.borderLabel.setAlignment(1);
        this.borderLabel.setText("Border");
        this.upBorderButton.setLabel("\u25b3");
        this.upBorderButton.addActionListener(this.setButtonAdapter);
        this.downBorderButton.setLabel("\u25bd");
        this.downBorderButton.addActionListener(this.setButtonAdapter);
        this.rengPanelGridLayout.setColumns(1);
        this.rengPanelGridLayout.setRows(5);
        this.rengPanelGridLayout.setVgap(3);
        this.contourSetPanel.setLayout(this.gridLayout0);
        this.xRangePanel.setLayout(this.gridLayout1);
        this.yRangePanel.setLayout(this.gridLayout2);
        this.borderSetPanel.setLayout(this.gridLayout3);
        this.setRangPanel.setLayout(this.rangGridLayout);
        this.borderPanel.setLayout(this.borderGridLayout);
        this.contourPanel.setLayout(this.contourGridLayout);
        this.baseSetPanel.setLayout(this.baseGridLayout);
        this.typeSetPanel.setLayout(this.typeGridLayout);
        this.modePanel.setLayout(this.modePanelGridLayout);
        this.modePanelGridLayout.setColumns(1);
        this.modePanelGridLayout.setRows(4);
        this.contorlPanel.setLayout(this.controlBorderLayout);
        this.modeLabel.setText("Mode");
        this.umapButton.setLabel("U-Map");
        this.umapButton.addActionListener(this.buttonAdapter);
        this.elementButton.setLabel("Element");
        this.elementButton.addActionListener(this.buttonAdapter);
        this.settingPanelGridLayout.setColumns(1);
        this.settingPanelGridLayout.setRows(4);
        this.timePanel.setLayout(this.timeGridLayout);
        this.timeGridLayout.setColumns(4);
        this.firstButton.setLabel("|<<");
        this.firstButton.addActionListener(this.buttonAdapter);
        this.backButton.setLabel("<");
        this.backButton.addActionListener(this.buttonAdapter);
        this.nextButton.setLabel(">");
        this.nextButton.addActionListener(this.buttonAdapter);
        this.lastButton.setLabel(">>|");
        this.lastButton.addActionListener(this.buttonAdapter);
        this.valuePanel.setLayout(this.valueGridLayout);
        this.valueGridLayout.setColumns(4);
        this.valueLabel.setAlignment(1);
        this.valueLabel.setText("Element");
        this.elementNameTextField.setText("Name");
        this.offValueTextField.setEditable(false);
        this.offValueTextField.setText("1");
        this.onValueTextField.setText("0");
        this.onValueTextField.addActionListener(this.settingTextFieldAdapter);
        this.trialPanel.setLayout(this.trialGridLayout);
        this.trialGridLayout.setColumns(2);
        this.trialLabel.setAlignment(1);
        this.trialLabel.setText("Trial");
        this.trialTextField.setText("50");
        this.trialTextField.addActionListener(this.settingTextFieldAdapter);
        this.mapSetPanel.setLayout(this.mapGridLayout);
        this.mapGridLayout.setColumns(4);
        this.mapSetPanel.add((Component)this.xLabel, null);
        this.mapSetPanel.add((Component)this.uMapXSizeTextField, null);
        this.mapSetPanel.add((Component)this.yLabel, null);
        this.mapSetPanel.add((Component)this.uMapYSizeTextField, null);
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.graphTitlePanel, "North");
        this.mainPanel.add((Component)this.graphPanel, "Center");
        this.mainPanel.add((Component)this.operatePanel, "South");
        this.graphTitlePanel.add((Component)this.graphTitileLabel, "West");
        this.graphPanel.add((Component)this.graph, "Center");
        this.operatePanel.add((Component)this.modePanel, "West");
        this.operatePanel.add((Component)this.contorlPanel, "Center");
        this.xRangePanel.add((Component)this.valueLabel, null);
        this.xRangePanel.add((Component)this.elementNameTextField, null);
        this.xRangePanel.add((Component)this.onValueTextField, null);
        this.xRangePanel.add((Component)this.offValueTextField, null);
        this.yRangePanel.add((Component)this.firstButton, null);
        this.yRangePanel.add((Component)this.backButton, null);
        this.yRangePanel.add((Component)this.nextButton, null);
        this.yRangePanel.add((Component)this.lastButton, null);
        this.contourSetPanel.add((Component)this.contourLabel, null);
        this.contourSetPanel.add((Component)this.numOfContourTextField, null);
        this.contourSetPanel.add((Component)this.contourPanel, null);
        this.contourPanel.add((Component)this.upContourButton, null);
        this.contourPanel.add((Component)this.downContourButton, null);
        this.contourSetPanel.add((Component)this.baseSetPanel, null);
        this.baseSetPanel.add((Component)this.baseLabel, null);
        this.baseSetPanel.add((Component)this.baseTextField, null);
        this.borderSetPanel.add((Component)this.borderLabel, null);
        this.borderSetPanel.add((Component)this.borderContourTextField, null);
        this.borderSetPanel.add((Component)this.borderPanel, null);
        this.borderPanel.add((Component)this.upBorderButton, null);
        this.borderPanel.add((Component)this.downBorderButton, null);
        this.borderSetPanel.add((Component)this.typeSetPanel, null);
        this.typeSetPanel.add((Component)this.typeLabel, null);
        this.typeSetPanel.add((Component)this.evaluationTypeTextField, null);
        this.rangePanel.add((Component)this.setRangPanel, null);
        this.rangePanel.add((Component)this.contourSetPanel, null);
        this.rangePanel.add((Component)this.xRangePanel, null);
        this.rangePanel.add((Component)this.yRangePanel, null);
        this.rangePanel.add((Component)this.borderSetPanel, null);
        this.operatePanel.add((Component)this.rangePanel, "East");
        this.modePanel.add((Component)this.umapButton, null);
        this.modePanel.add((Component)this.elementButton, null);
        this.modePanel.add((Component)this.evaluateButton, null);
        this.modePanel.add((Component)this.borderButton, null);
        this.contorlPanel.add((Component)this.colorPaletPanel, "Center");
        this.contorlPanel.add((Component)this.saveButton, "South");
        this.setRangPanel.add((Component)this.trialPanel, null);
        this.trialPanel.add((Component)this.trialLabel, null);
        this.trialPanel.add((Component)this.trialTextField, null);
        this.setRangPanel.add((Component)this.mapSetPanel, null);
        Dimension rangeDim = new Dimension(260, 120);
        this.rangePanel.setPreferredSize(rangeDim);
        if (this.packFrame) {
            this.pack();
        } else {
            this.validate();
        }
    }

    public void setProperty(int numOfTrial, int evaluationType, int numOfContour, int baseContour, double borderContour, int uMapXSize, int uMapYSize) {
        this.numOfTrial = numOfTrial;
        this.evaluationType = evaluationType;
        this.numOfContour = numOfContour;
        this.baseContour = baseContour;
        this.borderContour = borderContour;
        this.uMapXSize = uMapXSize;
        this.uMapYSize = uMapYSize;
        this.setEvaluationType(String.valueOf(evaluationType));
        this.setNumOfContour(String.valueOf(numOfContour));
        this.setBaseContour(String.valueOf(baseContour));
        this.setBorderContour(String.valueOf(borderContour));
        this.setUMapXSize(String.valueOf(uMapXSize));
        this.setUMapYSize(String.valueOf(uMapYSize));
    }

    public void setParameter(int dimOfFactor, int dimOfCodeX, int dimOfCodeY, String[] factorNames, int numOfFactor, double[][] factorVectors, String[] factorLabels) {
        this.factorNames = factorNames;
        this.dimOfFactor = dimOfFactor;
        this.dimOfCodeX = dimOfCodeX;
        this.dimOfCodeY = dimOfCodeY;
        this.numOfFactor = numOfFactor;
        this.factorVectors = factorVectors;
        this.factorLabels = factorLabels;
        this.numOfCodeVector = dimOfCodeX * dimOfCodeY;
        this.dimOfUX = dimOfCodeX * 2;
        this.dimOfUY = dimOfCodeY * 2;
        this.elemetMap = new double[this.dimOfUX][this.dimOfUY];
    }

    public void setMap(double[][] codeVectorArray, double[][] uMatrix, String[][] labelMap) {
        this.codeVectorArray = codeVectorArray;
        this.uMatrix = uMatrix;
        this.labelMap = labelMap;
    }

    void updateMap() {
        double[][] aRegionMap;
        if (this.umapFlag) {
            this.graph.setUMap(this.uMatrix);
        }
        if (this.elementFlag) {
            this.compositeElementMap();
            this.graph.setCodeMap(this.elemetMap);
            this.offValueTextField.setText(String.valueOf(this.dimOfFactor));
            this.onValueTextField.setText(String.valueOf(this.elementNo));
            this.elementName = this.factorNames[this.elementNo];
            this.elementNameTextField.setText(this.elementName);
        } else if (this.evaluateFlag && (aRegionMap = this.regionMap()) != null) {
            this.graph.setCodeMap(aRegionMap);
        }
        this.graph.setLabelMap(this.labelMap);
        this.trialTextField.setText(String.valueOf(this.learningCount));
        this.graph.repaint();
    }

    public void updateMap(int iCount) {
        this.learningCount = iCount;
        this.updateMap();
    }

    void compositeElementMap() {
        for (int i = 0; i < this.dimOfCodeX; ++i) {
            int iu = i * 2;
            int iu1 = iu + 1;
            for (int j = 0; j < this.dimOfCodeY; ++j) {
                int ju = j * 2;
                int ju1 = ju + 1;
                if (i < this.dimOfCodeX - 1 && j < this.dimOfCodeY - 1) {
                    this.elemetMap[iu][ju] = this.codeVectorArray[i + j * this.dimOfCodeX][this.elementNo];
                    this.elemetMap[iu1][ju] = (this.elemetMap[iu][ju] + this.codeVectorArray[i + 1 + j * this.dimOfCodeX][this.elementNo]) / 2.0;
                    this.elemetMap[iu][ju1] = (this.elemetMap[iu][ju] + this.codeVectorArray[i + (j + 1) * this.dimOfCodeX][this.elementNo]) / 2.0;
                    this.elemetMap[iu1][ju1] = (this.elemetMap[iu][ju] + this.codeVectorArray[i + 1 + (j + 1) * this.dimOfCodeX][this.elementNo]) / 2.0;
                    continue;
                }
                if (i == this.dimOfCodeX - 1 && j < this.dimOfCodeY - 1) {
                    this.elemetMap[iu][ju] = this.codeVectorArray[i + j * this.dimOfCodeX][this.elementNo];
                    this.elemetMap[iu1][ju] = this.elemetMap[iu][ju] + (-this.elemetMap[iu][ju] + this.codeVectorArray[i - 1 + j * this.dimOfCodeX][this.elementNo]) / 2.0;
                    this.elemetMap[iu][ju1] = (this.elemetMap[iu][ju] + this.codeVectorArray[i + (j + 1) * this.dimOfCodeX][this.elementNo]) / 2.0;
                    this.elemetMap[iu1][ju1] = this.elemetMap[iu][ju1];
                    continue;
                }
                if (i < this.dimOfCodeX - 1 && j == this.dimOfCodeY - 1) {
                    this.elemetMap[iu][ju] = this.codeVectorArray[i + j * this.dimOfCodeX][this.elementNo];
                    this.elemetMap[iu1][ju] = (this.elemetMap[iu][ju] + this.codeVectorArray[i + 1 + j * this.dimOfCodeX][this.elementNo]) / 2.0;
                    this.elemetMap[iu][ju1] = i + (j - 1) * this.dimOfCodeX < 0 ? this.elemetMap[iu][ju] : this.elemetMap[iu][ju] + (-this.elemetMap[iu][ju] + this.codeVectorArray[i + (j - 1) * this.dimOfCodeX][this.elementNo]) / 2.0;
                    this.elemetMap[iu1][ju1] = this.elemetMap[iu1][ju];
                    continue;
                }
                this.elemetMap[iu][ju] = this.codeVectorArray[i + j * this.dimOfCodeX][this.elementNo];
                if (i - 1 < 0 || j - 1 < 0) {
                    this.elemetMap[iu1][ju] = this.elemetMap[iu][ju];
                    this.elemetMap[iu][ju1] = this.elemetMap[iu][ju];
                    this.elemetMap[iu1][ju1] = this.elemetMap[iu][ju];
                    continue;
                }
                this.elemetMap[iu1][ju] = this.elemetMap[iu][ju] + (-this.elemetMap[iu][ju] + this.codeVectorArray[i - 1 + j * this.dimOfCodeX][this.elementNo]) / 2.0;
                this.elemetMap[iu][ju1] = this.elemetMap[iu][ju] + (-this.elemetMap[iu][ju] + this.codeVectorArray[i + (j - 1) * this.dimOfCodeX][this.elementNo]) / 2.0;
                this.elemetMap[iu1][ju1] = this.elemetMap[iu][ju] + (-this.elemetMap[iu][ju] + this.codeVectorArray[i - 1 + (j - 1) * this.dimOfCodeX][this.elementNo]) / 2.0;
            }
        }
    }

    double[][] regionMap() {
        int i;
        int[] bestMatches = new int[this.numOfCodeVector];
        int type = Integer.parseInt(this.evaluationTypeTextField.getText().trim());
        int base = Integer.parseInt(this.baseTextField.getText().trim());
        for (i = 0; i < this.numOfCodeVector; ++i) {
            double leastNorm = Double.MAX_VALUE;
            bestMatches[i] = 0;
            block6: for (int j = 0; j < this.numOfFactor; ++j) {
                double delta;
                double aNorm = 0.0;
                for (int k = 0; k < this.dimOfFactor && !((aNorm += (delta = this.codeVectorArray[i][k] - this.factorVectors[j][k]) * delta) > leastNorm); ++k) {
                }
                if (!(aNorm < leastNorm)) continue;
                leastNorm = aNorm;
                switch (type) {
                    case 1: {
                        bestMatches[i] = j % base;
                        continue block6;
                    }
                    case 2: {
                        bestMatches[i] = j / base;
                        continue block6;
                    }
                    case 3: {
                        String st = this.factorLabels[j].trim();
                        if (st.isEmpty()) continue block6;
                        bestMatches[i] = Integer.parseInt(st);
                        continue block6;
                    }
                }
            }
        }
        double[][] aRegionMap = new double[this.dimOfCodeX * 2][this.dimOfCodeY * 2];
        for (i = 0; i < this.dimOfCodeX; ++i) {
            int iu = i * 2;
            for (int j = 0; j < this.dimOfCodeY; ++j) {
                int ju = j * 2;
                double d = bestMatches[i + j * this.dimOfCodeX];
                aRegionMap[iu + 1][ju + 1] = d;
                aRegionMap[iu + 1][ju] = d;
                aRegionMap[iu][ju + 1] = d;
                aRegionMap[iu][ju] = d;
            }
        }
        return aRegionMap;
    }

    public String getViewerTitile() {
        return VIEWER_TITLE;
    }

    public String getUMapXSize() {
        return this.uMapXSizeTextField.getText().trim();
    }

    public void setUMapXSize(String uMapXSize) {
        this.uMapXSizeTextField.setText(uMapXSize.trim());
        this.graph.setUMapXSize(Float.parseFloat(uMapXSize.trim()));
    }

    public String getUMapYSize() {
        return this.uMapYSizeTextField.getText().trim();
    }

    public void setUMapYSize(String uMapYSize) {
        this.uMapYSizeTextField.setText(uMapYSize.trim());
        this.graph.setUMapYSize(Float.parseFloat(uMapYSize.trim()));
    }

    public String getEvaluationType() {
        return this.evaluationTypeTextField.getText().trim();
    }

    public void setEvaluationType(String evaluationType) {
        this.evaluationTypeTextField.setText(evaluationType.trim());
    }

    public String getBaseContour() {
        return this.baseTextField.getText().trim();
    }

    public void setBaseContour(String baseContour) {
        this.baseTextField.setText(baseContour.trim());
    }

    public String getBorderContour() {
        return this.borderContourTextField.getText().trim();
    }

    public void setBorderContour(String borderContour) {
        this.borderContourTextField.setText(borderContour.trim());
        this.graph.setZMax(Float.parseFloat(borderContour.trim()));
    }

    public String getNumOfContour() {
        return this.numOfContourTextField.getText().trim();
    }

    public void setNumOfContour(String numOfContour) {
        this.numOfContourTextField.setText(numOfContour.trim());
        this.graph.setNumOfContour(Float.parseFloat(numOfContour.trim()));
    }

    public void repaintGraph() {
        this.graph.repaint();
    }

    public double[][] getUMatrix() {
        return this.uMatrix;
    }

    public String[][] getLabelMatrix() {
        return this.labelMap;
    }

    public double getLearningCount() {
        return this.learningCount;
    }

    public void saveData() {
        int j;
        ArrayList<String> buf = new ArrayList<String>();
        buf.add(this.comment.toString() + "\r\n");
        StringTokenizer commentToken = new StringTokenizer(this.comment.toString(), ",");
        ArrayList<String> commentList = new ArrayList<String>();
        while (commentToken.hasMoreTokens()) {
            commentList.add(commentToken.nextToken());
        }
        StringBuilder fileName = new StringBuilder("SomCode_");
        if (!commentList.isEmpty()) {
            fileName.append((String)commentList.get(1)).append("-");
        }
        fileName.append(TimeStamp.getDateAndTime()).append(".dat");
        buf.add("Property:\r\n");
        buf.add("Number Of Trial = \r\n");
        buf.add(this.numOfTrial + "\r\n");
        buf.add("Evaluation Type = \r\n");
        buf.add(this.evaluationType + "\r\n");
        buf.add("Numbe Of Contour = \r\n");
        buf.add(this.numOfContour + "\r\n");
        buf.add("Base Contour = \r\n");
        buf.add(this.baseContour + "\r\n");
        buf.add("Border Contour = \r\n");
        buf.add(this.borderContour + "\r\n");
        buf.add("U-Map X-Axis Size = \r\n");
        buf.add(this.uMapXSize + "\r\n");
        buf.add("U-Map Y-Axis Size = \r\n");
        buf.add(this.uMapXSize + "\r\n");
        buf.add("Factor Vector:\r\n");
        buf.add("Dimension of factor = \r\n");
        buf.add(this.dimOfFactor + "\r\n");
        buf.add("factorNames:\r\n");
        buf.add("Factor Name = \r\n");
        if (this.dimOfFactor > 0) {
            buf.add(this.factorNames[0]);
            for (int k = 1; k < this.dimOfFactor; ++k) {
                buf.add("," + this.factorNames[k]);
            }
        }
        buf.add("\r\n");
        buf.add("factorVectors = \r\n");
        buf.add(this.numOfFactor + "\r\n");
        if (this.numOfFactor > 0) {
            this.addFactor(this.factorVectors, 0, buf);
            for (j = 1; j < this.numOfFactor; ++j) {
                this.addFactor(this.factorVectors, j, buf);
            }
        } else {
            buf.add("\r\n");
        }
        buf.add("Factor Label:\r\n");
        buf.add("factorLabels = \r\n");
        buf.add(this.numOfFactor + "\r\n");
        if (this.numOfFactor > 0) {
            buf.add(" " + this.factorLabels[0]);
            for (int i = 1; i < this.numOfFactor; ++i) {
                buf.add(", " + this.factorLabels[i]);
            }
        }
        buf.add("\r\n");
        buf.add("Code Vectors:\r\n");
        buf.add("Number of codeVectors =\r\n");
        buf.add(this.numOfCodeVector + "\r\n");
        buf.add("codeVectors = \r\n");
        if (this.numOfCodeVector > 0) {
            this.addFactor(this.codeVectorArray, 0, buf);
            for (j = 1; j < this.numOfCodeVector; ++j) {
                this.addFactor(this.codeVectorArray, j, buf);
            }
        } else {
            buf.add("\r\n");
        }
        buf.add("Label Map:\r\n");
        int row = this.labelMap.length;
        int col = this.labelMap[0].length;
        buf.add("Row number of Label Map = \r\n");
        buf.add(row + "\r\n");
        buf.add("Collumn number of Label Map = \r\n");
        buf.add(col + "\r\n");
        buf.add("Label Map =\r\n");
        if (row > 0) {
            this.addLabel(this.labelMap, 0, buf);
            for (int j2 = 1; j2 < row; ++j2) {
                this.addLabel(this.labelMap, j2, buf);
            }
        } else {
            buf.add("\r\n");
        }
        LogEditor.saveText(buf, fileName.toString());
    }

    void addFactor(double[][] array, int j, ArrayList<String> buf) {
        int col = array[j].length;
        if (col > 0) {
            buf.add(" " + array[j][0]);
            for (int i = 1; i < col; ++i) {
                buf.add(", " + array[j][i]);
            }
            buf.add("\r\n");
        }
    }

    void addLabel(String[][] array, int j, ArrayList<String> buf) {
        int col = array[j].length;
        if (col > 0) {
            buf.add(" " + array[j][0]);
            for (int i = 1; i < col; ++i) {
                buf.add(", " + array[j][i]);
            }
            buf.add("\r\n");
        }
    }

    void button_actionPerformed(ActionEvent e) {
        String cmd;
        switch (cmd = e.getActionCommand()) {
            case "Graph": {
                break;
            }
            case "U-Map": {
                this.elementFlag = false;
                this.elementButton.setBackground(this.buttonColor);
                this.evaluateFlag = false;
                this.evaluateButton.setBackground(this.buttonColor);
                this.borderFlag = false;
                this.borderButton.setBackground(this.buttonColor);
                this.graph.setEvaluateFlag(this.evaluateFlag);
                this.graph.setBorderFlag(this.borderFlag);
                this.umapFlag = true;
                this.umapButton.setBackground(Color.ORANGE);
                this.updateMap();
                break;
            }
            case "Element": {
                if (this.elementFlag) break;
                this.umapFlag = false;
                this.umapButton.setBackground(this.buttonColor);
                this.evaluateFlag = false;
                this.evaluateButton.setBackground(this.buttonColor);
                this.borderFlag = false;
                this.borderButton.setBackground(this.buttonColor);
                this.graph.setEvaluateFlag(this.evaluateFlag);
                this.graph.setBorderFlag(this.borderFlag);
                this.elementFlag = true;
                this.elementButton.setBackground(Color.ORANGE);
                this.updateMap();
                break;
            }
            case "|<<": {
                if (!this.elementFlag) {
                    this.umapFlag = false;
                    this.umapButton.setBackground(this.buttonColor);
                    this.elementFlag = true;
                    this.elementButton.setBackground(Color.ORANGE);
                }
                this.elementNo = 0;
                this.updateMap();
                break;
            }
            case "<": {
                int no;
                if (!this.elementFlag || (no = this.elementNo - 1) < 0) break;
                this.elementNo = no;
                this.updateMap();
                break;
            }
            case ">": {
                int no;
                if (!this.elementFlag || (no = this.elementNo + 1) >= this.dimOfFactor) break;
                this.elementNo = no;
                this.updateMap();
                break;
            }
            case ">>|": {
                if (!this.elementFlag) {
                    this.umapFlag = false;
                    this.umapButton.setBackground(this.buttonColor);
                    this.elementFlag = true;
                    this.elementButton.setBackground(Color.ORANGE);
                }
                this.elementNo = this.dimOfFactor - 1;
                this.updateMap();
                break;
            }
        }
    }

    void setButton_actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            switch (cmd) {
                case "SET": {
                    break;
                }
                case "Evaluate": {
                    if (this.evaluateFlag) {
                        this.evaluateFlag = false;
                        this.evaluateButton.setBackground(this.buttonColor);
                    } else {
                        this.umapFlag = false;
                        this.umapButton.setBackground(this.buttonColor);
                        this.elementFlag = false;
                        this.elementButton.setBackground(this.buttonColor);
                        this.borderFlag = false;
                        this.borderButton.setBackground(this.buttonColor);
                        this.evaluateFlag = true;
                        this.evaluateButton.setBackground(Color.ORANGE);
                    }
                    this.graph.setEvaluateFlag(this.evaluateFlag);
                    this.graph.setBorderFlag(this.borderFlag);
                    break;
                }
                case "Border": {
                    if (this.borderFlag) {
                        this.borderFlag = false;
                        this.borderButton.setBackground(this.buttonColor);
                    } else {
                        this.evaluateFlag = false;
                        this.evaluateButton.setBackground(this.buttonColor);
                        this.borderFlag = true;
                        this.borderButton.setBackground(Color.ORANGE);
                    }
                    this.graph.setEvaluateFlag(this.evaluateFlag);
                    this.graph.setBorderFlag(this.borderFlag);
                    break;
                }
                case "Save SOM": {
                    this.saveData();
                    break;
                }
                case "\u25b2": {
                    this.numOfContour = Integer.parseInt(this.numOfContourTextField.getText().trim());
                    this.numOfContourTextField.setText(String.valueOf(this.numOfContour + 1));
                    break;
                }
                case "\u25bc": {
                    this.numOfContour = Integer.parseInt(this.numOfContourTextField.getText().trim());
                    --this.numOfContour;
                    if (this.numOfContour <= 1) break;
                    this.numOfContourTextField.setText(String.valueOf(this.numOfContour));
                    break;
                }
                case "\u25b3": {
                    float borderLevel = Float.parseFloat(this.borderContourTextField.getText().trim());
                    if (borderLevel < 1.0E-4f) {
                        borderLevel = 0.1f;
                    }
                    borderLevel = borderLevel * 1.05f + 5.0E-5f;
                    int i = (int)(borderLevel * 10000.0f);
                    if ((borderLevel = (float)i / 10000.0f) > 1.0f) {
                        borderLevel = 1.0f;
                    }
                    this.borderContourTextField.setText(String.valueOf(borderLevel));
                    break;
                }
                case "\u25bd": {
                    float borderLevel = Float.parseFloat(this.borderContourTextField.getText().trim());
                    if (borderLevel < 1.0E-4f) {
                        borderLevel = 0.9f;
                    }
                    borderLevel = borderLevel * 0.95f + 5.0E-5f;
                    int i = (int)(borderLevel * 10000.0f);
                    if ((borderLevel = (float)i / 10000.0f) < 0.0f) {
                        borderLevel = 0.0f;
                    }
                    this.borderContourTextField.setText(String.valueOf(borderLevel));
                    break;
                }
            }
            this.graph.setUMapXSize(Float.parseFloat(this.uMapXSizeTextField.getText().trim()));
            this.graph.setUMapYSize(Float.parseFloat(this.uMapYSizeTextField.getText().trim()));
            this.graph.setZMin(Float.parseFloat(this.zMinTextField.getText().trim()));
            this.graph.setZMax(Float.parseFloat(this.borderContourTextField.getText().trim()));
            float zRange = Float.parseFloat(this.numOfContourTextField.getText().trim());
            if (zRange <= 100.0f) {
                this.graph.setNumOfContour(zRange);
            } else {
                DJ.print("***** WARNING ***** SomGraphViewer.setButtonAction() \u7b49\u9ad8\u7dda\u6570\u304c" + Integer.toString(100) + "\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002");
            }
        }
        catch (NumberFormatException nfe) {
            DJ.print("***** ERROR ***** SomGraphViewer.setButton_actionPerformed() Number Format Error.");
        }
        this.updateMap();
        this.colorPaletPanel.repaint();
    }

    void settingTextField_actionPerformed(ActionEvent e) {
        int anElementNo = (int)Float.parseFloat(this.onValueTextField.getText().trim());
        if (anElementNo >= this.dimOfFactor) {
            DJ.print("***** ERROR ***** SomGraphViewer.settingTextField_actionPerformed() ElementNo > dimOfCode.");
            this.onValueTextField.setText(String.valueOf(this.elementNo));
        } else {
            this.elementNo = anElementNo;
            this.updateMap();
        }
    }
}

