/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2021.3.3
 *  Copyright: 2020, 2021
 */
package active;

import util.DJ;

/**
 * <p> 表　題: Class: Activator</p>
 * <p> 説　明:活性化関数クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.14</p>
 */
public abstract class Activator {
  
  public static final String IDENTITY = "active.Identity";
  public static final String STEP = "active.Step";
  public static final String SIGMOID = "active.Sigmoid";
  public static final String RELU = "active.ReLU";
  public static final String SOFTMAX = "active.SoftMax";
  
  // 活性化関数
  public abstract void function(double[] u, double[] y);
  public abstract void function(double[][] u, double[][] y);
  
  // 活性化関数の微分
  public void derivative(double[] u, double[] y, double[] dudy) {
    for (int i = 0; i < u.length; i++) {
      dudy[i] = 0; // 活性化関数の微分
    }
  }
  public void derivative(double[][] u, double[][] y, double[][] dudy) {
    for (int i = 0; i < u.length; i++) {
      for (int j = 0; j < u[0].length; j++) {
        dudy[i][j] = 0; // 活性化関数の微分
      }
    }
  }
  
  // 活性化関数の微分
  public void derivative(double[] u, double[] y, double[] c, double[] dudy) {
    for (int i = 0; i < u.length; i++) {
      dudy[i] = 0; // 活性化関数の微分
    }
  }
  public void derivative(double[][] u, double[][] y, double[][] c, double[][] dudy) {
    for (int i = 0; i < u.length; i++) {
      for (int j = 0; j < u[0].length; j++) {
        dudy[i][j] = 0; // 活性化関数の微分
      }
    }
  }
  
  // 活性化関数の生成
  public static final Activator createActivator(String activatorName) {
    Activator activator = null; // 活性化関数のインスタンス
    
    try {
      Class<?> activatorClass = Class.forName(activatorName); // 活性化関数のクラス
// 2024.2.13      activator = (Activator)(activatorClass.newInstance()); // インスタンス
      activator = (Activator)(activatorClass.getDeclaredConstructor().newInstance()); // インスタンス
    }
    catch (ReflectiveOperationException e) {
      DJ._print("Activator.Function(): ReflectiveOperationException.");
      DJ._print("Activator.Function(): Failed to get an Activator.");
    }

    return activator;
  }
  
} // Activator

// EOF
