/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2021.3.3
 *  Copyright: 2020, 2021
 */
package active;

/**
 * <p> 表　題: Class: Identity</p>
 * <p> 説　明:恒等活性化関数クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.19</p>
 */
public class Identity extends Activator {
  
  // 活性化関数
  @Override
  public void function(double[] u, double[] y) {
    int length = u.length;
    System.arraycopy(u, 0, y, 0, length);
  }
  @Override
  public void function(double[][] u, double[][] y) {
    for (int i = 0; i < u.length; i++) {
      System.arraycopy(u[i], 0, y[i], 0, u[0].length);
    }
  }
  
  // 活性化関数の微分
  @Override
  public void derivative(double[] u, double[] y, double[] dudy) {
    int length = u.length;
    for (int i = 0; i < length; i++) {
       // 恒等関数の微分
      dudy[i] = 1.0;
    }
  }
  @Override
  public void derivative(double[][] u, double[][] y, double[][] dudy) {
    for (int i = 0; i < u.length; i++) {
      for (int j = 0; j < u[0].length; j++) {
        // 恒等関数の微分
        dudy[i][j] = 1.0;
      }
    }
  }
  
  // 恒等関数
  private double identity(double u) {
    double y;
    y = u;
    return y;
  }
  
} // Identity

// EOF
