/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2020.7.1
 *  Copyright: 2020, 2021
 */
package layer;

import java.util.ArrayList;

/**
 * <p> 表　題: Class: PlaneLayer</p>
 * <p> 説　明:２次元層クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.13</p>
 */
public abstract class PlaneLayer extends Layer {
  // ノード数
  protected int inNodeRow; // 入力の行数
  protected int inNodeCol; // 入力の列数
  protected int outNodeRow; // 出力の行数
  protected int outNodeCol; // 出力の列数
  
  // 変数宣言
//  protected double[][] x; // 入力
//  protected double[][] y; // 出力
  
//  protected double[][] dEdX; // dE/dX: 入力による誤差の勾配
//  protected double[][] dEdY; // dE/dY: 出力による誤差の勾配
  
  protected ArrayList<double[][]> xList; // 入力リスト
  protected ArrayList<double[][]> yList; // 出力リスト
  
  protected ArrayList<double[][]> dEdXList; // dE/dX: 入力による誤差の勾配のリスト
  protected ArrayList<double[][]> dEdYList; // dE/dX: 入力による誤差の勾配のリスト
  
  // 生成子
  public PlaneLayer(int inputNodeRow, int inputNodeCol) {
//    super(inputNodeRow, inputNodeCol);
    super(1, 1);
    
    inNodeRow = inputNodeRow;
    inNodeCol = inputNodeCol;
    
//    x = new double[inputNodeRow][inputNodeCol];
//    dEdX = new double[inputNodeRow][inputNodeCol];

    xList = new ArrayList<>();
    yList = new ArrayList<>();
    dEdXList = new ArrayList<>();
    dEdYList = new ArrayList<>();

  }

  // 生成子
  public PlaneLayer(int inputNodeRow, int inputNodeCol,
                   int outputNodeRow, int outputNodeCol) {
    super(inputNodeRow, outputNodeRow);
    
    inNodeRow = inputNodeRow;
    inNodeCol = inputNodeCol;
    outNodeRow = outputNodeRow;
    outNodeCol = outputNodeCol;
    
//    x = new double[inputNodeRow][inputNodeCol];
//    y = new double[outputNodeRow][outputNodeCol];

//    dEdX = new double[inputNodeRow][inputNodeCol];
//    dEdY = new double[outputNodeRow][outputNodeCol];
  }

  // アクセス・メソッド
  public ArrayList<double[][]> get_xList() { return xList; }
  public void set_xList(ArrayList<double[][]> xList) { 
    this.xList = xList;
  }
    
  public ArrayList<double[][]> get_yList() { return yList; }
  public void set_yList(ArrayList<double[][]> yList) { 
    this.yList = yList;
  }
    
  public ArrayList<double[][]> get_dEdXList() { return dEdXList; }
  public void set_dEdXList(ArrayList<double[][]> dEdXList) { 
    this.dEdXList = dEdXList;
  }
  
  public ArrayList<double[][]> get_dEdYList() { return dEdYList; }
  public void set_dEdYList(ArrayList<double[][]> dEdYList) { 
    this.dEdYList = dEdYList;
  }
  
} // class PlaneLayer

// EOF

