/*
 *  Title: DaiJa_V5 (Digital-Learning Aide Instrument by Java)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020, 2021, 2022
 */
package task;

import java.util.ArrayList;
import meta.Assets;
import meta.Chaos;
import meta.Domain;
import meta.Entity;
import util.DJ;
import util.TimeStamp;

/**
 * <p> 表　題: Class: MetaTask</p>
 * <p> 説　明: メタ・タスク</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2022.11.18</p>
 */
public class MetaTask extends Task {
  
  // 学習・試行制御
  int epoch = 20; // エポックの回数
  int interval = 1; // 経過表示間隔
  
 /**
   * Taskクラスで新しく作られたスレッドから呼び出される
   */
  @Override
  public void runTask() {
    DJ._print("・タスク開始日時：", TimeStamp.getTimeFormated());
    beginTime = System.currentTimeMillis(); // タスク開始時刻

    // メタ・タスクの呼出
    metaTask();
  }
    
  /**
   * メタ・タスクの実行
   */
  public void metaTask() {
    DJ._print("MetaTask.metaTask() ==================");
  
    DJ.print_(", epoch=", epoch);
    DJ.print_(", interval=", interval);
    
    DJ._print("・実行開始時刻：", TimeStamp.getTimeFormated());
    
    
    
    
    DJ._print("## Chaosクラスのインスタンスchaosを生成");
    Chaos chaos = new Chaos();
    String reply = chaos.whoAreYou();
    DJ.print("## 誰何chaos：" + reply);
//    String name = chaos.getEntityName();
//    DJ.print("## Chaosクラスの領域の名称：" + name);
    
    DJ._print("## DomainクラスのインスタンスdomainAを生成");
    Domain domainA = new Domain();
    chaos.registerDomain(domainA); // chaosにdomainAを子領域として登録
    ArrayList<Domain> domainList = chaos.getChildDomainList();
    Domain aDomain = domainList.get(0);
    reply = aDomain.whoAreYou();
    DJ.print("## 誰何domainA：" + reply);
//    name = aDomain.getEntityName();
//    DJ.print("## domainAクラスの領域の名称：" + name);
    
    DJ._print("## DomainクラスのインスタンスdomainBを生成");
    Domain domainB = new Domain();
    domainA.registerDomain(domainB); // domainAにdomainBを子領域として登録
    domainList = domainA.getChildDomainList();
    aDomain = domainList.get(0);
    reply = aDomain.whoAreYou();
    DJ.print("## 誰何domainB：" + reply);
//    name = aDomain.getEntityName();
//    DJ.print("## domainBクラスの領域の名称：" + name);
    
    DJ._print("## DomainクラスのインスタンスdomainCを生成");
    Domain domainC = new Domain();
    domainA.registerDomain(domainC); // domainAにdomainCを子領域として登録
    domainList = domainA.getChildDomainList();
    aDomain = domainList.get(1);
    reply = aDomain.whoAreYou();
    DJ.print("## 誰何domainC：" + reply);
//    name = aDomain.getEntityName();
//    DJ.print("## domainCクラスの領域の名称：" + name);
    
    DJ._print("## DomainクラスのインスタンスdomainDを生成");
    Domain domainD = new Domain();
    domainC.registerDomain(domainD); // domainCにdomainDを子領域として登録
    domainList = domainC.getChildDomainList();
    aDomain = domainList.get(0);
    reply = aDomain.whoAreYou();
    DJ.print("## 誰何domainD：" + reply);

    DJ._print("## DomainクラスのインスタンスdomainXを生成");
    Domain domainX = new Domain();
    chaos.registerDomain(domainX); // chaosにdomainXを子領域として登録
//    domainList = chaos.getChildDomainList();
//    aDomain = domainList.get(1);
    reply = chaos.getChildDomainList().get(1).whoAreYou();
    DJ.print("## 誰何domainX：" + reply);
    
    DJ._print("## DomainクラスのインスタンスdomainYを生成");
    Domain domainY = new Domain();
    domainA.registerDomain(domainY); // domainAにdomainYを子領域として登録
    domainList = domainA.getChildDomainList();
    aDomain = domainList.get(2);
    DJ.print("## 誰何domainY：" + reply);
    
    DJ._print("## DomainクラスのインスタンスdomainZを生成");
    Domain domainZ = new Domain();
    domainC.registerDomain(domainZ); // domainCにdomainZを子領域として登録
//    domainList = domainC.getChildDomainList();
//    aDomain = domainC.getChildDomainList().get(1);
    reply = domainC.getChildDomainList().get(1).whoAreYou();
    DJ.print("## 誰何domainZ：" + reply);
    
       
    DJ._print("## 各クラスに再度誰何：");
    reply = chaos.whoAreYou();
    DJ.print("## 誰何chaos：" + reply);
//    DJ._print("## domainAに再度誰何：");
    DJ.print("## 誰何domainA：" + domainA.whoAreYou());
//    DJ._print("## domainBに再度誰何：");
    DJ.print("## 誰何domainB：" + domainB.whoAreYou());
//    DJ._print("## domainCに再度誰何：");
    DJ.print("## 誰何domainC：" + domainC.whoAreYou());
    DJ.print("## 誰何domainD：" + domainD.whoAreYou());
    DJ.print("## 誰何domainX：" + domainX.whoAreYou());
    DJ.print("## 誰何domainY：" + domainY.whoAreYou());
    DJ.print("## 誰何domainZ：" + domainZ.whoAreYou());
    
//$    
//    DJ._print("## Chaosクラスの孫領域に誰何：");
//    aDomain = chaos.getChildDomainList().get(0); // domainA
////    aDomain = domainList.get(0); // domainA
//    aDomain = (aDomain.getChildDomainList()).get(0); // domainB
//    DJ.print("## 誰何aDomain：" + aDomain.whoAreYou());
    
    
    // ##### 領域に直接、先祖系統の表示を要求する
    
    DJ._print("## chaosの先祖系統：");
//    ArrayList<Domain> ancestorList = chaos.getAncestorList();
//    Entity.printAncestorList(ancestorList);
    chaos.printAncestorList();
    
    DJ._print("## domainAの先祖系統：");
//    ancestorList = domainA.getAncestorList();
//    Entity.printAncestorList(ancestorList);
    domainA.printAncestorList();
    
    DJ._print("## domainBの先祖系統：");
//    ancestorList = domainB.getAncestorList();
//    Entity.printAncestorList(ancestorList);
    domainB.printAncestorList();
    
    DJ._print("## domainCの先祖系統：");
//    ancestorList = domainC.getAncestorList();
//    Entity.printAncestorList(ancestorList);
    domainC.printAncestorList();

    DJ._print("## domainDの先祖系統：");
    domainD.printAncestorList();

    DJ._print("## domainXの先祖系統：");
    domainX.printAncestorList();
    DJ._print("## domainYの先祖系統：");
    domainY.printAncestorList();
    DJ._print("## domainZの先祖系統：");
    domainZ.printAncestorList();
    
    
    DJ._print("## chaosの子領域の系統：");
//    Entity.printChildList(chaos.getChildDomainList());
    chaos.printChildList();
    
    DJ._print("## domainAの子領域の系統：");
//    Entity.printChildList(domainA.getChildDomainList());
    domainA.printChildList();
    
    DJ._print("## domainBの子領域の系統：");
//    Entity.printChildList(domainB.getChildDomainList());
    domainB.printChildList();
    
    DJ._print("## domainCの子領域の系統：");
//    Entity.printChildList(domainC.getChildDomainList());
    domainC.printChildList();
    
    DJ._print("## domainXの子領域の系統：");
    domainX.printChildList();
    DJ._print("## domainYの子領域の系統：");
    domainY.printChildList();
    DJ._print("## domainZの子領域の系統：");
    domainZ.printChildList();
    
    
    DJ._print("## 全領域のリスト：");
    aDomain.printAllDomain();
    
    DJ._print("## 資産クラスの操作");
    Assets assets = chaos.getAssets();
    String assetsName = assets.getEntityName();
    int assetsNo = assets.getAssetsNo(); // 
    DJ.print("資産番号=" + assetsNo + ", 資産名=" + assetsName);
    
    DJ._print("## 整数データ");
    assets.appendInteger("val3", 3); // 整数データを設定
    assets.appendInteger("val4", 4); // 整数データを設定
    DJ.print("val3=" + assets.getIntegerValue("val3"));
    DJ.print("val4=" + assets.getIntegerValue("val4"));
    assets.setIntegerValue("val4", 50); // 整数データを設定
    assets.setIntegerValue("val5", 60); // 整数データを設定
    DJ.print("val4=" + assets.getIntegerValue("val4"));
    DJ.print("val5=" + assets.getIntegerValue("val5"));
    
    
    DJ._print("## 実数データ");
    assets = domainC.getAssets();
    assetsName = assets.getEntityName();
    assetsNo = assets.getAssetsNo(); // 
    DJ.print("DomainC 資産番号=" + assetsNo + ", 資産名=" + assetsName);
    assets.appendDouble("val3.14", 3.14); // 実数データを設定
    assets.setDoubleValue("val500", 500); // 実数データを設定
    assets.setDoubleValue("ルート２", 1.4142); // 実数データを設定
    DJ.print("val3.14=" + assets.getDoubleValue("val3.14"));
    DJ.print("val500=" + assets.getDoubleValue("val500"));
    DJ.print("ルート２=" + assets.getDoubleValue("ルート２"));
    
    
    DJ._print("## 論理データ");
//    assets = domainC.getAssets();
//    assetsName = assets.getEntityName();
//    assetsNo = assets.getAssetsNo();
    DJ.print("DomainC 資産番号=" + assetsNo + ", 資産名=" + assetsName);
    assets.appendBoolean("True", true); // 論理データを設定
    assets.setBooleanValue("False", false); // 論理データを設定
    assets.setBooleanValue("正論理", true); // 論理データを設定
    DJ.print("True=" + assets.getBooleanValue("True"));
    DJ.print("False=" + assets.getBooleanValue("False"));
    DJ.print("正論理=" + assets.getBooleanValue("正論理"));
    
    
    DJ._print("## 文字列データ");
    assets = domainZ.getAssets();
    assetsName = assets.getEntityName();
    assetsNo = assets.getAssetsNo(); // 
    DJ.print("DomainZ 資産番号=" + assetsNo + ", 資産名=" + assetsName);
    assets.appendString("TextA", "エイ"); // 文字列データを設定
    assets.setStringValue("テキストＢ", "ビー"); // 文字列データを設定
    assets.appendString("テキストＣ", "Ｃcc"); // 文字列データを設定
    DJ.print("TextA=" + assets.getStringValue("TextA"));
    DJ.print("テキストＢ=" + assets.getStringValue("テキストＢ"));
    DJ.print("テキストＣ=" + assets.getStringValue("テキストＣ"));
    
    
    
    
    
    
    
    
    
    
    
    
    
    DJ._print(" ##### メタ・タスクの実行開始 #####");
    for (int i = 0; i <= epoch; i++) {
      startTime = System.nanoTime(); // 実行開始時刻
      intervalFlag = (i % interval == interval - 1)
              | (i == epoch); //経過表示フラグ
    
      // 実行時間の累積
      endTime = System.nanoTime(); // 休止時刻
      double lapTime_ = (endTime - startTime) / 1000000.0;
      if (lapTime_ > 0.0) lapTime = lapTime_; // オーバーフロー対策
      totalTime = totalTime + (double)lapTime; // 経過時間を追加
    
      if (intervalFlag) {
        // DJ._print(" ##### １エポックの実行結果 #####");
        DJ._print_(" i=" + i);
      
        DJ.print_(" lapTime = ", lapTime); DJ.print("[msec]");
      
        // スレッドの休止（実行速度の調整および経過表示のため）
        synchronized(this) {
          try {
            // DJ.print("Ｅnter to wait(sleepTime)");
            wait(SLEEP_TIME); // タイムアウト付きで待機状態
            // DJ.print("Resume from wait(sleepTime)");
            if (pauseFlag) wait(); // 休止状態
          }
          catch (InterruptedException ex) {
             DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
                 + " Exception occur in wait(sleepTime):" + ex.toString());
          }
        } // synchronized()
      } // interval
      
      // 実行処理の中断
      if (abortFlag) {
        DJ._print("##### Abort action requested");
        epoch = i; // エポック回数を強制的に現在の実行回数に置き換える
      }
      
    } // End of One epoch
    DJ._print(" End of all epoch ---------------");
    
    DJ._print("・各変数の最終値");
    DJ.print(" Last epoch = ", epoch);
      
      
    // 実行時間の算出
    DJ._print_("・総実行時間：" + (totalTime / 1000.0) + " [sec]");
    double aveTime = totalTime / epoch;
    DJ.print(", 平均実行時間：" + aveTime + " [msec/epoch]");
    
    DJ.print_("・タスク終了日時：", TimeStamp.getTimeFormated());
    finishTime = System.currentTimeMillis(); // タスク開始時刻
    DJ.print(", タスク処理時間：" + 
            ((finishTime - beginTime) / 1000.0) + " [sec]");

  } // metaTask()
  
} // MetaTask Class

// End of File
