/*
 *  Title: DaiJa_V5 (Digital-learning Aide Instrument by JAva))
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020 - 2024
 */
package task.qu;

import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;

/**
 * <p> 表　題: Class: PhaseEstimation</p>
 * <p> 説　明: 量子位相推定（QPE）</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2024, 2025</p>
 * <p> 作成日: 2025.05.27</p>
 * <p> 作成日: 2025.06.05</p>
 */
public class PhaseEstimation extends Task {
  
  // 学習・試行制御
  // int epoch = 2; // エポックの回数
  // int interval = 1; //10; // 経過表示間隔
  
  // 量子計算パラメータ
  // int delta = 30; // 5; //10; //15; // 基底角度の増分（度）

  /**
   * Taskクラスで新しく作られたスレッドから呼び出される
   */
  @Override
  public void runTask() {
    DJ._print("・タスク開始日時：", TimeStamp.getTimeFormated());
    beginTime = System.currentTimeMillis(); // タスク開始時刻
    
    // パターン・ビューワ・ランチャを得る
    //  patternViewerFlag = true; //true; // false:非表示
    //  patternData0 = new double[5][dataNum]; // 附番,
    //  patternData1 = new double[5][dataNum]; // ID,
    //  patternViewerLauncher = DJ.pattern(  // 判定パターン、データ、タイトル
    //      PatternViewer.PATTERN_TUNER, patternData0, "PhaseEstimation",
    //      PatternViewer.PATTERN_TUNER, patternData1, "PhaseEstimation");
    
    this.stepMode = true; // タスクのステップ実行モード
    
    phaseEstimation(); // タスク本体の呼び出し
  }
  
  /** 
   * 量子位相推定
   */
  public void phaseEstimation() {
    DJ._print("PhaseEstimation.phaseEstimation() ========================");
    DJ.print("(1)量子位相推定の量子回路");
    DJ.print("(2)アダマール・ゲート");
    DJ.print("(3)コントロール・ユニタリ・ゲート");
    DJ.print("(4)逆量子フーリエ変換");
    DJ.print("(5)量子位相推定を実行：３量子ビット");
    DJ.print("(6)量子位相推定を実行：５量子ビット");
    
        
    // this.stepMode = true; // タスクのステップ実行モードON
    DJ.printS(2, "PhaseEstimation(1)", this); // Pause Task ------------------
    DJ._print("Code(1)量子位相推定の量子回路");
    DJ.print("・ユニタリ行列Uの固有値（位相）を推定します。");
    DJ.print("・アダマール・ゲートHとユニタリ行列U、"
           + "逆量子フーリエ変換QFT'で構成されます。");
    DJ._print(
        "・量子位相推定の量子回路、m:入力量子ビット数、n:補助量子ビット数  \n"
      + " qb0     ┌-┐┌-─┐  ┌-───┐┌─┐┌-┐                     \n"
      + "  =[1 0]'┤H├┤ I ├…┤   C   ├┤Q'├┤M├ ←補助量子ビット0   \n"
      + "     :   │:││ : │  │   |   ││F ││:│     r0              \n"
      + " qbn-1   │:││ : │  │   |   ││T ││:│      :              \n"
      + "  =[1 0]'┤H├┤ C ├…┤   |   ├┤  ├┤M├ ←補助量子ビットn-1 \n"
      + "         ├-┤├ | ┤  ├─ | ─┤└─┘└-┘     rn-1            \n"
      + " f0QB──┤I├┤ | ├…┤   |   ├─────  ←入力量子ビット0   \n"
      + "  :      │:││U^1│  │ U^k+1 │                 :              \n"
      + " fkQB──┤I├┤   ├…┤k=2^m-1├─────  ←入力量子ビットn   \n"
      + " k=2^m-1 └-┘└-─┘  └-───┘                                \n"
      + "       qbf  qbf0   qbf1         qbfn  qbfn+1  ←全量子状態        ");
    

    DJ.printS(1, "PhaseEstimation(2)", this); // Pause Task ------------
    DJ.print("Code(2)アダマール・ゲート");
    
    DJ._print("Code(2-1)Hゲート（Hadamardゲート）を生成");
    QuGate hQuGate = new QuGate(QuGate.H_GATE);
    DJ.printF("hQuGate", hQuGate); // Hゲート
    // hGate:F
    // ┌                        ┐        ┌      ┐ 
    // │ 0.70711+0i   0.70711+0i│ = 1/√2│ 1   1│ 
    // │ 0.70711+0i  -0.70711+0i│        │ 1  -1│ 
    // └                        ┘        └      ┘ 
    
    DJ.print("・Iゲート（恒等ゲート）を生成します。");
    QuGate iQuGate = new QuGate(QuGate.I_GATE);
    DJ.printF("iQuGate", iQuGate); // Ｉゲート
    // iGate:F
    // ┌            ┐ ┌      ┐
    // │ 1+0i   0+0i│=│ 1  0 │
    // │ 0+0i   1+0i│ │ 0  1 │
    // └            ┘ └      ┘ 
    
    DJ.printS(1, "PhaseEstimation(2-2)", this); // Pause Task ------------------
    DJ.print("Code(2-2)HHIゲートを生成");
    DJ.print("・HHゲート(H⊗H)を生成します。");
    QuGate hhGate = hQuGate.interactQuGate(hQuGate);
    DJ.printF("hhGate", hhGate); // HH = H⊗H
    //  hhGate:F
    //  ┌                                  ┐     ┌          ┐       ┌    ┐
    //  │ 0.5+0i   0.5+0i   0.5+0i   0.5+0i│= 1/2│1  1  1  1│= 1/√2│H  H│
    //  │ 0.5+0i  -0.5+0i   0.5+0i  -0.5+0i│     │1 -1  1 -1│       │H -H│
    //  │ 0.5+0i   0.5+0i  -0.5+0i  -0.5+0i│     │1  1 -1 -1│       └    ┘
    //  │ 0.5+0i  -0.5+0i  -0.5+0i   0.5-0i│     │1 -1 -1  1│
    //  └                                  ┘     └          ┘
    
    DJ.print("・HHIゲート(H⊗H⊗I)を生成します。");
    QuGate hhiGate = hhGate.interactQuGate(iQuGate);
    DJ.printF("hhiGate", hhiGate); // HHI = H⊗H⊗I
    // hhiGate:F
    //  ┌                                                                      ┐
    //  │ 0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i   0+0i  │
    //  │ 0+0i     0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i│
    //  │ 0.5+0i   0+0i    -0.5+0i   -0+0i    0.5+0i   0+0i    -0.5+0i   -0+0i │
    //  │ 0+0i     0.5+0i   -0+0i   -0.5+0i   0+0i     0.5+0i   -0+0i   -0.5+0i│
    //  │ 0.5+0i   0+0i     0.5+0i   0+0i    -0.5+0i   -0+0i   -0.5+0i   -0+0i │
    //  │ 0+0i     0.5+0i   0+0i     0.5+0i   -0+0i   -0.5+0i   -0+0i   -0.5+0i│
    //  │ 0.5+0i   0+0i    -0.5+0i   -0+0i   -0.5+0i   -0+0i    0.5+0i   0+0i  │
    //  │ 0+0i     0.5+0i   -0+0i   -0.5+0i   -0+0i   -0.5+0i   0+0i     0.5+0i│
    //  └                                                                      ┘
    //       ┌          ┐
    //  = 1/2│I  I  I  I│
    //       │I -I  I -I│
    //       │I  I -I -I│
    //       │I -1 -I  I│
    //       └          ┘
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "PhaseEstimation(3)", this); // Pause Task ------------------
    DJ.print("Code(3)コントロール・ユニタリ・ゲート");
    DJ.print("　Sゲートを生成し、コントロールSゲートC-Sにします。\n"
            + "　Tゲートを生成し、コントロールTゲートC-Tにします。");
    
    DJ._print("Code(3-1)Sゲート（R1）をRk行列k=1で生成");
    DJ._print("　固有値v=1,i、固有ベクトル|f>=[1 0]',[0 1]'です。");
    int k = 1; // Sゲート
    DJ.print_("k = ", k);
    QuGate sQuGate = new QuGate(QuGate.RK_GATE, k);
    DJ.printF(",  sQuGate = r1Gate", sQuGate);
    // k = 1,  sQuGate = r1Gate:F
    // ┌            ┐ ┌      ┐
    // │ 1+0i   0+0i│=│ 1  0 │ // Sゲート
    // │ 0+0i   0+1i│ │ 0  i │
    // └            ┘ └      ┘
    
    DJ.printS(1, "PhaseEstimation(3-1)", this); // Pause Task ------------------
    DJ._print("Code(3-2)コントロールSゲートC-Sを生成");
    QuGate targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(sQuGate.copyGateMat());
    int numOfBits = 2; // 量子ビット数
    int target = 1; // ターゲット量子ビット
    int[] controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 0;
    DJ.print_("targetGate = S-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    DJ.print("QuGate cSGate = new QuGate(\n"
          + "targetGate, numOfBits, target, controlArray);");
    QuGate cSGate = new QuGate(targetGate, numOfBits, target, controlArray);
    DJ.printF("cSGate", cSGate); // C-Sゲート
    //  cSGate:F
    //  ┌                          ┐ ┌       ┐ ┌   ┐
    //  │ 1+0i   0+0i   0+0i   0+0i│=│1 0 0 0│=│I O│ // C-Sゲート
    //  │ 0+0i   1+0i   0+0i   0+0i│ │0 1 0 0│ │O S│
    //  │ 0+0i   0+0i   1+0i   0+0i│ │0 0 1 0│ └   ┘
    //  │ 0+0i   0+0i   0+0i   0+1i│ │0 0 0 i│
    //  └                          ┘ └       ┘
    
    
    DJ.printS(1, "PhaseEstimation(3-3)", this); // Pause Task ------------------
    DJ._print("Code(3-3)Tゲート(R2)をRk行列k=2で生成");
    k = 2; // Tゲート
    DJ.print_("k = ", k);
    QuGate tQuGate = new QuGate(QuGate.RK_GATE, k);
    DJ.printF(",  tQuGate = r2Gate", tQuGate);
    // k = 2,  tQuGate = r2Gate:F
    // ┌                        ┐ ┌               ┐
    // │ 1+0i   0+0i            │=│ 1  0          │ // Tゲート
    // │ 0+0i   0.70711+0.70711i│ │ 0  exp(iπ/4) │
    // └                        ┘ └               ┘
    

    DJ._print("Code(3-4)コントロールTゲートC-Tを生成");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(tQuGate.copyGateMat());
    numOfBits = 2; // 量子ビット数
    target = 1; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 0;
    DJ.print("targetGate = T-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    QuGate cTGate = new QuGate(targetGate, numOfBits, target, controlArray);
    DJ.printF("cTGate", cTGate); // CTゲート
    //  cTGate:F
    //  ┌                                      ┐ ┌                ┐ ┌   ┐
    //  │ 1+0i   0+0i   0+0i   0+0i            │=│1 0 0 0         │=│I O│
    //  │ 0+0i   1+0i   0+0i   0+0i            │ │0 1 0 0         │ │O T│
    //  │ 0+0i   0+0i   1+0i   0+0i            │ │0 0 1 0         │ └   ┘
    //  │ 0+0i   0+0i   0+0i   0.70711+0.70711i│ │0 0 0 exp(iπ/4)│
    //  └                                      ┘ └                ┘

    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "PhaseEstimation(4)", this); // Pause Task ------------------
    DJ.print("Code(4)逆量子フーリエ変換");
    DJ.print(
              "  量子フーリエ変換Wを２量子ビットで生成し、"
            + "共役転置により逆行列にします。\n"
            + "  １量子ビットの単位ゲートと相互作用させ、"
            + "３量子ビットにします。");
    
    DJ._print("(4-1)２量子ビットのフーリエ変換を生成");
    int numOfQuBit = 2; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    DJ.print("QuGate w2Gate = new QuGate(QuGate.W_GATE, numOfQuBit);");
    QuGate w2Gate = new QuGate(QuGate.W_GATE, numOfQuBit);
    DJ.printF("w2Gate", w2Gate);
    //  w2Gate:F
    //  ┌                                  ┐    ┌          ┐
    //  │ 0.5+0i   0.5+0i   0.5+0i   0.5+0i│=1/2│1  1  1  1│
    //  │ 0.5+0i   0+0.5i  -0.5+0i  -0-0.5i│    │1  i -1 -i│
    //  │ 0.5+0i  -0.5+0i   0.5-0i  -0.5+0i│    │1 -1  1 -1│
    //  │ 0.5+0i  -0-0.5i  -0.5+0i   0+0.5i│    │1 -i -1  i│
    //  └                                  ┘    └          ┘
    
    
    DJ.printS(1, "PhaseEstimation(4-2)", this); // Pause Task ------------------
    DJ.print("(4-2)逆量子フーリエ変換を算出");
    DJ.print("・フーリエ変換w2Gateを逆行列にします。");
    QuGate w2InvGate = w2Gate.conjugate(); // W2の逆行列（共役転置）
    DJ.printF("w2InvGate", w2InvGate);
    //  w2InvGate:F
    //  ┌                                  ┐    ┌          ┐
    //  │ 0.5-0i   0.5-0i   0.5-0i   0.5-0i│=1/2│1  1  1  1│
    //  │ 0.5-0i   0-0.5i  -0.5-0i  -0+0.5i│    │1 -i -1  i│
    //  │ 0.5-0i  -0.5-0i   0.5+0i  -0.5-0i│    │1 -1  1 -1│
    //  │ 0.5-0i  -0+0.5i  -0.5-0i   0-0.5i│    │1  i -1 -i│
    //  └                                  ┘    └          ┘

    
    DJ.printS(1, "PhaseEstimation(4-3)", this); // Pause Task ------------------
    DJ.print("(4-3)逆量子フーリエ変換QFT'を生成");
    DJ.print("・逆行列w2InvGateとIゲートを相互作用させ、"
           + "３量子ゲートを生成します。");
    DJ.print("  w2Inv_I = w2InvGate⊗I");
    DJ.print("  QuGate w2InvIGate = w2InvGate.interactQuGate(iQuGate)");
    QuGate w2InvIGate = w2InvGate.interactQuGate(iQuGate); // W2InvⓧI
    DJ.printF("w2InvIGate", w2InvIGate); // W2InvIIゲート
    //  w2InvIGate:F
    //  ┌                                                                      ┐
    //  │ 0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i   0+0i  │
    //  │ 0+0i     0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i   0+0i     0.5+0i│
    //  │ 0.5+0i   0+0i     0-0.5i   0+0i    -0.5-0i   0-0i    -0+0.5i   -0+0i │
    //  │ 0+0i     0.5+0i   0+0i     0-0.5i   0-0i    -0.5-0i   -0+0i   -0+0.5i│
    //  │ 0.5+0i   0+0i    -0.5-0i   0-0i     0.5+0i   0+0i    -0.5-0i   0-0i  │
    //  │ 0+0i     0.5+0i   0-0i    -0.5-0i   0+0i     0.5+0i   0-0i    -0.5-0i│
    //  │ 0.5+0i   0+0i    -0+0.5i   -0+0i   -0.5-0i   0-0i     0-0.5i   0+0i  │
    //  │ 0+0i     0.5+0i   -0+0i   -0+0.5i   0-0i    -0.5-0i   0+0i     0-0.5i│
    //  └                                                                      ┘
    //      ┌             ┐
    //  =1/2│I   I   I   I│
    //      │I -iI  -I  iI│
    //      │I  -I   I  -I│
    //      │I  iI  -I -iI│
    //      └             ┘
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "PhaseEstimation(5)", this); // Pause Task ------------------
    DJ.print("Code(5)量子位相推定を実行：３量子ビット");
    DJ._print("・例題の実装では、補助量子ビットを２個、"
            + "入力量子ビットを１個として、\n"
            + "　全体で３量子ビットの量子回路を構成します。");
    DJ._print("・１量子ビットのユニタリ行列は、Sゲートを使用します。");
    
    DJ._print(
        "・量子位相推定の量子回路、入力量子ビット数:1、補助量子ビット数:2 \n"
      + " qb0     ┌-┐┌-─┐  ┌-─┐┌─┐┌-┐                       \n"
      + "  =[1 0]'┤H├┤ I ├…┤ C ├┤Q'├┤M├ ←補助量子ビット0：r0 \n"
      + " qbn-1   ├-┤│ | │  │ | ││F ││ │                       \n"
      + "  =[1 0]'┤H├┤ C ├…┤ I ├┤T ├┤M├ ←補助量子ビット1：r1 \n"
      + "         ├-┤├ | ┤  ├ | ┤└─┘└-┘                       \n"
      + " qb=f──┤I├┤U^1├…┤U^2│            ←入力量子ビット0     \n"
      + "         └-┘└-─┘  └-─┘                                  \n"
      + "       qbf  qbf0    qbf1     qbfn  qbfn+1 ←全量子状態          ");
    
    
    DJ.printS(1, "PhaseEstimation(5-1)", this); // Pause Task ------------------
    DJ.print("Code(5-1)コントロールSゲートICSを生成");
    DJ.print("・コントロールSゲートICSを３量子ビットで生成します。");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(sQuGate.copyGateMat());
    numOfBits = 3; // 量子ビット数
    target = 2; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 1;
    DJ.print("targetGate = S-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    DJ.print("QuGate icSGate = new QuGate("
          + "targetGate, numOfBits, target, controlArray);");
    QuGate icSGate = new QuGate(targetGate, numOfBits, target, controlArray);
    DJ.printF("icSGate", icSGate); // ICSゲート
    // icSGate:F
    // ┌                                                      ┐
    // │ 1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f0
    // │ 0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i   0+0i   0+0i│f1
    // │ 0+0i   0+0i   0+0i   0+0i   1+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   0+0i   0+0i   0+0i   1+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i│f0
    // │ 0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i│f1
    // └               f0     f1                   f0     f1  ┘
    
    
    DJ.printS(1, "PhaseEstimation(5-2)", this); // Pause Task ------------------
    DJ.print("Code(5-2)コントロールSゲートCISを生成");
    DJ.print("・コントロールSゲートCISを３量子ビットで生成します。");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(sQuGate.copyGateMat());
    numOfBits = 3; // 量子ビット数
    target = 2; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 0;
    DJ.print("targetGate = S-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    DJ.print("QuGate ciSGate = new QuGate(\n"
          + "targetGate, numOfBits, target, controlArray);");
    QuGate ciSGate = new QuGate(targetGate, numOfBits, target, controlArray);
    DJ.printF("ciSGate", ciSGate); // CISゲート
    // ciSGate:F
    // ┌                                                      ┐
    // │ 1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   1+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   0+0i   1+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i│f0
    // │ 0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i│f1
    // │ 0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i│f0
    // │ 0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i│f1
    // └                             f0     f1     f0     f1  ┘
    
    
    DJ.printS(1, "PhaseEstimation(5-3)", this); // Pause Task ------------------
    DJ.print("Code(5-3)量子位相推定を実行");
    DJ.print("・入力量子ビットの量子状態を"
           + "実行毎に変化させます。");
     
    numOfQuBit = 3; // 量子ビット数
    DJ.print("QuBit qbf0 = QuBit.unitQuBit(numOfQuBit, paId);");
    DJ.print("numOfQuBit = " +  numOfQuBit);
    DJ.print("");
    for (int i = 0; i < 2; i++) { // 2 = 2^1
      int paId = i + 0; // '1'にする確率振幅のインデックス
      DJ._print_("paId = ", paId);
      QuBit qbf0 = QuBit.unitQuBit(numOfQuBit, paId);
      DJ.printF(",  qbf0", qbf0); // 列（縦）ベクトル表示
      // DJ.print("qbf0", qbf0); // 行（横）ベクトル表示
    
      DJ.print("①入力量子ビットqbf0を量子ゲートhhiGateに適用します。");
      DJ.print("QuBit qbf1 = hhiGate.apply(qbf0);");
      QuBit qbf1 = hhiGate.apply(qbf0);
      DJ.printF("qbf1", qbf1);
      
      DJ.print("②量子ビットqbf1を量子ゲートicSGateに１回適用します。");
      QuBit oprandQB = icSGate.apply(qbf1);
      DJ.printF("qbf2", oprandQB);
      
      DJ.print("③量子ビットqbf2を量子ゲートciSGateに２回適用します。");
      for (int j = 0; j < 2; j++) {
        oprandQB = ciSGate.apply(oprandQB);
      }      
      DJ.printF("qbfn", oprandQB);
      
      DJ.print("④量子ビットqbfnを逆量子フーリエ変換"
             + "w2InvIGateに適用します。");
      oprandQB = w2InvIGate.apply(oprandQB);
      DJ.printF("qbfn+1", oprandQB);
      
      DJ.print("⑤３量子ビットqbfn+1の遷移確率を求めます。");
      double[][] result = oprandQB.getTransProb();
      DJ.printF("result", result);
    }

    //  paId = 0
    //  qbf0:F   ①qbf1:F     ②qbfn:F 
    //  ┌     ┐  ┌       ┐  ┌       ┐
    //  │ 1+0i│  │ 0.5+0i│  │ 0.5+0i│
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  │ 0+0i│  │ 0.5+0i│  │ 0.5+0i│
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  │ 0+0i│  │ 0.5+0i│  │ 0.5+0i│
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  │ 0+0i│  │ 0.5+0i│  │ 0.5+0i│
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  └     ┘  └       ┘  └       ┘
    //  qbfn+1:F 
    //  ┌     ┐ ┌ ┐ ┌ ┐ ┌ ┐
    //  │ 1+0i│=│1│⊗│1│⊗│1│
    //  │ 0+0i│ │0│ │0│ │0│
    //  │-0-0i│ └ ┘ └ ┘ └ ┘
    //  │ 0+0i│  ↓    ↓
    //  │ 0-0i│  0b0   0b0 → r = 0b0.00 = d0.0
    //  │ 0+0i│
    //  │ 0-0i│
    //  │ 0+0i│
    //  └     ┘
    //  result=
    //  [[1, 1, 1]←[1 0]'への遷移確率
    //  [0, 0, 0] ←[0 1]'への遷移確率
    //  ]↑ ↑         
    //   │ └ 第１量子ビットの遷移確率
    //   └ 第０量子ビットの遷移確率
    
    
    //  paId = 1
    //  qbf0:F   ①qbf1:F     ②qbfn:F 
    //  ┌     ┐  ┌       ┐  ┌       ┐
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  │ 1+0i│  │ 0.5+0i│  │ 0.5+0i│
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  │ 0+0i│  │ 0.5+0i│  │ 0+0.5i│
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  │ 0+0i│  │ 0.5+0i│  │-0.5+0i│
    //  │ 0+0i│  │ 0+0i  │  │ 0+0i  │
    //  │ 0+0i│  │ 0.5+0i│  │-0-0.5i│
    //  └     ┘  └       ┘  └       ┘
    //  qbfn+1:F 
    //  ┌     ┐ ┌ ┐ ┌ ┐ ┌ ┐
    //  │ 0+0i│=│1│⊗│0│⊗│0│
    //  │-0+0i│ │0│ │1│ │1│
    //  │ 0+0i│ └ ┘ └ ┘ └ ┘
    //  │ 1-0i│  ↓    ↓
    //  │ 0+0i│  0b0   0b1 → r = 0b0.01 = d0.25
    //  │-0-0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  └     ┘
    //  result=
    //  [[1, 0, 0]←[1 0]'への遷移確率
    //  [0, 1, 1] ←[0 1]'への遷移確率
    //  ]↑ ↑          
    //   │ └ 第１量子ビットの遷移確率
    //   └ 第０量子ビットの遷移確率
    DJ._print("・３量子ビット量子位相推定の実行完了");
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "PhaseEstimation(6)", this); // Pause Task ------------------
    DJ.print("Code(6)量子位相推定を実行：５量子ビット");
    DJ._print("・例題の実装では、入力量子ビット２個、"
            + "補助量子ビット３個として、\n"
            + "  全体で５量子ビットの量子回路を構成します。");
    DJ.print("・２量子ビットのユニタリ行列には、"
            + "SゲートとTゲートを使用します。");
    
    DJ._print(
        "・量子位相推定の量子回路、入力量子ビット数２個、補助量子ビット数３個\n"
      + " qb0     ┌-┐┌-─┐┌-─┐┌-─┐┌─┐┌-┐                    \n"
      + "  =[1 0]'┤H├┤ I ├┤ I ├┤ C ├┤Q'├┤M├ ←補助量子ビットr0 \n"
      + " qb1     ├-┤├-─┤├-─┤├ | ┤│F ││:│      :             \n"
      + "  =[1 0]'┤H├┤ I ├┤ C ├┤ | ├┤T ├┤M├ ←補助量子ビットr1 \n"
      + " qb2     ├-┤├-─┤├ | ┤├ | ┤│  ││:│      :             \n"
      + "  =[1 0]'┤H├┤ C ├┤ | ├┤ | ├┤  ├┤M├ ←補助量子ビットr2 \n"
      + "         ├-┤├ | ┤├ | ┤├ | ┤└─┘└-┘                    \n"
      + " f0QB──┤I├┤ | ├┤ | ├┤ | ├─────  ←入力量子ビット0  \n"
      + "  :      ├-┤│U^1││U^2││U^4│                 :             \n"
      + " f1QB──┤I├┤   ├┤   ├┤   ├─────  ←入力量子ビット1  \n"
      + "         └-┘└-─┘└-─┘└-─┘                               \n"
      + "       qbf  qbf0   qbf1   qbf2  qbfn    qbfn+1 ←全量子状態       ");

    
    
    DJ.printS(1, "PhaseEstimation(6-1)", this); // Pause Task ------------------
    DJ.print("Code(6-1)①HHHゲート(H⊗H⊗H)を生成");
    DJ._print("・HHHゲート(H⊗H⊗H)を生成します。");
    QuGate hhhGate = hhGate.interactQuGate(hQuGate);
    DJ.printF("hhhGate", hhhGate); // HHH = H⊗H⊗H
    // hhhGate:F
    // ┌                                                                                                      ┐
    // │ 0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i│
    // │ 0.35355+0i  -0.35355+0i   0.35355+0i  -0.35355+0i   0.35355+0i  -0.35355+0i   0.35355+0i  -0.35355+0i│
    // │ 0.35355+0i   0.35355+0i  -0.35355+0i  -0.35355+0i   0.35355+0i   0.35355+0i  -0.35355+0i  -0.35355+0i│
    // │ 0.35355+0i  -0.35355+0i  -0.35355+0i   0.35355-0i   0.35355+0i  -0.35355+0i  -0.35355+0i   0.35355-0i│
    // │ 0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i  -0.35355+0i  -0.35355+0i  -0.35355+0i  -0.35355+0i│
    // │ 0.35355+0i  -0.35355+0i   0.35355+0i  -0.35355+0i  -0.35355+0i   0.35355-0i  -0.35355+0i   0.35355-0i│
    // │ 0.35355+0i   0.35355+0i  -0.35355+0i  -0.35355+0i  -0.35355+0i  -0.35355+0i   0.35355+0i   0.35355+0i│
    // │ 0.35355+0i  -0.35355+0i  -0.35355+0i   0.35355-0i  -0.35355+0i   0.35355-0i   0.35355+0i  -0.35355+0i│
    // └                                                                                                      ┘
    
    
    DJ.printS(1, "PhaseEstimation(6-1)②", this); // Pause Task ------------------
    DJ.print("Code(6-1)②HHHIIゲートを生成");
    DJ._print("・HHHIIゲート(H⊗H⊗H⊗I⊗I)を生成します。");
    QuGate hhhiiGate = new QuGate();
    hhhiiGate.setGateMat(hhhGate.copyGateMat());
    for (int i = 0; i < 2; i++) {
      hhhiiGate = hhhiiGate.interactQuGate(iQuGate);
    }
    DJ.printF("hhhiiGate", hhhiiGate); // HHHII = H⊗H⊗H⊗I⊗I
    // hhhiiGate:F
    // ┌                                                                                                          ┐
    // │ 0.35355+0i   0+0i         0+0i         0+0i        ..   0.35355+0i   0+0i         0+0i         0+0i      │
    // │ 0+0i         0.35355+0i   0+0i         0+0i        ..   0+0i         0.35355+0i   0+0i         0+0i      │
    // │ 0+0i         0+0i         0.35355+0i   0+0i        ..   0+0i         0+0i         0.35355+0i   0+0i      │
    // │ 0+0i         0+0i         0+0i         0.35355+0i  ..   0+0i         0+0i         0+0i         0.35355+0i│
    // │  :            :            :            :                :            :            :            :        │
    // │  :            :            :            :                :            :            :            :        │
    // │ 0.35355+0i   0+0i         0+0i         0+0i        ..  -0.35355+0i  -0+0i        -0+0i        -0+0i      │
    // │ 0+0i         0.35355+0i   0+0i         0+0i        ..  -0+0i        -0.35355+0i  -0+0i        -0+0i      │
    // │ 0+0i         0+0i         0.35355+0i   0+0i        ..  -0+0i        -0+0i        -0.35355+0i  -0+0i      │      
    // │ 0+0i         0+0i         0+0i         0.35355+0i  ..  -0+0i        -0+0i        -0+0i        -0.35355+0i│
    // └                                                                                                          ┘ 

    
    
    DJ.printS(2, "PhaseEstimation（6-2）", this); // Pause Task ------------------
    DJ.print("Code(6-2)コントロール・ユニタリ・ゲートC-U0を作成");
    
    DJ._print("Code(6-2)①C-SゲートIICSIを生成");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(sQuGate.copyGateMat());
    numOfBits = 5; // 量子ビット数
    target = 3; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 2;
    DJ.print("targetGate = S-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    QuGate iicSiGate = new QuGate(targetGate, numOfBits, target, controlArray);
    // DJ.printF("iicSiGate", iicSiGate); // IICSIゲート
    
    
    DJ._print("Code(6-2)②C-TゲートIICITを生成");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(tQuGate.copyGateMat());
    numOfBits = 5; // 量子ビット数
    target = 4; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 2;
    DJ.print("targetGate = T-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    QuGate iiciTGate = new QuGate(targetGate, numOfBits, target, controlArray);
    // DJ.printF("iiciTGate", iiciTGate); // IICITゲート
    
    
    DJ.printS(1, "PhaseEstimation（6-3）", this); // Pause Task ------------------
    DJ.print("Code(6-3)コントロール・ユニタリ・ゲートC-U1を作成");
    
    DJ._print("Code(6-3)①C-SゲートICISIを生成します。");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(sQuGate.copyGateMat());
    numOfBits = 5; // 量子ビット数
    target = 3; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 1;
    DJ.print("targetGate = S-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    QuGate iciSiGate = new QuGate(targetGate, numOfBits, target, controlArray);
    // DJ.printF("iciSiGate", iciSiGate); // ICISIゲート
    
    DJ._print("Code(6-3)②C-TゲートICIITを生成します。");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(tQuGate.copyGateMat());
    numOfBits = 5; // 量子ビット数
    target = 4; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 1;
    DJ.print("targetGate = T-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    QuGate iciiTGate = new QuGate(targetGate, numOfBits, target, controlArray);
    // DJ.printF("iciiTGate", iciiTGate); // ICIITゲート
    
    
    
    DJ.printS(1, "PhaseEstimation（6-4）", this); // Pause Task ------------------
    DJ.print("Code(6-4)コントロール・ユニタリ・ゲートC-U2を作成");
    
    DJ._print("Code(6-4)①コントロールSゲートCIISIを生成します。");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(sQuGate.copyGateMat());
    numOfBits = 5; // 量子ビット数
    target = 3; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 0;
    DJ.print("targetGate = S-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    QuGate ciiSiGate = new QuGate(targetGate, numOfBits, target, controlArray);
    // DJ.printF(", ciiSiGate", ciiSiGate); // CSIゲート
    // targetGate = S-Gate, numOfBits = 5, target = 3, controlArray[0]
    // ciiSiGate:F
    // ┌                                                                                                                                                                                                                              ┐
    // │ 1+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   1+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │  :      :        :      :      :      :      :      :      :      :      :      :      :      :      :      :      :      :      :  │
    // │  :      :        :      :      :      :      :      :      :      :      :      :      :      :      :      :      :      :      :  │
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   0+0i ..  1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   0+0i ..  0+0i  '1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f0←┐  
    // │ 0+0i   0+0i ..  0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f1←│┐
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f0←┘│
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f1←─┘
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f2
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f3
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f2
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f3
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f4
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│f5
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i   0+0i   0+0i   0+0i│f4
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i   0+0i   0+0i   0+0i   0+0i│f5
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i   0+0i   0+0i│f6
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '1+0i   0+0i   0+0i│f7
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i   0+0i│f6
    // │ 0+0i   0+0i ..  0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i  '0+1i│f7
    // └                        f0     f1     f0     f1     f2     f3     f2     f3     f4     f5     f4     f5     f6     f7     f6     f7  ┘
    
    
    // DJ.printS(1, "PhaseEstimation（6-4）②", this); // Pause Task ------------------
    DJ._print("Code(6-4)②コントロールTゲートCIIITを生成します。");
    targetGate = new QuGate(); // ターゲット量子ゲート
    targetGate.setGateMat(tQuGate.copyGateMat());
    numOfBits = 5; // 量子ビット数
    target = 4; // ターゲット量子ビット
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 0;
    DJ.print("targetGate = T-Gate" + ", numOfBits = " + numOfBits
          + ", target = " + target + ", controlArray", controlArray);
    QuGate ciiiTGate = new QuGate(targetGate, numOfBits, target, controlArray);
    // DJ.printF("ciiiTGate", ciiiTGate); // CTゲート
    // targetGate = T-Gate, numOfBits = 5, target = 4, controlArray[0]
    // ciiiTGate:F
    // ┌                                                                                             ┐
    // │ 1+0i   0+0i  ..  0+0i   0+0i               0+0i   0+0i               0+0i   0+0i            │
    // │ 0+0i   1+0i  ..  0+0i   0+0i               0+0i   0+0i               0+0i   0+0i            │
    // │  :      :         :      :                  :      :                  :      :              │
    // │  :      :         :      :                  :      :                  :      :              │
    // │ 0+0i   0+0i      1+0i   0+0i               0+0i   0+0i               0+0i   0+0i            │f5
    // │ 0+0i   0+0i      0+0i   0.70711+0.70711i   0+0i   0+0i               0+0i   0+0i            │f5
    // │ 0+0i   0+0i  ..  0+0i   0+0i               1+0i   0+0i               0+0i   0+0i            │f6
    // │ 0+0i   0+0i  ..  0+0i   0+0i               0+0i   0.70711+0.70711i   0+0i   0+0i            │f6
    // │ 0+0i   0+0i  ..  0+0i   0+0i               0+0i   0+0i               1+0i   0+0i            │f7
    // │ 0+0i   0+0i  ..  0+0i   0+0i               0+0i   0+0i               0+0i   0.70711+0.70711i│f7
    // └                  f5     f5                 f6     f6                 f7     f7              ┘
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "PhaseEstimation(6-5)", this); // Pause Task ------------------
    DJ.print("Code(6-5)逆量子フーリエ変換");
    DJ.print("　量子フーリエ変換行列Wを３量子ビットで生成し、\n"
           + "共役転置により逆行列にします。\n"
           + "　２量子ビットの単位ゲートと相互作用させ、"
           + "５量子ビットにします。");
    
    
    DJ._print("Code(6-5)①３量子ビットの量子フーリエ変換行列Wを生成");
    numOfQuBit = 3; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    DJ.print("QuGate wGate = new QuGate(QuGate.W_GATE, numOfQuBit);");
    QuGate w3Gate = new QuGate(QuGate.W_GATE, numOfQuBit);
    DJ.printF("w3Gate", w3Gate);
    // wGate:F
    // ┌                                                                                                      ┐
    // │ 0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i│
    // │ 0.35355+0i   0.25+0.25i   0+0.35355i  -0.25+0.25i  -0.35355+0i  -0.25-0.25i  -0-0.35355i   0.25-0.25i│
    // │ 0.35355+0i   0+0.35355i  -0.35355+0i  -0-0.35355i   0.35355-0i   0+0.35355i  -0.35355+0i  -0-0.35355i│
    // │ 0.35355+0i  -0.25+0.25i  -0-0.35355i   0.25+0.25i  -0.35355+0i   0.25-0.25i   0+0.35355i  -0.25-0.25i│
    // │ 0.35355+0i  -0.35355+0i   0.35355-0i  -0.35355+0i   0.35355-0i  -0.35355+0i   0.35355-0i  -0.35355+0i│
    // │ 0.35355+0i  -0.25-0.25i   0+0.35355i   0.25-0.25i  -0.35355+0i   0.25+0.25i  -0-0.35355i  -0.25+0.25i│
    // │ 0.35355+0i  -0-0.35355i  -0.35355+0i   0+0.35355i   0.35355-0i  -0-0.35355i  -0.35355+0i  -0+0.35355i│
    // │ 0.35355+0i   0.25-0.25i  -0-0.35355i  -0.25-0.25i  -0.35355+0i  -0.25+0.25i  -0+0.35355i   0.25+0.25i│
    // └                                                                                                      ┘
    
    
    DJ.printS(1, "PhaseEstimation(6-5)②", this); // Pause Task ------------------
    DJ._print("Code(6-5)②逆量子フーリエ変換行列を算出");
    QuGate w3InvGate = w3Gate.conjugate(); // Wの逆行列（共役転置）
    DJ.printF("w3InvGate", w3InvGate);
    // wInvGate:F
    // ┌                                                                                                      ┐
    // │ 0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i│
    // │ 0.35355-0i   0.25-0.25i   0-0.35355i  -0.25-0.25i  -0.35355-0i  -0.25+0.25i  -0+0.35355i   0.25+0.25i│
    // │ 0.35355-0i   0-0.35355i  -0.35355-0i  -0+0.35355i   0.35355+0i   0-0.35355i  -0.35355-0i  -0+0.35355i│
    // │ 0.35355-0i  -0.25-0.25i  -0+0.35355i   0.25-0.25i  -0.35355-0i   0.25+0.25i   0-0.35355i  -0.25+0.25i│
    // │ 0.35355-0i  -0.35355-0i   0.35355+0i  -0.35355-0i   0.35355+0i  -0.35355-0i   0.35355+0i  -0.35355-0i│
    // │ 0.35355-0i  -0.25+0.25i   0-0.35355i   0.25+0.25i  -0.35355-0i   0.25-0.25i  -0+0.35355i  -0.25-0.25i│
    // │ 0.35355-0i  -0+0.35355i  -0.35355-0i   0-0.35355i   0.35355+0i  -0+0.35355i  -0.35355-0i  -0-0.35355i│
    // │ 0.35355-0i   0.25+0.25i  -0+0.35355i  -0.25+0.25i  -0.35355-0i  -0.25-0.25i  -0-0.35355i   0.25-0.25i│
    // └                                                                                                      ┘
    
    
    DJ.printS(1, "PhaseEstimation(6-6)", this); // Pause Task ------------------
    DJ.print("Code(6-6)逆量子フーリエ変換を生成");
    DJ.print("・行列wInvGateとIIゲートを相互作用させ、\n"
            + "５量子ゲートを生成します。");
    DJ.print("  w3Inv_I2 = w3InvGate⊗I2");
    
    DJ._print("Code(6-6)①２量子ビットの単位ゲートを生成");
    numOfQuBit = 2;
    QuGate iiQuGate = new QuGate(numOfQuBit);
    DJ.printF("iiQuGate", iiQuGate);
    // iiQuGate:F
    // ┌                          ┐
    // │ 1+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   1+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   1+0i   0+0i│
    // │ 0+0i   0+0i   0+0i   1+0i│
    // └                          ┘
    
    
    DJ.printS(1, "PhaseEstimation(6-6)②", this); // Pause Task ------------------
    DJ.print("Code(6-6)②行列WInvIIを生成");
    DJ.print("・行列w3InvGateとIIゲートを相互作用させます。");
    DJ.print("  w3Inv_II = w3InvGate⊗II");
    
   DJ.print("  QuGate w3InvIiGate = w3InvGate.interactQuGate(iiQuGate)");
    QuGate w3InvIiGate = w3InvGate.interactQuGate(iiQuGate);
    // DJ.printF("w3InvIiGate", w3InvIiGate);
    // wInvIiGate:F
    // ┌                                                                                                           ┐
    // │ 0.35355+0i   0+0i         0+0i         0+0i         ..   0.35355+0i   0+0i         0+0i         0+0i      │
    // │ 0+0i         0.35355+0i   0+0i         0+0i         ..   0+0i         0.35355+0i   0+0i         0+0i      │
    // │ 0+0i         0+0i         0.35355+0i   0+0i         ..   0+0i         0+0i         0.35355+0i   0+0i      │
    // │ 0+0i         0+0i         0+0i         0.35355+0i   ..   0+0i         0+0i         0+0i         0.35355+0i│
    // │ 0.35355+0i   0+0i         0+0i         0+0i         ..   0.25+0.25i   0+0i         0+0i         0+0i      │
    // │ 0+0i         0.35355+0i   0+0i         0+0i         ..   0+0i         0.25+0.25i   0+0i         0+0i      │
    // │ 0+0i         0+0i         0.35355+0i   0+0i         ..   0+0i         0+0i          0.25+0.25i  0+0i      │
    // │ 0+0i         0+0i         0+0i         0.35355+0i   ..   0+0i         0+0i         0+0i         0.25+0.25i│
    // │  :            :            :            :                 :            :            :            :        │
    // │  :            :            :            :                 :            :            :            :        │
    // │ 0.35355+0i   0+0i         0+0i         0+0i         ..   0.25-0.25i   0+0i         0+0i         0+0i      │
    // │ 0+0i         0.35355+0i   0+0i         0+0i         ..   0+0i         0.25-0.25i   0+0i         0+0i      │
    // │ 0+0i         0+0i         0.35355+0i   0+0i         ..   0+0i         0+0i         0.25-0.25i   0+0i      │
    // │ 0+0i         0+0i         0+0i         0.35355+0i   ..   0+0i         0+0i         0+0i         0.25-0.25i│
    // └                                                                                                           ┘
    
    
    DJ.printS(1, "PhaseEstimation(6-7)", this); // Pause Task ------------------
    DJ.print("Code(6-7)量子位相推定を実行");
    DJ.print("・ターゲット量子ビットの量子状態を"
           + "実行毎に変化させます。");
    
    DJ.print("QuBit e30_fQB = QuBit.unitQuBit(numOfQuBit, paId);");
    numOfQuBit = 5; // 量子ビット数
    DJ.print("numOfQuBit = " +  numOfQuBit);
    DJ.print("");
    for (int i = 0; i < 4; i++) { // 4 = 2^2
      int paId = i + 0; // '1'にする確率振幅のインデックス
      DJ._print("paId = ", paId);
      QuBit qbf0 = QuBit.unitQuBit(numOfQuBit, paId);
      // DJ.printF(",  qbf0", qbf0);
      DJ.print("qbf0", qbf0);
    
      // DJ.print("①入力量子ビットqbf0を量子ゲートhhhiiGateに適用します。");
      DJ.print("QuBit qbf1 = hhhiiGate.apply(qbf0);");
      QuBit qbf1 = hhhiiGate.apply(qbf0);
      // DJ.print("qbf1", qbf1);
      
      // DJ.print("②量子ビットqbf1を量子ゲートiicSiGateに適用します。");
      QuBit oprandQB = iicSiGate.apply(qbf1); // qbf2_
      // DJ.print("qbf2_", oprandQB);
      
      // DJ.print("③量子ビットqbf1sを量子ゲートiiciTGateに適用します。");
      oprandQB = iiciTGate.apply(oprandQB); // qbf2
      // DJ.printF("qbf2", oprandQB);
      
      // DJ.print("④量子ゲートiciSiGateとiciiTGateに各々２回適用します。");
      for (int j = 0; j < 2; j++) {
        oprandQB = iciSiGate.apply(oprandQB); // qbf3_
        oprandQB = iciiTGate.apply(oprandQB); // qbf3
      }      
      // DJ.printF("qbf3", oprandQB);
      
      // DJ.print("⑤量子ゲートciiSiGateとciiiTGateに各々４回適用します。");
      for (int j = 0; j < 4; j++) {
        oprandQB = ciiSiGate.apply(oprandQB); // qbfn_
        oprandQB = ciiiTGate.apply(oprandQB); // qbfn
      }      
      // DJ.printF("qbf4", oprandQB);
      
      // DJ.print("⑥量子ビットqbf4を行列wInvIiGateに適用します。");
      oprandQB = w3InvIiGate.apply(oprandQB); // qbfn+1
      DJ.printF("qbfn+1", oprandQB);
      
      // DJ.print("⑤３量子ビットqbfn+1の遷移確率を求めます。");
      double[][] result = oprandQB.getTransProb();
      DJ.printF("result", result);
    }
      
    DJ._print("・５量子ビット量子位相推定の実行完了");
    
    //  paId = 0
    //  qbfn+1:F 
    //  ┌     ┐ ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐ 
    //  │ 1+0i│=│1│ⓧ│1│ⓧ│1│ⓧ│1│ⓧ│1│
    //  │ 0+0i│ │0│  │0│  │0│  │0│  │0│
    //  │ 0+0i│ └ ┘  └ ┘  └ ┘  └ ┘  └ ┘  
    //  │ 0+0i│  補助量子ビット       入力量子ビット
    //  │-0+0i│  二進数：000          二進数：00
    //  │ 0+0i│
    //  │ 0+0i│　固有値：１
    //  │ 0+0i│　位相：0＝0.000 * 2π
    //  │-0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │-0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │-0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │-0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  └     ┘
    //  result=
    //  [[1, 1, 1, 1, 1]
    //  [0, 0, 0, 0, 0]
    //  ]

    //  paId = 1
    //  qbfn+1:F 
    //  ┌     ┐ ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐ 
    //  │ 0+0i│=│1│ⓧ│1│ⓧ│0│ⓧ│1│ⓧ│0│
    //  │-0+0i│ │0│  │0│  │1│  │0│  │1│
    //  │ 0+0i│ └ ┘  └ ┘  └ ┘  └ ┘  └ ┘  
    //  │ 0+0i│  補助量子ビット       入力量子ビット
    //  │ 0+0i│  二進数：001          二進数：01
    //  │ 1-0i│←5
    //  │ 0+0i│
    //  │ 0+0i│　固有値：exp(iπ/4)   
    //  │ 0+0i│　位相：π/4 = 0.001 * 2π
    //  │ 0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  └     ┘
    //  result=
    //  [[1, 1, 0, 1, 0]
    //  [0, 0, 1, 0, 1]
    //  ]
    
    //  paId = 2
    //  qbfn+1:F 
    //  ┌     ┐ ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐ 
    //  │ 0+0i│=│1│ⓧ│0│ⓧ│1│ⓧ│0│ⓧ│1│
    //  │ 0+0i│ │0│  │1│  │0│  │1│  │0│
    //  │-0+0i│ └ ┘  └ ┘  └ ┘  └ ┘  └ ┘
    //  │ 0+0i│  補助量子ビット       入力量子ビット
    //  │ 0+0i│  二進数：010          二進数：10
    //  │ 0+0i│
    //  │-0+0i│　固有値：exp(iπ/2)
    //  │ 0+0i│　位相：π/2 = 0.010 * 2π
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 1+0i│←10
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │-0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │-0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  │ 0+0i│
    //  └     ┘
    //  result=
    //  [[1, 0, 1, 0, 1]
    //  [0, 1, 0, 1, 0]
    //  ]

    //  paId = 3
    //  qbfn+1:F 
    //  ┌     ┐ ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐  ┌ ┐ 
    //  │ 0+0i│=│1│ⓧ│0│ⓧ│0│ⓧ│0│ⓧ│0│
    //  │ 0+0i│ │0│  │1│  │1│  │1│  │1│
    //  │ 0+0i│ └ ┘  └ ┘  └ ┘  └ ┘  └ ┘  
    //  │-0+0i│  補助量子ビット       入力量子ビット
    //  │ 0+0i│  二進数：011          二進数：11
    //  │ 0+0i│
    //  │ 0+0i│　固有値：exp(i3π/4)
    //  │-0+0i│　位相：3π/4 = 0.011 * 2π
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │-0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 1-0i│←15
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │-0-0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0+0i│
    //  │ 0-0i│
    //  └     ┘
    //  result=
    //  [[1, 0, 0, 0, 0]
    //  [0, 1, 1, 1, 1]
    //  ]
   
    DJ._print("##### PhaseEstimationの処理を終了します　#####");
  } // phaseEstimation()

} // PhaseEstimation Class

// End of file
