/*
 *  Title: DaiJa_V5 (Digital-learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020 - 2025
 */
package task.qu;

import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.DJ;
import util.TimeStamp;
import util.comp.CompMat;

/**
 * <p> 表　題: Class: Quantum Fourier Transfrom</p>
 * <p> 説　明: 量子フーリエ変換</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2025</p>
 * <p> 作成日: 2024.08.27</p>
 * <p> 作成日: 2025.04.16,更新</p>
 */
public class QuantumFourierTransfrom extends Task {
  
  // 学習・試行制御
  int epoch = 2; // エポックの回数
  int interval = 1; //10; // 経過表示間隔
  int dataNum = 200; // エポック毎の学習データ数
  
  // 量子計算パラメータ
  int delta = 30; // 5; //10; //15; // 基底角度の増分（度）

  /**
   * Taskクラスで新しく作られたスレッドから呼び出される
   */
  @Override
  public void runTask() {
    DJ._print("・タスク開始日時：", TimeStamp.getTimeFormated());
    beginTime = System.currentTimeMillis(); // タスク開始時刻
    
    // パターン・ビューワ・ランチャを得る
    //  patternViewerFlag = true; //true; // false:非表示
    //  patternData0 = new double[5][dataNum]; // 附番,
    //  patternData1 = new double[5][dataNum]; // ID,
    //  patternViewerLauncher = DJ.pattern(  // 判定パターン、データ、タイトル
    //    PatternViewer.PATTERN_TUNER, patternData0, "QuantumFourierTransfrom",
    //    PatternViewer.PATTERN_TUNER, patternData1, "QuantumFourierTransfrom");
    
    this.stepMode = true; // タスクのステップ実行モード
    
    quantumFourierTransfrom(); // タスク本体の呼び出し
  }
  
  /** 
   * 量子フーリエ変換 QFT:Quantum Fourier Transform
   * （１）量子フーリエ変換（Wゲート）
   * （２）量子フーリエ変換（RKゲート）
   */
  public void quantumFourierTransfrom() {
    DJ._print("QuantumFourierTransfrom.quantumFourierTransfrom() ========================");
    DJ.print("■量子フーリエ変換 QFT： Quantum Fourier Transfrom");
    DJ.print("(1)量子フーリエ変換用ゲート（Wゲート）");
    DJ.print("(1-1)量子ビット用フーリエ変換用ゲートwGate(1)");
    DJ.print("(1-2)２量子ビット用フーリエ変換用ゲートwGate(2)");
    DJ.print("(1-3)３量子ビット用フーリエ変換用ゲートwGate(3)");
    DJ.print("(2)回転量子ゲート（RKゲート）による量子フーリエ変換");
    DJ.print("(2-1)１量子ビットの量子フーリエ変換");
    DJ.print("(2-2)２量子ビットを量子フーリエ変換");
    
    DJ._print("・タスク実行パラメータ");
    DJ.print("　エポックの回数：epoch = ",epoch);
    DJ.print("　経過表示間隔：interval = ",interval);
    DJ.print("　学習データ数：dataNum = ", dataNum);
    DJ.print("・量子計算のパラメータ");
    DJ.print("　基底角度の増分（度）：delta = ",delta);

    
    // this.stepMode = true; // タスクのステップ実行モードON
    DJ.printS(3, "QuantumFourierTransfrom(1)", this); // Pause Task ------------------
    DJ._print("Code(1)量子フーリエ変換");
    
    DJ._print("Code(1-1)量子フーリエ変換用ゲート（Wゲート）");
    DJ.print("Code(1-1)①１量子ビットのフーリエ変換用ゲートwGate(1)を生成");
    int numOfQuBit = 1; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    QuGate wGate = new QuGate(QuGate.W_GATE, numOfQuBit);
    DJ.printF("wGate(" + numOfQuBit + ")", wGate);
    // wGate(1):F
    // ┌                        ┐       ┌     ┐
    // │ 0.70711+0i   0.70711+0i│= 1/√2│ 1  1│
    // │ 0.70711+0i  -0.70711+0i│       │ 1 -1│
    // └                        ┘       └     ┘
    
    DJ._print("　wGate(1)ゲートとアダマールゲートと比較します。");
    QuGate hGate = new QuGate(QuGate.H_GATE);
    DJ.printF("hGate", hGate);
    // hGate:F
    // ┌                        ┐       ┌     ┐
    // │ 0.70711+0i   0.70711+0i│= 1/√2│ 1  1│
    // │ 0.70711+0i  -0.70711+0i│       │ 1 -1│
    // └                        ┘       └     ┘
    
    DJ.printS(1, "QuantumFourierTransfrom(1-1)②", this); // Pause Task ------------------
    DJ._print("Code(1-1)②１量子ビットの標準量子ビットstd0QuBitを生成");
    QuBit std0QuBit = new QuBit(QuBit.STD0_QUBIT);
    DJ.printF("std0QuBit(" + numOfQuBit + ")", std0QuBit);
    // std0QuBit(1):F
    // ┌     ┐
    // │ 1+0i│= [1 0]'= |0>
    // │ 0+0i│
    // └     ┘
    
    DJ._print("・標準量子ビットstd0QuBitを量子ゲートwGateに適用し、"
            + "フーリエ変換します。");
    DJ.print("QuBit ftQB = wGate.apply(std0QuBit);");
    QuBit ft0QB = wGate.apply(std0QuBit);
    DJ.printF("ft0QB", ft0QB);
    // ft0QB:F 
    // ┌           ┐          ┌  ┐ ┌  ┐
    // │ 0.70711+0i│= (1/√2)(│ 1│+│ 0│) = (1/√2)(|0> + |1>)
    // │ 0.70711+0i│          │ 0│ │ 1│
    // └           ┘          └  ┘ └  ┘
    
    DJ.printS(1, "QuantumFourierTransfrom(1-1)③", this); // Pause Task ------------------
    DJ._print("Code(1-1)③１量子ビットの標準量子ビットstd1QuBitを生成");
    QuBit std1QuBit = new QuBit(QuBit.STD1_QUBIT);
    DJ.printF("std1QuBit(" + numOfQuBit + ")", std1QuBit);
    // std0QuBit(1):F
    // ┌     ┐
    // │ 0+0i│
    // │ 1+0i│
    // └     ┘
    
    DJ._print("・標準量子ビットstd1QuBitを量子ゲートwGateに適用し、"
            + "フーリエ変換します。");
    DJ.print("ft1QB = wGate.apply(std1QuBit);");
    QuBit ft1QB = wGate.apply(std1QuBit);
    DJ.printF("ft1QB", ft1QB);
    // ft1QB:F 
    // ┌           ┐          ┌  ┐ ┌  ┐ 
    // │ 0.70711+0i│= (1/√2)(│ 1│-│ 0│) 
    // │-0.70711+0i│          │ 0│ │ 1│ 
    // └           ┘          └  ┘ └  ┘ 


    DJ.printS(2, "QuantumFourierTransfrom(1-1)④", this); // Pause Task ------------
    DJ.print("Code(1-1)④逆量子フーリエ変換");

    DJ._print("・量子ゲートwGateが逆行列に等しいことを検証します。");
    QuGate iGate = wGate.innerProduct(wGate);
    DJ.printF("iGate", iGate);
    // iGate:F
    // ┌            ┐
    // │ 1+0i   0+0i│
    // │ 0-0i   1+0i│
    // └            ┘

    // 上書きされていないことをチェックします。
    // DJ.printF("wGate(" + numOfQuBit + ")", wGate);

    
    DJ._print("・量子ゲートwGateの共役転置行列wInvGateを求めます。");
    QuGate wInvGate = wGate.conjugate();
    DJ.printF("wInvGate", wInvGate);
    // wInvGate:F
    // ┌                        ┐
    // │ 0.70711-0i   0.70711-0i│
    // │ 0.70711-0i  -0.70711-0i│
    // └                        ┘
    
    // DJ._print("　量子ゲートwInvGateが逆行列であることを検証します。");
    // iGate = wInvGate.product(wGate);
    // DJ.printF("iGate", iGate);
    // iGate:F
    
    DJ._print("・フーリエ変換された量子ビットft1QBを量子ゲートwInvGateに\n"
        + "　適用し、逆フーリエ変換します。");
    QuBit wInvQB = wInvGate.apply(ft1QB);
    DJ.printF("wInvQB", wInvQB);
    // wInvQB:F 
    // ┌     ┐
    // │ 0+0i│ = std1QuBit
    // │ 1+0i│
    // └     ┘
    DJ.print("　元の標準量子ビットstd1QuBitに戻りました。");
    
    
    
    // this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "QuantumFourierTransfrom(1-2)", this); // Pause Task -----------------
    DJ._print("Code(1-2)２量子ビット用のWゲート");
    
    DJ._print("Code(1-2)①２量子ビットのフーリエ変換用ゲートを生成");
    numOfQuBit = 2; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    wGate = new QuGate(QuGate.W_GATE, numOfQuBit);
    DJ.printF("wGate(" + numOfQuBit + ")", wGate);
    // wGate:F
    // ┌                                  ┐     ┌           ┐
    // │ 0.5+0i   0.5+0i   0.5+0i   0.5+0i│= 1/2│ 1  1  1  1│
    // │ 0.5+0i   0+0.5i  -0.5+0i  -0-0.5i│     │ 1  i -1 -i│
    // │ 0.5+0i  -0.5+0i   0.5-0i  -0.5+0i│     │ 1 -1  1 -1│
    // │ 0.5+0i  -0-0.5i  -0.5+0i   0+0.5i│     │ 1 -i -1  i│
    // └                                  ┘     └           ┘

    DJ._print("・wGateの各要素に2を掛けて標準化します。");
    CompMat wGateMat = wGate.copyGateMat();
    wGateMat.product(2.0);
    DJ.printF("wGateMat(" + numOfQuBit + ")", wGateMat);
    // wGateMat(2):F
    // ┌                          ┐ ┌           ┐ ┌               ┐
    // │ 1+0i   1+0i   1+0i   1+0i│=│ 1  1  1  1│+│ 0i  0i  0i  0i│
    // │ 1+0i   0+1i  -1+0i  -0-1i│ │ 1  0 -1  0│ │ 0i  1i  0i -1i│
    // │ 1+0i  -1+0i   1-0i  -1+0i│ │ 1 -1  1 -1│ │ 0i  0i  0i  0i│
    // │ 1+0i  -0-1i  -1+0i   0+1i│ │ 1  0 -1  0│ │ 0i -1i  0i  1i│
    // └                          ┘ └           ┘ └               ┘
    
    
    DJ.printS(2, "QuantumFourierTransfrom(1-2)②", this); // Pause Task -----------------
    DJ._print("Code(1-2)②２量子ビットの量子フーリエ変換");
    
    DJ._print("・２量子ビットの標準量子ビットstd0QuBitを生成します。");
    numOfQuBit = 2; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    std0QuBit = QuBit.unitQuBit(numOfQuBit, QuBit.PA0);
    DJ.printF("std0QuBit(" + numOfQuBit + ")", std0QuBit);
    // std0QuBit(2):F
    // ┌     ┐
    // │ 1+0i│= [1 0 0 0]'
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // └     ┘
    
    DJ._print("・標準量子ビットstd1QuBitを量子ゲートwGateに適用し、"
        + "フーリエ変換します。");
    DJ.print("QuBit ft0QB = wGate.apply(std0QuBit);");
    ft0QB = wGate.apply(std0QuBit);
    DJ.printF("ft0QB", ft0QB);
    // ft0QB:F 
    // ┌       ┐        ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐
    // │ 0.5+0i│= (1/2)(│ 1│+│ 0│+│ 0│+│ 0│)
    // │ 0.5+0i│        │ 0│ │ 1│ │ 0│ │ 0│
    // │ 0.5+0i│        │ 0│ │ 0│ │ 1│ │ 0│
    // │ 0.5+0i│        │ 0│ │ 0│ │ 0│ │ 1│
    // └       ┘        └  ┘ └  ┘ └  ┘ └  ┘
    
    
    DJ.printS(2, "QuantumFourierTransfrom(1-2)③", this); // Pause Task -----------------
    DJ._print("Code(1-2)③２量子ビットの標準量子ビットstd1QuBitを生成");
    numOfQuBit = 2; // 量子ビット数
    DJ.print_("numOfQuBit = ", numOfQuBit);
    int numOfPa = QuBit.calcNumOfProbAmp(numOfQuBit); // 確率振幅の個数
    DJ.print(",  numOfPa = ", numOfPa);
    std1QuBit = QuBit.unitQuBit(numOfQuBit, numOfPa - 1); // 最後の確率振幅
    DJ.printF("std1QuBit(" + numOfQuBit + ")", std1QuBit);
    // std1QuBit:F
    // ┌     ┐
    // │ 0+0i│= [0 0 0 1]'
    // │ 0+0i│
    // │ 0+0i│
    // │ 1+0i│
    // └     ┘
    
    DJ._print("・標準量子ビットstd1QuBitを量子ゲートwGateに適用し、"
        + "フーリエ変換します。");
    DJ.print("QuBit ft1QB = wGate.apply(std1QuBit);");
    ft1QB = wGate.apply(std1QuBit);
    DJ.printF("ft1QB", ft1QB);
    // ft1QB:F 
    // ┌       ┐        ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐
    // │ 0.5+0i│= (1/2)(│ 1│+│ 0│+│ 0│+│ 0│)
    // │-0-0.5i│        │ 0│ │-i│ │ 0│ │ 0│
    // │-0-0.5i│        │ 0│ │ 0│ │-i│ │ 0│
    // │ 0.5+0i│        │ 0│ │ 0│ │ 0│ │ 1│
    // └       ┘        └  ┘ └  ┘ └  ┘ └  ┘

    
    DJ.printS(2, "QuantumFourierTransfrom(1-2)④", this); // Pause Task -----------------
    DJ._print("Code(1-2)④量子ゲートwGateが逆行列に等しいことを検証");
    iGate = wGate.innerProduct(wGate);
    DJ.printF("iGate", iGate);
    // iGate:F
    // ┌                          ┐
    // │ 1+0i  -0+0i   0+0i   0+0i│
    // │-0-0i   1+0i  -0+0i   0+0i│
    // │ 0-0i  -0-0i   1+0i  -0+0i│
    // │ 0-0i   0-0i  -0-0i   1+0i│
    // └                          ┘

    // 上書きされていないことをチェックします。
    // DJ.printF("wGate(" + numOfQuBit + ")", wGate);
    
    
    
    // this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "QuantumFourierTransfrom(1-3)", this); // Pause Task -----------------
    DJ._print("Code(1-3)量子フーリエ変換用ゲート（3量子ビットのWゲート）");

    DJ._print("Code(1-3)①３量子ビットのフーリエ変換用ゲートwGateを生成");
    numOfQuBit = 3; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    QuGate w3Gate = new QuGate(QuGate.W_GATE, numOfQuBit);
    DJ.printF("w3Gate", w3Gate);
    // w3Gate:F
    // ┌                                                                                                      ┐
    // │ 0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i   0.35355+0i│
    // │ 0.35355+0i   0.25+0.25i   0+0.35355i  -0.25+0.25i  -0.35355+0i  -0.25-0.25i  -0-0.35355i   0.25-0.25i│
    // │ 0.35355+0i   0+0.35355i  -0.35355+0i  -0-0.35355i   0.35355-0i   0+0.35355i  -0.35355+0i  -0-0.35355i│
    // │ 0.35355+0i  -0.25+0.25i  -0-0.35355i   0.25+0.25i  -0.35355+0i   0.25-0.25i   0+0.35355i  -0.25-0.25i│
    // │ 0.35355+0i  -0.35355+0i   0.35355-0i  -0.35355+0i   0.35355-0i  -0.35355+0i   0.35355-0i  -0.35355+0i│
    // │ 0.35355+0i  -0.25-0.25i   0+0.35355i   0.25-0.25i  -0.35355+0i   0.25+0.25i  -0-0.35355i  -0.25+0.25i│
    // │ 0.35355+0i  -0-0.35355i  -0.35355+0i   0+0.35355i   0.35355-0i  -0-0.35355i  -0.35355+0i  -0+0.35355i│
    // │ 0.35355+0i   0.25-0.25i  -0-0.35355i  -0.25-0.25i  -0.35355+0i  -0.25+0.25i  -0+0.35355i   0.25+0.25i│
    // └                                                                                                      ┘
    
    DJ._print("・wGateの各要素に2√2を掛けて標準化します。");
    CompMat w3GateMat = w3Gate.copyGateMat();
    w3GateMat.product(2.0 * Math.sqrt(2.0));
    DJ.printF("w3GateMat", w3GateMat);
    // w3GateMat:F
    // ┌                                                                                                      ┐
    // │ 1+0i   1+0i               1+0i   1+0i               1+0i   1+0i               1+0i   1+0i            │
    // │ 1+0i   0.70711+0.70711i   0+1i  -0.70711+0.70711i  -1+0i  -0.70711-0.70711i  -0-1i   0.70711-0.70711i│
    // │ 1+0i   0+1i              -1+0i  -0-1i               1-0i   0+1i              -1+0i  -0-1i            │
    // │ 1+0i  -0.70711+0.70711i  -0-1i   0.70711+0.70711i  -1+0i   0.70711-0.70711i   0+1i  -0.70711-0.70711i│
    // │ 1+0i  -1+0i               1-0i  -1+0i               1-0i  -1+0i               1-0i  -1+0i            │
    // │ 1+0i  -0.70711-0.70711i   0+1i   0.70711-0.70711i  -1+0i   0.70711+0.70711i  -0-1i  -0.70711+0.70711i│
    // │ 1+0i  -0-1i              -1+0i   0+1i               1-0i  -0-1i              -1+0i  -0+1i            │
    // │ 1+0i   0.70711-0.70711i  -0-1i  -0.70711-0.70711i  -1+0i  -0.70711+0.70711i  -0+1i   0.70711+0.70711i│
    // └                                                                                                      ┘

    
    DJ.printS(2, "QuantumFourierTransfrom(1-3)②", this); // Pause Task -----------------
    DJ._print("code(1-3)②３量子ビットを量子フーリエ変換");
    
    DJ._print("・３量子ビットの標準量子ビットstd0QuBitを生成します。");
    numOfQuBit = 3; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    QuBit std3_0QuBit = QuBit.unitQuBit(numOfQuBit, 0);
    DJ.printF("std3_0QuBit", std3_0QuBit);
    // std3_0QuBit:F
    // ┌     ┐
    // │ 1+0i│= [1 0 0 0 0 0 0 0]'
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // └     ┘
    
    DJ._print("　標準量子ビットstd3_0QuBitを量子ゲートw3Gateに適用し、"
        + "フーリエ変換します。");
    DJ.print("QuBit ft3_0QB = w3Gate.apply(std3_0QuBit);");
    QuBit ft3_0QB = w3Gate.apply(std3_0QuBit);
    DJ.printF("ft3_0QB", ft3_0QB);
    // ft3_0QB:F 
    // ┌           ┐           ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐
    // │ 0.35355+0i│= (1/2√2)(│ 1│+│ 0│+│ 0│+│ 0│+│ 0│+│ 0│+│ 0│+│ 0│)
    // │ 0.35355+0i│           │ 0│ │ 1│ │ 0│ │ 0│ │ 0│ │ 0│ │ 0│ │ 0│
    // │ 0.35355+0i│           │ 0│ │ 0│ │ 1│ │ 0│ │ 0│ │ 0│ │ 0│ │ 0│
    // │ 0.35355+0i│           │ 0│ │ 0│ │ 0│ │ 1│ │ 0│ │ 0│ │ 0│ │ 0│
    // │ 0.35355+0i│           │ 0│ │ 0│ │ 0│ │ 0│ │ 1│ │ 0│ │ 0│ │ 0│
    // │ 0.35355+0i│           │ 0│ │ 0│ │ 0│ │ 0│ │ 0│ │ 1│ │ 0│ │ 0│
    // │ 0.35355+0i│           │ 0│ │ 0│ │ 0│ │ 0│ │ 0│ │ 0│ │ 1│ │ 0│
    // │ 0.35355+0i│           │ 0│ │ 0│ │ 0│ │ 0│ │ 0│ │ 0│ │ 0│ │ 1│
    // └           ┘           └  ┘ └  ┘ └  ┘ └  ┘ └  ┘ └  ┘ └  ┘ └  ┘
    //          = (1/2√2)(|000> + |001> + |010> + |011> + |100> + |101> + |110> + |111>)
    
    
    DJ.printS(2, "QuantumFourierTransfrom(1-3)③", this); // Pause Task -----------------
    DJ._print("Code(1-3)③３量子ビットの標準量子ビットstd1QuBitを生成");
    numOfQuBit = 3; // 量子ビット数
    DJ._print_("numOfQuBit = ", numOfQuBit);
    numOfPa = QuBit.calcNumOfProbAmp(numOfQuBit); // 確率振幅の個数
    DJ.print(",  numOfPa = ", numOfPa);
    QuBit std3_1QuBit = QuBit.unitQuBit(numOfQuBit, numOfPa - 1); // 最後の確率振幅
    DJ.printF("std3_1QuBit", std3_1QuBit);
    // std3_1QuBit:F
    // ┌     ┐
    // │ 0+0i│= [0 0 0 0 0 0 0 1]'= |111>
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // │ 1+0i│
    // └     ┘
    
    DJ._print("・標準量子ビットstd3_1QuBitを量子ゲート3Gateに適用し、"
        + "フーリエ変換します。");
    DJ.print("QuBit ft3_1QB = w3Gate.apply(std3_1QuBit);");
    QuBit ft3_1QB = w3Gate.apply(std3_1QuBit);
    DJ.printF("ft3_1QB", ft3_1QB);
    // ft3_1QB:F
    // ┌           ┐           ┌  ┐ ┌             ┐ ┌  ┐ ┌             ┐       ┌            ┐
    // │ 0.35355+0i│= (1/2√2)(│ 1│+│ 0           │+│ 0│+│            0│+ ... +│ 0          │)
    // │ 0.25-0.25i│           │ 0│ │(1/√2)( 1-i)│ │ 0│ │            0│  ...  │ 0          │
    // │-0-0.35355i│           │ 0│ │ 0           │ │-i│ │            0│  ...  │ 0          │
    // │-0.25-0.25i│           │ 0│ │ 0           │ │ 0│ │(1/√2)(-1-i)│  ...  │ 0          │
    // │-0.35355+0i│           │ 0│ │ 0           │ │ 0│ │ 0           │  ...  │ 0          │
    // │-0.25+0.25i│           │ 0│ │ 0           │ │ 0│ │ 0           │  ...  │ 0          │
    // │-0+0.35355i│           │ 0│ │ 0           │ │ 0│ │ 0           │  ...  │ 0          │
    // │ 0.25+0.25i│           │ 0│ │ 0           │ │ 0│ │ 0           │  ...  │(1/√2)(1+i)│
    // └           ┘           └  ┘ └             ┘ └  ┘ └             ┘  ...  └            ┘
    //      = (1/2√2)(|000> + (1/√2)(1-i)||001> -i|010> - (1/√2)(1+i)||001>  + ... + (1/√2)(1+i)|111>)

    
    
    DJ.printS(2, "QuantumFourierTransfrom(1-3)④", this); // Pause Task ------------
    DJ._print("Code(1-3)④３量子ビットの逆行列");

    DJ._print("・量子ゲートwGateが逆行列に等しいことを検証します。");
    QuGate i3Gate = w3Gate.innerProduct(w3Gate);
    DJ.printF("i3Gate", i3Gate);
    // i3Gate:F
    // ┌                                                      ┐
    // │ 1+0i  -0-0i  -0+0i  -0-0i   0+0i  -0+0i  -0+0i   0-0i│= [I]
    // │-0+0i   1+0i  -0+0i   0+0i  -0+0i  -0-0i   0-0i   0-0i│
    // │-0-0i  -0-0i   1+0i  -0+0i  -0+0i   0+0i   0+0i   0+0i│
    // │-0+0i   0-0i  -0-0i   1+0i  -0-0i  -0+0i   0-0i  -0+0i│
    // │ 0-0i  -0-0i  -0-0i  -0+0i   1+0i  -0-0i   0+0i  -0+0i│
    // │-0-0i  -0+0i   0-0i  -0-0i  -0+0i   1+0i   0+0i   0-0i│
    // │-0-0i   0+0i   0-0i   0+0i   0-0i   0-0i   1+0i  -0-0i│
    // │ 0+0i   0+0i   0-0i  -0-0i  -0-0i   0+0i  -0+0i   1+0i│
    // └                                                      ┘
    
    // 上書きされていないことをチェックします。
    DJ.printF("w3Gate", w3Gate);


    DJ.printS(2, "QuantumFourierTransfrom(1-3)⑤", this); // Pause Task ------------
    DJ._print("Code(1-3)⑤３量子ビットの逆フーリエ変換");
    
    DJ._print("・量子ゲートw3Gateの共役転置行列w3InvGateを求めます。");
    QuGate w3InvGate = w3Gate.conjugate();
    DJ.printF("w3InvGate", w3InvGate);
    // w3InvGate:F
    // ┌                                                                                                      ┐
    // │ 0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i   0.35355-0i│
    // │ 0.35355-0i   0.25-0.25i   0-0.35355i  -0.25-0.25i  -0.35355-0i  -0.25+0.25i  -0+0.35355i   0.25+0.25i│
    // │ 0.35355-0i   0-0.35355i  -0.35355-0i  -0+0.35355i   0.35355+0i   0-0.35355i  -0.35355-0i  -0+0.35355i│
    // │ 0.35355-0i  -0.25-0.25i  -0+0.35355i   0.25-0.25i  -0.35355-0i   0.25+0.25i   0-0.35355i  -0.25+0.25i│
    // │ 0.35355-0i  -0.35355-0i   0.35355+0i  -0.35355-0i   0.35355+0i  -0.35355-0i   0.35355+0i  -0.35355-0i│
    // │ 0.35355-0i  -0.25+0.25i   0-0.35355i   0.25+0.25i  -0.35355-0i   0.25-0.25i  -0+0.35355i  -0.25-0.25i│
    // │ 0.35355-0i  -0+0.35355i  -0.35355-0i   0-0.35355i   0.35355+0i  -0+0.35355i  -0.35355-0i  -0-0.35355i│
    // │ 0.35355-0i   0.25+0.25i  -0+0.35355i  -0.25+0.25i  -0.35355-0i  -0.25-0.25i  -0-0.35355i   0.25-0.25i│
    // └                                                                                                      ┘
    
    
    DJ._print("・フーリエ変換された量子ビットft3_1QBを量子ゲートw3InvGateに\n"
        + "　適用し、逆フーリエ変換します。");
    QuBit w3InvQB = w3InvGate.apply(ft3_1QB);
    DJ.printF("w3InvQB", w3InvQB);
    // w3InvQB:F 
    // ┌     ┐
    // │ 0+0i│ = std3_1QuBit
    // │ 0+0i│
    // │ 0+0i│
    // │-0+0i│
    // │-0+0i│
    // │ 0+0i│
    // │-0+0i│
    // │ 1+0i│
    // └     ┘
    DJ.print("　元の標準量子ビットstd3_1QuBitに戻りました。");
    
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(3, "QuantumFourierTransfrom(2)", this); // Pause Task -----------------
    DJ._print("Code(2)回転量子ゲートによる量子フーリエ変換");
    
    DJ._print("Code(2-1)①１量子ビットの量子フーリエ変換");
    
    DJ._print("・回転量子ゲートによる量子フーリエ変換という\n"
        + "  タイトルにも拘わらず、１量子ビットの場合には\n"
        + "  回転しない（０度の回転）ため、回転量子ゲートは\n"
        + "  使われず、量子回路はアダマールゲート(Hゲート)\n"
        + "  のみで構成されます。\n"
        + "                 \n"
        + "        ┌-┐    \n"
        + "  QB0 ─┤H├─  \n"
        + "        └-┘    ");
    
    DJ._print("・Hゲートを生成します。");
    // QuGate hGate = new QuGate(QuGate.H_GATE);
    DJ.printF("hGate", hGate);
    // hGate:F
    // ┌                        ┐       ┌     ┐
    // │ 0.70711+0i   0.70711+0i│= 1/√2│ 1  1│
    // │ 0.70711+0i  -0.70711+0i│       │ 1 -1│
    // └                        ┘       └     ┘
    
    
    DJ.printS(2, "QuantumFourierTransfrom(2-1)②", this); // Pause Task -----------------
    DJ._print("Code(2-1)②１量子ビットを量子フーリエ変換");
    
    DJ._print("・１量子ビットの標準量子ビットe1_0QBを生成します。");
    QuBit e1_0QB = new QuBit(QuBit.STD0_QUBIT);
    DJ.printF("e1_0QB", e1_0QB);
    // e1_0QB:F
    // ┌     ┐
    // │ 1+0i│= [1 0]'
    // │ 0+0i│
    // └     ┘
    
    DJ._print("・標準量子ビットe1_0QBを量子ゲートhGateに適用し、"
        + "フーリエ変換します。");
    QuBit ft1_0QB = hGate.apply(e1_0QB);
    DJ.printF("ft1_0QB", ft1_0QB);
    // ft1_0QB:F 
    // ┌           ┐          ┌  ┐ ┌  ┐
    // │ 0.70711+0i│= (1/√2)(│ 1│+│ 0│)
    // │ 0.70711+0i│          │ 0│ │ 1│
    // └           ┘          └  ┘ └  ┘
    
    DJ.printS(2, "QuantumFourierTransfrom(2-1)③", this); // Pause Task -----------------
    DJ._print("Code(2-1)③１量子ビットの標準量子ビットe1_1QBを生成");
    QuBit e1_1QB = new QuBit(QuBit.STD1_QUBIT);
    DJ.printF("e1_1QB", e1_1QB);
    // e1_1QB:F
    // ┌     ┐
    // │ 0+0i│= [0 1]'
    // │ 1+0i│
    // └     ┘
    
    DJ._print("　標準量子ビットe1_1QBを量子ゲートhGateに適用し、"
        + "フーリエ変換します。");
    DJ.print("QuBit ft1_1QB = hGate.apply(e1_1QBt);");
    QuBit ft1_1QB = hGate.apply(e1_1QB);
    DJ.printF("ft1_1QB", ft1_1QB);
    // ft1_1QB:F 
    // ┌           ┐          ┌  ┐ ┌  ┐
    // │ 0.70711+0i│= (1/√2)(│ 1│-│ 0│)
    // │-0.70711+0i│          │ 0│ │ 1│
    // └           ┘          └  ┘ └  ┘

    
    
    DJ.printS(3, "QuantumFourierTransfrom(2-2)", this); // Pause Task ---------------
    DJ._print("Code(2-2)２量子ビットを量子フーリエ変換");
    DJ._print("・アダマールゲートと回転量子ゲートで、"
            + "２量子ビットを量子フーリエ変換します。");
    
    DJ._print("・量子回路はアダマールゲート(Hゲート)と、\n"
      + "コントロール回転量子ゲート（C-Rkゲート）で構成されます。\n"
      + "                              \n"
      + "      ┌-┐  ┌─-┐  ┌-┐   \n"
      + "QB0 ─┤H├─┤ Rk├─┤I├─ \n"
      + "      ├-┤  ├ | ┤  ├-┤   \n"
      + "QB0 ─┤I├─┤ C ├─┤H├─ \n"
      + "      └-┘  └─-┘  └-┘   ");
    
        
    DJ.printS(2, "QuantumFourierTransfrom(2-2)①", this); // Pause Task ---------------
    DJ._print("Code(2-2)①１量子ビットのIゲートを生成");
    iGate = new QuGate(QuGate.I_GATE); // １量子ビットのIゲート
    DJ.printF("iGate", iGate);
    // iGate:F
    // ┌            ┐
    // │ 1+0i   0+0i│
    // │ 0+0i   1+0i│
    // └            ┘
    
    DJ._print("　HゲートにIゲートを相互作用させ、２量子ゲートに拡張します。");
    QuGate h_iGate = hGate.interactQuGate(iGate);
    DJ.printF("h_iGate", h_iGate);
    // h_iGate:F
    // ┌                                                  ┐         ┌    ┐
    // │ 0.70711+0i   0+0i         0.70711+0i   0+0i      │= (1/√2)│I  I│ 
    // │ 0+0i         0.70711+0i   0+0i         0.70711+0i│         │I -I│
    // │ 0.70711+0i   0+0i        -0.70711+0i   -0+0i     │         └    ┘
    // │ 0+0i         0.70711+0i   -0+0i       -0.70711+0i│
    // └                                                  ┘

    DJ.printS(2, "QuantumFourierTransfrom(2-2)②", this); // Pause Task ---------------
    DJ._print("Code(2-2)②入力として２量子ビットe2_0QBを生成");
    numOfQuBit = 2; // 量子ビット数
    DJ.print("numOfQuBit = ", numOfQuBit);
    QuBit e2_0QB = QuBit.unitQuBit(numOfQuBit, QuBit.PA0);
    DJ.printF("e2_0QB", e2_0QB);
    // e2_0QB:F
    // ┌     ┐
    // │ 1+0i│= [1 0 0 0]'= [1 0]'⊗[1 0]'
    // │ 0+0i│
    // │ 0+0i│
    // │ 0+0i│
    // └     ┘
    
    DJ._print("　２量子ビットe2_0QBを量子ゲートh_iGateに適用します。");
    QuBit hi_e20QB = h_iGate.apply(e2_0QB);
    DJ.printF("hi_e20QB", hi_e20QB);
    // hi_e20QB:F 
    // ┌           ┐          ┌     ┐ ┌     ┐
    // │ 0.70711+0i│= (1/√2)(│ 1+0i│+│ 0+0i│)
    // │ 0+0i      │          │ 0+0i│ │ 0+0i│
    // │ 0.70711+0i│          │ 0+0i│ │ 1+0i│
    // │ 0+0i      │          │ 0+0i│ │ 0+0i│
    // └           ┘          └     ┘ └     ┘
    
    
    DJ.printS(2, "QuantumFourierTransfrom(2-2)③", this); // Pause Task ---------------
    DJ._print("Code(2-2)③Rk-Cゲートを生成");
    DJ.print("・Rk-Cゲートの生成では、ターゲット量子ビット、\n"
        + "制御量子ビット配列、および位相パラメータkを指定します。");
    int numOfBits = 2; // 量子ビット数
    int target = 0; // ターゲット量子ビットのインデックス
    DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
    int[] controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 1; // 制御量子ビットのインデックス
    int k = 2; // 位相パラメータ
    DJ.print(", controlArray", controlArray);
    DJ.print("QuGate rkCGate = QuGate.makeCRkQuGate(numOfBits,"
           + " target, controlArray, _k);");
    QuGate r2cGate = QuGate.makeCRkQuGate(numOfBits, target, controlArray, k);
    DJ.printF("r2cGate", r2cGate); // Rk-Cゲート
    // r2cGate:F
    // ┌                                      ┐ ┌                   ┐ 
    // │ 1+0i   0+0i   0+0i   0+0i            │=│ 1 0 0 0           │
    // │ 0+0i   1+0i   0+0i   0+0i            │ │ 0 1 0 0           │
    // │ 0+0i   0+0i   1+0i   0+0i            │ │ 0 0 1 0           │
    // │ 0+0i   0+0i   0+0i   0.70711+0.70711i│ │ 0 0 0 (1/√2)(1+i)│ 
    // └                                      ┘ └                   ┘ 
    // exp(i2π/2^(k+1)) = exp(iπ/2^2) = cos(π/4) + isin(π/4) = (1/√2)(1+i)
    
    DJ._print("　量子ビットhi_e20QBを量子ゲートr2cGateに適用します。");
    QuBit r2c_hie20QB = r2cGate.apply(hi_e20QB);
    DJ.printF("r2c_hie20QB", r2c_hie20QB);
    // r2c_hie20QB:F 
    // ┌           ┐
    // │ 0.70711+0i│
    // │ 0+0i      │
    // │ 0.70711+0i│
    // │ 0+0i      │
    // └           ┘

    DJ.printS(2, "QuantumFourierTransfrom(2-2)④", this); // Pause Task ---------------
    DJ._print("Code(2-2)④Hゲートを２量子ゲートに拡張");
    DJ._print("・IゲートにHゲートを相互作用させ、２量子ゲートに拡張します。");
    QuGate i_hGate = iGate.interactQuGate(hGate);
    DJ.printF("i_hGate", i_hGate);
    // i_hGate:F
    // ┌                                                  ┐ ┌   ┐
    // │ 0.70711+0i   0.70711+0i   0+0i         0+0i      │=│H O│ 
    // │ 0.70711+0i  -0.70711+0i   0+0i         -0+0i     │ │O H│
    // │ 0+0i         0+0i         0.70711+0i   0.70711+0i│ └   ┘
    // │ 0+0i         -0+0i        0.70711+0i  -0.70711+0i│
    // └                                                  ┘
    
    DJ._print("・量子ビットr2c_hie20QBを量子ゲートi_hGateに適用します。");
    QuBit ih_hie20QB = i_hGate.apply(r2c_hie20QB);
    DJ.printF("ih_hie20QB", ih_hie20QB);
    // ih_hie20QB:F 
    // ┌       ┐        ┌  ┐ ┌  ┐ ┌  ┐ ┌  ┐
    // │ 0.5+0i│= (1/2)(│ 1│+│ 0│+│ 0│+│ 0│)
    // │ 0.5+0i│        │ 0│ │ 1│ │ 0│ │ 0│
    // │ 0.5+0i│        │ 0│ │ 0│ │ 1│ │ 0│
    // │ 0.5+0i│        │ 0│ │ 0│ │ 0│ │ 1│
    // └       ┘        └  ┘ └  ┘ └  ┘ └  ┘

    DJ._print("　得られた量子ビットは、Wゲートを使用した\n"
            + "　量子フーリエ変換の結果ft0QBと一致しています。");
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "QuantumFourierTransfrom（Ending）", this); // Pause Task ------------------
   
  } // quantumFourierTransfrom()

} // QuantumFourierTransfrom Class

// End of file
