/*
 *  Title: DaiJa_V5 (Digital-learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020 - 2025
 */
package task.qu;

import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.comp.Complex;
import util.DJ;
import util.TimeStamp;
import util.comp.CompVec;
import view.PatternViewer;

/**
 * <p> 表　題: Class: Quantum Teleportation</p>
 * <p> 説　明: 量子テレポーテーション</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2025</p>
 * <p> 作成日: 2024.09.08</p>
 * <p> 作成日: 2025.04.06,更新</p>
 */
public class QuantumTeleportation extends Task {
  
  // 学習・試行制御
  int dataNum = 200; // エポック毎の学習データ数
  
  // 量子計算パラメータ

  /**
   * Taskクラスで新しく作られたスレッドから呼び出される
   */
  @Override
  public void runTask() {
    DJ._print("・タスク開始日時：", TimeStamp.getTimeFormated());
    beginTime = System.currentTimeMillis(); // タスク開始時刻
    
    // パターン・ビューワ・ランチャを得る
    patternViewerFlag = true; //true; // false:非表示
    patternData0 = new double[5][dataNum]; // 附番,
    patternData1 = new double[5][dataNum]; // ID,
    patternViewerLauncher = DJ.pattern(  // 判定パターン、データ、タイトル
        PatternViewer.PATTERN_TUNER, patternData0, "Quantum Teleportation",
        PatternViewer.PATTERN_TUNER, patternData1, "Quantum Teleportation");
    
    this.stepMode = true; // タスクのステップ実行モード
    
    quantumTeleportation(); // タスク本体の呼び出し
  }
  
  /** 
   * 量子テレポーテーション
   */
  public void quantumTeleportation() {
    DJ._print("QuantumTeleportation.quantumTeleportation() ==================");
    DJ.print("■量子テレポーテーション：Quantum Teleportation");
    DJ.print("  量子状態を転送する技術");
    DJ.print("(1)量子テレポーテーション");
    DJ.print("(2)初期値を設定");
    DJ.print("(3)量子もつれ状態");
    DJ.print("(4)逆ベル回路に適用");
    DJ.print("(5)量子の測定と復元");
    
    DJ._print("・量子テレポーテーションは量子もつれ (Quantum entanglement)と\n"
      + "　古典的な情報伝達手段を複合的に利用して行われます。");
    DJ._print("・量子もつれの関係にある2つの粒子のうち一方の状態を観測すると\n"
      + "　観測と同時に離れた位置にあるもう一方の粒子の状態が確定します。\n"
      + "　状態の確定はもつれた量子がどんなに離れていても瞬時に伝わることが、\n"
      + "　実験により証明されています。光の速さを超越しているこの現象は、\n"
      + "　相対論的な局所性を破るため、量子力学における非局所性と呼ばれています。");

    // DJ.print("　学習データ数：dataNum = ", dataNum);
   
    
    DJ.printS(3, "QuantumTeleportation(1)", this); // Pause Task ---------------
    DJ._print("Code(1)量子テレポーテーション");
    DJ.print("Code(1-1)織姫Vegaはメッセージ（量子ビットの状態）を、  \n"
      + "　彦星Altairに量子テレポーテーションで伝えます。            \n"
      + "　量子ビットはたった１個でも無限の状態を表すことができます。\n"
      + "　あらかじめもつれた量子ビットの各々を双方が持つことにより、\n"
      + "　２個の古典ビットで、１量子ビットを再現します。");
    
    DJ._print("Code(1-2)量子テレポーテーションを実現する量子回路");
    DJ.print("・量子テレポーテーションの量子回路は、         \n"
      + "　Hゲート(Hadamard Gate)とC-Notゲート(CX Gate)、    \n"
      + "　Xゲート、Zゲート、測定ゲートM1、M2で構成されます。");
    
    DJ._print(
  "               ┌-┐┌-┐┌-┐┌-┐┌─┐                        \n"
+ " sQB = [s0 s1]'┤I├┤I├┤C├┤H├┤M1┝━━━━┓              \n"
+ "               ├-┤├-┤│|│├-┤├─┤        ┃              \n"
+ " vQB = [1 0]'─┤H├┤C├┤X├┤I├┤M2┝━┓    ┃              \n"
+ "               ├-┤│|│├-┤├-┤└─┘┌┸┐┌┸┐            \n"
+ " aQB = [1 0]'─┤I├┤X├┤I├┤I├───┤X ├┤Z ├ [s0~ s1~]' \n"
+ "               └-┘└-┘└-┘└-┘      └─┘└─┘            \n"
+ "    量子状態  P0   P1   P2   P3    P4   P5          P6           ");

    DJ._print( "  sQB:織姫が彦星に送りたい量子ビットの状態 \n"
             + "      sQB = [s0 s1]' = s0[1 0]' + s1[0 1]' \n"
             + "  vQB:織姫の入力量子ビット：[1 0]'  　　   \n"
             + "  aQB:彦星の入力量子ビット：[1 0]'         \n"
             + "※太い線は古典ビットによるコントロールを表します。");

    
    DJ.printS(2, "QuantumTeleportation(2)", this); // Pause Task --------
    DJ.print("（Code(2)P0:初期値を設定");
    DJ._print("・織姫は彦星に伝えたい量子状態の量子ビットsQBと、\n"
      + "　初期値 [1 0]'の量子ビットvQBを用意します。\n"
      + "　彦星も 初期値[1 0]'の量子ビットaQBを用意します。");
    double pi = Math.PI;
    // double cos30 = Math.cos(pi / 6.0);
    int sDeg = 30; // 30度 
    double sRad = Math.cos(pi * sDeg / 180.0); // ラジアンに変換
    Complex s0PA = new Complex(sRad, 0.0); // 一方の確率振幅
    DJ.print_("s0PA", s0PA); // 0.86603+0i = √3/2
    Complex s1PA = QuBit.getOtherPA(s0PA); // 他方の確率振幅
    DJ.print(", s1PA", s1PA); // 0.5+0i = 1/2
    DJ.print("QuBit sQB = new QuBit(s0PA, s1PA);");
    QuBit sQB = new QuBit(s0PA, s1PA); // sQB = s0PA[1 0]' + s1PA[0 1]'
    DJ.printF("sQB", sQB); // [0.86603+0i  0.5+0i]' = [√3/2  1/2]'
    
    QuBit _sQB = new QuBit(pi * sDeg / 180.0); // 回転量子ビットの生成子を使用
    DJ.printF("_sQB", _sQB); // [0.86603+0i  0.5+0i]' = [√3/2  1/2]'
    
    QuBit vQB = new QuBit(); // デフォルトで生成した場合
    DJ.printF("vQB", vQB); // [1+0i  0+0i]'
    QuBit aQB = new QuBit(QuBit.STD0_QUBIT); // 明示的に指定する場合
    DJ.printF("aQB", aQB); // [1+0i  0+0i]'
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "QuantumTeleportation(3)", this); // Pause Task --------
    DJ.print("Code(3)量子もつれ状態の生成");
    DJ.print("  織姫と彦星は量子ビットvQBとaQBをもつれさせます。\n"
           + "  量子もつれ状態の生成にHゲート（アダマール・ゲート）と\n"
           + "  CXゲート（コントロールNOTゲート）を使います。");
    
    DJ._print("Code(3-1)①Hゲート（アダマール・ゲート）");
    QuGate hGate = new QuGate(QuGate.H_GATE); 
    DJ.printF("hGate", hGate);
    // hGate = :F
    // ┌                        ┐       ┌     ┐
    // │ 0.70711+0i   0.70711+0i│= 1/√2│ 1  1│ 
    // │ 0.70711+0i  -0.70711+0i│       │ 1 -1│
    // └                        ┘       └     ┘
    
    DJ._print("Code(3-1)②P1:量子ビットvQBをHゲートに適用します。");
    DJ.print("QuBit hV = hGate.apply(vQB);");
    QuBit hvQB = hGate.apply(vQB);
    DJ.printF("hvQB", hvQB);
    // hvQB:F 
    // ┌           ┐
    // │ 0.70711+0i│
    // │ 0.70711+0i│
    // └           ┘

    DJ.printS(1, "QuantumTeleportation(3-2)", this); // Pause Task -----------
    DJ._print("Code(3-2)量子ビットaQBとhvQBを２量子ビットに拡張\n"
        + "  量子ビットhvQBにCXゲートを適用するため、量子ビットhvQBと\n"
        + "  量子ビットaQBと相互作用させ、２量子ビットに拡張します。");
    DJ.print("QuBit hv_aQB = hvQB.interactQuBit(aQB);");
    QuBit hv_aQB = hvQB.interactQuBit(aQB);
    DJ.printF("hv_aQB", hv_aQB);
    // hv_aQB:F 
    // ┌           ┐
    // │ 0.70711+0i│
    // │ 0+0i      │
    // │ 0.70711+0i│
    // │ 0+0i      │
    // └           ┘

    
    DJ.printS(2, "QuantumTeleportation(3-3)①", this); // Pause Task -----------
    DJ._print("Code(3-3)①CXゲート（コントロールNOTゲート）");
    int numOfBit = 2; // 量子ビット数
    int target = 1; // ターゲット量子ビット
    int[] control = {0}; // 制御量子ビット配列
    QuGate cxGate = new QuGate(QuGate.CX_GATE, numOfBit, target, control); 
    DJ.printF("cxGate = ", cxGate);
    // cxGate = :F
    // ┌                          ┐
    // │ 1+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   1+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   0+0i   1+0i│
    // │ 0+0i   0+0i   1+0i   0+0i│
    // └                          ┘    
    
    DJ.printS(1, "QuantumTeleportation(3-3)②", this); // Pause Task -----------
    DJ._print("Code(3-3)②P2:２量子ビットhv_aQBをCXゲートに適用");
    DJ.print("QuBit hv_aQB = cxGate.apply(hv_aQB);");
    QuBit cxHv_aQB = cxGate.apply(hv_aQB);
    DJ.printF("cxHv_aQB", cxHv_aQB);
    // cxHv_aQB = :F 
    // ┌           ┐
    // │ 0.70711+0i│←────────┐
    // │ 0+0i      │←┐(1) product   │(0) product
    // │ 0+0i      │←┘     = 0.0    │     = 0.5
    // │ 0.70711+0i│←────────┘
    // └           ┘
    
    DJ._print("Code(3-3)③２量子ビットのもつれ状態を判定");
    boolean checked = cxHv_aQB.entangleDetails(); // 判定中の詳細情報を表示
    // boolean checked = cxHv_aQB.entangleCheck(); // 判定結果のみを表示
    DJ._print("もつれ状態：", Boolean.toString(checked));
    // $ (0) product = :0.4999999999999999+0.0i
    // $ (1) product = :0.0+0.0i
    // $ difference = 0.4999999999999999　←　(0)と(1)に差が有ればもつれている
    // $ judgment = true
    // もつれ状態：true ←　もつれている
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "QuantumTeleportation(4)", this); // Pause Task ---------------
    DJ.print("Code(4)量子ビットsQBとcx_hvaQBを逆ベル回路に適用");
    DJ._print("  織姫は量子ビットsQBとcx_hvaQB３量子ビットに拡張し、\n"
            + "  CXゲートに適用してもつれを解消させます。");
    
    DJ._print("Code(4-1)量子ビットcxHv_aQBBをCXゲートに適用するため、\n"
        + "　量子ビットsQBと相互作用させ、３量子ビットに拡張します。");
    // DJ.printF("sQB = ", sQB); // [0.86603+0i  0.5+0i]'
    // DJ.printF("cxHv_aQB = ", cxHv_aQB); // [0.70711+0i  0+0i  0+0i  0.70711+0i]'
    QuBit s_v_aQB = sQB.interactQuBit(cxHv_aQB);
    DJ.printF("s_v_aQB", s_v_aQB);
    // s_v_aQB:F 
    // ┌           ┐
    // │ 0.61237+0i│
    // │ 0+0i      │
    // │ 0+0i      │
    // │ 0.61237+0i│
    // │ 0.35355+0i│
    // │ 0+0i      │
    // │ 0+0i      │
    // │ 0.35355+0i│
    // └           ┘
    
    DJ.printS(1, "QuantumTeleportation(4-2)①", this); // Pause Task -----------
    DJ._print("Code(4-2)①CXゲートを３量子ゲートに拡張");
    QuGate iGate = new QuGate(QuGate.I_GATE); // １量子ビットのIゲート
    DJ.printF("iGate", iGate);
    // iGate:F
    // ┌            ┐
    // │ 1+0i   0+0i│
    // │ 0+0i   1+0i│
    // └            ┘
    
    DJ._print("・IゲートをCXゲートに相互作用させ、３量子ゲートに拡張します。");
    DJ.print("QuGate cx_iGate = cxGate.interactQuGate(iGate);");
    QuGate cx_iGate = cxGate.interactQuGate(iGate);
    DJ.printF("cx_iGaet", cx_iGate);
    // cx_iGaet:F
    //┌                                                      ┐
    //│ 1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    //│ 0+0i   1+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    //│ 0+0i   0+0i   1+0i   0+0i   0+0i   0+0i   0+0i   0+0i│
    //│ 0+0i   0+0i   0+0i   1+0i   0+0i   0+0i   0+0i   0+0i│
    //│ 0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   1+0i   0+0i│←┐反転
    //│ 0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   0+0i   1+0i│←┘
    //│ 0+0i   0+0i   0+0i   0+0i   1+0i   0+0i   0+0i   0+0i│←┐反転
    //│ 0+0i   0+0i   0+0i   0+0i   0+0i   1+0i   0+0i   0+0i│←┘
    //└                                                      ┘
    
    
    DJ.printS(1, "QuantumTeleportation(4-2)②", this); // Pause Task -----------
    DJ._print("Code(4-2)②P3:量子ビットs_v_aQBをCX_Iゲートに適用");
    QuBit cXsvaQB = cx_iGate.apply(s_v_aQB);
    DJ.printF("cXsvaQB = ", cXsvaQB);
    // cXsvaQB = :F 
    // ┌           ┐                   ┌ ┐  ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐
    // │ 0.61237+0i│= 1/√(2) (√(3)/2(│1│⊗(│1│⊗│1│+│0│⊗│0│))
    // │ 0+0i      │                   │0│  │0│ │0│ │1│ │1│             
    // │ 0+0i      │                   └ ┘  └ ┘ └ ┘ └ ┘ └ ┘
    // │ 0.61237+0i│                   ┌ ┐  ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐   
    // │ 0+0i      │            + 1/2 (│0│⊗(│1│⊗│0│+│0│⊗│1│)))
    // │ 0.35355+0i│                   │1│  │0│ │1│ │1│ │0│    
    // │ 0.35355+0i│                   └ ┘  └ ┘ └ ┘ └ ┘ └ ┘    
    // │ 0+0i      │
    // └           ┘
      
    DJ._print("Code(4-2)③３量子ビットcXsvaQBの遷移確率");
    double[][] cXsvaTransProb = cXsvaQB.getTransProb();
    DJ.printF("cXsvaTransProb", cXsvaTransProb);
    //  cXsvaTransProb=
    //  [[0.75, 0.5, 0.5] ←[1 0]'への遷移確率
    //  [0.25, 0.5, 0.5] ←[0 1]'への遷移確率
    //  ] ↑   ↑   ↑
    //    │   │   └ 第２量子ビットの遷移確率
    //    │   └ 第１量子ビットの遷移確率
    //    └ 第０量子ビットの遷移確率
    
    
    DJ.printS(2, "QuantumTeleportation(4-3)①", this); // Pause Task -----------
    DJ._print("Code(4-3)①２量子ビットの単位ゲートを生成");
    int numOfQuBit = 2; // 量子ビット数
    DJ.print("QuGate i_iGate = new QuGate(numOfQuBit); // numOfQuBit=2");
    QuGate i_iGate = new QuGate(numOfQuBit);
    DJ.printF("i_iGate", i_iGate);
    // i_iGate:F
    // ┌                          ┐
    // │ 1+0i   0+0i   0+0i   0+0i│
    // │ 0+0i   1+0i   0+0i   0+0i│
    // │ 0+0i   0+0i   1+0i   0+0i│
    // │ 0+0i   0+0i   0+0i   1+0i│
    // └                          ┘
    

    DJ._print("Code(4-3)②Hゲートを３量子ビットに拡張\n"
        + "  HゲートにI_Iゲートを相互作用させ、３量子ビットに拡張します。");
    DJ.print("QuGate h_i_iGate = hGate.interactQuGate(i_iGate);");
    QuGate h_i_iGate = hGate.interactQuGate(i_iGate);
    DJ.printF("h_i_iGate", h_i_iGate);
    // h_i_iGate:F
    // ┌                                                                                                      ┐
    // │ 0.70711+0i   0+0i         0+0i         0+0i         0.70711+0i   0+0i         0+0i         0+0i      │
    // │ 0+0i         0.70711+0i   0+0i         0+0i         0+0i         0.70711+0i   0+0i         0+0i      │
    // │ 0+0i         0+0i         0.70711+0i   0+0i         0+0i         0+0i         0.70711+0i   0+0i      │
    // │ 0+0i         0+0i         0+0i         0.70711+0i   0+0i         0+0i         0+0i         0.70711+0i│
    // │ 0.70711+0i   0+0i         0+0i         0+0i        -0.70711+0i   -0+0i        -0+0i        -0+0i     │
    // │ 0+0i         0.70711+0i   0+0i         0+0i         -0+0i       -0.70711+0i   -0+0i        -0+0i     │
    // │ 0+0i         0+0i         0.70711+0i   0+0i         -0+0i        -0+0i       -0.70711+0i   -0+0i     │
    // │ 0+0i         0+0i         0+0i         0.70711+0i   -0+0i        -0+0i        -0+0i       -0.70711+0i│
    // └                                                                                                      ┘

    DJ.printS(1, "QuantumTeleportation(4-3)③", this); // Pause Task -----------
    DJ._print("Code(4-3)③P4:量子ビットcXsvaQBをH_I_Iゲートに適用");
    DJ.print("QuGate hcXsvaQB = h_i_iGate.apply(cXsvaQB)");
    QuBit hcXsvaQB = h_i_iGate.apply(cXsvaQB);
    DJ.printF("hcXsvaQB", hcXsvaQB);
    // hcXsvaQB = :F 
    // ┌           ┐       ┌ ┐ ┌ ┐           ┌ ┐     ┌ ┐
    // │ 0.43301+0i│= 1/2 (│1│⊗│1│⊗ ( 0.86603│1│+ 0.5│0│)
    // │ 0.25+0i   │       │0│ │0│           │0│     │1│
    // │ 0.25+0i   │       └ ┘ └ ┘           └ ┘     └ ┘
    // │ 0.43301+0i│       ┌ ┐ ┌ ┐       ┌ ┐         ┌ ┐
    // │ 0.43301+0i│      +│1│⊗│0│⊗ ( 0.5│1│+ 0.86603│0│)
    // │-0.25+0i   │       │0│ │1│       │0│         │1│
    // │-0.25+0i   │       └ ┘ └ ┘       └ ┘         └ ┘
    // │ 0.43301+0i│       ┌ ┐ ┌ ┐           ┌ ┐     ┌ ┐
    // └           ┘      +│0│⊗│1│⊗ ( 0.86603│1│- 0.5│0│)
    //                       │1│ │0│           │0│     │1│
    //                       └ ┘ └ ┘           └ ┘     └ ┘
    //                       ┌ ┐ ┌ ┐       ┌ ┐         ┌ ┐
    //                      +│0│⊗│0│⊗ (-0.5│1│+ 0.86603│0│))
    //                       │1│ │1│       │0│         │1│
    //                       └ ┘ └ ┘       └ ┘         └ ┘     
    
    DJ._print("Code(4-3)④量子ビットhcXsvaQBの遷移確率");
    double[][] hcXsvaTransProb = hcXsvaQB.getTransProb();
    DJ.printF("hcXsvaTransProb", hcXsvaTransProb);
    //  cXsvaTransProb=
    //  [[0.5, 0.5, 0.5] ←[1 0]'への遷移確率
    //  [0.5, 0.5, 0.5] ←[0 1]'への遷移確率
    //  ] ↑   ↑   ↑
    //    │   │   └ 第２量子ビットの遷移確率
    //    │   └ 第１量子ビットの遷移確率
    //    └ 第０量子ビットの遷移確率
    
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(3, "QuantumTeleportation(5)", this); // Pause Task ---------------
    DJ.print("Code(5)量子状態の測定と復元\n"
           + "・織姫は自分の量子ビットsQBとvQBを測定し、\n"
           + "　結果を２個の古典ビットで彦星に送ります。");
    DJ.print("・彦星は織姫から送られた２個の古典ビットに\n"
           + "  従って自分の量子ビットaQBを処理し、\n"
           + "  織姫の量子ビットsQBの状態を復元します。");
    
    DJ._print("・Hゲートに適用した量子ビットhcXsvaQBは   \n"
            + "  量子回路の量子状態P4に相当し、          \n"
            + "  以下のように４項に分かれます。          \n"
            + "　各項の最初の２個の織姫の2量子ビットを、 \n"
            + "　織姫が測定ゲートM0、M1で測定した結果は、\n"
            + "  各項（1/2)^2=1/4　の確率で、古典ビット  \n"
            + "　00、01、10、11のいずれかになります。");
    
    DJ.print( "hcXsvaQB  ┌ ┐  ┌ ┐         ┌ ┐     ┌ ┐    \n"
            + "   = 1/2 (│1│ⓧ│1│ⓧ (√3/2│1│+ 1/2│0│)   \n"
            + "          │0│  │0│         │0│     │1│    \n"
            + "          └ ┘  └ ┘         └ ┘     └ ┘    \n"     
            + "          ┌ ┐  ┌ ┐        ┌ ┐       ┌ ┐   \n"
            + "        + │1│ⓧ│0│ⓧ ( 1/2│1│+ √3/2│0│)  \n"
            + "          │0│  │1│        │0│       │1│   \n"
            + "          └ ┘  └ ┘        └ ┘       └ ┘   \n"
            + "          ┌ ┐  ┌ ┐         ┌ ┐     ┌ ┐    \n"
            + "        + │0│ⓧ│1│ⓧ (√3/2│1│- 1/2│0│)   \n"
            + "          │1│  │0│         │0│     │1│    \n"
            + "          └ ┘  └ ┘         └ ┘     └ ┘    \n"     
            + "          ┌ ┐  ┌ ┐        ┌ ┐       ┌ ┐   \n"
            + "        + │0│ⓧ│0│ⓧ (-1/2│1│+ √3/2│0│)) \n"
            + "          │1│  │1│        │0│       │1│   \n"
            + "          └ ┘  └ ┘        └ ┘       └ ┘   ");     
    
    
    
    DJ.printS(1, "QuantumTeleportation(5-0)", this); // Pause Task -------------
    DJ._print("Code(5-0)彦星の量子ビット\n"
        + "・各項の３個目の量子ビットは彦星の量子ビットに      \n"
        + "  対応しています。織姫が測定すると同時に            \n"
        + "　彦星の量子ビットも遷移し、確定します。            \n"
        + "・全体が1/2で括られているのは、彦星の量子ビットの   \n"
        + "  確率（確率振幅の自乗の和）を１にするためです。    \n"
        + "　例えば第１項では、                                \n"
        + "    (√3/2)^2 + (1/2)^2 = 3/4 + 1/4 = 1 となります。");
    
    DJ._print("・各項の３個目の量子ビットを取り出し、\n"
            + "　全体を1/2で括るため、２倍します。");
    CompVec probAmpVec = hcXsvaQB.copyProbAmpVec();
    probAmpVec.product(2.0); // 全体を1/2で括るために２倍する
    
    QuBit[] aQBArray = new QuBit[4];
    for (int i = 0; i < 4; i++) {
      aQBArray[i] = new QuBit(
          probAmpVec.getComp(i*2), probAmpVec.getComp(i*2+1));
      String term = Integer.toBinaryString(i);
      if (i < 2) term = "0" + term;
      DJ.printF("aQBArray[" + term + "] = ", aQBArray[i]);
    }
    
    
    DJ.printS(2, "QuantumTeleportation(5-1)", this); // Pause Task -------------
    DJ.print("Code(5-1)織姫の測定結果が00の場合");
    DJ._print("・彦星の量子ビットは織姫が伝えたい"
            + "　量子ビットの量子状態sQBに一致します。\n"
            + "                                \n"
            + "    sQB = [s0 s1]'              \n"
            + "        = s0[1 0]' + s1[0 1]'   \n"
            + "        = [0.86603+0i  0.5+0i]' \n"
            + "        = [√3/2  1/2]'         \n"
            + "                                \n"
      + "  従って、彦星は量子ビットを復元する必要がありません。" );
    
    DJ._print("・しかし、織姫の測定結果が２項目以降の \n"
            + "  01、10、11の場合には、彦星は以下のように\n"
            + "  量子ビットの状態を復元します。");
        
        
    DJ.printS(1, "QuantumTeleportation(5-2)", this); // Pause Task -------------
    DJ._print("Code(5-2)織姫の測定結果が01の場合");
    DJ.print("　彦星の量子ビットをXゲートに適用し、\n"
           + "  状態を復元します。\n");

    QuGate xGate = new QuGate(QuGate.X_GATE); // Xゲートを生成
    DJ.printF("xGate", xGate);
    //xGate:F
    //┌            ┐
    //│ 0+0i   1+0i│
    //│ 1+0i   0+0i│
    //└            ┘
    
    DJ._printF("aQBArray[01] = ", aQBArray[0b01]);
    //aQBArray[01] = :F 
    //┌           ┐ ┌        ┐
    //│ 0.5+0i    │=│ 1/2    │
    //│ 0.86603+0i│ │ √(3/)2│
    //└           ┘ └        ┘

    DJ._print("　量子ビットをXゲートに適用します。");
    DJ.print("QuBit _aQB = xGate.apply(aQBArray[0b01]);");
    QuBit _aQB = xGate.apply(aQBArray[0b01]);
    DJ.printF("_aQB", _aQB);
    // _aQB:F 
    //┌           ┐ ┌        ┐
    //│ 0.86603+0i│=│ √(3/)2│ 
    //│ 0.5+0i    │ │ 1/2    │
    //└           ┘ └        ┘

    
    DJ.printS(1, "QuantumTeleportation(5-3)", this); // Pause Task -------------
    DJ._print("Code(5-3)織姫の測定結果が10の場合");
    DJ.print("・彦星の量子ビットをZゲートに適用し、\n"
           + "  状態を復元します。\n");
    
    QuGate zGate = new QuGate(QuGate.Z_GATE); // Zゲートを生成
    DJ.printF("zGate", zGate);
    //zGate:F
    //┌            ┐
    //│ 1+0i   0+0i│
    //│ 0+0i  -1+0i│
    //└            ┘

    DJ.printF("aQBArray[10] = ", aQBArray[0b10]);
    //aQBArray[10] = :F 
    //┌           ┐ ┌        ┐
    //│ 0.86603+0i│=│ √(3/)2│ 
    //│-0.5+0i    │ │-1/2    │
    //└           ┘ └        ┘

    DJ._print("・量子ビットをZゲートに適用します。");
    DJ.print("QuBit _aQB = zGate.apply(aQBArray[0b10]);");
    _aQB = zGate.apply(aQBArray[0b10]);
    DJ.printF("_aQB", _aQB);
    // _aQB:F 
    //_aQB:F 
    //┌           ┐ ┌        ┐
    //│ 0.86603+0i│=│ √(3/)2│
    //│ 0.5+0i    │ │ 1/2    │
    //└           ┘ └        ┘

    
    DJ.printS(1, "QuantumTeleportation(5-4)", this); // Pause Task -------------
    DJ._print("(5-4)織姫の測定結果が11の場合");
    DJ._print("・彦星の量子ビットをX、Zゲートに適用し、"
            + "状態を復元します。\n");
    DJ.printF("aQBArray[11] = ", aQBArray[0b11]);
    //aQBArray[11] = :F 
    //┌           ┐ ┌        ┐
    //│-0.5+0i    │=│-1/2    │
    //│ 0.86603+0i│ │ √(3/)2│
    //└           ┘ └        ┘

    DJ._print("  量子ビットをXゲートに適用します。");
    DJ.print("QuBit _aQB = xGate.apply(aQBArray[0b11]);");
    _aQB = xGate.apply(aQBArray[0b11]);
    DJ.printF("_aQB", _aQB);
    //_aQB:F 
    //┌           ┐ ┌        ┐
    //│ 0.86603+0i│=│ √(3/)2│ 
    //│-0.5+0i    │ │-1/2    │
    //└           ┘ └        ┘
    
    DJ._print("  量子ビットをZゲートに適用します。");
    DJ.print("QuBit _aQB = zGate.apply(_aQB);");
    _aQB = zGate.apply(_aQB);
    DJ.printF("_aQB", _aQB);
    // _aQB:F 
    //┌           ┐ ┌        ┐
    //│ 0.86603+0i│=│ √(3/)2│
    //│ 0.5+0i    │ │ 1/2    │
    //└           ┘ └        ┘

    DJ._print("・以上により、織姫が送信した量子ビットsQBが\n"
        + "  もつれた量子ビット対を用いた量子テレポーテーションにより\n"
        + "  彦星の量子ビットaQBに再現されることを確認しました。");

    
    // DJ.printS(2, "QuantumTeleportation(Ending)", this); // Pause Task -----------------------
    DJ._print("量子計算の完了");
    DJ.print("QuantumTeleportation.quantumTeleportation() =================");
  } // quantumTeleportation()

} // QuantumTeleportation Class

// End of file
