/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2020.7.1
 *  Copyright: 2020, 2021
 */
package util;

import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * <p> 表　題: Class: TimeStamp</p>
 * <p> 説　明: 時刻や日時のデータを提供</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2019, 2020, 2021</p>
 * <p> 作成日: 2019.4.24</p>
 */
public class TimeStamp {
  
  /** インスタンスの構築子。
   *  メソッドをStaticにするために、構築子はプライベートになっている。
   */
  private TimeStamp() {
    // Do noting
  }

  /** 日付タイムスタンプを作成する。
   *  書式：yyyy/mm/dd
   *  @return String 日付タイムスタンプ。
   */
  public static String getDateStamp() {
    StringBuilder stamp = new StringBuilder();
    GregorianCalendar cal = new GregorianCalendar();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1; // Month starts from 0
		int date = cal.get(Calendar.DATE);

		stamp.append(year);
		stamp.append("/");
		if (month<10) stamp.append("0");
		stamp.append(month);
		stamp.append("/");
		if (date<10) stamp.append("0");
		stamp.append(date);

    return stamp.toString();
  }

  /** 時刻タイムスタンプを作成する。
   *  書式：hh:mm:ss
   *  @return String タイムスタンプ。
   */
  public static String getTimeStamp() {
    StringBuilder stamp = new StringBuilder();
    GregorianCalendar cal = new GregorianCalendar();
    int hour = cal.get(Calendar.HOUR_OF_DAY);
    int minute = cal.get(Calendar.MINUTE);
    int second = cal.get(Calendar.SECOND);

    if (hour<10) stamp.append("0");
    stamp.append(hour);
    stamp.append(":");
    if (minute<10) stamp.append("0");
    stamp.append(minute);
    stamp.append(":");
    if (second<10) stamp.append("0");
    stamp.append(second);

    return stamp.toString();
  }

  /** 日時タイムスタンプを作成する。
   *  書式：yyyy/mm/dd hh:mm:ss
   *  @return String タイムスタンプ。
   */
  public static String getTimeFormated() {
    StringBuilder stamp = new StringBuilder();
    GregorianCalendar cal = new GregorianCalendar();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1; // Month starts from 0
    int date = cal.get(Calendar.DATE);

    int hour = cal.get(Calendar.HOUR_OF_DAY);
    int minute = cal.get(Calendar.MINUTE);
    int second = cal.get(Calendar.SECOND);

    stamp.append(year).append("/");
    if (month<10) stamp.append("0");
    stamp.append(month).append("/");
    if (date<10) stamp.append("0");
    stamp.append(date).append(" ");

    if (hour<10) stamp.append("0");
    stamp.append(hour).append(":");
    if (minute<10) stamp.append("0");
    stamp.append(minute).append(":");
    if (second<10) stamp.append("0");
    stamp.append(second);

    return stamp.toString();
  }

  /** 日時タイムスタンプを作成する。
   *  書式：yyyymmddhhmm
   *  @return String タイムスタンプ。
   */
  public static String getDateAndTime() {
    StringBuilder stamp = new StringBuilder();
    GregorianCalendar cal = new GregorianCalendar();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1; // Month starts from 0
    int date = cal.get(Calendar.DATE);
    int hour = cal.get(Calendar.HOUR_OF_DAY);
    int minute = cal.get(Calendar.MINUTE);

    stamp.append(year);
    if (month<10) stamp.append("0");
    stamp.append(month);
    if (date<10) stamp.append("0");
    stamp.append(date);
    if (hour<10) stamp.append("0");
    stamp.append(hour);
    if (minute<10) stamp.append("0");
    stamp.append(minute);

    return stamp.toString();
  }

  /** 日時秒タイムスタンプを作成する。
   *  書式：yyyymmddhhmmss
   *  @return String タイムスタンプ。
   */
  public static String getDateAndTimeSec() {
    StringBuilder stamp = new StringBuilder();
    GregorianCalendar cal = new GregorianCalendar();
    int year = cal.get(Calendar.YEAR);
    int month = cal.get(Calendar.MONTH) + 1; // Month starts from 0
    int date = cal.get(Calendar.DATE);
    int hour = cal.get(Calendar.HOUR_OF_DAY);
    int minute = cal.get(Calendar.MINUTE);
    int second = cal.get(Calendar.SECOND);

    stamp.append(year);
    if (month<10) stamp.append("0");
    stamp.append(month);
    if (date<10) stamp.append("0");
    stamp.append(date);
    if (hour<10) stamp.append("0");
    stamp.append(hour);
    if (minute<10) stamp.append("0");
    stamp.append(minute);
    if (second<10) stamp.append("0");
    stamp.append(second);

    return stamp.toString();
  }

  /** 時刻タイムスタンプを整数にする。
   *  書式：hh:mm:ss
   *  @param stamp String // タイムスタンプ
   *  @return　time long // 時間（秒）。
   */
  public static long decodeTimeStamp(String stamp) {
   long hour = Long.parseLong(stamp.substring(0, 1));
   long minute = Long.parseLong(stamp.substring(3, 4));
   long second = Long.parseLong(stamp.substring(6, 7));
   long time = hour * 3600 + minute * 60 + second;

    return time;
  }

} // TimeStamp

// EOF

