/*
 *  Title: DaiJa_V5 (Digital-learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020 - 2024
 */
package util.comp;

/**
 * <p> 表　題: Class: CompBra</p>
 * <p> 説　明: ブラ・ベクトル（複素数横・行配列）</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2024</p>
 * <p> 作成日: 2024.04.07</p>
 */
public class CompBra {
  
  private Complex[] complexArray; // 複素数配列
  
  /**
   * デフォルト（要素０個）のブラ・ベクトルを生成する
   */
  public CompBra() {
    complexArray = new Complex[0];
  }
  
  /**
   * 引数で与えられた要素数のブラ・ベクトルを生成する
   * @param length int // 要素数
   */
  public CompBra(int length) {
    complexArray = new Complex[length];
    
    for (int i = 0; i < length; i++) {
      complexArray[i] = new Complex(); // {0.0+0.0i}
    }
  }
  
    /**
   * 引数で与えられた長さと実数で複素数配列を生成する
   * @param length int // 複素数配列の長さ
   * @param real double // 実数部の値
   * @param image double // 虚数部の値
   */
  public CompBra(int length, double real, double image) {
    complexArray = new Complex[length];
    
    for (int i = 0; i < length; i++) {
      complexArray[i] = new Complex(real, image);
    }
  }

  /**
   * 引数で与えられた長さと複素数で複素数配列を生成する
   * @param length int // 複素数配列の長さ
   * @param complex Complex // 引数で与えられた複素数
   */
  public CompBra(int length, Complex complex) {
    complexArray = new Complex[length];
    
    for (int i = 0; i < length; i++) {
      complexArray[i] = complex.copyComplex();
    }
  }
  
  
  
  
  
}
