/*
 *  Title: DaiJa_V5 (Digital-Learning Aide Instrument by Java)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020, 2021, 2022
 */
package view;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import static java.awt.Toolkit.getDefaultToolkit;

/**
 * <p> 表　題: Class: AboutDialog</p>
 * <p> 説　明: アバウト・ダイアログ</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2022</p>
 * <p> 作成日: 2022.11.6</p>
 */
public class AboutDialog extends javax.swing.JDialog {

  /**
   * Creates new form AboutDialog
   * @param parent
   * @param modal
   */
  public AboutDialog(java.awt.Frame parent, boolean modal) {
    super(parent, modal);
    initComponents();
  }
  
  public Point getCenterLocation() {
    Toolkit tk = getDefaultToolkit();
    Dimension screen = tk.getScreenSize();
    Dimension size = this.getSize();
    Point location = new Point((screen.width - 200) / 2,
                               (screen.height - size.height) / 2);
    return location;
  }
  
  /**
   * ダイアログの表示位置をスクリーンの中央に設定する
   * @param abouDialogt AboutDialog
   */
  public void setCenterLocation(AboutDialog abouDialogt) {
    Toolkit tk = getDefaultToolkit();
    Dimension screen = tk.getScreenSize();
    Dimension dialog = abouDialogt.getSize();
    Point location = new Point((screen.width - dialog.width) / 2,
                               (screen.height - dialog.height) / 2);
    abouDialogt.setLocation(location);
  }
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    aboutTitleLabel = new javax.swing.JLabel();
    jScrollPane1 = new javax.swing.JScrollPane();
    aboutTextArea = new javax.swing.JTextArea();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("About DaiJa");
    setLocation(new java.awt.Point(0, 0));

    aboutTitleLabel.setFont(new java.awt.Font("Yu Gothic UI", 0, 24)); // NOI18N
    aboutTitleLabel.setText("DaiJa Ver.5");

    aboutTextArea.setEditable(false);
    aboutTextArea.setColumns(20);
    aboutTextArea.setFont(new java.awt.Font("Yu Gothic UI", 0, 14)); // NOI18N
    aboutTextArea.setRows(5);
    aboutTextArea.setText(" Digital-Learning Aide Instrument by JAva\n\n Author : Yoshinari Sasaki\n Version : 5.0\n Since 2019.4.15\n Copyright : 2019 - 2022\n");
    aboutTextArea.setAutoscrolls(false);
    aboutTextArea.setBorder(javax.swing.BorderFactory.createEtchedBorder());
    jScrollPane1.setViewportView(aboutTextArea);

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(40, 40, 40)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 320, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(aboutTitleLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 236, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(40, Short.MAX_VALUE))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addGap(31, 31, 31)
        .addComponent(aboutTitleLabel)
        .addGap(18, 18, 18)
        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 176, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(43, Short.MAX_VALUE))
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

//  /**
//   * @param args the command line arguments
//   */
//  public static void main(String args[]) {
//    /* Set the Nimbus look and feel */
//    //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
//    /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
//         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
//     */
//    try {
//      for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
//        if ("Nimbus".equals(info.getName())) {
//          javax.swing.UIManager.setLookAndFeel(info.getClassName());
//          break;
//        }
//      }
//    } catch (ClassNotFoundException ex) {
//      java.util.logging.Logger.getLogger(AboutDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//    } catch (InstantiationException ex) {
//      java.util.logging.Logger.getLogger(AboutDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//    } catch (IllegalAccessException ex) {
//      java.util.logging.Logger.getLogger(AboutDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//    } catch (javax.swing.UnsupportedLookAndFeelException ex) {
//      java.util.logging.Logger.getLogger(AboutDialog.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
//    }
//    //</editor-fold>
//
//    /* Create and display the dialog */
//    java.awt.EventQueue.invokeLater(() -> {
//      AboutDialog dialog = new AboutDialog(new javax.swing.JFrame(), true);
//      dialog.addWindowListener(new java.awt.event.WindowAdapter() {
//        @Override
//        public void windowClosing(java.awt.event.WindowEvent e) {
//          System.exit(0);
//        }
//      });
//      dialog.setVisible(true);
//    });
//  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextArea aboutTextArea;
  private javax.swing.JLabel aboutTitleLabel;
  private javax.swing.JScrollPane jScrollPane1;
  // End of variables declaration//GEN-END:variables
}
