/*
 *  Title: DaiJa_V4 (Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2020.7.1
 *  Copyright: 2020, 2021
 */
package view;

//import view.SomGraphDrawer;
import java.awt.*;

/**
 * <p> 表　題: Class: ColorPaletPanel</p>
 * <p> 説　明: カラー・パレット</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2007 - 2021</p>
 * <p> 作成日: 2007/05/09</p>
 */
public class ColorPaletPanel extends Panel {
  
  SomDrawer theSomGraphDrawer; // ＳＯＭグラフ描画
  
  /** Creates new form ColorPaletPanel
   * @param aSomGraphDrawer 
   */
  public ColorPaletPanel(SomDrawer aSomGraphDrawer) {
    this.theSomGraphDrawer = aSomGraphDrawer;
    initComponents();
  }
   
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    paletTitleLabel = new java.awt.Label();
    paletScalePanel = new java.awt.Panel();
    minLabel = new java.awt.Label();
    midLabel = new java.awt.Label();
    maxLabel = new java.awt.Label();
    colorPaletLabel = new java.awt.Label();

    addComponentListener(new java.awt.event.ComponentAdapter() {
      public void componentMoved(java.awt.event.ComponentEvent evt) {
        formComponentMoved(evt);
      }
    });
    setLayout(new java.awt.BorderLayout());

    paletTitleLabel.setAlignment(java.awt.Label.CENTER);
    paletTitleLabel.setText("Color Palet");
    add(paletTitleLabel, java.awt.BorderLayout.NORTH);

    paletScalePanel.setLayout(new java.awt.BorderLayout());

    minLabel.setText("0.0");
    paletScalePanel.add(minLabel, java.awt.BorderLayout.WEST);

    midLabel.setAlignment(java.awt.Label.CENTER);
    midLabel.setText("0.5");
    paletScalePanel.add(midLabel, java.awt.BorderLayout.CENTER);

    maxLabel.setText("1.0");
    paletScalePanel.add(maxLabel, java.awt.BorderLayout.EAST);

    add(paletScalePanel, java.awt.BorderLayout.SOUTH);
    add(colorPaletLabel, java.awt.BorderLayout.CENTER);
  }// </editor-fold>//GEN-END:initComponents

  private void formComponentMoved(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentMoved
// TODO add your handling code here:
  }//GEN-LAST:event_formComponentMoved
  
  static final int MARGIN = 10; // パレットの周りの余白
  
  @Override
  public void paint(Graphics g) {
    Graphics cpg = colorPaletLabel.getGraphics();
    Color cc = cpg.getColor();
    int ph = colorPaletLabel.getHeight() - MARGIN;
    int pw = colorPaletLabel.getWidth() - (MARGIN * 2);
    Color[] colorPalet =  theSomGraphDrawer.getColorPalet();
    int numOfColor = colorPalet.length - 1;
    if (numOfColor < 1) return;
    int delta = pw / numOfColor;
    int x = MARGIN;
    for (int id = 0; id < numOfColor; id++) {
      cpg.setColor(colorPalet[id]);
      cpg.fillRect(x, MARGIN, x = x + delta, ph);
    }
    cpg.setColor(Color.WHITE);
    x = x + delta;
    cpg.fillRect(x, MARGIN, x, ph);
  }
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private java.awt.Label colorPaletLabel;
  private java.awt.Label maxLabel;
  private java.awt.Label midLabel;
  private java.awt.Label minLabel;
  private java.awt.Panel paletScalePanel;
  private java.awt.Label paletTitleLabel;
  // End of variables declaration//GEN-END:variables
  
}

// EOF
