/*
 *  Title: DaiJa_V4 (Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2020.7.1
 *  Copyright: 2020, 2021, 2022
 */
package view;

import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
//import javax.swing.JFrame;
import javax.swing.text.DefaultCaret;
import task.SelfOrganizingMap;
import task.Task;
import util.DJ;
import util.LogEditor;

/**
 * <p> 表　題: Class: Console</p>
 * <p> 説　明: メッセージ（ログ）を表示・保存・読出しする</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2019 ～ 2025</p>
 * <p> 作成日: 2019.1.20</p>
 * <p> 更新日: 2025.6.29</p>
 */
public class Console extends javax.swing.JFrame {

  public static Image icon16;
  public static final String ICON16_FILE = "image/som16.jpg";
  
  public static final String BOUNDS_NAME = "consoleBounds";
  
  private LogEditor editor;
  private DJ dj;
  private PropertyViewer propertyViewer; // プロパティ・ビューワ
  public static final boolean PROPERTY_OPEN = true; // プロパティ・ビューワ表示中
  public static final boolean PROPERTY_CLOSE = false; // プロパティ・ビューワ非表示中
  private static boolean propertyFlag = PROPERTY_CLOSE; // プロパティ・ビューワ表示中フラグ
  
  Task task; // アプリケーション実行用タスク
  
  /**
   * Creates new form LogFrame
   */
  public Console() {
    initComponents();
    ((DefaultCaret)logTextArea.getCaret()).setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
    initialize();
    
    // フォントはinitComponents()ルーチンで、「BIZ UDゴシック 12 プレーン」に設定
    // logTextArea.setFont(new Font(Font.DIALOG, Font.PLAIN, 12)); // 非等幅フォント
    // logTextArea.setFont(new Font(Font.DIALOG_INPUT, Font.PLAIN, 13)); // 等幅フォント
    // logTextArea.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 13));
    
    // BIZ UDゴシック
    
    setBounds(); // 領域を設定
    
    logTextArea.append(" 実行開始のガイド\n");
    logTextArea.append(" ############################################################\n");
    logTextArea.append(" ##\n");
    logTextArea.append(" ##      ・タスクの実行を開始するには、             \n");
    logTextArea.append(" ##      　コンソールの「Run/Pause」ボタンをクリックしてください。 \n");
    logTextArea.append(" ##\n");
    logTextArea.append(" ############################################################\n");
  }
  
  // 領域を設定
  public final void setBounds() {
    Rectangle rect = propertyViewer.getBoundsValue(BOUNDS_NAME);
    if (rect != null) {
      setBounds(rect);
    }
    else { // ディフォルト値を設定
      setBounds(0, 0, 600, 400);
    }
  }
  
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    buttonPanel = new javax.swing.JPanel();
    dumpButton = new javax.swing.JButton();
    loadButton = new javax.swing.JButton();
    clearButton = new javax.swing.JButton();
    onButton = new javax.swing.JButton();
    abortButton = new javax.swing.JButton();
    runButton = new javax.swing.JButton();
    propertyButton = new javax.swing.JButton();
    stepButton = new javax.swing.JButton();
    logPanel = new javax.swing.JPanel();
    logScrollPane = new javax.swing.JScrollPane();
    logTextArea = new javax.swing.JTextArea();
    mainMenuBar = new javax.swing.JMenuBar();
    fileMenu = new javax.swing.JMenu();
    dumpMenuItem = new javax.swing.JMenuItem();
    loadMenuItem = new javax.swing.JMenuItem();
    propertyMenu = new javax.swing.JMenu();
    savePropertyMenuItem = new javax.swing.JMenuItem();
    reReadPropertyMenuItem = new javax.swing.JMenuItem();
    exitMenuItem = new javax.swing.JMenuItem();
    editMenu = new javax.swing.JMenu();
    startStopLogMenuItem = new javax.swing.JMenuItem();
    clearLogMenuItem = new javax.swing.JMenuItem();
    viewerMenu = new javax.swing.JMenu();
    propertyMenuItem = new javax.swing.JMenuItem();
    graphMenuItem = new javax.swing.JMenuItem();
    patternMenuItem = new javax.swing.JMenuItem();
    somMenuItem = new javax.swing.JMenuItem();
    runMenu = new javax.swing.JMenu();
    runPauseMenuItem = new javax.swing.JMenuItem();
    abortMenuItem = new javax.swing.JMenuItem();
    helpMenu = new javax.swing.JMenu();
    aboutMenuItem = new javax.swing.JMenuItem();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    setTitle("DaiJa : Console");
    setName("logFrame"); // NOI18N
    setSize(new java.awt.Dimension(600, 400));

    buttonPanel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
    buttonPanel.setPreferredSize(new java.awt.Dimension(600, 24));

    dumpButton.setText("Dump");
    dumpButton.setMargin(new java.awt.Insets(2, 5, 2, 5));
    dumpButton.setMaximumSize(new java.awt.Dimension(33, 22));
    dumpButton.setMinimumSize(new java.awt.Dimension(33, 22));
    dumpButton.setPreferredSize(new java.awt.Dimension(44, 18));

    loadButton.setText("Load");
    loadButton.setMargin(new java.awt.Insets(2, 10, 2, 10));
    loadButton.setPreferredSize(new java.awt.Dimension(48, 18));

    clearButton.setText("Clear");
    clearButton.setMargin(new java.awt.Insets(2, 10, 2, 10));
    clearButton.setPreferredSize(new java.awt.Dimension(48, 18));

    onButton.setText("On / Off");
    onButton.setMargin(new java.awt.Insets(2, 10, 2, 10));
    onButton.setPreferredSize(new java.awt.Dimension(66, 18));

    abortButton.setText("Abort");
    abortButton.setMargin(new java.awt.Insets(2, 10, 2, 10));
    abortButton.setPreferredSize(new java.awt.Dimension(52, 18));

    runButton.setText("Run / Pause");
    runButton.setMargin(new java.awt.Insets(2, 10, 2, 10));
    runButton.setPreferredSize(new java.awt.Dimension(85, 18));

    propertyButton.setText("Property");
    propertyButton.setMargin(new java.awt.Insets(2, 10, 2, 10));
    propertyButton.setPreferredSize(new java.awt.Dimension(67, 18));

    stepButton.setText("Step");
    stepButton.setToolTipText("");
    stepButton.setMargin(new java.awt.Insets(2, 10, 2, 10));
    stepButton.setPreferredSize(new java.awt.Dimension(45, 18));
    stepButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        stepAction(evt);
      }
    });

    javax.swing.GroupLayout buttonPanelLayout = new javax.swing.GroupLayout(buttonPanel);
    buttonPanel.setLayout(buttonPanelLayout);
    buttonPanelLayout.setHorizontalGroup(
      buttonPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(buttonPanelLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(dumpButton, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(loadButton, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(clearButton, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(onButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(propertyButton, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(abortButton, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(stepButton, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(runButton, javax.swing.GroupLayout.PREFERRED_SIZE, 94, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(28, Short.MAX_VALUE))
    );
    buttonPanelLayout.setVerticalGroup(
      buttonPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(buttonPanelLayout.createSequentialGroup()
        .addGroup(buttonPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(dumpButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(loadButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(clearButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(onButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(runButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(propertyButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(abortButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(stepButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(0, 0, Short.MAX_VALUE))
    );

    getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

    logPanel.setLayout(new java.awt.BorderLayout());

    logScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
    logScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
    logScrollPane.setAutoscrolls(true);
    logScrollPane.setPreferredSize(new java.awt.Dimension(600, 200));

    logTextArea.setFont(new java.awt.Font("BIZ UDゴシック", 0, 14)); // NOI18N
    logScrollPane.setViewportView(logTextArea);

    logPanel.add(logScrollPane, java.awt.BorderLayout.CENTER);

    getContentPane().add(logPanel, java.awt.BorderLayout.CENTER);

    fileMenu.setText("File");

    dumpMenuItem.setText("DumpLogFile");
    dumpMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        dumpLogAction(evt);
      }
    });
    fileMenu.add(dumpMenuItem);

    loadMenuItem.setText("LoadLogFile");
    loadMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        loadLogAction(evt);
      }
    });
    fileMenu.add(loadMenuItem);

    propertyMenu.setText("Property");

    savePropertyMenuItem.setText("SavePropertyFile");
    savePropertyMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        savePropertyAction(evt);
      }
    });
    propertyMenu.add(savePropertyMenuItem);

    reReadPropertyMenuItem.setText("ReadPropertyFile");
    reReadPropertyMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        readPropertyAction(evt);
      }
    });
    propertyMenu.add(reReadPropertyMenuItem);

    fileMenu.add(propertyMenu);

    exitMenuItem.setText("Exit");
    exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        exitMenuAction(evt);
      }
    });
    fileMenu.add(exitMenuItem);

    mainMenuBar.add(fileMenu);

    editMenu.setText("Edit");

    startStopLogMenuItem.setText("Start/Stop Log");
    startStopLogMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        start_stopLogAction(evt);
      }
    });
    editMenu.add(startStopLogMenuItem);

    clearLogMenuItem.setText("Clear Log");
    clearLogMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        clearLogAction(evt);
      }
    });
    editMenu.add(clearLogMenuItem);

    mainMenuBar.add(editMenu);

    viewerMenu.setText("Viewer");

    propertyMenuItem.setText("PropertyViewer");
    propertyMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        propertyViewerAction(evt);
      }
    });
    viewerMenu.add(propertyMenuItem);

    graphMenuItem.setText("GraphViewer");
    graphMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        graphViewerAction(evt);
      }
    });
    viewerMenu.add(graphMenuItem);

    patternMenuItem.setText("PatternViewer");
    patternMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        patternViewerAction(evt);
      }
    });
    viewerMenu.add(patternMenuItem);

    somMenuItem.setText("SomViewer");
    somMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        somViewerAction(evt);
      }
    });
    viewerMenu.add(somMenuItem);

    mainMenuBar.add(viewerMenu);

    runMenu.setText("Run");

    runPauseMenuItem.setText("Run/Pause");
    runPauseMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        run_pauseAction(evt);
      }
    });
    runMenu.add(runPauseMenuItem);

    abortMenuItem.setText("Abort");
    abortMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        abortAction(evt);
      }
    });
    runMenu.add(abortMenuItem);

    mainMenuBar.add(runMenu);

    helpMenu.setText("Help");

    aboutMenuItem.setText("About");
    aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        aboutAction(evt);
      }
    });
    helpMenu.add(aboutMenuItem);

    mainMenuBar.add(helpMenu);

    setJMenuBar(mainMenuBar);

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void exitMenuAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuAction
    logTextArea.append("Console: <Exit> menu item is selected.\n");
//    System.exit(0);
    closeWindow();
  }//GEN-LAST:event_exitMenuAction

  private void propertyViewerAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_propertyViewerAction
//$    logTextArea.append("Console: <PropertyViewer> menu item is selected.\n");
    showPropertyViewer();
  }//GEN-LAST:event_propertyViewerAction

  private void patternViewerAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_patternViewerAction
//$    logTextArea.append("Console: <PatternViewer> menu item is selected.\n");
//    task.showPattern(); // Bug fix  
    if (task != null) task.showPattern();
    else {
      logTextArea.append("Task is not run.\n");
      logTextArea.append("Click Run/Pause button to run the task.\n");
    }
  }//GEN-LAST:event_patternViewerAction

  private void graphViewerAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_graphViewerAction
//$    logTextArea.append("Console: <GraphViewer> menu item is selected.\n");
//    task.showGraph();
    if (task != null) task.showGraph();
    else {
      logTextArea.append("Task is not run.\n");
      logTextArea.append("Click Run/Pause button to run the task.\n");
    }
  }//GEN-LAST:event_graphViewerAction

  private void somViewerAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_somViewerAction
//$    logTextArea.append("Console: <SomViewer> menu item is selected.\n");
    if (task instanceof SelfOrganizingMap) {
      ((SelfOrganizingMap)task).showSom();
    }
    else {
      logTextArea.append("Task is not SelfOrganizingMap.\n");
    }
  }//GEN-LAST:event_somViewerAction

  private void dumpLogAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dumpLogAction
    logTextArea.append("Console: <DumpLogFile> menu item is selected.\n");
    if (editor != null) editor.dumpLog();
    else logTextArea.append("***** ERROR ***** Console: Logs are not dumped. \n");        
  }//GEN-LAST:event_dumpLogAction

  private void loadLogAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadLogAction
    logTextArea.append("Console: <LoadLogFile> menu item is selected.\n");
    if (editor != null) editor.loadLog();
    else logTextArea.append("***** ERROR ***** Console: Logs are not loaded. \n");        
  }//GEN-LAST:event_loadLogAction

  private void savePropertyAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_savePropertyAction
    if (propertyViewer != null) {
      propertyViewer.restoreBoundsList(); // ビューワから領域を取り出し、領域プロパティ・リストに戻す
      propertyViewer.restoreParamerList(); // パラメータ・テーブルからパラメータ・プロパティを取り出す
      propertyViewer.restoreProperty(); // プロパティを再生成し、ファイルに保存する
    }
  }//GEN-LAST:event_savePropertyAction

  private void readPropertyAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_readPropertyAction
    if (propertyViewer != null) {
      propertyViewer.readProperty(); // プロパティ・ファイルを再読み込み
    }  
  }//GEN-LAST:event_readPropertyAction

  private void start_stopLogAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_start_stopLogAction
    logTextArea.append("Console: <Start/Stop Log> menu is selected.\n");
    if (editor != null) editor.setLogActive();
    else logTextArea.append("***** ERROR ***** Console: Log start/stop-operation is failed. \n");
  }//GEN-LAST:event_start_stopLogAction

  private void clearLogAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearLogAction
    logTextArea.setText("Console: <Clear> menu is selected.\n");
    if (editor != null) editor.clearLog();
    else logTextArea.append("***** ERROR ***** Console: Log is not cleared. \n");
  }//GEN-LAST:event_clearLogAction

  private void run_pauseAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_run_pauseAction
    logTextArea.append("Console: <Run / Pause> menu is selected.\n");
    if (propertyViewer.checkParameterChange()) 
      task = taskOperation();  // 実行するタスク
  }//GEN-LAST:event_run_pauseAction

  private void abortAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_abortAction
    logTextArea.append("Console: <Abort> menu is selected.\n");
    if (task != null) task.abortTask();
    else logTextArea.append("***** ERROR ***** Console: There is no task to abort. \n");
  }//GEN-LAST:event_abortAction

  private void aboutAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutAction
    AboutDialog abouDialogt = new AboutDialog(this, true);
    abouDialogt.setCenterLocation(abouDialogt);
    abouDialogt.setVisible(true);
  }//GEN-LAST:event_aboutAction

  private void stepAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stepAction
    if (task != null) task.stepTask(); // ステップ送り実行モードを反転する
  }//GEN-LAST:event_stepAction

  
  private void initialize() {
    
///    setFont(new Font("Century", Font.ITALIC, 18));
    
    // フレーム用アイコンを読込
    icon16 = Toolkit.getDefaultToolkit().getImage(ICON16_FILE);
    
    // ボタンにリスナーを登録
    Console_button_actionAdapter buttonAdapter =
        new Console_button_actionAdapter(this);
    dumpButton.addActionListener(buttonAdapter);
    loadButton.addActionListener(buttonAdapter);
    clearButton.addActionListener(buttonAdapter);
    propertyButton.addActionListener(buttonAdapter);
    onButton.addActionListener(buttonAdapter);
    abortButton.addActionListener(buttonAdapter);
    runButton.addActionListener(buttonAdapter);
    stepButton.addActionListener(buttonAdapter);
    
    // 閉じるボタンのアクション・リスナーを登録
    addWindowListener(new WindowClosing());
    
    // LogEditorを生成
    editor = new LogEditor(this);  
    dj = new DJ(this); // DaiJa汎用関数を生成
    if (!DJ.checkDJ()) {
      System.out.println("***** ERROR ***** LogFrame.initialize: DJ is wrong.");
      System.exit(1);
    }

    // プロパティ・ビューワを生成する
//    propertyViewer = createPropertyViewer();
    showPropertyViewer();
  }

  /**
   * プロパティ・ビューワを生成する
   * ※　初期状態では画面には表示はされない
   * @return propertyViewer PropertyViewer // プロパティ・ビューワ
   */
  public PropertyViewer createPropertyViewer() {
    if (propertyViewer == null) {
      propertyViewer = new PropertyViewer(this);
      
      if (propertyViewer.stringList == null) {
        // プロパティ・ファイルが読込まれなかった
        System.out.println("***** ERROR ***** Console.createPropertyViewer():");
        System.out.println("Failed to open a property file.");
        System.exit(0);
      }
      
      propertyViewer.putBounds(); // 領域をプロパティで置き換え
    }
    
    return propertyViewer;
  }
  
  /**
   * プロパティ・ビューワを表示・非表示する。
   */
  public void showPropertyViewer() {
    createPropertyViewer();
    
    // 表示されていなかったらフラグを落とす
    if (!propertyViewer.isShowing()) propertyFlag = PROPERTY_CLOSE;
    if (propertyFlag == PROPERTY_OPEN) { // プロパティ・フレームは表示中か？
      propertyViewer.setVisible(false); // ロパティ・フレームを非表示にする
      propertyFlag = PROPERTY_CLOSE; // プロパティ・フレーム非表示中
//$      addLog("Console.showPropertyFrame(): PropertyFrame is closed.");
      logTextArea.append("Console.showPropertyFrame(): PropertyFrame is closed.\n");
    }
    else {
      propertyViewer.setVisible(true); // ロパティ・フレームを表示する
      propertyFlag = PROPERTY_OPEN; // プロパティ・フレーム表示中
//      addLog("Console.showPropertyFrame(): PropertyFrame is opened.");
      logTextArea.append("Console.showPropertyFrame(): PropertyFrame is opened.\n");
    }
  }
  
  public PropertyViewer getPropertyViewer() {
    return propertyViewer; // プロパティ・ビューワ
  }
  
   /**
   * メッセージをテキストエリアに追加する。
   * @param log String // メッセージ
   */
  public void writeToTextArea(String log) {
    logTextArea.append(log);
  }
  
  void button_actionPerformed(ActionEvent e) {
    String cmd = e.getActionCommand();
    switch (cmd) {
      case "On / Off": //"Start / Stop":
        logTextArea.append("Console: <On / Off> button is clicked.\n");
        if (editor != null) editor.setLogActive();
        else logTextArea.append("***** ERROR ***** Console: Log on/off-operation is failed. \n");       
        break;
      case "Dump":
        logTextArea.append("Console: <Dump> button is clicked.\n");
        if (editor != null) editor.dumpLog();
        else logTextArea.append("***** ERROR ***** Console: Logs are not dumped. \n");
        break;
      case "Load":
        logTextArea.append("Console: <Load> button is clicked.\n");
        if (editor != null) editor.loadLog();
        else logTextArea.append("***** ERROR ***** Console: Logs are not loaded. \n");        
        break;
      case "Clear":
        logTextArea.setText("Console: <Clear> button is clicked.\n");
        if (editor != null) editor.clearLog();
        else logTextArea.append("***** ERROR ***** Console: Log is not cleared. \n");
        break;
      case "Property":
        logTextArea.append("Console: <Property> button is clicked.\n");
        showPropertyViewer();
        break;
      case "Abort":
        logTextArea.append("Console: <Abort> button is clicked.\n");
        if (task != null) task.abortTask();
        break;
      case "Run / Pause": //"Run
        moveCaretToEnd(); // キャレットを最後尾に移動
        logTextArea.append("Console: <Run / Pause> button is clicked.\n");
        if (propertyViewer.checkParameterChange()) 
          task = taskOperation();  // 実行するタスク
        break;
    }
  
  }
  
  /**
   * テキスト表示エリアのキャレットを最後尾に移動する
   */
  private void moveCaretToEnd() {
    int end = logTextArea.getDocument().getLength();
    logTextArea.setCaretPosition(end);
  }
              
  /**
   * アプリケーションを実行/休止する
   * アプリケーションが定義されていなければ生成する
   * @return task Task // タスク
   */
  public Task taskOperation() {
    Class<?> appClass = null; // アプリケーションのクラス
    
    if (task == null) { // タスクがまだ生成されていない
      String className = propertyViewer.getAppName();
      try {
        appClass = Class.forName(className); // アプリケーションのクラス
// 2024.2.13        task = (Task)(appClass.newInstance()); // アプリケーションのインスタンス
        task = (Task)(appClass.getDeclaredConstructor().newInstance()); // アプリケーションのインスタンス
      }
      catch (ReflectiveOperationException e) {
//        addLog("Console.taskOperation(): ReflectiveOperationException.");
//        addLog("Console.taskOperation(): Failed to get an application.");
        logTextArea.append("Console.taskOperation(): ReflectiveOperationException.\n");
        logTextArea.append("Console.taskOperation(): Failed to get an application.\n");
      }

      // アプリケーションのパラメータをプロパティで置き換え
      propertyViewer.putParameter(appClass, task);

      task.startTask();
    }
    else {
      task.pauseTask();
    }
    return task;
  }
  
  /**
   * スレッドの実行開始
   * @param thread Thread // スレッド
   * @return resultFlag boolean // true:実行開始, false:実行できない
   */
  public boolean startThread(Thread thread) {
    if (thread == null) {
      logTextArea.setText("Console.startThread():There are no taskThread. \n" +
            "***** ERROR ***** 'taskThread' is not started. \n");
      return false;
    }
    else {
      thread.start();
      return true;
    }
  }
  
  // プログラムを終了する
  private void closeWindow() {
    int ans = JOptionPane.showConfirmDialog(
            Console.this, "本当に終了しますか?", "終了確認",
            JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
    if (ans == JOptionPane.YES_OPTION) {
//$      addLog("Console.closeWindow(): Exit from DaiJa.");
      logTextArea.append("Console.closeWindow(): Exit from DaiJa.\n");
      System.out.println("Console.closeWindow(): Exit from DaiJa.");
      System.exit(0);
    }  
  }
  
  // 閉じるボタンのアクション・アダプター
  class WindowClosing extends WindowAdapter {
    @Override
    public void windowClosing(WindowEvent e) {
      closeWindow();      
    }
  }
  
  class Console_button_actionAdapter implements java.awt.event.ActionListener {

    Console adaptee;

    Console_button_actionAdapter(Console adaptee) {
      this.adaptee = adaptee;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
      adaptee.button_actionPerformed(e);
    }
}
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton abortButton;
  private javax.swing.JMenuItem abortMenuItem;
  private javax.swing.JMenuItem aboutMenuItem;
  private javax.swing.JPanel buttonPanel;
  private javax.swing.JButton clearButton;
  private javax.swing.JMenuItem clearLogMenuItem;
  private javax.swing.JButton dumpButton;
  private javax.swing.JMenuItem dumpMenuItem;
  private javax.swing.JMenu editMenu;
  private javax.swing.JMenuItem exitMenuItem;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JMenuItem graphMenuItem;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JButton loadButton;
  private javax.swing.JMenuItem loadMenuItem;
  private javax.swing.JPanel logPanel;
  private javax.swing.JScrollPane logScrollPane;
  private javax.swing.JTextArea logTextArea;
  private javax.swing.JMenuBar mainMenuBar;
  private javax.swing.JButton onButton;
  private javax.swing.JMenuItem patternMenuItem;
  private javax.swing.JButton propertyButton;
  private javax.swing.JMenu propertyMenu;
  private javax.swing.JMenuItem propertyMenuItem;
  private javax.swing.JMenuItem reReadPropertyMenuItem;
  private javax.swing.JButton runButton;
  private javax.swing.JMenu runMenu;
  private javax.swing.JMenuItem runPauseMenuItem;
  private javax.swing.JMenuItem savePropertyMenuItem;
  private javax.swing.JMenuItem somMenuItem;
  private javax.swing.JMenuItem startStopLogMenuItem;
  private javax.swing.JButton stepButton;
  private javax.swing.JMenu viewerMenu;
  // End of variables declaration//GEN-END:variables

} // Console

// EOF

