/*
 *  Title: DaiJa_V4 (Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
  *  @since 2020.7.1
 *  Copyright: 2020, 2021
 */
package view;

import util.DJ;

/**
 * <p> 表　題: Class: PatternViewerLauncher</p>
 * <p> 説　明: PatternViewerを新規スレッドで開始する</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2019, 2020</p>
 * <p> 作成日: 2019.9.9</p>
 */
//public class PatternViewerLauncher implements Runnable {
public class PatternViewerLauncher extends ViewerLauncher {

  PatternViewer patternViewer;
  double[][] patternData0, patternData1; // パターン・データ
  double[][][] patternArray0, patternArray1; // パターン・データ
  int patternType0, patternType1; // 描画パターン・タイプ
  String patternComment0, patternComment1;
  int numOfPattern; // パターン数

  /**
   * 新規スレッドで実行されるPatternViewerを生成する
   *
   * @param patternType0 int // 描画パターン・タイプ
   * @param patternArray0 double[][] // パターン・データ
   * @param patternComment0 String // パターン・コメント
   */
  public PatternViewerLauncher(
          int patternType0, double[][] patternArray0, String patternComment0) {
    numOfPattern = 1;
    this.patternType0 = patternType0; // 描画パターン
    patternData0 = patternArray0;
    this.patternComment0 = patternComment0;
    // スレッドの生成と開始
    Thread pvThread = new Thread(this); // タスク実行用スレッド
    pvThread.setPriority(Thread.NORM_PRIORITY);
    startThread(pvThread);
  }

  /**
   * 新規スレッドで実行されるPatternViewerを生成する
   *
   * @param patternType0 int // 描画パターン・タイプ
   * @param patternArray0 double[][] // パターン・データ
   * @param patternComment0 String // パターン・コメント
   * @param patternType1 int // 描画パターン・タイプ
   * @param patternArray1 double[][] // パターン・データ
   * @param patternComment1 String // パターン・コメント
   */
  public PatternViewerLauncher(
          int patternType0, double[][] patternArray0, String patternComment0,
          int patternType1, double[][] patternArray1, String patternComment1) {
    numOfPattern = 2;
    this.patternType0 = patternType0; // 描画パターン
    patternData0 = patternArray0;
    this.patternComment0 = patternComment0;
    this.patternType1 = patternType1; // 描画パターン
    patternData1 = patternArray1;
    this.patternComment1 = patternComment1;
    // スレッドの生成と開始
    Thread pvThread = new Thread(this); // タスク実行用スレッド
    pvThread.setPriority(Thread.NORM_PRIORITY);
    startThread(pvThread);
  }

  /**
   * 新規スレッドで実行されるPatternViewerを生成する
   *
   * @param patternType0 int // 描画パターン・タイプ
   * @param patternArray0 double[][][] // パターン・データ
   * @param patternComment0 String // パターン・コメント
   * @param patternType1 int // 描画パターン・タイプ
   * @param patternArray1 double[][] // パターン・データ
   * @param patternComment1 String // パターン・コメント
   */
  public PatternViewerLauncher(
          int patternType0, double[][][] patternArray0, String patternComment0,
          int patternType1, double[][] patternArray1, String patternComment1) {
    numOfPattern = 2;
    this.patternType0 = patternType0; // 描画パターン
    this.patternArray0 = patternArray0;
    this.patternComment0 = patternComment0;
    this.patternType1 = patternType1; // 描画パターン
    this.patternData1 = patternArray1;
    this.patternComment1 = patternComment1;
    // スレッドの生成と開始
    Thread pvThread = new Thread(this); // タスク実行用スレッド
    pvThread.setPriority(Thread.NORM_PRIORITY);
    startThread(pvThread);
  }

  /**
   * 新規スレッドで実行されるPatternViewerを生成する
   *
   * @param patternType0 int // 描画パターン・タイプ
   * @param patternArray0 double[][][] // パターン・データ
   * @param patternComment0 String // パターン・コメント
   * @param patternType1 int // 描画パターン・タイプ
   * @param patternArray1 double[][][] // パターン・データ
   * @param patternComment1 String // パターン・コメント
   */
  public PatternViewerLauncher(
          int patternType0, double[][][] patternArray0, String patternComment0,
          int patternType1, double[][][] patternArray1, String patternComment1) {
    numOfPattern = 2;
    this.patternType0 = patternType0; // 描画パターン
    this.patternArray0 = patternArray0;
    this.patternComment0 = patternComment0;
    this.patternType1 = patternType1; // 描画パターン
    this.patternArray1 = patternArray1;
    this.patternComment1 = patternComment1;
    // スレッドの生成と開始
    Thread pvThread = new Thread(this); // タスク実行用スレッド
    pvThread.setPriority(Thread.NORM_PRIORITY);
    startThread(pvThread);
  }

  private void startThread(Thread pvThread) {
    pvThread.start(); // メソッドrun()を実行
  }

  @Override
  public void run() {
    if (numOfPattern == 1) { // パターン数
      patternViewer = new PatternViewer(
              patternType0, patternData0, patternComment0);
    } else {
      patternViewer = new PatternViewer(
              patternType0, patternData0, patternComment0,
              patternType1, patternData1, patternComment1);
    }
//    patternViewer.setVisible(true);
    patternViewer.setVisible(false);
  }

  /**
   * パターン・ビューワを得る
   *
   * @return patternViewer　PatternViewer　// パターン・ビューワ
   */
  public PatternViewer getPatternViewer() {
    
///    waitViewer(patternViewer);
    
    Boolean waitFlag = true;    
    synchronized (this) {
      while (waitFlag) {
        try {
          wait(1); // タイムアウト付きで待機状態
          if (patternViewer != null) { waitFlag = false; }
        } catch (InterruptedException e) {
          DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
                  + " Exception occur in while loop:" + e.toString());
        }
      } // while
    } // synchronized()
    if (patternViewer == null) {
      DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
              + " Failed to get patternViewer.");
    }
    
    return patternViewer;
  }

} // PatternViewerLauncher

// EOF
