/*
 *  Title: DaiJa_V4 (Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2021.4.4
 *  Copyright: 2020, 2021
 */
package view;

//import java.util.ArrayList;
import util.DJ;

/**
 * <p> 表　題: Class: SomViewerLauncher</p>
 * <p> 説　明: SomViewerを新規スレッドで開始する</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2021</p>
 * <p> 作成日: 2021.4.29</p>
 */
//public class SomViewerLauncher implements Runnable {
public class SomViewerLauncher extends ViewerLauncher {

  SomViewer somViewer; // ＳＯＭビューワ
  int somType; // ＳＯＭタイプ
  String somComment; // ＳＯＭコメント

  /**
   * 新規スレッドで実行されるＳＯＭビューワを生成する
   *
   * @param somType int // ＳＯＭタイプ
   * @param somComment String // ＳＯＭコメント
   */
  public SomViewerLauncher(int somType, String somComment) {
    this.somType = somType; // ＳＯＭタイプ
    this.somComment = somComment; // ＳＯＭコメント
    // スレッドの生成と開始
    Thread somThread = new Thread(this); // ＳＯＭビューワ実行用スレッド
    somThread.setPriority(Thread.NORM_PRIORITY);
    startThread(somThread);
  }

  private void startThread(Thread somThread) {
    somThread.start(); // メソッドrun()を実行
  }

  @Override
  public void run() {
    somViewer = new SomViewer();
    somViewer.setVisible(false);
  }

  /**
   * ＳＯＭビューワを得る
   * @return SomViewer SomViewer　// ＳＯＭビューワ
   */
  public SomViewer getSomViewer() {
    
//  waitViewer()は1度目のみ機能し、２度目以降は機能しない
//    waitViewer(somViewer);
//    ArrayList<Viewer> viewerList = new ArrayList<>();
//    viewerList.add(somViewer);
//    waitViewer(viewerList);
    
    Boolean waitFlag = true;    
    synchronized (this) {
      while (waitFlag) {
        try {
          wait(1); // タイムアウト付きで待機状態
          if (somViewer != null) { waitFlag = false; }
        } catch (InterruptedException e) {
          DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
                  + " Exception occur in while loop:" + e.toString());
        }
      } // while
    } // synchronized()
    if (somViewer == null) {
      DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
              + " Failed to get SomViewer.");
    }
    
    return somViewer;
  }

} // SomViewerLauncher

// EOF
