/*
 *  Title: DaiJa_V4 (Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2021.3.3
 *  Copyright: 2021
 */
package view;

//import task.Task;
//import java.util.ArrayList;
import util.DJ;

/**
 * <p> 表　題: Class: ViewerLauncher</p>
 * <p> 説　明: ビューワを起動する</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2021</p>
 * <p> 作成日: 2021.4.30</p>
 */
public abstract class ViewerLauncher implements Runnable {
  
  
/**
 * ビューワが起動されるのを待つ
 * ※　waitViewer()は1度目のみ機能し、２度目以降は機能しない
 * 
 * @param viewer Viewer // ビューワ
 */
  public void waitViewer(Viewer viewer) {
    Boolean waitFlag = true;    
    synchronized (this) {
      while (waitFlag){
        try {
          wait(1); // タイムアウト付きで待機状態
          if (viewer != null) {
            waitFlag = false;
          }
        } catch (InterruptedException e) {
          DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
                  + " Exception occur in while loop:" + e.toString());
        }
      } // while
    } // synchronized()
//    if (viewer == null) {
//          DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
//                  + " Failed to get Viewer.");
//    }
  } // waitViewer
  
} // ViewerLauncher

// EOF

