/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2021.3.3
 *  Copyright: 2020, 2021
*/
package active;

/**
 * <p> 表　題: Class: Sigmoid</p>
 * <p> 説　明:シグモイド活性化関数クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.14</p>
 */
public class Sigmoid extends Activator {
  
  // 活性化関数
  @Override
  public void function(double[] u, double[] y) {
    int length = u.length;
    for (int i = 0; i < length; i++) {
      // シグモイド関数 y[i] = sigmoid(u[i]);
      y[i] = 1.0 / (1.0 + Math.exp(-u[i]));
    }
  }
  @Override
  public void function(double[][] u, double[][] y) {
    for (int i = 0; i < u.length; i++) {
      for (int j = 0; j < u[0].length; j++) {
      // シグモイド関数 y[i][j] = sigmoid(u[i][j]);
      y[i][j] = 1.0 / (1.0 + Math.exp(-u[i][j]));
      }
    }
  }
  
  // 活性化関数の微分
  @Override
  public void derivative(double[] u, double[] y, double[] dydu) {
    for (int i = 0; i < u.length; i++) {
      dydu[i] = (1.0 - y[i]) * y[i]; // シグモイド関数の微分
    }
  }
  @Override
  public void derivative(double[][] u, double[][] y, double[][] dydu) {
    for (int i = 0; i < u.length; i++) {
      for (int j = 0; j < u[0].length; j++) {
        dydu[i][j] = (1.0 - y[i][j]) * y[i][j]; // シグモイド関数の微分
      }
    }
  }
  
  // シグモイド関数
  private double sigmoid(double u) {
    double y = 1.0 / (1.0 + Math.exp(-u));
    return y;
  }
  
} // Sigmoid

// EOF
