/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2021.3.3
 *  Copyright: 2020, 2021
 */
package active;

/**
 * <p> 表　題: Class: SoftMax</p>
 * <p> 説　明:ソフトマックス活性化関数クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.14</p>
 */
public class SoftMax extends Activator {
  
  // 活性化関数
  @Override
  public void function(double[] u, double[] y) {
    int length = u.length;
    double sum = 0.0;
    double[] expU = new double[length];
    for (int i = 0; i < length; i++) {
      expU[i] = Math.exp(u[i]);
      sum = sum + expU[i];
    }
    
    for (int i = 0; i < length; i++) {
      y[i] = expU[i] / sum;
    }
  }
  @Override
  public void function(double[][] u, double[][] y) {
    int row = u.length;
    int col = u[0].length;
    double sum = 0.0;
    double[][] expU = new double[row][col];
    for (int i = 0; i < row; i++) {
      for (int j = 0; j < col; j++) {
      expU[i][j] = Math.exp(u[i][j]);
      sum = sum + expU[i][j];
      }
    }
    
    for (int i = 0; i < row; i++) {
      for (int j = 0; j < col; j++) {
        y[i][j] = expU[i][j] / sum;
      }
    }
  }
  
  // 活性化関数の微分
  @Override
  public void derivative(double[] u, double[] y, double[] dydu) {
    int length = u.length;
    
//###########################################################################
// 暫定処理　2020.9.19

    //  ※誤差関数として交差エントロピー誤差を用い、
    //　　活性化関数としてソフトマックスを用いた場合
    //　　dEdu=y-tなので、活性化関数の微分dyduとして1.0を返す
    // dEdu = dEdy * dydu (誤差関数 * 活性化関数)
    //　　　= (y - t) * 1.0
    //      = e  * 1.0

    for (int i = 0; i < length; i++) {
      dydu[i] = 1.0; // ソフトマックス関数の微分ではない
    }
//###########################################################################    
    
  }
  @Override
  public void derivative(double[][] u, double[][] y, double[][] dudy) {
    int row = u.length;
    int col = u[0].length;
    
//###########################################################################
// 暫定処理　2020.9.19

    //  ※誤差関数として交差エントロピー誤差を用い、
    //　　活性化関数としてソフトマックスを用いた場合
    //　　dEdu=y-tなので、活性化関数の微分dyduとして1.0を返す
    // dEdu = dEdy * dydu (誤差関数 * 活性化関数)
    //　　　= (y - t) * 1.0
    //      = e  * 1.0

    for (int i = 0; i < row; i++) {
      for (int j = 0; j < col; j++) {
        // ソフトマックス関数の微分
        dudy[i][j] = 1.0; // ソフトマックス関数の微分ではない
      }
    }
//###########################################################################    

  }
  
} // SoftMax

// EOF
