/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2021.3.3
 *  Copyright: 2020, 2021
 */
package active;

/**
 * <p> 表　題: Class: Step</p>
 * <p> 説　明:ステップ活性化関数クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.14</p>
 */
public class Step extends Activator {
  
  // 活性化関数
  @Override
  public void function(double[] u, double[] y) {
    int length = u.length;
    for (int i = 0; i < length; i++) {
      // ステップ関数 y[i] = step(u[i]);
      if (u[i] >= 0.0) y[i] = 1.0;
      else y[i] = 0.0;
    }
  }
  @Override
  public void function(double[][] u, double[][] y) {
    for (int i = 0; i < u.length; i++) {
      for (int j = 0; j < u[0].length; j++) {
        // ステップ関数 y[i][j] = step(u[i][j]);
        if (u[i][j] >= 0.0) y[i][j] = 1.0;
        else y[i][j] = 0.0;
      }
    }
  }
  
  // 活性化関数の疑似微分
  @Override
  public void derivative(double[] u, double[] y, double[] dudy) {
    for (int i = 0; i < u.length; i++) {
      dudy[i] = 1.0; // ステップ関数の疑似微分
    }
  }
  @Override
  public void derivative(double[][] u, double[][] y, double[][] dudy) {
    for (int i = 0; i < u.length; i++) {
      for (int j = 0; j < u[0].length; j++) {
        dudy[i][j] = 1.0; // ステップ関数の疑似微分
      }
    }
  }
  
  // ステップ関数
  private double step(double u) {
    double y;
    if (u >= 0.0) y = 1.0;
    else y = 0.0;
    return y;
  }
  
} // Step

// EOF
