/*
 *  Title: DaiJa_V5 (Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020 - 2022
 */
package daija;

import view.Console;

/**
 * <p> 表　題: Class: DaiJa</p>
 * <p> 説　明: Digital-Learning Aide Instrument with Java</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.10</p>
 */
public class DaiJa{
    
  private static DaiJa daija; // このクラスのインスタンスへの参照
  public static String CLASS_NAME; // このクラスの名称
  public static String SIMPLE_NAME; // このクラスのみの名称
  private Console consol; // コンソール
    
  private DaiJa(String[] args) {
    init();
  }
    
  private void init() {
    consol = new Console();
    consol.setVisible(true);
  }
   
  /**
   * DaiJaクラスのインスタンスを返す
   * インスタンスが無ければ生成する
   * @param args String[] // パラメータ
   */
  public static final void createDaiJa(String[] args) {
    if (daija == null) {
      daija = new DaiJa(args);
    }
    SIMPLE_NAME = daija.getClass().getSimpleName();
    System.out.println(SIMPLE_NAME + " class is created.");
    CLASS_NAME = daija.getClass().getName();
    System.out.println("Class ID is \"" + CLASS_NAME + "\".");
  }

  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    createDaiJa(args);
  }
    
} // End of DaiJa

// End of File


