/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2020.7.1
 *  Copyright: 2020, 2021
 */
package layer;

/**
 * <p> 表　題: Class: ControlLayer</p>
 * <p> 説　明:制御層クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.7.23</p>
 */
public class ControlLayer extends Layer{

  // 生成子
  public ControlLayer(int inputNodeNum, int outputNodeNum) {
    super(inputNodeNum, outputNodeNum);
  }
  
  // 変数をゼロクリアする  
  public void clear() {
    
    for (int i = 0; i < inNodeNum; i++) {
      x[i] = 0.0; // 入力
    }
    
    for (int i = 0; i < outNodeNum; i++) {
//      for (int j = 0; j < inNodeNum; j++) {
//        hWeight[i][j] = 1.0E-8;
//      }
//      hBias[i] = 1.0E-8;

      u[i] = 0.0; // 内部状態量
      y[i] = 0.0; // 出力
      c[i] = 0.0; // 正解
      e[i] = 0.0; // 誤差
    }
  }
  
//  // 順伝播処理 ----------------------------------------------------------------
//  @Override
//  public void forward() {
//    calcuOutput(); // 出力を求める
//  }
//  
//  // 出力を求める
//  private void calcuOutput() {
//    for (int i = 0; i < outNodeNum; i++) {
//      u[i] = b[i];
//      for (int j = 0; j < inNodeNum; j++) {
//        u[i] = u[i] +  w[i][j] * x[j];
//      }
//    }
//    activator.function(u, y);
//  }

//  // 逆伝播処理（出力層用）-----------------------------------------------------
//  @Override
//  public void backward(double[] c) {
//    calcuGradient(c); //勾配を求める
//  }

  public void backward(double[] c, double[] s) {
    calcuGradient(c, s); //勾配を求める
  }
  
//  // 逆伝播処理（中間層用：引数なし）
////#  public void backwardMid(double[] dEdX) {
//  @Override
//  public void backward() {
//    calcuGradient(); //勾配を求める
//  }
  
//  // 誤差を求める
//  public void calcuError() {
//    for (int i = 0; i < outNodeNum; i++) {
//      e[i] = y[i] - c[i];
//    }
//    dEdY = e;
//  }
  
  // 勾配を求める
  private void calcuGradient(double[] c) {
    
//#    activator.derivative(u, y, c, dYdU); // 活性化関数の微分
/*#*/    activator.derivative(u, y, dYdU); // 活性化関数の微分

    for (int j = 0; j < inNodeNum; j++) {
      dEdX[j] = 0.0;
    }
    
    for (int i = 0; i < outNodeNum; i++) {
      // 誤差を求める
      e[i] = y[i] - c[i]; // 注）二乗誤差の微分は2*eとなる。2は除外
      // 注）ReLUの微分は負側でゼロとなるので、強制的に１とする
      dEdU[i] = e[i]; // 内部状態量による誤差の勾配
      dEdB[i] = dEdU[i]; // バイアスによる誤差の勾配
      dEdB_sum[i] = dEdB_sum[i] + dEdB[i]; // バッチ用のバイアスによる誤差の勾配
      for (int j = 0; j < inNodeNum; j++) {
        dEdW[i][j] = dEdU[i] * x[j]; // 重みによる誤差の勾配
        dEdW_sum[i][j] = dEdW_sum[i][j] + dEdW[i][j]; // バッチ用の重みによる誤差の勾配
        dEdX[j] = dEdX[j] + w[i][j] * dEdU[i]; // 入力による誤差の勾配
      }
    }

  }
  
  // 勾配を求める
  // 出力ｙ[]をそのまま誤差の算出に使わない場合に使われる
  // 誤差は制御対象の出力（応答速度s[]）と正解（c[]所望速度）から求める
  private void calcuGradient(double[] c, double[] s) {
    activator.derivative(u, y, dYdU); // 活性化関数の微分

    for (int j = 0; j < inNodeNum; j++) {
      dEdX[j] = 0.0;
    }
    
    for (int i = 0; i < outNodeNum; i++) {
      // 誤差を求める
      e[i] = s[i] - c[i]; // 注）二乗誤差の微分は2*eとなる。2は除外
/**/      dEdU[i] = e[i] * dYdU[i]; // 内部状態量による誤差の勾配
//**/      dEdU[i] = e[i]; // 内部状態量による誤差の勾配
      dEdB[i] = dEdU[i]; // バイアスによる誤差の勾配
      dEdB_sum[i] = dEdB_sum[i] + dEdB[i]; // バッチ用のバイアスによる誤差の勾配
      for (int j = 0; j < inNodeNum; j++) {
        dEdW[i][j] = dEdU[i] * x[j]; // 重みによる誤差の勾配
        dEdW_sum[i][j] = dEdW_sum[i][j] + dEdW[i][j]; // バッチ用の重みによる誤差の勾配
        dEdX[j] = dEdX[j] + w[i][j] * dEdU[i]; // 入力による誤差の勾配
      }
    }

  }
  
} // class LinearLayer

// EOF

