/*
 *  Title: DaiJa_V4 ( Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2020.7.1
 *  Copyright: 2020, 2021
 */
package layer;

/**
 * <p> 表　題: Class: IntegerLayer</p>
 * <p> 説　明:整数変数層クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2020, 2021</p>
 * <p> 作成日: 2020.3.13</p>
 */
public class IntegerLayer extends Layer {
  
  // Input
  private int[] intInVector;
  private int[][] intInMatrix;
  
  // Weight
  private int[][] intWeightMatrix;
  
  // Filter
  private int[][] intFilterMatrix;
  private int[][][] intFilterTrisor; // ３次元フィルタ
  
  // Bias
  private int[] intBiasVector;
  private int[][] intBiasMatrix;
  
  // U：内部状態量
  private int[] intUVector;
  private int[][] intUMatrix;
  
  // Output
  private int[] intOutVector;
  private int[][] intOutMatrix;
  
  public IntegerLayer(int row, int initialValue) {
    super(1, 1);
    
    intInVector = new int[row];
    for (int i = 0; i < row; i++) {
      intInVector[i] = initialValue;
    }
  }

  public IntegerLayer(int row, int column, int initialValue) {
    super(1, 1);
    
    intInMatrix = new int[row][column];
    for (int i = 0; i < row; i++) {
      for (int j = 0; j < row; j++) {
        intInMatrix[i][j] = initialValue;
      }
    }
  }

  public IntegerLayer intMatrixLayer(int row, int column) {
    return new IntegerLayer(row, column, 0);
  }
  
  // 初期化
  @Override
  public void initialize(double eta, double initialCoef,
          String activatorName, int gradientDescent) {
    
  }
  
  // 順伝播処理
  @Override
  public void forward() { }

  // 逆伝播処理
  @Override
  public void backward(double[] c) { } // 出力層用：引数あり
  @Override
  public void backward() { } // 中間層用：引数なし

  // 更新処理
  @Override
  public void update() { }
  
} // IntegerLayer

// EOF
