/*
 *  Title: DaiJa_V5 (Digital-Learning Aide Instrument by Java)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020, 2021, 2022
 */
package meta;

import java.util.HashMap;
import java.util.Map;
import util.DJ;

/**
 * <p> 表　題: Class: Assets</p>
 * <p> 説　明: 資産クラス</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2022</p>
 * <p> 作成日: 2022.11.18</p>
 */
public class Assets extends Entity {
  
  static int numOfAssets = 0; // 資産の個数
  protected int assetsNo; // 資産番号
  ; // 整数マップ
  protected Map<String, Integer> integerMap; // 整数マップ
  protected Map<String, Double> doubleMap; // 実数マップ
  protected Map<String, Boolean> booleanMap; // 論理値マップ
  protected Map<String, String> textMap; // 文字列マップ
  
  /**
   * Assetsクラス生成子
   */
  public Assets() {
    initAssets();
  }
  
  // Assertを初期化
  private void initAssets() {
    assetsNo = numOfAssets++; // 資産の個数を更新
    entityName = "Assert" + assetsNo; // 資産番号を設定
    
    DJ.print_("Assets is created! --- ");
  }
  
  /**
   * 資産番号を設定する
   * ※資産番号を強制的に設定するので、使用は慎重に
   * @param assetsNo int // 資産番号
   */
  public void setAssetsNo(int assetsNo) {
    this.assetsNo = assetsNo;
  }
  
  /**
   * 資産番号を得る
   * @return assetsNo int // 資産番号
   */
  public int getAssetsNo() {
    return assetsNo;
  }

  // ---------------------------------------------------------------------------

  // 整数マップを宣言
  private void makeIntegerMap() {
    integerMap = new HashMap<>();
  }

  // 実数マップを宣言
  private void makeDoubleMap() {
    doubleMap = new HashMap<>();
  }

  // 論理値マップを宣言
  private void makeBooleanMap() {
    booleanMap = new HashMap<>();
  }

  // 文字列マップを宣言
  private void makeTextMap() {
    textMap = new HashMap<>();
  }

  // ---------------------------------------------------------------------------
  /**
   * 整数データを追加
   * @param key String // キー：文字列
   * @param value int // 値：整数
   */
  public void appendInteger(String key, int value) {
    if (integerMap == null ) makeIntegerMap();
    integerMap.put(key, value);
  }
  
  /**
   * 実数データを追加
   * @param key String // キー：文字列
   * @param value double // 値：実数
   */
  public void appendDouble(String key, double value) {
    if (doubleMap == null ) makeDoubleMap();
    doubleMap.put(key, value);
  }
  
  /**
   * 論理値データを追加
   * @param key String // キー：文字列
   * @param flag boolean // 値：論理値
   */
  public void appendBoolean(String key, boolean flag) {
    if (booleanMap == null ) makeBooleanMap();
    booleanMap.put(key, flag);
  }
  
  /**
   * 文字列データを追加
   * @param key String // キー：文字列
   * @param text String // 値：文字列
   */
  public void appendString(String key, String text) {
    if (textMap == null ) makeTextMap();
    textMap.put(key, text);
  }
  
  // ---------------------------------------------------------------------------
  /**
   * 整数データを得る
   * @param key
   * @return 
   */
  public int getIntegerValue(String key){
//    Object obj = integerMap.get(key);
//    int value = (Integer)obj;
//    return value;
//    return (Integer)obj;
    return integerMap.get(key);
  }
  
  /**
   * 整数データを設定する
   * @param key String // キー
   * @param value int // 整数値
   */
  public void setIntegerValue(String key, int value){
//    Object result = integerMap.put(key, value);
//    if (result == null)
//      DJ.print_("Assets.setValue() Error: key=" + key + ", Value=" + value + ".");
    if (integerMap == null ) 
      DJ._print("Assets.setIntegerValue() Error:Integer asset is null."
              + " key=" + key + ", Value=" + value + ".");
    else integerMap.put(key, value);
  }
  
  /**
   * 　実数データを得る
   * @param key String // キー
   * @return value double // 実数値
   */
  public double getDoubleValue(String key){
    return doubleMap.get(key);
  }
  
  /**
   * 実数データを設定する
   * @param key String // キー
   * @param value double // 実数値
   */
  public void setDoubleValue(String key, double value){
    if (doubleMap == null ) 
      DJ._print("Assets.setDoubleValue() Error:Double asset is null."
              + " key=" + key + ", Value=" + value + ".");
    else doubleMap.put(key, value);
  }
  
  /**
   * 　論理データを得る
   * @param key String // キー
   * @return flag boolean // 論理値
   */
  public boolean getBooleanValue(String key){
    return booleanMap.get(key);
  }
  
  /**
   * 論理データを設定する
   * @param key String // キー
   * @param flag boolean // 論理値
   */
  public void setBooleanValue(String key, boolean flag){
    if (booleanMap == null ) 
      DJ._print("Assets.setBooleanValue() Error:Boolean asset is null."
              + " key=" + key + ", Value=" + flag + ".");
    else booleanMap.put(key, flag);
  }
  
  /**
   * 文字列データを得る
   * @param key String // キー
   * @return text String // 文字列
   */
  public String getStringValue(String key){
//    Object obj = textMap.get(key);
//    int value = (String)obj;
//    return value;
    return textMap.get(key);
  }
  
  /**
   * 文字列データを設定する
   * @param key String // キー
   * @param text String // 文字列
   */
  public void setStringValue(String key, String text){
//    Object result = textMap.put(key, text);
//    if (result == null)
//      DJ._print("Assets.setValue() Error: key=" + key + ", Value=" + text + ".");
    if (textMap == null ) 
      DJ._print("Assets.setStringValue() Error:String asset is null."
              + " key=" + key + ", Value=" + text + ".");
    else textMap.put(key, text);
  }
  
  // ---------------------------------------------------------------------------
  
  
  
  
  
} // Assets class

// EOF