/*
 *  Title: DaiJa_V5 (Digital-learning Aide Instrument by JAva))
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020 - 2024
 */
package task.qu;

import quan.QuBit;
import quan.QuGate;
import task.Task;
import util.comp.Complex;
import util.DJ;
import util.TimeStamp;

/**
 * <p> 表　題: Class: HadamardTest</p>
 * <p> 説　明: アダマール・テスト</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2024, 2025</p>
 * <p> 作成日: 2024.08.27</p>
 * <p> 作成日: 2025.05.02,更新</p>
 */
public class HadamardTest extends Task {
  
  // 学習・試行制御
  // int epoch = 2; // エポックの回数
  // int interval = 1; //10; // 経過表示間隔
  
  // 量子計算パラメータ
  // int delta = 30; // 5; //10; //15; // 基底角度の増分（度）

  /**
   * Taskクラスで新しく作られたスレッドから呼び出される
   */
  @Override
  public void runTask() {
    DJ._print("・タスク開始日時：", TimeStamp.getTimeFormated());
    beginTime = System.currentTimeMillis(); // タスク開始時刻
    
    // パターン・ビューワ・ランチャを得る
    //  patternViewerFlag = true; //true; // false:非表示
    //  patternData0 = new double[5][dataNum]; // 附番,
    //  patternData1 = new double[5][dataNum]; // ID,
    //  patternViewerLauncher = DJ.pattern(  // 判定パターン、データ、タイトル
    //      PatternViewer.PATTERN_TUNER, patternData0, "HadamardTest",
    //      PatternViewer.PATTERN_TUNER, patternData1, "HadamardTest");
    
    this.stepMode = true; // タスクのステップ実行モード
    
    hadamardTest(); // タスク本体の呼び出し
  }
  
  /** 
   * アダマール・テスト
   */
  public void hadamardTest() {
    DJ._print("HadamardTest.hadamardTest() ========================");
    DJ.print("(1)アダマール・テスト Hadamard test");
    DJ.print("(2)ユニタリ行列の固有ベクトルと固有値");
    DJ.print("(3)ユニタリ行列にZゲートを使用");
    DJ.print("(4)ユニタリ行列にXゲートを使用");
    DJ.print("(5)非固有ベクトルの場合");
        
    // this.stepMode = true; // タスクのステップ実行モードON
    DJ.printS(2, "HadamardTest(1)", this); // Pause Task ------------------
    DJ._print("Code(1)アダマール・テスト Hadamard test");
    DJ.print("・ユニタリ行列を入力量子ビットに作用させ、\n"
           + "　固有値や期待値を推定するアルゴリズムです。");
    
    DJ._print("・アダマール・テストの量子回路\n"
      + "補助量子ビット ┌-┐  ┌-┐  ┌-┐  ┌-┐ \n"
      + "qb0 = [1 0]' ─┤H├─┤C├─┤H├─┤M│ \n"
      + "入力量子ビット ├-┤  ├|┤  ├-┤  └-┘ \n"
      + "qb1 = f  ───┤I├─┤U├─┤I├──    \n"
      + "               └-┘  └-┘  └-┘        \n"
      + "全量子状態  qbf0   qbf1   qbf2   qbf3     ");
    
    DJ._print("・入力状態fがユニタリ行列Uの固有ベクトルのときは、\n"
           + "　対応する固有値v=exp(2πiθ)が推定できます。");

    
    DJ.printS(1, "HadamardTest(1-1)", this); // Pause Task ------------
    DJ._print("Code(1-1)１量子ビットの標準量子ビットe0QBを生成");
    QuBit e0QB = new QuBit(QuBit.STD0_QUBIT);
    DJ.printF("e0QB", e0QB);
    // e0QB:F
    // ┌     ┐
    // │ 1+0i│= [1 0]'
    // │ 0+0i│
    // └     ┘
    
    DJ.print("・補助量子ビットqb0に標準量子ビットe0QBをコピーします。");
    QuBit qb0 = new QuBit(e0QB);
    DJ.printF("qb0", qb0); // 補助量子ビット
    // qb0:F
    // ┌     ┐
    // │ 1+0i│= [1 0]'
    // │ 0+0i│
    // └     ┘
    
    DJ.printS(1, "HadamardTest(1-2)", this); // Pause Task --------------
    DJ.print("Code(1-2)Iゲート（恒等ゲート）を生成");
    QuGate iGate = new QuGate(QuGate.I_GATE);
    DJ.printF("iGate", iGate); // Ｉゲート
    // iGate:F
    // ┌            ┐  ┌      ┐
    // │ 1+0i   0+0i│= │ 1   0│
    // │ 0+0i   1+0i│  │ 0   1│
    // └            ┘  └      ┘
    
    DJ.print("Code(1-3)Hゲート（Hadamardゲート）を生成\n"
    +"          ┌      ┐ \n"
    +" H = 1/√2│ 1   1│ \n"
    +"          │ 1  -1│ \n"
    +"          └      ┘ ");
    QuGate hQuGate = new QuGate(QuGate.H_GATE);
    DJ.printF("hQuGate", hQuGate); // Hゲート
    // hGate:F
    // ┌                        ┐
    // │ 0.70711+0i   0.70711+0i│
    // │ 0.70711+0i  -0.70711+0i│
    // └                        ┘
    
    DJ.printS(1, "HadamardTest(1-4)", this); // Pause Task --------------
    DJ._print("Code(1-4)HIゲートを生成");
    DJ._print("・HゲートとIゲートを相互作用させ、"
            + "２量子ゲートを生成します。");
    DJ.print("HIゲート:H⊗I \n"
    +"            ┌     ┐ \n"
    +" H⊗I = 1/√2│ I  I│ \n"
    +"            │ I -I│ \n"
    +"            └     ┘ ");
    QuGate hiQuGate = hQuGate.interactQuGate(iGate);
    DJ.printF("hiQuGate", hiQuGate); // HIゲート
    // hiQuGate:F
    // ┌                                                  ┐
    // │ 0.70711+0i   0+0i         0.70711+0i   0+0i      │
    // │ 0+0i         0.70711+0i   0+0i         0.70711+0i│
    // │ 0.70711+0i   0+0i        -0.70711+0i   -0+0i     │
    // │ 0+0i         0.70711+0i   -0+0i       -0.70711+0i│
    // └                                                  ┘
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(1, "HadamardTest(2)", this); // Pause Task --------------
    DJ._print("Code(2)ユニタリ行列の固有値と固有ベクトル");
    DJ._print("Code(2-1)Zゲートを生成");
    QuGate zQuGate = new QuGate(QuGate.Z_GATE);
    DJ.printF(",  zQuGate = r0Gate", zQuGate);
    //  zQuGate:F
    //  ┌            ┐ ┌      ┐
    //  │ 1+0i   0+0i│=│ 1  0 │
    //  │ 0+0i  -1+0i│ │ 0 -1 │
    //  └            ┘ └      ┘
    
    DJ._print("・R0ゲートを生成");
    DJ.print("  Zゲートは位相回転ゲートR0(Rk,k=0)と同じです。");
    DJ.print("     ┌                      ┐ \n"
           + " Rk =│ 1   0                │ \n"
           + "     │ 0   exp(i2π/2^(k+1))│ \n"
           + "     └                      ┘ ");
    int k = 0; // インデックス
    DJ.print_("k = ", k);
    QuGate r0QuGate = new QuGate(QuGate.RK_GATE, k);
    DJ.printF(",  r0QuGate", r0QuGate);
    //  k = 0,  r0QuGate = r0QuGate:F
    //  ┌            ┐
    //  │ 1+0i   0+0i│ // R0ゲート
    //  │ 0+0i  -1+0i│
    //  └            ┘
    // exp(i2π/2^(k+1)) = exp(i2π/2^1) = cos(π) + isin(π) = -1+0i
    
    
    DJ.printS(1, "HadamardTest(2-2)", this); // Pause Task --------------
    DJ._print("Code(2-2)Zゲートの固有値と固有ベクトル");
    DJ.print("  Zゲートの固有値はv0=+1とv1=-1で\n、"
           + "  固有ベクトルはf0=[1 0]'とf1=[0 1]'です。Zf = vf");
    
    DJ._print("・Zゲートの固有ベクトルf0=[1 0]'を適用します。\n"
            + "  z・f = +1・e0 = +1[1 0]'");
    QuBit z_e0QB = zQuGate.apply(e0QB);
    DJ.printF("z_e0QB", z_e0QB);
    //  z_e0QB:F 
    //  ┌     ┐     ┌ ┐
    //  │ 1+0i│= +1(│1│)
    //  │ 0+0i│     │0│
    //  └     ┘     └ ┘
    DJ.print("・固有値と固有ベクトルの関係を満たしています。");
    
    DJ._print("・Zゲートの固有ベクトルf1=[0 1]'を適用します。\n"
            + "  z・f = -1・e1 = -1[0 1]'");
    QuBit e1QB = new QuBit(QuBit.STD1_QUBIT);
    QuBit z_e10QB = zQuGate.apply(e1QB);
    DJ.printF("z_e10QB", z_e10QB);
    //  z_e10QB:F 
    //  ┌     ┐     ┌ ┐
    //  │ 0+0i│= -1(│0│)
    //  │-1+0i│     │1│
    //  └     ┘     └ ┘
    DJ.print("・固有値と固有ベクトルの関係を満たしています。");
    
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "HadamardTest(3)", this); // Pause Task --------------
    DJ._print("Code(3)ユニタリ行列にZゲートを使用");
    
    DJ._print("Code(3-1)入力量子ビットに固有ベクトルを設定");
    DJ.print("・Zゲートの固有ベクトル[1 0]を"
            + "入力量子ビットfにコピーします。");
    QuBit f = new QuBit(e0QB);
    DJ.printF("f", f); // 入力量子ビットf
    //  f:F 
    //  ┌     ┐
    //  │ 1+0i│
    //  │ 0+0i│
    //  └     ┘
    
    DJ._print("・補助量子ビットqb0と入力量子ビットfを\n"
            + "  相互作用させ、２量子ビットqbf0にします。");
    QuBit qbf0 = qb0.interactQuBit(f);
    DJ.printF("qbf0", qbf0);
    //  qbf0:F 
    //  ┌     ┐ ┌ ┐ ┌ ┐
    //  │ 1+0i│=│1│⊗│1│
    //  │ 0+0i│ │0│ │0│
    //  │ 0+0i│ └ ┘ └ ┘
    //  │ 0+0i│
    //  └     ┘

    
    DJ.printS(1, "HadamardTest(3-2)", this); // Pause Task --------------
    DJ._print("Code(3-2)初期量子状態をHIゲートに適用");
    DJ.print("・２量子ビットqbf0を量子ゲートhiGateに適用し、\n"
           + "  量子ビット状態qbf1を求めます。");
    QuBit qbf1 = hiQuGate.apply(qbf0);
    DJ.printF("qbf1", qbf1);
    // qbf1:F 
    //  ┌           ┐        ┌ ┐ ┌ ┐   ┌ ┐
    //  │ 0.70711+0i│= 1/√2(│1│+│0│) ⊗│1│
    //  │ 0+0i      │        │0│ │1│   │0│
    //  │ 0.70711+0i│        └ ┘ └ ┘   └ ┘
    //  │ 0+0i      │
    //  └           ┘
    
    
    DJ.printS(1, "HadamardTest(3-3)", this); // Pause Task --------------
    DJ._print("Code(3-3)コントロールZゲート（C-Rkゲート）を生成");
    DJ.print("・C-Rkゲートの生成では、量子ビット数、\n"
        + "  ターゲット量子ビット、制御量子ビット配列、\n"
        + "  および位相パラメータk=0を指定します。");
    int numOfBits = 2; // 量子ビット数
    int target = 1; // ターゲット量子ビットのインデックス
    DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
    int[] controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 0; // 制御量子ビットのインデックス
    k = 0; // 位相パラメータ
    DJ.print(", controlArray", controlArray);
    DJ.print("QuGate cU0Gate = QuGate.makeCUkQuGate("
           + "numOfBits, target, controlArray, k);");
    QuGate cR0Gate = QuGate.makeCRkQuGate(
        numOfBits, target, controlArray, k);
    DJ.printF("cR0Gate", cR0Gate); // C-Rkゲート
    // cR0Gate:F
    // ┌                          ┐ ┌           ┐ 
    // │ 1+0i   0+0i   0+0i   0+0i│=│ 1  0  0  0│
    // │ 0+0i   1+0i   0+0i   0+0i│ │ 0  1  0  0│
    // │ 0+0i   0+0i   1+0i   0+0i│ │ 0  0  1  0│
    // │ 0+0i   0+0i   0+0i  -1+0i│ │ 0  0  0 -1│ 
    // └                          ┘ └           ┘ 
    
    
    DJ.printS(1, "HadamardTest(3-4)", this); // Pause Task --------------
    DJ._print("Code(3-4)コントロールZゲートを適用");
    DJ.print("・２量子ビットqbf1を量子ゲートcR0Gateに適用し、\n"
           + "  量子ビット状態qbf2を求めます。");
    QuBit qbf2 = cR0Gate.apply(qbf1);
    DJ.printF("qbf2", qbf2);
    // qbf2:F 
    //  ┌           ┐        ┌ ┐ ┌ ┐   ┌ ┐
    //  │ 0.70711+0i│= 1/√2(│1│+│0│) ⊗│1│
    //  │ 0+0i      │        │0│ │1│   │0│
    //  │ 0.70711+0i│        └ ┘ └ ┘   └ ┘
    //  │ 0+0i      │
    //  └           ┘
    
    
    DJ.print("・量子ビット状態qbf2を量子ゲートhiGateに適用し、\n"
           + "  量子ビット状態qbf3を求めます。");
    QuBit qbf3 = hiQuGate.apply(qbf2);
    DJ.printF("qbf3", qbf3);
    //  qbf3:F 
    // ┌     ┐ ┌ ┐ ┌ ┐
    // │ 1+0i│=│1│⊗│1│
    // │ 0+0i│ │0│ │0│
    // │ 0+0i│ └ ┘ └ ┘
    // │ 0+0i│
    // └     ┘
    DJ._print("・補助量子ビットは[1 0]'になり、\n"
            + "　固有ベクトルf=[1 0]'が得られます。\n"
            + "  量子状態fは[1 0]'で変化しません。");
    
    
    DJ.printS(1, "HadamardTest(3-5)", this); // Pause Task --------------
    DJ._print("Code(3-5)量子ビット状態qbf3の測定");
    DJ.print("・量子ビット状態qbf3の遷移確率を求めます。");
    double[][] result = qbf3.getTransProb();
    DJ.printF("result", result);
    //  result=
    //  [[1, 1]←[1 0]'への遷移確率
    //  [0, 0] ←[0 1]'への遷移確率
    //  ]↑ ↑         
    //   │ └ 第１量子ビットの遷移確率
    //   └ 第０量子ビットの遷移確率
    
    DJ._print("・遷移確率P0, P1は各々の確率振幅の自乗です。\n"
            + "  P0 = 1^2 = 1 "
            + "  P1 = 0^2 = 0 ");
    
    DJ._print("・確率p0=(1+cosλ)/2、p0=1より、"
            + "cosλ=2p0-1=1、 ∴  λ=0, 2πとなり、\n"
            + "　固有値exp(iλ)=+1が導かれます。 ");

    DJ._print("・確率p1=(1-cosλ)/2、p1=0より、"
            + "cosλ=-2p1+1=1、 ∴  λ=0, 2πとなり、\n"
            + "　固有値exp(iλ)=1が導かれます。 ");
    
    DJ._print("・確率P0と確率P1は、それぞれ次式で与えられます。\n"
            + "  P0 = 1/2(1 + Re(f'Uf) = 1 "
            + "  ∴　期待値f'Uf = 2 P0 - 1 = 1"
            + "  P1 = 1/2(1 - Re(f'Uf) = 0 \n"
            + "  ∴　期待値f'Uf = -2 P1 + 1 = 1 \n"
            + "  記号'は共役転置を意味する。");
    
    DJ._print("・固有値v=-1、固有ベクトルf=[0 1]'の場合は、\n"
            + "  P0=0, P1=1 で、期待値f'Uf=-1 になります。");
    
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "HadamardTest(4)", this); // Pause Task --------------
    DJ._print("Code(4)対象ユニタリ行列にXゲートを使用");
    
    DJ._print("・アダマール・テストの量子回路\n"
      + "補助量子ビット ┌-┐  ┌-┐  ┌-┐  ┌-┐ \n"
      + "qb0 = [1 0]' ─┤H├─┤C├─┤H├─┤M│ \n"
      + "入力量子ビット ├-┤  ├|┤  ├-┤  └-┘ \n"
      + "qb1 = f  ───┤I├─┤X├─┤I├──    \n"
      + "               └-┘  └-┘  └-┘        \n"
      + "全量子状態  qbf0   qbf1   qbf2   qbf3     ");
    
    
    DJ._print("Code(4-1)Xゲートを生成");
    QuGate xQuGate = new QuGate(QuGate.X_GATE);
    DJ.printF("xQuGate", xQuGate);
    //  xQuGate:F
    //  ┌            ┐ ┌     ┐
    //  │ 0+0i   1+0i│=│ 0  1│
    //  │ 1+0i   0+0i│ │ 1  0│
    //  └            ┘ └     ┘
    
    DJ.printS(1, "HadamardTest(4-2)", this); // Pause Task --------------
    DJ._print("Code(4-2)Xゲートの固有値と固有ベクトル");
    DJ.print("・Xゲートの固有値vは+1と-1で、固有ベクトルfは"
           + "  (1/√(2))[1 1]'と(1/√(2))[1 -1]'です。\n"
           + "  X f = v f");
    
    DJ._print("・固有ベクトルf0を生成します。");
    QuBit f0 = hQuGate.apply(e0QB); // +(1/√(2))[1 1]'
    DJ.printF("f0", f0); // 固有ベクトルf0
    //  f0:F 
    //  ┌           ┐          ┌ ┐ ┌ ┐
    //  │ 0.70711+0i│= 1/√(2)(│1│+│0│)
    //  │ 0.70711+0i│          │0│ │1│
    //  └           ┘          └ ┘ └ ┘
    
    DJ._print("・Xゲートに固有ベクトルf0を適用します。\n"
            + "  x f0 = +1 f0 = (1/√(2)([1 0]'+[0 1]')");
    QuBit x_f0QB = xQuGate.apply(f0);
    DJ.printF("x_f0QB", x_f0QB);
    //  x_f0QB:F 
    //  ┌           ┐             ┌ ┐ ┌ ┐
    //  │ 0.70711+0i│= +1(1/√(2)(│1│+│0│))
    //  │ 0.70711+0i│             │0│ │1│
    //  └           ┘             └ ┘ └ ┘
    DJ.print("・固有値と固有ベクトルの関係を満たしています。");
    
   
    DJ.printS(1, "HadamardTest(4-3)", this); // Pause Task --------------
    DJ._print("Code(4-3)Xゲートの固有値と固有ベクトル");
    DJ._print("・固有ベクトルf1=(1/√(2))[1 -1]'を生成します。");
    QuBit f1 = new QuBit(f0);
    int pa1Id = QuBit.PA1; // 第１確率振幅インデックス
    Complex pa1 = f1.copyProbAmp(pa1Id);
    pa1.mul(-1.0);
    f1.setProbAmp(pa1Id, pa1); // (1/√(2))[1 -1]'
    DJ.printF("f1", f1); // 固有ベクトルf1
    //  f1:F 
    //  ┌           ┐          ┌ ┐ ┌ ┐
    //  │ 0.70711+0i│= 1/√(2)(│1│-│0│)
    //  │-0.70711+0i│          │0│ │1│
    //  └           ┘          └ ┘ └ ┘

    DJ._print("・Xゲートに固有ベクトルf1を適用します。\n"
            + "  x f1 = -(1/√(2)([1 0]'-[0 1]' = -1 f1)");
    QuBit x_f1QB = xQuGate.apply(f1);
    DJ.printF("x_f1QB", x_f1QB);
    //  x_f1QB:F 
    //  ┌           ┐             ┌ ┐ ┌ ┐
    //  │-0.70711+0i│= -1(1/√(2)(│1│-│0│))
    //  │ 0.70711+0i│             │0│ │1│
    //  └           ┘             └ ┘ └ ┘
    DJ.print("・固有値と固有ベクトルの関係を満たしています。");
    
    
    DJ.printS(1, "HadamardTest(4-4)", this); // Pause Task --------------
    DJ.print("Code(4-4)入力量子ビットに固有ベクトルを設定");
    DJ._print("・補助量子ビットqb0とXゲートの固有ベクトルf0を\n"
            + "  相互作用させ、２量子ビットqbf0にします。");
    qbf0 = qb0.interactQuBit(f0); // [1 0]'と+(1/√(2))[1 1]'
    DJ.printF("qbf0", qbf0);
    //  qbf0:F 
    //  ┌           ┐           ┌ ┐   ┌ ┐ ┌ ┐
    //  │ 0.70711+0i│=+(1/√(2))│1│⊗ (│1│+│0│)
    //  │ 0.70711+0i│           │0│   │0│ │1│
    //  │ 0+0i      │           └ ┘   └ ┘ └ ┘
    //  │ 0+0i      │
    //  └           ┘

    DJ._print("Code(4-5)量子ビット状態をHゲートに適用");
    DJ._print("・２量子ビットqbf0を量子ゲートhiGateに適用し、\n"
           + "  量子ビット状態qbf1を求めます。");
    qbf1 = hiQuGate.apply(qbf0);
    DJ.printF("qbf1", qbf1);
    // qbf1:F 
    //  ┌       ┐      ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐
    //  │ 0.5+0i│= 1/2(│1│⊗│1│+│1│⊗│0│+│0│⊗│1│+│0│⊗│0│)
    //  │ 0.5+0i│      │0│ │0│ │0│ │1│ │1│ │0│ │1│ │1│
    //  │ 0.5+0i│      └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘
    //  │ 0.5+0i│
    //  └       ┘
    
    DJ.printS(1, "HadamardTest(4-6)", this); // Pause Task --------------
    DJ._print("Code(4-6)コントロールXゲート（C-Xゲート）を生成");
    DJ.print("  C-Xゲートの生成では、量子ゲート名、量子ビット数、\n"
       + "　ターゲット量子ビット、制御量子ビット配列を指定します。");
    numOfBits = 2; // 量子ビット数
    target = 1; // ターゲット量子ビットのインデックス
    DJ.print_("numOfBits = " + numOfBits + ", target = " + target);
    controlArray = new int[1]; // 制御量子ビット配列
    controlArray[0] = 0; // 制御量子ビットのインデックス
    DJ.print(", controlArray", controlArray);
    DJ.print("QuGate cU0Gate = new QuGate("
           + "numOfBits, target, controlArray);");
    QuGate cxGate = new QuGate( 
            QuGate.CX_GATE,numOfBits, target, controlArray);
    DJ.printF("cxGate", cxGate); // CXゲート
    // cxGate:F
    // ┌                          ┐ ┌           ┐ ┌      ┐
    // │ 1+0i   0+0i   0+0i   0+0i│=│ 1  0  0  0│=│ I  0 │
    // │ 0+0i   1+0i   0+0i   0+0i│ │ 0  1  0  0│ │ 0  X │
    // │ 0+0i   0+0i   0+0i   1+0i│ │ 0  0  0  1│ └      ┘
    // │ 0+0i   0+0i   1+0i   0+0i│ │ 0  0  1  0│ 
    // └                          ┘ └           ┘ 
    
    
    DJ.printS(1, "HadamardTest(4-7)", this); // Pause Task --------------
    DJ._print("Code(4-7)コントロールXゲートを適用");
    DJ.print("・２量子ビットqbf1を量子ゲートcx0Gateに適用し、\n"
           + "  量子ビット状態qbf2を求めます。");
    qbf2 = cxGate.apply(qbf1);
    DJ.printF("qbf2", qbf2);
    // qbf2:F 
    //  ┌       ┐      ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐
    //  │ 0.5+0i│= 1/2(│1│⊗│1│+│1│⊗│0│+│0│⊗│1│+│0│⊗│0│)
    //  │ 0.5+0i│      │0│ │0│ │0│ │1│ │1│ │0│ │1│ │1│
    //  │ 0.5+0i│      └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘
    //  │ 0.5+0i│
    //  └       ┘
    
    DJ.print("・量子ビット状態qbf2を量子ゲートhiGateに適用し、\n"
           + "  量子ビット状態qbf3を求めます。");
    qbf3 = hiQuGate.apply(qbf2);
    DJ.printF("qbf3", qbf3);
    //  qbf3:F
    //  ┌           ┐       ┌ ┐  ┌ ┐ ┌ ┐ 
    //  │ 0.70711+0i│= 1/√2│1│⊗(│1│+│0│)
    //  │ 0.70711+0i│       │0│  │0│ │1│ 
    //  │ 0+0i      │       └ ┘  └ ┘ └ ┘ 
    //  │ 0+0i      │
    //  └           ┘
    
    DJ._print("・補助量子ビットは[1 0]'になり、\n"
            + "　固有ベクトルf=[1 0]'が得られます。\n"
            + "  量子状態fは(1/√(2))[1 1]'で変化しません。");
    
    DJ.printS(1, "HadamardTest(4-8)", this); // Pause Task --------------
    DJ._print("Code(4-8)量子ビット状態qbf3の測定");
    DJ.print("・量子ビット状態qbf3の遷移確率を求めます。");
    result = qbf3.getTransProb();
    DJ.printF("result", result);
    //  result=
    //  [[1, 0.5]←[1 0]'への遷移確率
    //  [0, 0.5] ←[0 1]'への遷移確率
    //  ]↑  ↑         
    //   │  └ 第１量子ビットの遷移確率
    //   └ 第０量子ビットの遷移確率
    
    DJ._print("・遷移確率P0, P1は各々の確率振幅の自乗です。\n"
            + "  P0 = 1^2 = 1 "
            + "  P1 = 0^2 = 0 ");
    
    DJ._print("・確率P0と確率P1は、それぞれ次式で与えられます。\n"
            + "  P0 = 1/2(1 + Re(f'Uf))=1 ∴　期待値f'Uf=1 \n"
            + "  P1 = 1/2(1 - Re(f'Uf))=0 ∴　期待値f'Uf=1 \n"
            + "  記号'は共役転置を意味します。");
    
    
    
    DJ.printS(2, "HadamardTest(4-9)", this); // Pause Task --------------
    DJ.print("Code(4-9)Xゲートで固有ベクトルf1の場合");
    DJ.print("・補助量子ビットqb0とXゲートの固有ベクトルf1を\n"
            + "  相互作用させ、２量子ビットqbf0にします。");
    qbf0 = qb0.interactQuBit(f1); // [1 0]'と+(1/√(2))[1 -1]'
    DJ.printF("qbf0", qbf0);
    //  qbf0:F 
    //  ┌           ┐           ┌ ┐   ┌ ┐ ┌ ┐
    //  │ 0.70711+0i│=+(1/√(2))│1│⊗ (│1│-│0│)
    //  │-0.70711+0i│           │0│   │0│ │1│
    //  │ 0+0i      │           └ ┘   └ ┘ └ ┘
    //  │ 0+0i      │
    //  └           ┘
    
    DJ._print("・２量子ビットqbf0を量子ゲートhiGateに適用し、\n"
           + "  量子ビット状態qbf1を求めます。");
    qbf1 = hiQuGate.apply(qbf0);
    DJ.printF("qbf1", qbf1);
    // qbf1:F 
    //  ┌       ┐      ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐
    //  │ 0.5+0i│= 1/2(│1│⊗│1│-│1│⊗│0│+│0│⊗│1│-│0│⊗│0│)
    //  │-0.5+0i│      │0│ │0│ │0│ │1│ │1│ │0│ │1│ │1│
    //  │ 0.5+0i│      └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘
    //  │-0.5+0i│
    //  └       ┘
    
    DJ.print("・２量子ビットqbf1を量子ゲートcx0Gateに適用し、\n"
           + "  量子ビット状態qbf2を求めます。");
    qbf2 = cxGate.apply(qbf1);
    DJ.printF("qbf2", qbf2);
    // qbf2:F 
    //  ┌       ┐      ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐ ┌ ┐
    //  │ 0.5+0i│= 1/2(│1│⊗│1│-│1│⊗│0│-│0│⊗│1│+│0│⊗│0│)
    //  │-0.5+0i│      │0│ │0│ │0│ │1│ │1│ │0│ │1│ │1│
    //  │-0.5+0i│      └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘ └ ┘
    //  │ 0.5+0i│
    //  └       ┘
    
    DJ.print("・量子ビット状態qbf2を量子ゲートhiGateに適用し、\n"
           + "  量子ビット状態qbf3を求めます。");
    qbf3 = hiQuGate.apply(qbf2);
    DJ.printF("qbf3", qbf3);
    //  qbf3:F
    //  ┌           ┐       ┌ ┐  ┌ ┐ ┌ ┐ 
    //  │ 0+0i      │= 1/√2│0│⊗(│1│-│0│)
    //  │ 0+0i      │       │1│  │0│ │1│ 
    //  │ 0.70711+0i│       └ ┘  └ ┘ └ ┘ 
    //  │-0.70711+0i│
    //  └           ┘
    
    DJ.print("・量子ビット状態qbf3の遷移確率を求めます。");
    result = qbf3.getTransProb();
    DJ.printF("result", result);
    //  result=
    //  [[0, 0.5]←[1 0]'への遷移確率
    //  [1, 0.5] ←[0 1]'への遷移確率
    //  ]↑  ↑         
    //   │  └ 第１量子ビットの遷移確率
    //   └ 第０量子ビットの遷移確率
    
    DJ._print("・遷移確率P0, P1は各々の確率振幅の自乗です。\n"
            + "  P0 = 0^2 = 0 "
            + "  P1 = 1^2 = 1 ");
    
    DJ._print("・確率P0と確率P1は、それぞれ次式で与えられます。\n"
            + "  P0 = 1/2(1 + Re(f'Uf))=0 ∴　期待値f'Uf=-1 \n"
            + "  P1 = 1/2(1 - Re(f'Uf))=1 ∴　期待値f'Uf=-1 \n"
            + "  記号'は共役転置を意味します。");



    this.stepMode = true; // タスクのステップ実行モードON
    DJ.printS(3, "HadamardTest(5)", this); // Pause Task --------------
    DJ._print("Code(5)非固有ベクトルの場合");
    DJ.print("・ユニタリ行列にXゲート、入力量子ビットfに\n"
           + "  非固有ベクトルを使い、期待値f'Ufを求めます。");
    
    DJ._print("Code(5-1)入力量子ビットf0を角度θ=π/6で設定");
    double theta = Math.PI / 6.0; // 30度
    f0 = QuBit.rotateRadianQuBit(theta); // f0 = [√(3/2)  1/2]'
    DJ.printF("f0", f0);
    // f0:F 
    // ┌           ┐        ┌  ┐      ┌  ┐
    // │ 0.86603+0i│ = √3/2│ 1│＋ 1/2│ 0│
    // │ 0.5+0i    │        │ 0│      │ 1│
    // └           ┘        └  ┘      └  ┘
    
    DJ.print("・補助量子ビットqb0に入力量子ビットf0を\n"
           + "  相互作用させ、２量子ビットqbf0を生成します。");
    qbf0 = qb0.interactQuBit(f0); // [1 0]'と(√3/2)[1 0]'＋1/2[0 1]'
    DJ.printF("qbf0", qbf0);
    // qbf0:F
    // ┌           ┐        ┌  ┐      ┌  ┐
    // │ 0.86603+0i│ = √3/2│ 1│＋ 1/2│ 0│)
    // │ 0.5+0i    │        │ 0│      │ 1│
    // │ 0+0i      │        │ 0│      │ 0│
    // │ 0+0i      │        │ 0│      │ 0│
    // └           ┘        └  ┘      └  ┘

    DJ.printS(1, "HadamardTest(5-2)", this); // Pause Task --------------
    DJ.print("Code(5-2)量子ビットqbf0をhiゲートに適用");
    qbf1 = hiQuGate.apply(qbf0);
    DJ.printF("qbf1", qbf1);
    // qbf1:F
    // ┌           ┐             ┌  ┐     ┌  ┐       ┌  ┐     ┌  ┐
    // │ 0.61237+0i│= 1/√2(√3/2│ 1│＋1/2│ 0│＋√3/2│ 0│＋1/2│ 0│)
    // │ 0.35355+0i│             │ 0│     │ 1│       │ 0│     │ 0│
    // │ 0.61237+0i│             │ 0│     │ 0│       │ 1│     │ 0│
    // │ 0.35355+0i│             │ 0│     │ 0│       │ 0│     │ 1│
    // └           ┘             └  ┘     └  ┘       └  ┘     └  ┘
   

    DJ._print("・量子ビットqbf1をC-Xゲートに適用します。");
    qbf2 = cxGate.apply(qbf1);
    DJ.printF("qbf2", qbf2);
    // qbf2:F 
    // ┌           ┐             ┌ ┐ ┌ ┐      ┌ ┐ ┌ ┐
    // │ 0.61237+0i│= 1/√2(√3/2│1│⊗│1│ + 1/2│1│⊗│0│
    // │ 0.35355+0i│             │0│ │0│      │0│ │1│
    // │ 0.35355+0i│             └ ┘ └ ┘      └ ┘ └ ┘
    // │ 0.61237+0i│             ┌ ┐ ┌ ┐      ┌ ┐ ┌ ┐
    // └           ┘         +1/2│0│⊗│1│+√3/2│0│⊗│0│)
    //                             │1│ │0│      │1│ │1│
    //                             └ ┘ └ ┘      └ ┘ └ ┘

    
    DJ.printS(1, "HadamardTest(5-3)", this); // Pause Task --------------
    DJ.print("Code(5-3)量子ビットqbf2をhiゲートに適用");
    qbf3 = hiQuGate.apply(qbf2);
    DJ.printF("qbf3", qbf3);
    // qbf3:F 
    // ┌           ┐                 ┌ ┐  ┌ ┐            ┌ ┐ ┌ ┐
    // │ 0.68301+0i│= 1/2{(√3/2+1/2)│1│⊗ │1│+(1/2+√3/2)│1│⊗│0│
    // │ 0.68301+0i│                 │0│  │0│            │0│ │1│
    // │ 0.18301+0i│                 └ ┘  └ ┘            └ ┘ └ ┘
    // │-0.18301+0i│                 ┌ ┐ ┌ ┐             ┌ ┐ ┌ ┐
    // └           ┘     +(√3/2-1/2)│0│⊗│1│+(-√3/2+1/2)│0│⊗│0│}
    //                                 │1│ │0│             │1│ │1│
    //                                 └ ┘ └ ┘             └ ┘ └ ┘
    DJ._print("・得られた２量子ビットはもつれているため、\n"
            + "  分離することはできません。測定して、\n"
            + "　[1 0 0 0]'か[0 1 0 0]'が得られる確率P0と、\n"
            + "　[0 0 1 0]'か[0 0 0 1]が得られる確率P1は、\n"
            + "  それぞれ以下のようになります。");
    
    
    DJ._print("　量子ビットごとの遷移確率を収集します。");
    result = qbf3.getTransProb();
    DJ.printF("result", result);
    //  result=
    //  [[0.93301, 0.5]←[1 0]'への遷移確率
    //  [0.06699, 0.5] ←[0 1]'への遷移確率
    //  ]  ↑     ↑         
    //     │     └ 第１量子ビットの遷移確率
    //     └ 第０量子ビットの遷移確率
    
    DJ._print("・遷移確率P0, P1は各々の確率振幅の自乗です。\n"
        + "P0 = 0.68301^2 * 2 = 0.93303 \n"
        + "P1 = 0.18301^2 * 2 = 0.06698 ");
    
    DJ._print("・よって確率P0と確率P1は、それぞれ次式で与えられます。\n"
            + "P0 = 1/2(1 + Re(f'Uf) = 0.93303 \n"
            + "  ∴　期待値f'Uf = 2 P0 - 1 = 0.86603\n"
            + "P1 = 1/2(1 - Re(f'Uf) = 0.06698 \n"
            + "  ∴　期待値f'Uf = -2 P1 + 1 = 0.86603 \n "
            + "  記号'は共役転置を意味します。");
    //                   ┌   ┐┌     ┐
    // f'Uf = [√3/2 1/2]│0 1││√3/2│= √3/2 = 0.86603 
    //                   │1 0││ 1/2 │
    //                   └   ┘└     ┘
    
    
    this.stepMode = true; // タスクのステップ実行モード
    DJ._print("##### HadamardTestの処理を終了します　#####");
  } // hadamardTest()

} // HadamardTest Class

// End of file
