/*
 *  Title: DaiJa_V5 (Digital-learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 5.0
 *  @since 2022.8.18
 *  Copyright: 2020 - 2025
 */
package task.qu;

import quan.QuBit;
import quan.QuBasis;
import task.Task;
import util.comp.Complex;
import util.DJ;
import util.TimeStamp;
import util.comp.CompMat;
import util.comp.CompVec;
//import view.PatternViewer;

/**
 * <p> 表　題: Class: Polarization</p>
 * <p> 説　明: 偏光</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2025</p>
 * <p> 作成日: 2025.01.05</p>
 */
public class Polarization extends Task {
  
  // パラメータ
  int epoch = 6; // エポックの回数
  int interval = 1; //10; // 経過表示間隔

  /**
   * Taskクラスで新しく作られたスレッドから呼び出される
   */
  @Override
  public void runTask() {
    DJ._print("・タスク開始日時：", TimeStamp.getTimeFormated());
    beginTime = System.currentTimeMillis(); // タスク開始時刻
    
    // パターン・ビューワ・ランチャを得る
    // patternViewerFlag = true; //true; // false:非表示
    // patternData0 = new double[5][dataNum]; // ID,
    // patternData1 = new double[5][dataNum]; // ID,
    // patternViewerLauncher = DJ.pattern(  // パターン、データ、タイトル
    //     PatternViewer.PATTERN_TUNER, patternData0, "Polarization",
    //     PatternViewer.PATTERN_TUNER, patternData1, "Polarization");

    this.stepMode = true; // タスクのステップ実行モード
    
    polarization(); // タスク本体の呼び出し
  }
  
  /** 
   * 偏光板による測定
   */
  public void polarization() {
    DJ._print("Polarization.polarization() ========================");
    
    DJ._print("■偏光板による測定の考察");
    
    DJ.print("(1)１枚の偏光板による測定");
    DJ.print("(1-1)-π/4に偏光したPCモニタ画面の量子ビット");
    DJ.print("(1-2)-π/4回転したブラック偏光板を画面の前に置く");
    DJ.print("(1-3)①ブラック偏光板の吸収軸と透過軸");
    DJ.print("(1-3)②モニタ光子の吸収軸方向と透過軸方向の成分");
    DJ.print("(1-3)③吸収軸方向と透過軸方向に遷移する確率");
    DJ.print("(1-4)ブラック偏光板によるモニタ光子の"
           + "吸収軸方向と透過軸方向の遷移確率");
    
    DJ._print("(2)２枚の偏光板による測定");
    DJ.print("(2-1)モニタ画面とブラック偏光板との間に"
           + "ブラウン偏光板を水平（角度０）に差し込む");
    DJ.print("(2-2)基底brownBasisでモニタ光子を測定");
    DJ.print("(2-3)ブラウン偏光板で偏光されたモニタ光子は、"
            + "ブラウン偏光板の透過軸方向に遷移");
    DJ.print("(2-4)ブラック偏光板による測定");
    
    
    // this.stepMode = true; // タスクのステップ実行モードON
    DJ.printS(2, "Polarization(1)", this); // Pause Task --------------------
    DJ.print("Code(1)１枚の偏光板による測定");
    
    DJ._print("Code(1-1)-π/4に偏光したPCモニタ画面の量子ビット");
    double pi = Math.PI;
    double theta = -pi / 4.0; // 45[deg] = 0.7853981633974483[rad]
    QuBit monitorQB = new QuBit(theta); 
    DJ.print("monitorQB", monitorQB);
    // monitorQB:[0.7071067811865476+0.0i  -0.7071067811865475+0.0i]
    DJ.printF("monitorQB", monitorQB);
    //  monitorQB:F 
    //  ┌           ┐
    //  │ 0.70711+0i│
    //  │-0.70711+0i│
    //  └           ┘    
    
    DJ.printS(1, "Polarization(1-2)", this); // Pause Task ----------------
    DJ._print("Code(1-2)-π/4回転したブラック偏光板を画面の前に置く");
    
    DJ.print("・座標を-π/4回転する行列m45RotateMatを求めます。");
    double lamda = 0.0;
    double phi = 0.0;
    CompMat m45RotateMat = QuBasis.rotate(theta, lamda, phi);
    DJ.printF("m45RotateMat", m45RotateMat);
    //  m45RotateMat:F
    //  ┌                        ┐
    //  │ 0.70711+0i   0.70711+0i│
    //  │-0.70711+0i   0.70711+0i│
    //  └                        ┘
    
    DJ.print("(・ブラック偏光板の吸収軸と透過軸を求めます。");
    QuBasis blackBasis = new QuBasis(m45RotateMat); // black filter basis
    DJ.printF("blackBasis", blackBasis);
    //  blackBasis:F
    //  ┌                        ┐
    //  │ 0.70711+0i│ 0.70711+0i│
    //  │-0.70711+0i│ 0.70711+0i│
    //  └                        ┘
    DJ.print("・第０列が吸収軸方向、第１列が透過軸方向を表わすベクトルです。");

    
    DJ.printS(1, "Polarization(1-3)", this); // Pause Task ----------------
    DJ.print("Code(1-3)ブラック偏光板によるモニタ光子の状態遷移");
    DJ.print("  モニタ光子の振動方向がブラック偏光板の\n"
            + "　吸収軸と透過軸の方向に遷移する確率を求めます。");
    
    DJ._print("Code(1-3)①ブラック偏光板の吸収軸と透過軸");
    CompVec blackVecA = blackBasis.copyBasisVec(QuBasis.BASIS_0); // 
    DJ.printF("blackVecA", blackVecA);
    //  blackVecA:F 
    //  ┌           ┐
    //  │ 0.70711+0i│
    //  │-0.70711+0i│
    //  └           ┘
    
    CompVec blackVecB = blackBasis.getBasisVec(QuBasis.BASIS_1); // 
    DJ.printF("blackVecB", blackVecB);
    //  blackVecB:F 
    //  ┌           ┐
    //  │ 0.70711+0i│
    //  │ 0.70711+0i│
    //  └           ┘
    
    DJ.printS(1, "Polarization(1-3)②", this); // Pause Task ----------------
    DJ._print("Code(1-3)②モニタ光子の吸収軸方向と透過軸方向の成分");
    Complex blackPAa = blackVecA.innerProduct(monitorQB.getProbAmp());
    DJ.printF("blackPAa", blackPAa);
    // blackPAa:F 1+0i    
    
    Complex blackPAb = blackVecB.innerProduct(monitorQB.getProbAmp());
    DJ.printF("blackPAb", blackPAb);
    // blackPaB:F 0+0i    

    DJ._print("Code(1-3)③吸収軸方向と透過軸方向に遷移する確率");
    double blackPa = blackPAa.square();
    DJ.print("blackPa = ", blackPa);
    // blackPa = 1.0

    double blackPb = blackPAb.square();
    DJ.print("blackPb = ", blackPb);
    // blackPb = 0.0

    
    DJ.printS(1, "Polarization(1-4)", this); // Pause Task ----------------
    DJ._print("Code(1-4)ブラック偏光板によるモニタ光子の\n"
            + "　吸収軸方向と透過軸方向の遷移確率");
    QuBit blackBasisMontorQB = blackBasis.basisChang(monitorQB);
    DJ.printF("blackBasisMontorQB", blackBasisMontorQB); //  [1+0i, 0+0i]
    //  blackBasisMontorQB:F 
    //  ┌     ┐
    //  │ 1+0i│
    //  │ 0+0i│
    //  └     ┘    
    

    this.stepMode = true; // タスクのステップ実行モード
    DJ.printS(2, "Polarization(2)", this); // Pause Task --------------------
    DJ.print("Code(2)２枚の偏光板による測定");
    
    DJ._print("Code(2-1)モニタ画面とブラック偏光板との間に\n"
           + "　ブラウン偏光板を水平（角度０）に差し込む");
    
    DJ._print("・ブラウン偏光板の吸収軸と透過軸を求めます。偏光板は\n"
           + "　水平なので、基底brownBasisの回転角度は０[ラジアン]です。");
    QuBasis brownBasis = new QuBasis(0.0);
    DJ.printF("brownBasis", brownBasis);
    //  brownBasis:F
    //  ┌             ┐ ┌       ┐
    //  │ 1+0i│ -0+0i│=│ 1 │ 0│
    //  │ 0+0i│  1+0i│ │ 0 │ 1│
    //  └             ┘ └       ┘
    DJ.print("(第０列が吸収軸方向、第１列が透過軸方向を表わすベクトルです。");
    
    
    DJ.printS(1, "Polarization(2-2)", this); // Pause Task ----------------
    DJ._print("Code(2-2)基底brownBasisでモニタ光子を測定");
    DJ.print("・モニタ光子の吸収軸方向と透過軸方向の成分を求めます。");
    Complex brownPAa = brownBasis.getBasisVec(QuBasis.BASIS_0)
                          .innerProduct(monitorQB.getProbAmp());
    DJ.printF("brownPAa", brownPAa);
    // brownPAa:F 0.70711+0i    
    
    Complex brownPAb = brownBasis.getBasisVec(QuBasis.BASIS_1)
                         .innerProduct(monitorQB.getProbAmp());
    DJ.printF("brownPAb", brownPAb);
    // brownPAb:F -0.70711+0i    
    
    DJ._print("・モニタ光子の吸収軸方向と透過軸方向の成分を同時に求めます。");
    QuBit brownPA = brownBasis.basisChang(monitorQB);
    DJ.printF("brownPA", brownPA);
    //  brownPA:F 
    //  ┌           ┐
    //  │ 0.70711+0i│
    //  │-0.70711+0i│
    //  └           ┘
    
    DJ._print("　透過軸方向に遷移する確率を求めます。");
    double brownPb = brownPAb.square();
    DJ.printF("brownPb = ", brownPb);
    // brownPb = :F  0.5
    
    
    DJ.printS(1, "Polarization(2-3)", this); // Pause Task ----------------
    DJ._print("Code(2-3)ブラウン偏光板で偏光されたモニタ光子は、\n"
            + "　ブラウン偏光板の透過軸方向に遷移");
    CompVec brownBSbVec = brownBasis.getBasisVec(QuBasis.BASIS_1);
    QuBit brownMeasuredQB = new QuBit(brownBSbVec);
    DJ.printF("brownMeasuredQB", brownMeasuredQB); // [1+0i, -0+0i]
    //  brownMeasuredQB:F 
    //  ┌      ┐ ┌ ┐
    //  │ -0+0i│=│0│
    //  │ 1+0i │ │1│
    //  └      ┘ └ ┘

    
    DJ.printS(1, "Polarization(2-4)", this); // Pause Task ----------------
    DJ.print("Code(2-4)ブラック偏光板による測定");
    DJ.print("  ブラウン偏光板を通過した光子が"
           + "ブラック偏光板に到達します。");
    
    DJ._print("・光子がブラック偏光板を通過する際の、\n"
            + "  吸収軸方向と透過軸方向の成分を求めます。");
    QuBit blackBasisQB = blackBasis.basisChang(brownMeasuredQB);
    DJ.printF("blackBasisQB", blackBasisQB);
    //  blackBasisQB:F 
    //  ┌           ┐
    //  │-0.70711+0i│←吸収軸方向の成分
    //  │ 0.70711+0i│←透過軸方向の成分
    //  └           ┘

    DJ._print("・透過軸方向に遷移する確率を求めます。");
    blackPAb = blackBasisQB.getProbAmp(QuBasis.BASIS_1);
    blackPb = blackPAb.square();
    DJ.printF("blackPb = ", blackPb);
    // blackPb = :F  0.5
    
    
    this.stepMode = true; // タスクのステップ実行モード
    
    DJ._print("##### Polarizationの処理を終了します　#####");
    

    DJ.printS(2, "Polarization(Ending)", this); // Pause Task ----------------
//    // DJ._print("PatternViewerへの参照を得る");
//    patternViewer = patternViewerLauncher.getPatternViewer();

    for (int i = 0; i <= epoch; i++) {
      startTime = System.nanoTime(); // 実行開始時刻
      intervalFlag = (i % interval == interval - 1) | 
              (i == epoch); //経過表示フラグ
      
//      // updateViewer(i);
//      updatePattern(); // パターン表示を更新する

      // 実行時間の累積
      endTime = System.nanoTime(); // 休止時刻
      double lapTime_ = (endTime - startTime) / 1000000.0;
      if (lapTime_ > 0.0) lapTime = lapTime_; // オーバーフロー対策
      totalTime = totalTime + lapTime; // 経過時間を追加

//       // 経過表示インターバル
//      if (intervalFlag) { // 実行時間に影響を与える
//
//          // updateViewer(i);
//          updatePattern(); // パターン表示を更新する
//
//        // スレッドの休止（実行速度の調整および経過表示のため）
//        synchronized(this) {
//          try {
//            // DJ.print("Ｅnter to wait(sleepTime)");
////            wait(SLEEP_TIME); // タイムアウト付きで待機状態
//            wait(100); // タイムアウト付きで待機状態
//            // DJ.print("Resume from wait(sleepTime)");
//            if (pauseFlag) wait(); // 休止状態
//          
//          }
//          catch (InterruptedException e) {
//             DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
//                 + " Exception occur in wait(sleepTime):" + e.toString());
//          }
//        } // synchronized()
//      } // interval
    
      // 実行処理を強制的に終了させる
      if (abortFlag) {
        DJ._print("##### Abort action requested");
        epoch = i; // 現在のエポック回数iをepochに代入し、実行を強制的に終了させる
      }
      
      // DJ._print(" End of one epoch ---------------------------------------");
//      DJ.printS(0, "Polarization", this); // Pause Task
    } // i
    // DJ._print(" End of all epoch -----------------------------------------");
    
    // 処理時間の算出
    DJ._print("・総実行時間：" + (totalTime / 1000.0) + " [sec]");
    double aveTime = totalTime / epoch;
    DJ.print("・平均実行時間：" + aveTime + " [msec/epoch]");
    finishTime = System.currentTimeMillis(); // タスク開始時刻
    DJ.print_("・タスク処理時間：" + 
            ((finishTime - beginTime) / 1000.0) + " [sec]");
    DJ.print(", タスク終了日時：", TimeStamp.getTimeFormated());
    
    
    DJ._print("量子計算の完了");
    DJ.print("Polarization.polarization() ===========================");
//    if (true) return;
    
  } // polarization()
  
} // Polarization Class

// End of file
