/*
 *  Title: DaiJa_V4 (Digital-Learning Aide Instrument by JAva)
 *  @author Yoshinari Sasaki
 *  @version 4.0
 *  @since 2020.7.1
 *  Copyright: 2020, 2021
 */
package view;

import util.DJ;

/**
 * <p> 表　題: Class: GraphViewerLauncher</p>
 * <p> 説　明: GraphViewerを新規スレッドで開始する</p>
 * <p> 著　者: Yoshinari Sasaki</p>
 * <p> 著作権: Copyright (c) 2019, 2020</p>
 * <p> 作成日: 2019.9.10</p>
 */
//public class GraphViewerLauncher implements Runnable {
public class GraphViewerLauncher extends ViewerLauncher {
  
  private GraphViewer graphViewer;
  Thread graphViewerThread;
  
  int epoch; // エポック回数
  int interval; // 経過表示間隔
  String[] dataName; // データ名称
  double[] graphData;
 
  /**
   * 新規スレッドで実行されるGraphViewerを生成する
   * @param epoch int // エポック回数
   * @param interval int // 表示間隔
   * @param dataName String[] // データ名
   * @param graphData double[][] // パターン・データ
   */
  public GraphViewerLauncher(
      int epoch, int interval, String[] dataName, double[] graphData) {
    this.epoch = epoch;
    this.interval = interval;
    this.dataName = dataName;
    this.graphData = graphData;
    // スレッドの生成と開始
    graphViewerThread = new Thread(this); // タスク実行用スレッド
    graphViewerThread.setPriority(Thread.NORM_PRIORITY);
//    graphViewerThread.setPriority(Thread.MAX_PRIORITY);
    startThread();
  }
  
  private void startThread() {
    graphViewerThread.start(); // メソッドrun()を実行
  }
  
  @Override
  public void run() {
    graphViewer = new GraphViewer(epoch, interval, dataName, graphData);
    graphViewer.setVisible(true);
  }

  public GraphViewer getGraphViewer() {
    
///    waitViewer(graphViewer);
    
    Boolean waitFlag = true;    
    synchronized (this) {
      while (waitFlag) {
        try {
          wait(1); // タイムアウト付きで待機状態
          if (graphViewer != null) { waitFlag = false; }
        } catch (InterruptedException e) {
          DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
                  + " Exception occur in while loop:" + e.toString());
        }
      } // while
    } // synchronized()
    if (graphViewer == null) {
      DJ.print("***** ERROR ***** " + getClass().getName() + "\n"
              + " Failed to get graphViewer.");
    }
    
    return graphViewer;
  }
    
} // GraphViewerLauncher

// EOF
