/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAHeteroCloseCallback
implements OracleCloseCallback,
Monitor {
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();

    @Override
    public void beforeClose(OracleConnection oracleConnection, Object object) {
        Monitor.CloseableLock closeableLock = this.acquireCloseableLock();
        if (closeableLock != null) {
            closeableLock.close();
        }
    }

    @Override
    public void afterClose(Object object) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            int n2 = ((OracleXAHeteroConnection)object).getRmid();
            String string = ((OracleXAHeteroConnection)object).getXaCloseString();
            try {
                int n3 = this.t2cDoXaClose(string, n2, 0, 0);
                if (n3 != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * n3).fillInStackTrace();
                }
            }
            catch (SQLException sQLException) {
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private native int t2cDoXaClose(String var1, int var2, int var3, int var4);

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

