/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.util.ArrayList;
import jp.ne.sk_mine.util.andr_applet.SKMArray;
import jp.ne.sk_mine.util.andr_applet.SKMRandomTool;

public class SKMMath {
    public static final double PI = Math.PI;
    public static final double TO_RADIAN = Math.PI / 180;
    public static final double TO_DEGREE = 57.29577951308232;
    private static SKMRandomTool sRandom = new SKMRandomTool();

    public static void setRandom(SKMRandomTool random) {
        sRandom = random;
    }

    public static int[] shuffle(int[] n) {
        int i;
        int[] ret = new int[n.length];
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = n.length - 1; 0 <= i; --i) {
            list.add(n[i]);
        }
        for (i = list.size() - 1; 0 <= i; --i) {
            ret[i] = (Integer)list.remove(sRandom.nextInt(list.size()));
        }
        return ret;
    }

    public static SKMArray shuffle(SKMArray array) {
        int i;
        SKMArray ret = new SKMArray();
        SKMArray list = new SKMArray();
        for (i = array.size() - 1; 0 <= i; --i) {
            list.add(array.get(i));
        }
        for (i = list.size() - 1; 0 <= i; --i) {
            ret.add(list.removeAt(sRandom.nextInt(list.size())));
        }
        return ret;
    }

    public static double abs(double d) {
        return 0.0 <= d ? d : -d;
    }

    public static int abs(int d) {
        return 0 <= d ? d : -d;
    }

    public static double sin(double d) {
        return Math.sin(d);
    }

    public static double cos(double d) {
        return Math.cos(d);
    }

    public static double tan(double d) {
        return Math.tan(d);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double round(double d) {
        long l = (long)(d * 2.0);
        return (l >> 1) + (l & 1L);
    }

    public static double floor(double d) {
        return Math.floor(d);
    }

    public static double ceil(double d) {
        return Math.ceil(d);
    }

    public static int max(int a, int b) {
        return a < b ? b : a;
    }

    public static double max(double a, double b) {
        return a < b ? b : a;
    }

    public static int min(int a, int b) {
        return a < b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static boolean nearEquals(double base, double target) {
        double e = 1.0E-6;
        return base - 1.0E-6 <= target && target <= base + 1.0E-6;
    }

    public static boolean nearEquals(double base, double target, double e) {
        return base - e <= target && target <= base + e;
    }

    public static double distance(double x0, double y0, double x1, double y1) {
        return Math.sqrt(SKMMath.distance2(x0, y0, x1, y1));
    }

    public static double distance2(double x0, double y0, double x1, double y1) {
        double dx = x0 - x1;
        double dy = y0 - y1;
        return dx * dx + dy * dy;
    }

    public static double doubleModulo(double d, double m) {
        int id = (int)d;
        return (double)id % m + (d - (double)id);
    }

    public static double getRad(double x, double y, double toX, double toY) {
        return Math.atan2(toY - y, toX - x);
    }

    public static int getSignToRad(double fromRad, double toRad) {
        double ax = Math.cos(fromRad);
        double ay = Math.sin(fromRad);
        double bx = Math.cos(toRad);
        double by = Math.sin(toRad);
        double cross = ax * by - ay * bx;
        double e = 1.0E-8;
        if (-1.0E-8 < cross && cross < 1.0E-8) {
            return 0;
        }
        if (cross < 0.0) {
            return -1;
        }
        return 1;
    }

    public static boolean isSameRad(double radA, double radB) {
        double e = 1.0E-6;
        while (radA < 0.0) {
            radA += Math.PI * 2;
        }
        while (Math.PI * 2 < radA) {
            radA -= Math.PI * 2;
        }
        while (radB < 0.0) {
            radB += Math.PI * 2;
        }
        while (Math.PI * 2 < radB) {
            radB -= Math.PI * 2;
        }
        return radA - 1.0E-6 <= radB && radB <= radA + 1.0E-6;
    }

    public static boolean isSameRad(double radA, double radB, double e) {
        while (radA < 0.0) {
            radA += Math.PI * 2;
        }
        while (Math.PI * 2 < radA) {
            radA -= Math.PI * 2;
        }
        while (radB < 0.0) {
            radB += Math.PI * 2;
        }
        while (Math.PI * 2 < radB) {
            radB -= Math.PI * 2;
        }
        return radA - e <= radB && radB <= radA + e;
    }

    public static double getRadDiff(double radA, double radB) {
        while (radA < -Math.PI) {
            radA += Math.PI * 2;
        }
        while (Math.PI < radA) {
            radA -= Math.PI * 2;
        }
        while (radB < -Math.PI) {
            radB += Math.PI * 2;
        }
        while (Math.PI < radB) {
            radB -= Math.PI * 2;
        }
        double diff = SKMMath.abs(radA - radB);
        if (Math.PI < diff) {
            diff = Math.PI * 2 - diff;
        }
        return diff;
    }

    public static int factorial(int n) {
        if (n <= 0) {
            return 1;
        }
        int ret = n;
        while (1 < --n) {
            ret *= n;
        }
        return ret;
    }

    public static double calcCatmullRom(double p0, double p1, double p2, double p3, double t) {
        return (-0.5 * p0 + 1.5 * p1 - 1.5 * p2 + 0.5 * p3) * t * t * t + (p0 - 2.5 * p1 + 2.0 * p2 - 0.5 * p3) * t * t + (-0.5 * p0 + 0.5 * p2) * t + p1;
    }

    public static double calcCatmullRom(double[] p, int index, double t) {
        if (index < 0 || p.length <= index) {
            return 0.0;
        }
        int c1 = index;
        int c0 = c1 == 0 ? 0 : c1 - 1;
        int c2 = p.length - 1 <= c1 ? c1 : c1 + 1;
        int c3 = p.length - 2 <= c1 ? c2 : c1 + 2;
        return SKMMath.calcCatmullRom(p[c0], p[c1], p[c2], p[c3], t);
    }

    private SKMMath() {
    }
}

