/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jp.ne.sk_mine.util.image.AlphaFilter;

public final class ImageFuncs {
    public static final int REVERSE_HORIZONTAL = 0;
    public static final int REVERSE_VERTICAL = 1;
    public static final int ROTATE_90 = 0;
    public static final int ROTATE_180 = 1;
    public static final int ROTATE_270 = 2;

    private ImageFuncs() {
    }

    public static final Image getReversedImage(Image image, int reverseDir) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (reverseDir == 0) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width / 2; ++x) {
                    int tmp = pixels[y * width + x];
                    pixels[y * width + x] = pixels[y * width + (width - x - 1)];
                    pixels[y * width + (width - x - 1)] = tmp;
                }
            }
        } else if (reverseDir == 1) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height / 2; ++y) {
                    int tmp = pixels[y * width + x];
                    pixels[y * width + x] = pixels[(height - y - 1) * width + x];
                    pixels[(height - y - 1) * width + x] = tmp;
                }
            }
        }
        MemoryImageSource mis = new MemoryImageSource(width, height, pixels, 0, width);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public static final Image getRotatedImage(Image image, int rotate) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] newPixels = new int[height * width];
        MemoryImageSource mis = null;
        if (rotate == 0) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    newPixels[(width - x - 1) * height + y] = pixels[y * width + x];
                }
            }
            mis = new MemoryImageSource(height, width, newPixels, 0, height);
        } else if (rotate == 1) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    newPixels[(height - y - 1) * width + (width - x - 1)] = pixels[y * width + x];
                }
            }
            mis = new MemoryImageSource(width, height, newPixels, 0, width);
        } else if (rotate == 2) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    newPixels[x * height + (height - y - 1)] = pixels[y * width + x];
                }
            }
            mis = new MemoryImageSource(height, width, newPixels, 0, height);
        }
        return mis == null ? null : Toolkit.getDefaultToolkit().createImage(mis);
    }

    public static final Image getRotatedImageByRadian(Image image, double rad, Color bgColor, Color transparentColor, Component component) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Image outImage = component.createImage(width, height);
        Graphics2D g2 = (Graphics2D)outImage.getGraphics();
        g2.setColor(bgColor == null ? Color.BLACK : bgColor);
        g2.fillRect(0, 0, width, height);
        g2.rotate(rad, width / 2, height / 2);
        g2.drawImage(image, 0, 0, component);
        g2.dispose();
        if (transparentColor != null) {
            Image tmpImage = ImageFuncs.getFilteredImage(outImage, (ImageFilter)new AlphaFilter(transparentColor.getRGB() & 0xFFFFFF, 0));
            outImage.flush();
            outImage = tmpImage;
        }
        return outImage;
    }

    public static final Image[] getFilteredImage(Image[] inImages, ImageFilter filter) {
        Image[] outImages = new Image[inImages.length];
        for (int i = inImages.length - 1; 0 <= i; --i) {
            if (inImages[i] == null) continue;
            outImages[i] = ImageFuncs.getFilteredImage(inImages[i], filter);
        }
        return outImages;
    }

    public static final Image getFilteredImage(Image image, ImageFilter filter) {
        ImageProducer source = image.getSource();
        FilteredImageSource producer = new FilteredImageSource(source, filter);
        Image outImage = Toolkit.getDefaultToolkit().createImage(producer);
        Toolkit.getDefaultToolkit().prepareImage(outImage, -1, -1, null);
        return outImage;
    }

    public static final Image[] getFilteredImage(Image[] inImages, ImageFilter filter, Component component) {
        MediaTracker mt = new MediaTracker(component);
        Image[] outImages = new Image[inImages.length];
        for (int i = inImages.length - 1; 0 <= i; --i) {
            if (inImages[i] == null) continue;
            ImageProducer source = inImages[i].getSource();
            FilteredImageSource producer = new FilteredImageSource(source, filter);
            outImages[i] = Toolkit.getDefaultToolkit().createImage(producer);
            mt.addImage(outImages[i], 0);
        }
        try {
            mt.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outImages;
    }

    public static final Image getFilteredImage(Image inImage, ImageFilter filter, Component component) {
        MediaTracker mt = new MediaTracker(component);
        ImageProducer source = inImage.getSource();
        FilteredImageSource producer = new FilteredImageSource(source, filter);
        Image outImage = Toolkit.getDefaultToolkit().createImage(producer);
        mt.addImage(outImage, 0);
        try {
            mt.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outImage;
    }
}

