/** daytodaywin.cpp
 * ͉̓
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 * @QƃTCg	WikipediaC{LO
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-11-01.shtm
*/

//  ======================================================
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <iterator>
#include <list>
#include <regex>
#include <locale>
#include <winsock2.h>
#include <windows.h>
#include <commctrl.h>
#include <richedit.h>
#include <curl/curl.h>
#include <boost/format.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include "pahooCache.hpp"
#include "mystrings.h"
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"daytodaywin"			// AvP[V
#define APPNAMEJP	"͉̓"			// AvP[Vi{j
#define APPVERSION	"1.5.0"					// o[W
#define APPYEAR		"2020-25"				// 쐬NEXV
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-11-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF2		5120

// ListViewItem̍ő啶FύXs
#define MAX_LISTVIEWITEM	255

// NGXgURLi{LOjiύXsj
#define KINENBI_URL		"https://www.kinenbi.gr.jp/"

// LOʒliύXsj
#define KINENBI_YEAR	(-99999)

// LbVEfBNg
#define DIR_CACHE_WIKIPEDIA		"pcache\\"

// LbVێԁiftHgGj(0FLbVȂ)
#define LIFE_CACHE_WIKIPEDIA	(7 * 24 * 60)

// ݂̃C^[tFCX
static HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"daytodaywin.csv"

// UserAgent
string UserAgent;

// oi[pNX
#define SIZE_EVENTS		500		// i[
class _Events {
public:
	wstring category = L"";		// 敪
	int year = 0;				// N
	wstring era = L"";			// 
	wstring event = L"";		// o
	wstring plus = L"";			// ǉ
};
unique_ptr<_Events> Events[SIZE_EVENTS] = {};

// \[gp\
struct _stEvents {
	wchar_t* category = NULL;	// 敪
	int *year = NULL;			// N
	wchar_t* event = NULL;		// o
	size_t id = 0;				// Events̓Y
};
vector<_stEvents> Vevents;

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGW(g++), Boost C++Cu, cURL, OpenSSL
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// IvVǍ^ۑ ====================================================
/**
 * IvV̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadOption(void) {
	hParent_X = 0;
	hParent_Y = 0;
	ptree pt;

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			hParent_X = 0;
			hParent_Y = 0;
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		hParent_X = 0;
		hParent_Y = 0;
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * IvV̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveOption(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	// XMLt@C֏
	ptree pt;
	ptree& child2 = pt.add("parameter.param", (string)to_string(hParent_X));
	child2.add("<xmlattr>.type", "wx");
	ptree& child3 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child3.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg	EBhEEnh
 * @paramm	UINT uMsg
 * @param	WPARAM wParam
 * @paramL	PARAM lParam
 * @return	INT_PTR CALLBACK
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	string help;

	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
	setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
	break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
			// s
			case IDC_BUTTON_OK:
				EndDialog(hDlg, 0);
				break;
			default:
				return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

/**
 * ʂCSVt@Cɕۑ
 * @param	const char *fname ۑt@C
 * @return	Ȃ
*/
void __saveCSV(const char *fname) {
	ofstream outputfile(fname);

	// x
	outputfile << "\"" << "敪" << "\",";
	outputfile << "\"" << "N" << "\",";
	outputfile << "\"" << "o" << "\",";
	outputfile << "\"" << "NURL" << "\"" << endl;

	// f[^{
	for (int i = 0; i < SIZE_EVENTS; i++) {
		if (Events[i] != NULL) {
			outputfile << "\"" << _WS(Events[i]->category) << "\",";
			if (Events[i]->year != KINENBI_YEAR) {
				outputfile << "\"" << Events[i]->year << "\",";
			} else {
				outputfile << "\"\",";
			}
			outputfile << "\"" << _WS(Events[i]->event) << "\"" << endl;
		}
		if (outputfile.bad()) {
			ErrorMessage = "CSVt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * ʂCSVt@Cɕۑ
 * @param	Ȃ
 * @return	Ȃ
*/
void saveCSV(void) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("CSVt@C(*.csv;*.txt)\0*.csv;*.txt\0ׂẴt@C(*.txt)\0*.txt\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("csv");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveCSV(fname);
}

/**
 * Wikipedia URL擾
 * @param	int month, day	C
 * @param	char* url		URLi[
 * @param	size_t sz		url̍ő咷
 * @return	Ȃ
*/
void getURL_Wikipedia(int month, int day, char *url, size_t sz) {
	const string wiki = "https://ja.wikipedia.org/wiki/";
	static char buff1[SIZE_BUFF2 + 1], buff2[SIZE_BUFF2 + 1];

	snprintf(buff1, SIZE_BUFF2, "%d%d", month, day);
	string s1 = sjis_utf8(buff1);

	CURL *curl = curl_easy_init();
	strncpy(buff2, curl_easy_escape(curl, (const char *)s1.c_str(), strlen(s1.c_str())), SIZE_BUFF2);


	string ss = wiki + (string)buff2;
	strncpy(url, ss.c_str(), SIZE_BUFF2);

	curl_easy_cleanup(curl);
}

/**
 * ߔԍ菜ĕԂD
 * @param	wstring wstr	̓eLXg
 * @return	wstring ϊeLXg
*/
wstring wstripAnnotations(wstring wstr) {
	wregex re1(_SW("\\&\\#[0-9a-fA-F]+\\;[0-9a-fA-F]+\\&\\#[0-9a-fA-F]+\\;"));
	return (wstring)regex_replace(wstr, re1, L"");
}

/**
 * ͉̓ 擾
 * @param	int  month, day	C
 * @param	bool lfn		rciȗFALSEj
 * @return	int 񌏐
*/
int getDayToday(int month, int day, bool lfn=FALSE) {
	// 
	for (int i = 0; i < SIZE_EVENTS; i++) {
		Events[i].reset();
		Events[i] = NULL;
	}

	// LbVVXe
	pahooCache* pCC;
	pCC = new pahooCache(LIFE_CACHE_WIKIPEDIA, getMyPath(APPNAME) + DIR_CACHE_WIKIPEDIA, UserAgent);

	// WikipediaRec擾
	char url[SIZE_BUFF2];
	string contents = "";
//	int httpStatus;
	getURL_Wikipedia(month, day, (char *)url, SIZE_BUFF2);
//	bool res = readWebContents(url, UserAgent, &contents, &httpStatus);
	if (pCC->load(url, &contents) == FALSE) {
		ErrorMessage = "WikipediaɃANZXł܂F" + _WS(pCC->getError());
		delete pCC;
		return FALSE;
	}

//	if (res == FALSE) {
//		ErrorMessage = "WikipediaɃANZXł܂D";
//		return (-1);
//	}

	// Rec̉
	setlocale(LC_ALL, "Japanese");
	int cnt = -1;
	stringstream ss;
	string ss0;
	wstring mode = L"";
	wstring ws, ws2;
	wstringstream wss;
	static wsmatch mt1, mt2, mt3;
	static smatch mt4;
	wregex re1(_SW("<h2[\\s\\S]+id=\"(ł|o)\""));
	wregex re2(_SW("<h2[\\s\\S]+id=\"a\""));
	wregex re3(_SW("<h2[\\s\\S]+id=\"\""));
	wregex re5(_SW("<li>[^\\>]+([0-9]+(N|I).+)<\\/li>"));
	wregex re6(_SW("([^0-9]*)([0-9]+)N(\\s*[\(i].[^\\)j]+[j\\)].)?[ \\-]+(.+)"));	// N - o
	wregex re7(_SW("([^0-9]*)([0-9]+)N(\\s*[\\(i].[^\\)j]+[j\\)].)?[ \\-]+([^A]+)A?([^i\\(]+)*([^0-9]*)([0-9]*)"));		// N - OAEƁivNj
	wregex re8(_SW("<span[\\s\\S]+id=\"tBNV̂ł\">"));
	wregex re9(_SW("^\\i[\\*\\+]."));			// N - OAEƁivNj
	wregex re11(_SW("IO"));
	wregex re99(_SW("<span[\\s\\S]+class=\"vector-menu-heading-label\">"));		// 1sǂݍݑł؂

	ss << contents;
	while(ss && getline(ss, ss0)) {
		// 1swstringϊ
		ws = _UW(ss0);
		// 4000ȏȂ珈Ȃ
		if (ws.length() > 4000) {
			continue;
		}
		// }b`O
		if (regex_search(ws, mt1, re99)) {
			break;
		} else if (regex_search(ws, mt1, re1)) {
			mode = _SW("o");
		} else if (regex_search(ws, mt1, re8)) {
			mode = _SW("ˋ");
		} else if (regex_search(ws, mt1, re2)) {
			mode = _SW("a");
		} else if (regex_search(ws, mt1, re3)) {
			mode = _SW("S");
		} else if ((mode.length() != 0) && (regex_search(ws, mt1, re5) == TRUE)) {
			// HTML^O
			ws = wstrip_tags(ws);
			// ߔԍ
			ws = wstripAnnotations(ws);
			// o
			if ((mode == _SW("o")) && (regex_search(ws, mt2, re6) == TRUE)) {
				cnt++;
				Events[cnt] = make_unique<_Events>();
				Events[cnt]->category = mode;
				if (mt2[1].str().length() == 0) {
					Events[cnt]->year = atoi(_WS(mt2[2].str()).c_str());
				} else {
					Events[cnt]->year = 0 - atoi(_WS(mt2[2].str()).c_str());
				}
				Events[cnt]->era   = mt2[3].str();
				Events[cnt]->event = mt2[4].str();

			// aES
			} else if (regex_search(ws, mt2, re7)) {
				cnt++;
				Events[cnt] = make_unique<_Events>();
				Events[cnt]->category = mode;
				if (mt2[1].str().length() == 0) {
					Events[cnt]->year = atoi(_WS(mt2[2].str()).c_str());
				} else {
					Events[cnt]->year = 0 - atoi(_WS(mt2[2].str()).c_str());
				}
				Events[cnt]->era = mt2[3].str();
				ws2 = mt2[6].str();
				if (regex_search(ws2, mt3, re11) == TRUE) {
					Events[cnt]->plus = L"-" + mt2[7].str();
				} else if (regex_search(ws2, mt3, re9) == TRUE) {
					Events[cnt]->plus = mt2[7].str();
				} else {
					Events[cnt]->plus = L"";
				}
				wss << mt2[4].str() << _SW("i") << mt2[5].str();
				if (mode == _SW("a")) {
					wss << _SW("ja");
					if (Events[cnt]->plus.length() != 0) {
						wss << _SW("i`") << Events[cnt]->plus << _SW("Nj");
					}
				} else {
					wss << _SW("j");
					if (Events[cnt]->plus.length() != 0) {
						wss << _SW("i") << Events[cnt]->plus << _SW("N`")<< Events[cnt]->year << _SW("Nj");
					}
				}
				Events[cnt]->event = wss.str();
				wss.str(L"");
			}
		}
	}
	// CX^X
	delete pCC;

	return cnt;
}

/**
 * w茎̋LO擾
 * @param	int month, day 
 * @param	int cnt ǉz̍ŏ̔ԍ
 * @return	int ̑
*/
int getAnniversary(int month, int day, int cnt=0) {
	// Recǂݍ
	static char post[SIZE_BUFF2 + 1];
	snprintf(post, SIZE_BUFF2, "MD=%d&M=%d&D=%d", month, month, day);
	string contents = "";
	int httpStatus;
	bool res = readWebContents(KINENBI_URL, UserAgent, &contents, &httpStatus, post);

	if (res == FALSE) {
		ErrorMessage = "{LÕTCgɃANZXł܂D";
		return (-1);
	}

	// XNCsO
	wregex re1(_SW("<a\\s+class=\"winDetail\"\\s+href=\"([^\"]+)\"><font[^>]+>([^<]+)</font>"), wregex::icase);
	static wsmatch mt1;

	stringstream ss;
	wstring mode = _SW("LO");
	string ss0;
	wstring ws;
	ss << contents;
	while(ss && getline(ss, ss0)) {
		// 1swstringϊ
		ws = _UW(ss0);
		if (regex_search(ws, mt1, re1)) {
			Events[cnt] = make_unique<_Events>();
			Events[cnt]->category = mode;
			Events[cnt]->event = mt1[2].str();
			Events[cnt]->year  = KINENBI_YEAR;
			cnt++;
		}
	}

	return cnt;
}

// L\[gpID
enum {
	SORT_CATEGORY_ASC,
	SORT_CATEGORY_DEC,
	SORT_YEAR_ASC,
	SORT_YEAR_DEC,
	SORT_EVENT_ASC,
	SORT_EVENT_DEC,
	SORT_NONE
};

// L\[gpID
enum {
	SORT_ASC,
	SORT_DEC
};

/**
 * \[gp̔r֐F敪ij
 * @param	const _stEvents& left, right
 * @return	r
*/
bool __cmpCategoryAsc(const _stEvents& left, const _stEvents& right) {
	return wcscmp(left.category, right.category) < 0;
}

/**
 * \[gp̔r֐F敪i~j
 * @param	const _stEvents& left, right
 * @return	r
*/
bool __cmpCategoryDec(const _stEvents& left, const _stEvents& right) {
//	return strcmp(left.category, right.category) >= 0;
	return wcscmp(left.category, right.category) >= 0;
}

/**
 * \[gp̔r֐Fij
 * @param	const _stEvents& left, right
 * @return	r
*/
bool __cmpYearAsc(const _stEvents& left, const _stEvents& right) {
	return (*left.year < *right.year);
}

/**
 * \[gp̔r֐Fi~j
 * @param	const _stEvents& left, right
 * @return	r
*/
bool __cmpYearDec(const _stEvents& left, const _stEvents& right) {
	return (*left.year >= *right.year);
}

/**
 * \[gp̔r֐Foij
 * @param	const _stEvents& left, right
 * @return	r
*/
bool __cmpEventAsc(const _stEvents& left, const _stEvents& right) {
	return wcscmp(left.event, right.event) < 0;
}

/**
 * \[gp̔r֐Foi~j
 * @param	const _stEvents& left, right
 * @return	r
*/
bool __cmpEventDec(const _stEvents& left, const _stEvents& right) {
//	return strcmp(left.event, right.event) >= 0;
	return wcscmp(left.event, right.event) >= 0;
}

/**
 * \[gpϐɑ
 * @param	unique_ptr<_Events> &ptr 	f[^Zbg
 * @param	size_t i					f[^ZbgID
 * @return	_stEvents
*/
_stEvents __push_stEvents(unique_ptr<_Events> &ptr, size_t id) {
	_stEvents s;
	s.category	= (wchar_t*)ptr->category.c_str();
	s.year		= (int*)&ptr->year;
	s.event		= (wchar_t*)ptr->event.c_str();
	s.id		= id;
	return s;
}

/**
 * oꗗ̃\[g
 * @param	int c  \[g
 * @return	Ȃ
*/
void sortEvents(int c) {
	struct {
		int id;
		bool (*fn)(const _stEvents& left, const _stEvents& right);
} table[] = {
	{ SORT_CATEGORY_ASC,	__cmpCategoryAsc },
	{ SORT_CATEGORY_DEC,	__cmpCategoryDec },
	{ SORT_YEAR_ASC,		__cmpYearAsc },
	{ SORT_YEAR_DEC,		__cmpYearDec },
	{ SORT_EVENT_ASC,		__cmpEventAsc },
	{ SORT_EVENT_DEC,		__cmpEventDec }
};
	size_t i;
	bool (*fn)(const _stEvents& left, const _stEvents& right) = NULL;

	// \[gpz̏
	Vevents.clear();
	Vevents.shrink_to_fit();

	// o\[gpz
	for (i = 0; i < SIZE_EVENTS; i++) {
		if (Events[i] != NULL) {
			Vevents.push_back(__push_stEvents(Events[i], i));
		}
	}

	// \[gp֐̑I
	for (i = 0; i < (int)(sizeof(table) / sizeof(*table)); i++) {
		if (c == table[i].id) {
			fn = table[i].fn;
			break;
		}
	}

	// \[gs
	if (fn != NULL) {
		stable_sort(Vevents.begin(), Vevents.end(), fn);
	}
}

// Xgr[̗
enum {
	COL_CATEGORY,
	COL_YEAR,
	COL_EVENT,
	COL_ID
};

/**
 * oꗗ̃t[쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListViewFrame(HWND hWnd) {
	LVCOLUMNA lvcol;
	lvcol.mask = LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH | LVCF_FMT;
	lvcol.fmt = LVCFMT_LEFT;

	lvcol.cx = 70;
	lvcol.pszText = (char *)"敪";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_CATEGORY, (WPARAM)&lvcol);
	lvcol.cx = 50;
	lvcol.pszText = (char *)"";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_YEAR, (WPARAM)&lvcol);
	lvcol.cx = 450;
	lvcol.pszText = (char *)"o";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_EVENT, (WPARAM)&lvcol);
	lvcol.cx = 0;
	lvcol.pszText = (char *)"ID";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_ID, (WPARAM)&lvcol);

	// r\{1sI
	DWORD dwStyle = ListView_GetExtendedListViewStyle(hWnd);
	dwStyle = dwStyle | LVS_EX_GRIDLINES | LVS_EX_ONECLICKACTIVATE | LVS_EX_FULLROWSELECT;
	ListView_SetExtendedListViewStyle(hWnd, dwStyle);
}

/**
 * oꗗ쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListView(HWND hWnd) {
	LVITEMA item;
	stringstream ss;

	// 
	for (int i = 0; i < SIZE_EVENTS; i++) {
		item.iItem = i;
		SendMessage(hWnd, LVM_DELETEITEM, 0,(WPARAM)&item);
	}

	// f[^s
	for (int i = 0; i < SIZE_EVENTS; i++) {
		if (Events[i] == NULL)	break;
		// 敪
		item.mask = LVIF_TEXT;
		item.iItem = i;
		item.iSubItem = COL_CATEGORY;
		item.pszText = (LPSTR)_WS(Vevents[i].category).c_str();
		SendMessage(hWnd, LVM_INSERTITEMA, 0,(WPARAM)&item);
		// 
		item.iSubItem = COL_YEAR;
		ss.str("");
		if (*Vevents[i].year != KINENBI_YEAR) {
			ss << *Vevents[i].year;
		}
		item.pszText = (LPSTR)ss.str().c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// o
		item.iSubItem = COL_EVENT;
		string temp = _WS(Vevents[i].event).substr(0, MAX_LISTVIEWITEM);
		const char* cstr = temp.c_str();
		item.pszText = (LPSTR)cstr;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// ID
		item.iSubItem = COL_ID;
		ss.str("");
		ss << Vevents[i].id;
		item.pszText = (LPSTR)ss.str().c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
	}
}

/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	pahooCache* pCC;	// pahooCacheIuWFNg

	HICON hIcon;
	LV_HITTESTINFO lvinfo;
	NM_LISTVIEW *pNMLV;
	TCHAR buff[SIZE_BUFF2 + 1];
	static int subsort[100];
	HWND hDate;
	SYSTEMTIME st;
	LVITEMA item;
	size_t id;
	wstringstream wss;
	int cnt = 0;

	switch(uMsg) {
	// _CAO
	case WM_INITDIALOG:
		hParent = hDlg;
		hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
		SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
		makeListViewFrame(GetDlgItem(hDlg, IDC_LISTVIEW_EVENTS));
		// IvVǂݍ
		loadOption();
		ErrorMessage = "";
		// AvP[VEEBhEړ
		SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// 
		case IDM_EXEC:
		case IDC_BUTTON_EXEC:
			ErrorMessage = "";
			// N擾
			hDate = GetDlgItem(hDlg, IDC_CAL_TODAY);
			DateTime_GetSystemtime(hDate, &st);
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// Wikipedia
			cnt = getDayToday(st.wMonth, st.wDay, TRUE);
			// {LO
			cnt = getAnniversary(st.wMonth, st.wDay, cnt);
			// \[g
			sortEvents(SORT_YEAR_ASC);
			// ꗗ\
			makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_EVENTS));
			setStrEditBox(hDlg, IDC_TEXT_ERROR, ErrorMessage);
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveCSV();
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// Zp
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDC_BUTTON_COPY:
		case IDM_COPY:
			setClipboardData(getStrEditBox(hParent, IDC_EDIT_TODAY));
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hParent, IDC_EDIT_TODAY, "");
			break;
		// LbVENA
		case IDM_CLEAR_CACHE:
			pCC = new pahooCache(LIFE_CACHE_WIKIPEDIA, getMyPath(APPNAME) + DIR_CACHE_WIKIPEDIA, UserAgent);
			pCC->delCache(".+", 0);
			delete pCC;
			break;
		// vOI
		case IDM_QUIT:
			// IvVۑ
			saveOption();
			EndDialog(hParent, 0);
			return 0;
		default:
			return 1;
	}
	break;

	// ʒm
	case WM_NOTIFY:
		switch(((LPNMHDR)lParam)->idFrom) {
		case IDC_LISTVIEW_EVENTS:
			switch (((LPNMLISTVIEW)lParam)->hdr.code) {
				// ꗗ̃xNbN
				case LVN_COLUMNCLICK:
					pNMLV = (NM_LISTVIEW *)lParam;
					if (subsort[pNMLV->iSubItem] == SORT_ASC) {
						subsort[pNMLV->iSubItem] = SORT_DEC;
					} else {
						subsort[pNMLV->iSubItem] = SORT_ASC;
					}
					// oꗗ̕בւ
					sortEvents(pNMLV->iSubItem * 2 + subsort[pNMLV->iSubItem]);
					// ꗗ\
					makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_EVENTS));
					break;
				// oꗗ1sI
				case LVN_ITEMCHANGED:
				// Јꗗ1s_uNbN
				// case NM_DBLCLK:
					GetCursorPos((LPPOINT)&lvinfo.pt);
					ScreenToClient(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo.pt);
					ListView_HitTest(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &lvinfo);
					if ((lvinfo.flags & LVHT_ONITEM) != 0) {
						item.mask = TVIF_HANDLE | TVIF_TEXT;
						item.iItem = lvinfo.iItem;
						item.iSubItem = COL_ID;
						item.pszText = buff;
						item.cchTextMax = SIZE_BUFF2;
						ListView_GetItem(((LPNMLISTVIEW)lParam)->hdr.hwndFrom, &item);
						// f[^擾{\
						id = atoi(buff);
						wss.str(L"");
						wss << Events[id]->category << _SW("F");
						if (Events[id]->year != KINENBI_YEAR) {
							wss << Events[id]->year << _SW("NF");
						}
						wss << Events[id]->event;
						setStrEditBox(hDlg, IDC_EDIT_TODAY, _WS(wss.str()));
					}
					break;
				default:
					break;
			}
			break;
		default:
			break;
		}
		break;

	// vOI
	case WM_CLOSE:
		// IvVۑ
		saveOption();
		EndDialog(hParent, 0);
		return 0;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	hInst = hInstance;
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);

	return 0;
}

/*
** o[WAbv =====================================================
 *
 * @version 1.5.0  2025/09/11 getDayToday() LbVVXe𗘗p悤ύXCgpCuXV
 * @version 1.4.6  2025/09/11 getDayToday() ułƁv擾p^[ύX
 * @version 1.4.5  2025/07/17 gpCuXV, readWebContentssC
 * @version 1.4.4  2025/03/08 gpCuXV
 * @version 1.4.3  2024/11/23 makeListView()--debug, gpCuXV
 * @version 1.4.2  2024/07/27 getDayToday()擾p^[ύX, getDaygpCuXV
 * @version 1.4.1  2024/03/16 gpCuXV
 * @version 1.4.0  2023/11/04 ߔԍCgpCuXV
 * @version 1.3.4  2023/06/18 gpCuXV
 * @version 1.3.3  2023/03/11 gpCuXV
 * @version 1.3.2  2023/01/08 getDayToday() -- ̎擾p^[ύX
 * @version 1.3.1  2022/10/16 IOp^[ǉ
 * @version 1.3.0  2022/09/03 EBhEʒuۑ
 * @version 1.2.1  2022/09/03 getDayToday() -- 1s4000ȏȂǂݔ΂
 * @version 1.2    2022/03/26 getDayToday() -- 1sǂݍݑł؂ǉ
 * @version 1.1    2021/01/31 LO\C\[X
 * @version 1.0    2020/09/12 
*/
