#==================================================================#
# シンプルホットキー記録・再生ツール
#==================================================================#
#* C#のロード ****************************************************/##******************************************************#
Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName System.Drawing

$here = Split-Path $MyInvocation.MyCommand.Path -Parent
$csFilePath = Join-Path $here "PsMacros.cs"

if (-not (Test-Path $csFilePath)) {
    throw "C#クラスファイルが見つかりません: $csFilePath"
}

try {
    $csContent = Get-Content -Path $csFilePath -Encoding UTF8 -Raw
    Add-Type -TypeDefinition $csContent -ReferencedAssemblies @('System.Windows.Forms', 'System.Drawing')
    
    # テスト用インスタンス作成（正常にロードできるかチェック）
    $testController = New-Object SimpleHotkeyController
    $testController = $null
}
catch {
    $errorMsg = @"
エラー: C#クラスファイルの読み込みに失敗しました: $_

解決方法:
1. PowerShellを管理者権限で実行してください
2. 実行ポリシーを確認: Get-ExecutionPolicy
3. 必要に応じて変更: Set-ExecutionPolicy RemoteSigned
4. psHotKey.csファイルが同じフォルダにあることを確認
"@
    throw $errorMsg
}
#/*C#のロード ****************************************************/##******************************************************#

try {
    # シンプルにShowDialog()で起動
    $HotkeyManager = New-Object SimpleHotkeyController
    $HotkeyManager.ShowManagerDialog()
}
catch {
    $errorMsg = "ツール開始失敗: $($_.Exception.Message)"
    [System.Windows.Forms.MessageBox]::Show($errorMsg, "エラー", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Error)
}