/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.awt.Font;

public class SKMFont {
    public static int SERIF = 0;
    public static int SANSSERIF = 1;
    public static int MONOSPACED = 2;
    public static int COURIER = 3;
    public static int PLAIN = 0;
    public static int BOLD = 1;
    public static int ITALIC = 2;
    private Font mFont;

    public SKMFont(int size) {
        this.mFont = new Font("SERIF", 0, size);
    }

    public SKMFont(int style, int size) {
        this.mFont = new Font("SERIF", style, size);
    }

    public SKMFont(int name, int style, int size) {
        this.mFont = new Font(this.getNameString(name), style, size);
    }

    public SKMFont(Font font) {
        this.mFont = font;
    }

    public int getFontName() {
        String name = this.mFont.getFontName();
        if (name.equals("Serif")) {
            return SERIF;
        }
        if (name.equals("SansSerif")) {
            return SANSSERIF;
        }
        if (name.equals("Monospaced")) {
            return MONOSPACED;
        }
        if (name.equals("Courier")) {
            return COURIER;
        }
        return SERIF;
    }

    public int getStyle() {
        return this.mFont.getStyle();
    }

    public int getSize() {
        return this.mFont.getSize();
    }

    public Font getFont() {
        return this.mFont;
    }

    private final String getNameString(int name) {
        if (name == SERIF) {
            return "SERIF";
        }
        if (name == SANSSERIF) {
            return "SANSSERIF";
        }
        if (name == MONOSPACED) {
            return "MONOSPACED";
        }
        if (name == COURIER) {
            return "Courier";
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SKMFont) {
            return false;
        }
        SKMFont font = (SKMFont)o;
        return this.mFont.getFontName().equals(font.mFont.getFontName()) && this.mFont.getStyle() == font.mFont.getStyle() && this.mFont.getSize() == font.mFont.getSize();
    }
}

