/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import jp.ne.sk_mine.util.andr_applet.SKM;

public class SKMI18N {
    private static final String PREFIX_EXTENSION = "ext_";
    private static boolean sIsExtensionEnabled = true;
    private static String language__ = "";
    private static String country__ = "";
    private String fileName_;
    private Map<String, String> loadedMap_ = new HashMap<String, String>();

    public static void setExtensionEnabled(boolean f) {
        sIsExtensionEnabled = f;
    }

    public static boolean isExtensionEnabled() {
        return sIsExtensionEnabled;
    }

    public static String getExtensionPrefix() {
        return PREFIX_EXTENSION;
    }

    public static void setLanguage(Locale locale) {
        language__ = "_" + locale.getLanguage();
    }

    public static void setLanguage(String lang) {
        language__ = lang.equals("") ? "" : "_" + lang;
    }

    public static void setCountry(Locale locale) {
        country__ = "_" + locale.getCountry();
    }

    public static void setCountry(String country) {
        country__ = country.equals("") ? "" : "_" + country;
    }

    public static void setLocale(Locale locale) {
        SKMI18N.setLanguage(locale);
        SKMI18N.setCountry(locale);
    }

    public static String replaceMessages(String line, SKMI18N i18n) {
        SKMI18N i18nCommon = SKM.getI18NCommon();
        while (line.contains("$message(")) {
            int startIndex = line.indexOf("$message(");
            int closeIndex = startIndex + line.substring(startIndex).indexOf(")");
            String param = line.substring(startIndex + "$message(".length(), closeIndex);
            String rep = i18n.getString(param);
            if (rep.equals("") && i18n != i18nCommon) {
                rep = i18nCommon.getString(param);
            }
            line = line.replace("$message(" + param + ")", rep);
        }
        return line;
    }

    public SKMI18N(String baseName) {
        Locale defaultLocale;
        if (language__.equals("") && country__.equals("") && (defaultLocale = Locale.getDefault()).getLanguage().equals("ja")) {
            SKMI18N.setLocale(defaultLocale);
        }
        baseName = baseName.replaceAll("\\.", "/");
        this.fileName_ = baseName + language__ + country__ + ".properties";
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(this.fileName_);
            in.close();
        }
        catch (Exception e) {
            this.fileName_ = baseName + language__ + ".properties";
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(this.fileName_);
                in.close();
            }
            catch (Exception e2) {
                this.fileName_ = baseName + ".properties";
            }
        }
    }

    @Deprecated
    public String getMessage(String key) {
        return this.getString(key);
    }

    public String getString(String key) {
        return this.getMessage(key, null, true);
    }

    public String getString(String key, boolean canExtend) {
        return this.getMessage(key, null, canExtend);
    }

    public String getReplacedString(String key) {
        return this.getMessage(key, this, true);
    }

    public String getReplacedString(String key, boolean canExtend) {
        return this.getMessage(key, this, canExtend);
    }

    public String getReplacedString(String key, SKMI18N i18n) {
        return this.getMessage(key, i18n, true);
    }

    public String getReplacedString(String key, SKMI18N i18n, boolean canExtend) {
        return this.getMessage(key, i18n, canExtend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String[] getMessages(String[] keys) {
        String[] ret = new String[keys.length];
        boolean isAllLoaded = true;
        for (int i = keys.length - 1; 0 <= i; --i) {
            if (this.loadedMap_.containsKey(keys[i])) {
                ret[i] = this.loadedMap_.get(keys[i]);
                continue;
            }
            isAllLoaded = false;
        }
        if (isAllLoaded) {
            return ret;
        }
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(this.fileName_);
            InputStreamReader isr = new InputStreamReader(in, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            Properties prop = new Properties();
            prop.load(reader);
            for (int i = 0; i < keys.length; ++i) {
                try {
                    ret[i] = prop.getProperty(keys[i]);
                    if (ret[i] != null) continue;
                    ret[i] = "";
                    continue;
                }
                catch (Exception e) {
                    ret[i] = "";
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("IOException:" + this.fileName_);
            ioe.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Exception: " + this.fileName_);
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final String getMessage(String key, SKMI18N i18nForReplace, boolean canExtend) {
        String ret;
        block30: {
            if (this.loadedMap_.containsKey(key)) {
                this.loadedMap_.get(key);
            }
            if (sIsExtensionEnabled && canExtend) {
                try {
                    String extendedMessage = SKM.getManager().getStringSetting(PREFIX_EXTENSION + key, null);
                    if (extendedMessage != null) {
                        return extendedMessage;
                    }
                }
                catch (Exception extendedMessage) {
                    // empty catch block
                }
            }
            InputStream in = null;
            ret = "";
            try {
                in = this.getClass().getClassLoader().getResourceAsStream(this.fileName_);
                InputStreamReader isr = new InputStreamReader(in, "UTF-8");
                BufferedReader reader = new BufferedReader(isr);
                Properties prop = new Properties();
                prop.load(reader);
                try {
                    ret = prop.getProperty(key);
                    if (ret == null) {
                        ret = "";
                    } else if (i18nForReplace != null) {
                        ret = SKMI18N.replaceMessages(ret, i18nForReplace);
                    }
                    String string = ret;
                    return string;
                }
                catch (Exception e) {
                    String string;
                    block29: {
                        string = "";
                        if (in == null) break block29;
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return string;
                    catch (IOException ioe) {
                        System.out.println("IOException:" + this.fileName_);
                        ioe.printStackTrace();
                        break block30;
                    }
                    catch (Exception e2) {
                        System.out.println("Exception: " + this.fileName_);
                        e2.printStackTrace();
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return ret;
    }
}

