/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet.game;

import jp.ne.sk_mine.util.andr_applet.SKMColor;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;
import jp.ne.sk_mine.util.andr_applet.game.ShotCharacter;

public class Man
extends ShotCharacter {
    public static final double sBaseScale = 1.5;
    protected boolean mIsDirRight;
    protected boolean mIsBodyPointFromIntPosition;
    protected boolean mIsScaleBody;
    protected int[][] mBody;
    protected int[][] mBodyTmp;
    protected double mTilt;
    protected double mScale;
    protected double mFaceR;
    protected float mDrawScale;
    protected SKMColor mBodyColor;
    protected SKMColor mDeadColor;
    protected int[][] mStandBody = new int[][]{{-12, -6, -12, -6, 0, 0, 0, 6, 12, 6, 12}, {20, 12, 4, -2, 4, -8, -15, -2, 4, 12, 20}};

    public Man(double x, double y, int type) {
        super(x, y, type);
        this.mEnergy = 1;
        this.mMaxEnergy = 1;
        this.mFaceR = 5.0;
        this.mBody = new int[2][11];
        this.mBodyTmp = new int[2][this.mStandBody[0].length];
        this.mBodyColor = SKMColor.BLACK;
        this.mDeadColor = SKMColor.BLACK;
        this.setScale(1.0);
        this.copyBody(this.mStandBody);
    }

    public void setScale(double scale) {
        this.mScale = scale * 1.5;
        this.mSizeW = (int)(24.0 * this.mScale);
        this.mSizeH = (int)(40.0 * this.mScale);
        this.mMaxW = this.mSizeW >> 1;
        this.mMaxH = this.mSizeH >> 1;
    }

    public void scaleBody(int[][] bodyXys, double scale) {
        for (int i = bodyXys[0].length - 1; 0 <= i; --i) {
            bodyXys[0][i] = SKMUtil.toInt(scale * (double)bodyXys[0][i]);
            bodyXys[1][i] = SKMUtil.toInt(scale * (double)bodyXys[1][i]);
        }
    }

    public void scaleBody(int[][][] bodyXys, double scale) {
        for (int j = bodyXys.length - 1; 0 <= j; --j) {
            for (int i = bodyXys[j][0].length - 1; 0 <= i; --i) {
                bodyXys[j][0][i] = SKMUtil.toInt(scale * (double)bodyXys[j][0][i]);
                bodyXys[j][1][i] = SKMUtil.toInt(scale * (double)bodyXys[j][1][i]);
            }
        }
    }

    protected void makeWalkBody(int[][][] bodyXys, boolean isArmFixed) {
        for (int i = 2; i < 5; ++i) {
            bodyXys[i] = new int[2][11];
            int srcIndex = i % 2;
            for (int j = 10; 0 <= j; --j) {
                bodyXys[i][0][j] = bodyXys[srcIndex][0][j];
                bodyXys[i][1][j] = bodyXys[srcIndex][1][j];
            }
            if (i == 4) break;
            this.swapBodyXysPart(bodyXys[i], 0);
            this.swapBodyXysPart(bodyXys[i], 1);
            if (isArmFixed) continue;
            this.swapBodyXysPart(bodyXys[i], 2);
            this.swapBodyXysPart(bodyXys[i], 3);
        }
    }

    private void swapBodyXysPart(int[][] bodyXys, int index) {
        int tmp = bodyXys[0][index];
        bodyXys[0][index] = bodyXys[0][11 - index - 1];
        bodyXys[0][11 - index - 1] = tmp;
        tmp = bodyXys[1][index];
        bodyXys[1][index] = bodyXys[1][11 - index - 1];
        bodyXys[1][11 - index - 1] = tmp;
    }

    public double getScale() {
        return this.mScale;
    }

    public void setDrawScale(float scale) {
        this.mDrawScale = scale;
    }

    public float getDrawScale() {
        return this.mDrawScale;
    }

    public int getHeight() {
        return -this.mY - (this.mSizeH >> 1);
    }

    public void setDirRight(boolean f) {
        this.mIsDirRight = f;
    }

    public boolean isDirRight() {
        return this.mIsDirRight;
    }

    public void updateDirBySpeed() {
        if (this.mSpeedX != 0.0) {
            this.mIsDirRight = 0.0 < this.mSpeedX;
        }
    }

    public void setFaceRadius(double r) {
        this.mFaceR = r;
    }

    public double getFaceRadius() {
        return this.mFaceR;
    }

    @Override
    protected void myMove() {
        this.updateDirBySpeed();
    }

    public double getBodyPointX(int index) {
        return this.getBodyPointX(this.mBody[0], index);
    }

    public double getBodyPointX(int[] bodyX, int index) {
        if (bodyX == null) {
            return 0.0;
        }
        double scale = this.mIsScaleBody ? 1.0 : this.mScale;
        return (double)((this.mIsDirRight ? -1 : 1) * bodyX[index]) * scale + (this.mIsBodyPointFromIntPosition ? (double)this.mX : this.mRealX);
    }

    public int getBaseBodyPointX(int x) {
        double scale = this.mIsScaleBody ? 1.0 : this.mScale;
        return SKMUtil.toInt(((double)x - (this.mIsBodyPointFromIntPosition ? (double)this.mX : this.mRealX)) / ((double)(this.mIsDirRight ? -1 : 1) * scale));
    }

    public double getBodyPointY(int index) {
        return this.getBodyPointY(this.mBody[1], index);
    }

    public double getBodyPointY(int[] bodyY, int index) {
        if (bodyY == null) {
            return 0.0;
        }
        double scale = this.mIsScaleBody ? 1.0 : this.mScale;
        return (double)bodyY[index] * scale + (this.mIsBodyPointFromIntPosition ? (double)this.mY : this.mRealY);
    }

    public int getBaseBodyPointY(int y) {
        double scale = this.mIsScaleBody ? 1.0 : this.mScale;
        return SKMUtil.toInt(((double)y - (this.mIsBodyPointFromIntPosition ? (double)this.mY : this.mRealY)) / scale);
    }

    public double getFaceX() {
        return this.getBodyPointX(6);
    }

    public double getFaceY() {
        return this.getBodyPointY(6);
    }

    public double getLeftHandX() {
        return this.getBodyPointX(8);
    }

    public double getLeftHandY() {
        return this.getBodyPointY(8);
    }

    public double getRightHandX() {
        return this.getBodyPointX(2);
    }

    public double getRightHandY() {
        return this.getBodyPointY(2);
    }

    public double getLeftElbowX() {
        return this.getBodyPointX(7);
    }

    public double getLeftElbowY() {
        return this.getBodyPointY(7);
    }

    public double getRightElbowX() {
        return this.getBodyPointX(3);
    }

    public double getRightElbowY() {
        return this.getBodyPointY(3);
    }

    public double getWaistX() {
        return this.getBodyPointX(4);
    }

    public double getWaistY() {
        return this.getBodyPointY(4);
    }

    public int[][] getBody() {
        return this.mBody;
    }

    public boolean isReverse() {
        return this.mIsDirRight;
    }

    public void copyBody(int[][] base) {
        if (this.mBody == null) {
            this.mBody = new int[2][];
            this.mBody[0] = new int[base[0].length];
            this.mBody[1] = new int[base[1].length];
        }
        if (this.mIsScaleBody) {
            for (int i = base[0].length - 1; 0 <= i; --i) {
                this.mBody[0][i] = (int)(this.mScale * (double)base[0][i]);
                this.mBody[1][i] = (int)(this.mScale * (double)base[1][i]);
            }
        } else {
            System.arraycopy(base[0], 0, this.mBody[0], 0, this.mBody[0].length);
            System.arraycopy(base[1], 0, this.mBody[1], 0, this.mBody[1].length);
        }
    }

    public void copyBody(int[][] src, int[][] dst) {
        if (this.mIsScaleBody) {
            for (int i = src[0].length - 1; 0 <= i; --i) {
                dst[0][i] = (int)(this.mScale * (double)src[0][i]);
                dst[1][i] = (int)(this.mScale * (double)src[1][i]);
            }
        } else {
            System.arraycopy(src[0], 0, dst[0], 0, src[0].length);
            System.arraycopy(src[1], 0, dst[1], 0, src[1].length);
        }
    }

    public boolean getAnimatedBody(int[][][] body, int[] outX, int[] outY, int count, int kizami) {
        int prevIdx = SKMUtil.toInt(count / kizami);
        int postIdx = prevIdx + 1;
        int c = count % kizami;
        boolean ret = false;
        for (int i = 0; i < outX.length; ++i) {
            if (prevIdx < 0) {
                outX[i] = body[0][0][i];
                outY[i] = body[0][1][i];
            } else if (body.length <= prevIdx || body.length <= postIdx) {
                outX[i] = body[body.length - 1][0][i];
                outY[i] = body[body.length - 1][1][i];
                ret = true;
            } else {
                outX[i] = body[prevIdx][0][i] + c * (body[postIdx][0][i] - body[prevIdx][0][i]) / kizami;
                outY[i] = body[prevIdx][1][i] + c * (body[postIdx][1][i] - body[prevIdx][1][i]) / kizami;
            }
            if (!this.mIsScaleBody) continue;
            outX[i] = (int)(this.mScale * (double)outX[i]);
            outY[i] = (int)(this.mScale * (double)outY[i]);
        }
        return ret;
    }

    public boolean animateBody(int[][][] body, int count, int kizami) {
        return this.animateBody(body, count, kizami, false);
    }

    public boolean animateBody(int[][][] body, int count, int kizami, boolean isLoop) {
        if (kizami <= 0) {
            return false;
        }
        if (isLoop && 1 < body.length) {
            count %= kizami * (body.length - 1);
        }
        return this.getAnimatedBody(body, this.mBody[0], this.mBody[1], count, kizami);
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        double centerX = this.mDrawX;
        double centerY = this.mDrawY + this.mSizeH / 2;
        double tilt = this.mTilt;
        this.setProperBodyColor(g);
        g.saveTransform();
        g.rotate(-tilt, centerX, centerY);
        if (this.mDrawScale != 0.0f) {
            g.saveStroke();
            g.setStroke(this.mDrawScale);
        }
        this.paintBody(g, this.mX, this.mY, this.mScale, this.mIsDirRight);
        if (this.mDrawScale != 0.0f) {
            g.restoreStroke();
        }
        g.restoreTransform();
    }

    public void setBodyColor(SKMColor color) {
        this.mBodyColor = color;
    }

    public SKMColor getBodyColor() {
        return this.mBodyColor;
    }

    public void setDeadColor(SKMColor color) {
        this.mDeadColor = color;
    }

    public SKMColor getDeadColor() {
        return this.mDeadColor;
    }

    protected void setProperBodyColor(SKMGraphics g) {
        g.setColor(this.mEnergy == 0 ? this.mDeadColor : this.mBodyColor);
    }

    protected void paintBody(SKMGraphics g, int[] bodyX, int[] bodyY) {
        this.paintBody(g, bodyX, bodyY, this.mDrawX, this.mDrawY, this.mScale, this.mIsDirRight);
    }

    protected void paintBody(SKMGraphics g, int x, int y, double scale, boolean isReverse) {
        this.paintBody(g, this.mBody[0], this.mBody[1], x, y, scale, isReverse);
    }

    protected void paintBody(SKMGraphics g, int[] bodyX, int[] bodyY, int x, int y, double scale, boolean isReverse) {
        int i;
        for (i = 0; i < bodyX.length; ++i) {
            this.mBodyTmp[0][i] = bodyX[i];
            this.mBodyTmp[1][i] = bodyY[i];
        }
        for (i = 0; i < bodyX.length; ++i) {
            if (isReverse) {
                int[] nArray = this.mBodyTmp[0];
                int n = i;
                nArray[n] = nArray[n] * -1;
            }
            if (this.mIsScaleBody) {
                this.mBodyTmp[0][i] = x + this.mBodyTmp[0][i];
                this.mBodyTmp[1][i] = y + this.mBodyTmp[1][i];
                continue;
            }
            this.mBodyTmp[0][i] = (int)((double)this.mBodyTmp[0][i] * scale);
            this.mBodyTmp[1][i] = (int)((double)this.mBodyTmp[1][i] * scale);
            int[] nArray = this.mBodyTmp[0];
            int n = i;
            nArray[n] = nArray[n] + x;
            int[] nArray2 = this.mBodyTmp[1];
            int n2 = i;
            nArray2[n2] = nArray2[n2] + y;
        }
        this.paintManBody(g, this.mBodyTmp[0], this.mBodyTmp[1], scale);
    }

    protected void paintManBody(SKMGraphics g, int[] bodyX, int[] bodyY, double scale) {
        for (int i = 0; i < bodyX.length - 1; ++i) {
            if (i == 1 || i == 3 || i == 6 || i == 8) continue;
            g.drawLine(bodyX[i], bodyY[i], bodyX[i + 1], bodyY[i + 1]);
        }
        g.drawLine(bodyX[1], bodyY[1], bodyX[4], bodyY[4]);
        g.drawLine(bodyX[3], bodyY[3], bodyX[5], bodyY[5]);
        g.drawLine(bodyX[7], bodyY[7], bodyX[5], bodyY[5]);
        g.drawLine(bodyX[9], bodyY[9], bodyX[4], bodyY[4]);
        this.paintFace(g, bodyX, bodyY, scale);
    }

    protected void paintFace(SKMGraphics g, int[] bodyX, int[] bodyY, double scale) {
        int r = SKMUtil.toInt(this.mFaceR * scale);
        g.fillOval(bodyX[6] - r, bodyY[6] - r, 2 * r, 2 * r);
    }
}

