/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import java.util.Map;
import javax.sound.midi.Sequence;
import jp.ne.sk_mine.util.sound.MidiSequencer;
import jp.ne.sk_mine.util.sound.Player;

final class MidiPlayThread
extends Thread {
    private boolean mIsStop;
    private boolean mIsLoop;
    private boolean mIsFinished;
    private Sequence mSequence;
    private Map<String, MidiSequencer> mSeqMap;
    private Player mPlayer;
    private String mName;

    MidiPlayThread(String name, Sequence sequence, boolean isLoop, Map<String, MidiSequencer> seqMap, Player player) {
        this.mName = name;
        this.mSequence = sequence;
        this.mIsLoop = isLoop;
        this.mSeqMap = seqMap;
        this.mPlayer = player;
    }

    void stopToPlay() {
        this.mIsStop = true;
    }

    String getMidiName() {
        return this.mName;
    }

    boolean isFinished() {
        return this.mIsFinished;
    }

    @Override
    public void run() {
        MidiSequencer sequencer = new MidiSequencer(this.mSequence);
        this.mSeqMap.put(this.mName, sequencer);
        sequencer.setLoop(this.mIsLoop);
        if (this.mPlayer.isPlayable() && !this.mIsStop) {
            sequencer.play();
        }
    }
}

