/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.sound;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import jp.ne.sk_mine.util.sound.MidiPlayThread;
import jp.ne.sk_mine.util.sound.MidiSequencer;
import jp.ne.sk_mine.util.sound.Player;

public final class MidiPlayer
extends Player {
    private boolean isSaveLastBgmName_;
    private String lastBgmName_;
    private Map<String, String> nameMap_;
    private Map<String, Sequence> sequenceMap_;
    private Map<String, MidiSequencer> sequencerMap_;
    private List<MidiPlayThread> mPlayThreadList;

    public MidiPlayer(boolean isSaveLastBgmName) {
        this.isSaveLastBgmName_ = isSaveLastBgmName;
        this.nameMap_ = new HashMap<String, String>();
        this.sequenceMap_ = new HashMap<String, Sequence>();
        this.sequencerMap_ = new HashMap<String, MidiSequencer>();
        this.mPlayThreadList = new ArrayList<MidiPlayThread>();
    }

    @Override
    public boolean load(String name, String resourceName) {
        try {
            Sequence sequence = null;
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            sequence = MidiSystem.getSequence(in);
            if (sequence != null) {
                this.sequenceMap_.put(name, sequence);
                this.nameMap_.put(name, resourceName);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error in " + this.getClass() + ".load(): \"" + resourceName + "\"");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean load(String name, String resourceName, int loopStartPos) {
        return this.load(name, resourceName);
    }

    @Override
    public void preload() {
        Iterator<Map.Entry<String, String>> itr = this.nameMap_.entrySet().iterator();
        while (itr.hasNext()) {
            this.preload(itr.next().getKey());
        }
    }

    @Override
    public void preload(String name) {
        MidiSequencer sequencer = this.sequencerMap_.get(name);
        if (sequencer == null) {
            Sequence sequence = this.sequenceMap_.get(name);
            if (sequence == null) {
                return;
            }
            sequencer = new MidiSequencer(sequence);
            sequencer.preload();
            this.sequencerMap_.put(name, sequencer);
        }
    }

    @Override
    public boolean hasName(String name) {
        return this.nameMap_.containsKey(name);
    }

    @Override
    public final void play(String name, boolean isLoop, Player.PlayMode playMode) {
        Sequence sequence;
        if (this.isSaveLastBgmName_) {
            this.lastBgmName_ = name;
        }
        if ((sequence = this.sequenceMap_.get(name)) == null) {
            return;
        }
        MidiSequencer sequencer = this.sequencerMap_.get(name);
        if (sequencer == null) {
            for (int i = this.mPlayThreadList.size() - 1; 0 <= i; --i) {
                MidiPlayThread t = this.mPlayThreadList.get(i);
                if (!t.isFinished()) continue;
                this.mPlayThreadList.remove(t);
            }
            MidiPlayThread thread = new MidiPlayThread(name, sequence, isLoop, this.sequencerMap_, this);
            this.mPlayThreadList.add(thread);
            thread.start();
            return;
        }
        if (playMode == Player.PlayMode.SINGLE && sequencer.isPlaying()) {
            return;
        }
        if (playMode == Player.PlayMode.STOP_PREVIOUS) {
            sequencer.stop();
        }
        sequencer.setLoop(isLoop);
        if (this.isPlayable()) {
            sequencer.play();
        }
    }

    public final void play() {
        if (this.lastBgmName_ == null || !this.isPlayable()) {
            return;
        }
        MidiSequencer sequencer = this.sequencerMap_.get(this.lastBgmName_);
        if (sequencer == null || sequencer.isPlaying()) {
            return;
        }
        this.play(this.lastBgmName_, sequencer.isLoop());
    }

    public final void pause(String name) {
        MidiSequencer sequencer = this.sequencerMap_.get(name);
        if (sequencer != null) {
            sequencer.pause();
        }
    }

    public final void pause() {
        if (this.lastBgmName_ == null) {
            return;
        }
        this.pause(this.lastBgmName_);
    }

    @Override
    public final void stop(String name) {
        for (int i = this.mPlayThreadList.size() - 1; 0 <= i; --i) {
            MidiPlayThread t = this.mPlayThreadList.get(i);
            if (!t.getMidiName().equals(name)) continue;
            t.stopToPlay();
        }
        MidiSequencer sequencer = this.sequencerMap_.get(name);
        if (sequencer != null) {
            sequencer.stop();
        }
    }

    public final void stop() {
        if (this.lastBgmName_ == null) {
            return;
        }
        this.stop(this.lastBgmName_);
    }

    @Override
    public final void stopAll() {
        for (int i = this.mPlayThreadList.size() - 1; 0 <= i; --i) {
            this.mPlayThreadList.get(i).stopToPlay();
        }
        Iterator<Map.Entry<String, MidiSequencer>> itr = this.sequencerMap_.entrySet().iterator();
        while (itr.hasNext()) {
            itr.next().getValue().stop();
        }
    }

    public void reset() {
        this.lastBgmName_ = null;
    }

    @Override
    public void finalize() {
        Iterator<Map.Entry<String, MidiSequencer>> itr = this.sequencerMap_.entrySet().iterator();
        while (itr.hasNext()) {
            itr.next().getValue().closeSequencer();
        }
    }
}

