//---------------------------------------------------------------------------
#include <vcl.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <dos.h>
#include <string.h>
#include <registry.hpp>
#include <mmsystem.h>
#include <shellapi.h>
#pragma hdrstop

#include "fCPMain.h"
#include "AboutBox.h"
#include "fHighScore.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmCPMain *frmCPMain;

bool isPlayMode;
bool isGameOver;
int countDown;
long tickStart;
long tickTotal;
int challengeCount;
bool isEndWithRegDelete;
const char regTitle[] = "ClickPenguin";
//TImage *tImageList[] = { imgPentan, imgSyowa, imgSyowaColored, imgMoon, imgMoonYellow };

AnsiString exePath;   // path of exefile's directory.

// 1Q[̃NbN(ver 20255Ɍ炵)
int trynum=5;
const int MAXTRYNUM=10;

int eachtime[MAXTRYNUM];


//---------------------------------------------------------------------------
__fastcall TfrmCPMain::TfrmCPMain(TComponent* Owner)
    : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TfrmCPMain::FormCreate(TObject *Sender)
{
    randomize();
    int i,j;
    isEndWithRegDelete = false;

    
    // O[oɑ邽߂̎葱
  //  TImage *t[] = { imgPentan, imgSyowa, imgSyowaColored, imgMoon, imgMoonYellow };

//    tImageList = t;

    // NbN摜z񏉊(Ƃꂢȕ@Ǝv)
    tImageList[0] = imgPentan;
    tImageList[1] = imgSyowa;
    tImageList[2] = imgSyowaColored;
    tImageList[3] = imgMoon;
    tImageList[4] = imgMoonYellow;

    // VbtXg
    tShuffleList[0] = imgSyowa;
    tShuffleList[1] = imgMoonYellow;
    tShuffleList[2] = imgPentan;
    tShuffleList[3] = imgMoon;
    tShuffleList[4] = imgSyowaColored;



    
     exePath = ExtractFilePath(Application->ExeName);


    /*   *****      WXgݒǂݍ             */

    TRegIniFile *ini = new TRegIniFile("Software\\TF Software");

    for (i = 0; i < LEVELNUM; i++) {

        for (j = 0; j < 5; j++) {

    	    high[i][j] = new shighScore;
        }

    }


    // ̑ݒǂݍ

    isSoundEnabled = ini->ReadBool(regTitle,"Sound",true);
    difficulty = ini->ReadInteger(regTitle,"LastDifficulty",0);


    // OK

    AnsiString as; //
    as = regTitle;
    for (i = 0; i < LEVELNUM; i++) {
        for (j = 0; j < 5; j++) {
            high[i][j]->time = ini->ReadInteger(as+"\\HighScore"+IntToStr(i+1),"Time"+IntToStr(j+1),(10000+j*2000));
            high[i][j]->name = ini->ReadString(as+"\\HighScore"+IntToStr(i+1),"Name"+IntToStr(j+1),"Pentan");
            high[i][j]->score = ini->ReadInteger(as+"\\HighScore"+IntToStr(i+1),"Score"+IntToStr(j+1),60-(j*5));
        }
    }


    delete ini;
    //  WXgǂݍݏI


    mnuOptionSound->Checked = isSoundEnabled;

    mnuLevelSelect(NULL);

}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::FormDestroy(TObject *Sender)
{
    int i,j;


    // WXg
    TRegIniFile *ini = new TRegIniFile("Software\\TF Software");
   // AnsiString as;
   // as = regTitle;

   // Application->MessageBox(as.c_str(),"WXg̍폜", MB_ICONINFORMATION);


    if (isEndWithRegDelete == true) {
            ini->EraseSection(regTitle);
            Application->MessageBox("WXg폜܂B",
            "WXg̍폜", MB_ICONINFORMATION);
    } else {

      ini->WriteInteger(regTitle,"LastDifficulty",difficulty);
      ini->WriteBool(regTitle,"Sound",isSoundEnabled);

      for (i = 0; i < LEVELNUM; i++) {
          for (j = 0; j < 5; j++) {
              ini->WriteInteger((AnsiString)regTitle+"\\HighScore"+IntToStr(i+1),"Time"+IntToStr(j+1),high[i][j]->time);
              ini->WriteString((AnsiString)regTitle+"\\HighScore"+IntToStr(i+1),"Name"+IntToStr(j+1),high[i][j]->name);
              ini->WriteInteger((AnsiString)regTitle+"\\HighScore"+IntToStr(i+1),"Score"+IntToStr(j+1),high[i][j]->score);
          }
      }

    }


    delete ini;


    for (i = 0; i < LEVELNUM; i++) {
        for (j = 0; j < 5; j++) {
    	    delete high[i][j];
        }
    }

}
//---------------------------------------------------------------------------


void __fastcall TfrmCPMain::mnuExitClick(TObject *Sender)
{

    GetAsyncKeyState('Z'); // obt@ zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz


    if (GetAsyncKeyState('Z')) {
        if (Application->MessageBox("ACXg[̂߂ɂ̃\tg\nWXg폜܂?",
            "WXg̍폜",MB_YESNO | MB_ICONINFORMATION) == IDYES) {
            isEndWithRegDelete = true;

        }
        else {
            return;
        }

    }


    Close();
        
}
//---------------------------------------------------------------------------
void __fastcall TfrmCPMain::imgClickableMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
        long tickTime;

        tickTime = GetTickCount(); // ܂Ԃ擾Ă


// NbNƂ
     if (isPlayMode) {

        tickTime = tickTime - tickStart;
        playSound("ID_WAVECLICK");
    //    ShowMessage("Time: " + IntToStr(tickTime) + "ms");

        imgClickable->Visible = false;


        eachtime[challengeCount-1] = tickTime;
        tickTotal += tickTime;

        challengeCount++;

                if (clickImage == -2 ) {
          // Vbt

          imgClickable->Picture = tShuffleList[(challengeCount-1)%5]->Picture;
        } else if (clickImage == -1 ) {
         // 
          imgClickable->Picture = tImageList[(challengeCount-1)%5]->Picture;


        }


        StatusBar->Panels->Items[1]->Text = "Last: " + IntToStr((int)tickTime)+ "ms";
        StatusBar->Panels->Items[2]->Text = "Total: " + IntToStr((int)tickTotal)+ "ms";



        if (challengeCount > trynum) {

            isGameOver = true;
            isPlayMode = false;
            countDown = 0;
            tmrMain->Enabled = false;
            StatusBar->Panels->Items[0]->Text = "I";
            mnuLevel->Enabled = true;
            mnuTrynum->Enabled = true;


            // o[W

            int score;
            score = getScore(eachtime,trynum);

            AnsiString as;
            if (mnuEnglish->Checked == true ) {
               as ="Time:" + IntToStr((__int64)tickTotal) + "ms\n" + "Score : " + IntToStr(score)+ "points";
            } else {
               as ="̃^C:" + IntToStr((__int64)tickTotal) + "ms\n" + "XRA : " + IntToStr(score)+ "_";
            }
            Application->MessageBox(as.c_str(),"Score", MB_ICONINFORMATION | MB_OK);

            checkBestTime(tickTotal,score);


            btnStart->Visible = true;
            lblCountDown->Caption= "Click the Penguin!";
        }
        else {
            countDown = 4;
            tmrMain->Enabled = true;

            StatusBar->Panels->Items[0]->Text = "Challenge: " + IntToStr(challengeCount);

        //    StatusBar->Panels->Items[1]->Text = "Last: " + IntToStr(tickTime)+ "ms";
        //    StatusBar->Panels->Items[2]->Text = "Total: " + IntToStr(tickTotal)+ "ms";

        }
      //  StatusBar.Panels[1]->Text = "Last: " + FloatToStr(tickTime / 1000.0);


     }




}
//---------------------------------------------------------------------------
// XRAZo
// 600~b𒴂ƌ_݂łAY܂()
int TfrmCPMain::getScore(int *times,const int count) {

    const int standardtime = 600;
    int substractpoint;   // _
    int i;
    int eachsubst;

    substractpoint = 0;


    for (i = 0; i < count; i++) {

        eachsubst = times[i] - standardtime;
        if (eachsubst <0) eachsubst = 0;

        eachsubst = eachsubst/50;
        if (eachsubst > (100/count)) eachsubst = 100/count;

        substractpoint += eachsubst;


    }

    return (100-substractpoint);




}

//---------------------------------------------------------------------------

// nCXRÃ`FbN
void TfrmCPMain::checkBestTime(const int cleartime, const int score) {

        int i;
        int rank = 0,work;

        for (i=5;i>=1;i--) {

            if ( cleartime < high[difficulty][i-1]->time ) {

                work = high[difficulty][i-1]->time;
                high[difficulty][i-1]->time = cleartime;

                if (i != 5 ) high[difficulty][i]->time = work;

                work = high[difficulty][i-1]->score;
                high[difficulty][i-1]->score = score;

                if (i != 5 ) {
                    high[difficulty][i]->score = work;
                    high[difficulty][i]->name = high[difficulty][i-1]->name;
                }
                rank = i;
            }
            else {
                break;
            }
        }

        if ( rank > 0 ) {  //Tʈȓ

            frmHighScore = new TfrmHighScore(this);

            frmHighScore->Edit1->Visible = true;
            frmHighScore->Edit1->Top = frmHighScore->lblName[rank]->Top;
            frmHighScore->Edit1->Left = frmHighScore->lblName[rank]->Left;
            frmHighScore->lblName[rank]->Visible = false;
            frmHighScore->Edit1->BringToFront();

            frmHighScore->ShowModal();

            high[difficulty][rank-1]->name = frmHighScore->Edit1->Text;

            delete frmHighScore;

        }



}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::btnStartClick(TObject *Sender)
{
    // X^[g{^Ƃ̓j[̃X^[gƓɂ
    mnuStartClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TfrmCPMain::mnuStartClick(TObject *Sender)
{
        imgPentan->Visible = false;
        imgSyowa->Visible = false;
        imgSyowaColored->Visible = false;
        imgMoon->Visible = false;
        imgMoonYellow->Visible = false;

  //  if (isPlayMode == false) {

        isPlayMode = true;
        tmrMain->Enabled = true;
        countDown = 4;
        btnStart->Visible = false;
        challengeCount = 1;
        tickTotal = 0;
        tmrMainTimer(NULL);
        isGameOver = false;
        imgClickable->Visible = false;
        mnuLevel->Enabled = false;
        mnuTrynum->Enabled = false;
        if (clickImage == -2 ) {
          // Vbt

          imgClickable->Picture = tShuffleList[0]->Picture;
        } else if (clickImage == -1 ) {
         // 
          imgClickable->Picture = tImageList[0]->Picture;


        }

        
        StatusBar->Panels->Items[0]->Text = "Challenge: " + IntToStr(challengeCount);
        
        StatusBar->Panels->Items[1]->Text = "";
        StatusBar->Panels->Items[2]->Text = "";


  //  }



}
//---------------------------------------------------------------------------
void __fastcall TfrmCPMain::tmrMainTimer(TObject *Sender)
{
    if (countDown > 0) {
        countDown--;
        //StatusBar->Panels->Items[0]->Text = "Challenge: " + IntToStr(challengeCount);

        lblCountDown->Caption = "Challenge: " + IntToStr(challengeCount) + "/" + IntToStr(trynum)
         + "\n" +IntToStr(countDown);
        
        if (countDown != 0) {
           playSound("ID_WAVEREADY");
        }
        else {
           playSound("ID_WAVESET");
        }
    }

    if (countDown == 0) {

        imgClickable->Visible = true;

        imgClickable->Left = (rand() % (ClientWidth - 32));
        imgClickable->Top = (rand() % (ClientHeight - 32 - StatusBar->Height));
        countDown--;
        tickStart = GetTickCount();
        tmrMain->Enabled = false;
    }



}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::FormResize(TObject *Sender)
{

    lblCountDown->Left = (this->ClientWidth-lblCountDown->Width)/2;
    lblCountDown->Top = (this->ClientHeight- lblCountDown->Height)/2;

    
    btnStart->Left = (this->ClientWidth-btnStart->Width) /2;
    btnStart->Top = (lblCountDown->Top + lblCountDown->Height +10);


}
//---------------------------------------------------------------------------


void __fastcall TfrmCPMain::mnuLevelSelect(TObject *Sender)
{

    int levelsizes[][2] = { {400, 300},
                            {600, 450},
                            {750, 550},
                            {500, 700},
                            { -1,  -1},
                          };

    TMenuItem *mnuLev[] = { mnuLevelEasy, mnuLevelNormal, mnuLevelDifficult,mnuLevelTablet, mnuLevelFullScreen };



    if (Sender != NULL) {
      difficulty = ((TMenuItem *)Sender)->Tag;
    }

    mnuLev[difficulty]->Checked = true;

    Visible = false;
    if (levelsizes[difficulty][0] == -1) {
       // Sʃ[h
       Left = 0;
       Top = 0;
       Width = Screen->Width;
       Height = Screen->Height;

    } else {

       ClientWidth = levelsizes[difficulty][0];
       ClientHeight = levelsizes[difficulty][1];
       Left = (Screen->Width-Width)/2;
       Top = (Screen->Height- Height)/2;
    }

    Visible = true;
}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::mnuAboutClick(TObject *Sender)
{
    frmAbout->title = "Click the Penguin 2025 Ver. 4.01";
    frmAbout->ShowModal();

}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::mnuHighScoreClick(TObject *Sender)
{
    char chlevel[][10] = { "()","()","(㋉)","(c)" };
    char chrtitle[20];

    //v^Cgo[p
    strcpy(chrtitle,"BestTime");
    strcat(chrtitle,chlevel[difficulty]);

    frmHighScore = new TfrmHighScore(this);
    frmHighScore->Caption = chrtitle;
    frmHighScore->ShowModal();
    delete frmHighScore;

}
//---------------------------------------------------------------------------

/*
    // EXE ̃pX߂ ֐ (ExtractFilePath sgp)
    int i;

    int num;
    num = _argc;
    int lastslashpoint;  // Ō̃pX \ ̈ʒu


  //  char *pt,*lastptr;
    char exename[255];

    strcpy(exename, _argv[0]);


 //   i = 0;

    for (i=0;exename[i] !='\0'; i++) {

        if (exename[i] == '\\') {
            lastslashpoint = i;
            ShowMessage(i);
        }
    }

    exename[lastslashpoint +1] = '\0';
    ShowMessage(exename);

    ShowMessage(lastslashpoint);

    for (i = 0; i< _argc; i++) {

        ShowMessage(_argv[i]);

   }

    ShowMessage(num);
 */

//---------------------------------------------------------------------------


//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::mnuOptionSoundClick(TObject *Sender)
{

    mnuOptionSound->Checked = !(mnuOptionSound->Checked);
    isSoundEnabled = mnuOptionSound->Checked;


}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::mnuReadmeClick(TObject *Sender)
{
    AnsiString fileReadme;

    fileReadme = exePath + "ClickPen.txt";
    //ShowMessage(fileReadme);
    ShellExecute( Handle, "open",fileReadme.c_str(), NULL, exePath.c_str(), SW_MAXIMIZE);
}
//---------------------------------------------------------------------------
void TfrmCPMain::playSound(const AnsiString sndName)
{
    if (isSoundEnabled == false) return;

    PlaySound(sndName.c_str(),HInstance,SND_ASYNC | SND_NODEFAULT |SND_RESOURCE);

}

//---------------------------------------------------------------------------



void __fastcall TfrmCPMain::mnuCharClick(TObject *Sender)
{
     TMenuItem *s = (TMenuItem *)Sender;
     int index = s->Tag;
     clickImage = index;
     //ShowMessage(index);

     if (index == -2 ) {
       // Vbt
        if (challengeCount >= 1) {

           imgClickable->Picture = tShuffleList[(challengeCount-1)%5]->Picture;
        }

     } else if (index == -1 ) {
       // 
        if (challengeCount >= 1) {

           imgClickable->Picture = tImageList[(challengeCount-1)%5]->Picture;
        }

     } else {
        imgClickable->Picture = tImageList[index]->Picture;
     }

     //imgClickable->Picture = imgMoon->Picture;
     s->Checked = true;
}
//---------------------------------------------------------------------------




void __fastcall TfrmCPMain::mnuEnglishClick(TObject *Sender)
{
     ((TMenuItem*)Sender)->Checked = true;
     // ۉR[h(English)
     mnuGame->Caption = "&Game";
     mnuChara->Caption = "&Image";
     mnuHelp->Caption = "&Help";
     mnuStart->Caption = "Start(&N)";
     mnuAbort->Caption = "&Abort";
     mnuLevel->Caption = "&Level";
     mnuLevelEasy->Caption = "&Easy";
     mnuLevelNormal->Caption = "&Normal";
     mnuLevelDifficult->Caption = "&Difficult";
     mnuLevelTablet->Caption = "&Tablet";
     mnuLevelFullScreen->Caption = "&Full Screen";
     mnuTrynum->Caption="Number of Challenge(&T)";

     mnuOptionSound->Caption = "&Sound";

     mnuHighScore->Caption = "&HighScore...";
     mnuExit->Caption = "E&xit";



     mnuCharSeaquancial->Caption = "&Sequancial";
     mnuCharShuffle->Caption = "Shuffle(&R)";
     mnuCharPentan->Caption = "&Pentan";
     mnuCharSyowa->Caption = "Showa Smile(&BA-90)";
     mnuCharSyowaColored->Caption = "Showa Smile(Usudaidai)";
     mnuCharMoon->Caption = "Showa Mikaduki";
     mnuCharMoonYellow->Caption = "Showa Mikaduki(Yellow)";
     mnuReadme->Caption = "&Readme";
     mnuAbout->Caption = "&About...";

     btnStart->Caption = "Start";


}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::mnuJapaneseClick(TObject *Sender)
{
     ((TMenuItem*)Sender)->Checked = true;
     // ۉR[h({)
     mnuGame->Caption = "Q[(&G)";
     mnuChara->Caption = "LN^(&C)";
     mnuHelp->Caption = "wv(&H)";
     mnuStart->Caption = "X^[g(&N)";
     mnuAbort->Caption = "f(&A)";
     mnuLevel->Caption = "x(&L)";
     mnuLevelEasy->Caption = "(&E)";
     mnuLevelNormal->Caption = "(&N)";
     mnuLevelDifficult->Caption = "㋉(&D)";
     mnuLevelTablet->Caption = "c(&T)";
     mnuLevelFullScreen->Caption = "S(&F)";
     mnuTrynum->Caption="`W(&T)";

     mnuOptionSound->Caption = "TEh(&S)";

     mnuHighScore->Caption = "nCXRA(&H)...";
     mnuExit->Caption = "I(&X)";



     mnuCharSeaquancial->Caption = "Ԃɕ\(&S)";
     mnuCharShuffle->Caption = "Vbt(&R)";
     mnuCharPentan->Caption = "y^(&P)";
     mnuCharSyowa->Caption = "aΊ當(&BA-90)";
     mnuCharSyowaColored->Caption = "aΊ當 F(&C)";
     mnuCharMoon->Caption = "aO(&M)";
     mnuCharMoonYellow->Caption = "aOF(&Y)";
     mnuReadme->Caption = "hLg(&R)";
     mnuAbout->Caption = "o[W(&A)...";

     btnStart->Caption = "X^[g";

}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::mnuTryClick(TObject *Sender)
{
     // `W񐔕ύX
     ((TMenuItem*)Sender)->Checked = true;
     TMenuItem* s = ((TMenuItem*)Sender);
     trynum = s->Tag;

}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::imgSyowaColoredClick(TObject *Sender)
{
  // fobOpɉȂ܂B
  playSound("ID_WAVESET");
}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::imgSyowaClick(TObject *Sender)
{
  // fobOpɉȂ܂B
  playSound("ID_WAVEREADY");
}
//---------------------------------------------------------------------------

void __fastcall TfrmCPMain::imgMoonYellowClick(TObject *Sender)
{
  // fobOpɉȂ܂B
  playSound("ID_WAVECLICK");
}
//---------------------------------------------------------------------------

