Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName System.Drawing

# EBhEőOʂɈێ邽߂Win32 API
Add-Type @"
using System;
using System.Runtime.InteropServices;

public class MouseHelper {
    [DllImport("user32.dll")]
    public static extern bool SetWindowPos(IntPtr hWnd, IntPtr hWndInsertAfter, int X, int Y, int cx, int cy, uint uFlags);
    
    public static readonly IntPtr HWND_TOPMOST = new IntPtr(-1);
    public const uint SWP_NOMOVE = 0x0002;
    public const uint SWP_NOSIZE = 0x0001;
    public const uint SWP_SHOWWINDOW = 0x0040;
}
"@

# ݒt@C̃pX
$iniFilePath = Join-Path $PSScriptRoot "PsClock.ini"

# INIt@Cݒǂݍފ֐
function Get-IniValue {
    param(
        [string]$FilePath,
        [string]$Section,
        [string]$Key,
        [string]$Default = ""
    )
    
    if (-not (Test-Path $FilePath)) {
        return $Default
    }
    
    try {
        $content = Get-Content $FilePath -ErrorAction Stop
        $inSection = $false
        
        foreach ($line in $content) {
            $line = $line.Trim()
            
            # ZNV̔
            if ($line -match "^\[$Section\]$") {
                $inSection = $true
                continue
            }
            
            # ʂ̃ZNVɓI
            if ($inSection -and $line -match "^\[.+\]$") {
                break
            }
            
            # L[ƒl擾
            if ($inSection -and $line -match "^$Key\s*=\s*(.+)$") {
                return $matches[1].Trim()
            }
        }
    }
    catch {
        return $Default
    }
    
    return $Default
}

# INIt@Cɐݒފ֐
function Set-IniValue {
    param(
        [string]$FilePath,
        [string]$Section,
        [string]$Key,
        [string]$Value
    )
    
    $content = @()
    $sectionFound = $false
    $keyUpdated = $false
    
    # ̃t@Cǂݍ
    if (Test-Path $FilePath) {
        $content = Get-Content $FilePath
        $inSection = $false
        $newContent = @()
        
        foreach ($line in $content) {
            $trimmedLine = $line.Trim()
            
            # ZNV̔
            if ($trimmedLine -match "^\[$Section\]$") {
                $inSection = $true
                $sectionFound = $true
                $newContent += $line
                continue
            }
            
            # ʂ̃ZNVɓꍇ
            if ($inSection -and $trimmedLine -match "^\[.+\]$") {
                # ZNVŃL[Ȃꍇ͒ǉ
                if (-not $keyUpdated) {
                    $newContent += "$Key=$Value"
                    $keyUpdated = $true
                }
                $inSection = $false
            }
            
            # L[ꍇ͒lXV
            if ($inSection -and $trimmedLine -match "^$Key\s*=") {
                $newContent += "$Key=$Value"
                $keyUpdated = $true
                continue
            }
            
            $newContent += $line
        }
        
        # ZNVL[Ȃꍇ
        if ($sectionFound -and -not $keyUpdated) {
            $newContent += "$Key=$Value"
            $keyUpdated = $true
        }
        
        $content = $newContent
    }
    
    # ZNVȂꍇ͐VK쐬
    if (-not $sectionFound) {
        if ($content.Count -gt 0) {
            $content += ""
        }
        $content += "[$Section]"
        $content += "$Key=$Value"
    }
    
    # t@Cɏ
    $content | Set-Content $FilePath -Encoding UTF8
}

# CtH[̍쐬
$form = New-Object System.Windows.Forms.Form
$form.Text = "Desktop Clock"
$form.Size = New-Object System.Drawing.Size(75, 35)
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::None
$form.StartPosition = [System.Windows.Forms.FormStartPosition]::Manual
$form.TopMost = $true
$form.ShowInTaskbar = $false
$form.BackColor = [System.Drawing.Color]::Magenta
$form.TransparencyKey = [System.Drawing.Color]::Magenta
$form.AllowTransparency = $true
$form.Opacity = 1.0

# ÖʒuǂݍށiۑĂȂꍇ͉ʉEɔzuj
$savedX = Get-IniValue -FilePath $iniFilePath -Section "Settings" -Key "X" -Default ""
$savedY = Get-IniValue -FilePath $iniFilePath -Section "Settings" -Key "Y" -Default ""

if ($savedX -ne "" -and $savedY -ne "") {
    # ۑꂽʒugp
    $form.Location = New-Object System.Drawing.Point([int]$savedX, [int]$savedY)
} else {
    # ftHgʒuiʉEjgp
    $screen = [System.Windows.Forms.Screen]::PrimaryScreen
    $workingArea = $screen.WorkingArea
    $form.Location = New-Object System.Drawing.Point(
        ($workingArea.Right - $form.Width + 50),
        ($workingArea.Bottom - $form.Height)
    )
}

# EBhEőOʂɋIɔzu֐
function Set-TopMostWindow {
    param($formHandle)
    [MouseHelper]::SetWindowPos(
        $formHandle,
        [MouseHelper]::HWND_TOPMOST,
        0, 0, 0, 0,
        [MouseHelper]::SWP_NOMOVE -bor [MouseHelper]::SWP_NOSIZE -bor [MouseHelper]::SWP_SHOWWINDOW
    ) | Out-Null
}

# \郉x̍쐬
$label = New-Object System.Windows.Forms.Label
$label.Size = New-Object System.Drawing.Size(73, 33)
$label.Location = New-Object System.Drawing.Point(1, 1)
$label.Font = New-Object System.Drawing.Font("Segoe UI", 18, [System.Drawing.FontStyle]::Bold)
$label.ForeColor = [System.Drawing.Color]::White
$label.BackColor = [System.Drawing.Color]::Magenta
$label.TextAlign = [System.Drawing.ContentAlignment]::MiddleCenter

# x̃JX^`Cxgit̔`j
$label.Add_Paint({
    param($sender, $e)
    
    # \eLXg̏ꍇ͉Ȃ
    if ([string]::IsNullOrEmpty($sender.Text)) { return }
    
    $graphics = $e.Graphics
    $graphics.SmoothingMode = [System.Drawing.Drawing2D.SmoothingMode]::AntiAlias
    $graphics.TextRenderingHint = [System.Drawing.Text.TextRenderingHint]::AntiAlias
    
    $text = $sender.Text
    $font = $sender.Font
    $rect = New-Object System.Drawing.RectangleF(0, 0, $sender.Width, $sender.Height)
    
    # ̔zuݒij
    $format = New-Object System.Drawing.StringFormat
    $format.Alignment = [System.Drawing.StringAlignment]::Center
    $format.LineAlignment = [System.Drawing.StringAlignment]::Center
    
    # `i81sNZ炵ĕ`j
    $outlineBrush = New-Object System.Drawing.SolidBrush([System.Drawing.Color]::Black)
    for ($dx = -1; $dx -le 1; $dx++) {
        for ($dy = -1; $dy -le 1; $dy++) {
            if ($dx -ne 0 -or $dy -ne 0) {
                $outlineRect = New-Object System.Drawing.RectangleF(($rect.X + $dx), ($rect.Y + $dy), $rect.Width, $rect.Height)
                $graphics.DrawString($text, $font, $outlineBrush, $outlineRect, $format)
            }
        }
    }
    
    # 𒆉ɕ`
    $textBrush = New-Object System.Drawing.SolidBrush([System.Drawing.Color]::White)
    $graphics.DrawString($text, $font, $textBrush, $rect, $format)
    
    # \[X̉
    $outlineBrush.Dispose()
    $textBrush.Dispose()
    $format.Dispose()
})

# ENbNj[̍쐬
$contextMenu = New-Object System.Windows.Forms.ContextMenuStrip
$contextMenu.ShowImageMargin = $false

# uIvj[
$exitMenuItem = New-Object System.Windows.Forms.ToolStripMenuItem
$exitMenuItem.Text = "I"
$exitMenuItem.Add_Click({
    # ^C}[~Ĕj
    $timer.Stop()
    $topMostTimer.Stop()
    $timer.Dispose()
    $topMostTimer.Dispose()
    
    # tH[
    $form.Close()
})
$contextMenu.Items.Add($exitMenuItem) | Out-Null

# uʒu𒲐vj[
$adjustMenuItem = New-Object System.Windows.Forms.ToolStripMenuItem
$adjustMenuItem.Text = "ʒu𒲐"
$adjustMenuItem.Add_Click({
    if ($script:isDraggable) {
        # hbO[hÄ݂ʒuinit@Cɕۑ
        $script:isDraggable = $false
        $adjustMenuItem.Text = "ʒu𒲐"
        $form.Cursor = [System.Windows.Forms.Cursors]::Default
        
        # ʒuۑ
        Set-IniValue -FilePath $iniFilePath -Section "Settings" -Key "X" -Value $form.Location.X.ToString()
        Set-IniValue -FilePath $iniFilePath -Section "Settings" -Key "Y" -Value $form.Location.Y.ToString()
    } else {
        # hbO[hL
        $script:isDraggable = $true
        $adjustMenuItem.Text = "ʒuŒ"
        $form.Cursor = [System.Windows.Forms.Cursors]::SizeAll
    }
})
$contextMenu.Items.Add($adjustMenuItem) | Out-Null

# tH[ɉENbNj[֘At
$form.ContextMenuStrip = $contextMenu

# tH[̉ENbNCxgij[\j
$form.Add_MouseUp({
    if ($_.Button -eq [System.Windows.Forms.MouseButtons]::Right) {
        # j[tH[̍t߂ɕ\
        $screenPoint = New-Object System.Drawing.Point(
            ($form.Location.X - 40),
            ($form.Location.Y - 45)
        )
        $contextMenu.Show($screenPoint)
    }
})

# hbO@\̎
$script:isDraggable = $false      # hbO[h̃tO
$script:mouseOffset = $null        # hbOJñ}EXʒu

# tH[̃}EX_ECxgihbOJnj
$form.Add_MouseDown({
    if ($_.Button -eq [System.Windows.Forms.MouseButtons]::Left -and $script:isDraggable) {
        $script:mouseOffset = New-Object System.Drawing.Point($_.X, $_.Y)
    }
})

# tH[̃}EXړCxgihbOj
$form.Add_MouseMove({
    if ($_.Button -eq [System.Windows.Forms.MouseButtons]::Left -and $script:isDraggable -and $script:mouseOffset) {
        # }EẌړʂvZătH[ړ
        $newLocation = New-Object System.Drawing.Point(
            ($form.Left + $_.X - $script:mouseOffset.X),
            ($form.Top + $_.Y - $script:mouseOffset.Y)
        )
        $form.Location = $newLocation
    }
})

# tH[̃}EXAbvCxgihbOIj
$form.Add_MouseUp({
    if ($_.Button -eq [System.Windows.Forms.MouseButtons]::Left) {
        $script:mouseOffset = $null
    }
})

# x̃}EX_ECxgihbOJnj
$label.Add_MouseDown({
    if ($_.Button -eq [System.Windows.Forms.MouseButtons]::Left -and $script:isDraggable) {
        $script:mouseOffset = New-Object System.Drawing.Point($_.X, $_.Y)
    }
})

# x̃}EXړCxgihbOj
$label.Add_MouseMove({
    if ($_.Button -eq [System.Windows.Forms.MouseButtons]::Left -and $script:isDraggable -and $script:mouseOffset) {
        # }EẌړʂvZătH[ړ
        $newLocation = New-Object System.Drawing.Point(
            ($form.Left + $_.X - $script:mouseOffset.X),
            ($form.Top + $_.Y - $script:mouseOffset.Y)
        )
        $form.Location = $newLocation
    }
})

# x̃}EXAbvCxgihbOI܂͉ENbNj[\j
$label.Add_MouseUp({
    if ($_.Button -eq [System.Windows.Forms.MouseButtons]::Left) {
        $script:mouseOffset = $null
    } elseif ($_.Button -eq [System.Windows.Forms.MouseButtons]::Right) {
        # j[x̍t߂ɕ\
        $screenPoint = New-Object System.Drawing.Point(
            ($form.Location.X - 40),
            ($form.Location.Y - 45)
        )
        $contextMenu.Show($screenPoint)
    }
})

# XV^C}[̐ݒi20bƂɎXVj
$timer = New-Object System.Windows.Forms.Timer
$timer.Interval = 20000  # 20b = 20000~b
$timer.Add_Tick({
    # ݎ擾ăxɕ\
    $label.Text = (Get-Date).ToString("HH:mm")
    $label.Invalidate()  # xĕ`
})

# őOʈێ^C}[̐ݒi5bƂɍőOʏԂmFEێj
$topMostTimer = New-Object System.Windows.Forms.Timer
$topMostTimer.Interval = 5000  # 5b = 5000~b
$topMostTimer.Add_Tick({
    # tH[nhLȏꍇ̂ݍőOʂɐݒ
    if ($form.Handle -ne [IntPtr]::Zero) {
        $form.TopMost = $true
        Set-TopMostWindow $form.Handle
    }
})

# N̏ݒ
$label.Text = (Get-Date).ToString("HH:mm")
$label.Invalidate()

# tH[Ƀxǉ
$form.Controls.Add($label)

# tH[\ɍőOʂݒ
$form.Add_Shown({
    Set-TopMostWindow $form.Handle
})

# ^C}[Jn
$timer.Start()
$topMostTimer.Start()

# tH[\iC[vJnj
[System.Windows.Forms.Application]::Run($form)

# AvP[VĨN[Abv
$timer.Dispose()
$topMostTimer.Dispose()
$contextMenu.Dispose()
$form.Dispose()
