/* zbgL[̓o^p *********************************************************************************************/
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Forms;
/* NXizbgL[o^EptH[j ***********************************************************************/
public class HotKeyForm : Form
{
    [DllImport("user32.dll")]
    extern static int RegisterHotKey(IntPtr HWnd, int ID, int MOD_KEY, Keys KEY);

    [DllImport("user32.dll")]
    extern static int UnregisterHotKey(IntPtr HWnd, int ID);

    const int WM_HOTKEY = 0x0312;
    public readonly int modKey;
    public readonly Keys key;
    public readonly int id;
    public readonly ThreadStart proc;

    //zbgL[o^
    public HotKeyForm(int modKey, Keys key, ThreadStart proc)
    {
        for (int i = 0x0000; i <= 0xbfff; i++)
        {
            if (RegisterHotKey(this.Handle, i, modKey, key) != 0)
            {
                this.modKey = modKey;
                this.key = key;
                this.id = i;
                this.proc = proc;
                break;
            }
        }
    }

    //EBhEbZ[WĎ
    protected override void WndProc(ref Message m)
    {
        base.WndProc(ref m);

        //zbgL[ꂽ̏
        if (m.Msg == WM_HOTKEY)
        {
            if ((int)m.WParam == this.id)
            {
                this.proc();
            }
        }
    }

    //zbgL[
    protected override void Dispose(bool disposing)
    {
        UnregisterHotKey(this.Handle, this.id);
        base.Dispose(disposing);
    }
}
//*NXizbgL[o^EptH[j ***********************************************************************/
/* NXizbgL[ptH[j *****************************************************************************/
public class HotKeyController : Form
{
    public List<HotKeyForm> HotKeyFormList;

    //zbgL[o^EptH[\ƁAEBhEbZ[W̊ĎJn
    private void HotKeyController_Load(object sender,EventArgs e)
    {
        foreach (HotKeyForm hotKeyForm in this.HotKeyFormList)
        {
            hotKeyForm.WindowState = System.Windows.Forms.FormWindowState.Minimized;
            hotKeyForm.Show();
            hotKeyForm.Hide();
        }
    }

    private void HotKeyController_FormClosing(object sender,EventArgs e)
    {
        foreach (HotKeyForm hotKeyForm in this.HotKeyFormList)
        {
            if (!hotKeyForm.IsDisposed)
            {
                hotKeyForm.Close();
            }
        }
    }

    public HotKeyController()
    {
        this.HotKeyFormList = new List<HotKeyForm>();

        this.WindowState = System.Windows.Forms.FormWindowState.Minimized;
        this.ShowInTaskbar = false;

        this.Load += HotKeyController_Load;
        this.FormClosing += HotKeyController_FormClosing;
    }
}
//*NXizbgL[ptH[j *****************************************************************************/
//*zbgL[̓o^p *********************************************************************************************/
