#====================================================================
# zbgL[̓o^p
#====================================================================
Add-Type -TypeDefinition @"
using System;
using System.Runtime.InteropServices;
using System.Threading;

public class Keyboard {
    [DllImport("user32.dll", SetLastError = true)]
    public static extern void keybd_event(byte bVk, byte bScan, uint dwFlags, uint dwExtraInfo); } // L[{[hCxgp

public class KeyboardSimulator
{
    [DllImport("user32.dll", SetLastError = true)]
    public static extern void keybd_event(byte bVk, byte bScan, uint dwFlags, uint dwExtraInfo);

    private const int KEYEVENTF_EXTENDEDKEY = 0x0001;
    private const int KEYEVENTF_KEYUP = 0x0002;
    public static void SimulateKeyPress( byte vKey )
    {
        keybd_event(vKey, 0, KEYEVENTF_EXTENDEDKEY, 0);                    // L[_E
        keybd_event(vKey, 0, KEYEVENTF_EXTENDEDKEY | KEYEVENTF_KEYUP, 0);  // L[Abv
    }
}

public class Window {
    [DllImport("user32.dll")]
    public static extern bool SetForegroundWindow(IntPtr hWnd);
    
    [DllImport("user32.dll", SetLastError = true)]
    public static extern IntPtr FindWindow(string className, string windowName);
}
"@

#* 萔` ***********************************************************************************************************#
$VK_SHIFT = 0x10
$VK_CONTROL = 0x11
$VK_ALT = 0x12
$KEYEVENTF_KEYDOWN = 0x0
$KEYEVENTF_KEYUP = 0x2
$VK_HANZEN = 0xF3
$VK_KANA = 0xF2
$VK_P = 0x50
$VK_O = 0x4F
$VK_M = 0x4D
$VK_U = 0x55
#
#/*萔` ***********************************************************************************************************#
#* NXt@Cuwp *****************************************************************************************#
$here = Split-Path $MyInvocation.MyCommand.Path -Parent
#/*NXt@Cuwp *****************************************************************************************#
#* zbgL[o^ *****************************************************************************************************#
New-Module -ArgumentList $here {
    param($here)

    # --------------------
    # J`
    # --------------------
    # zbgL[o^EĎpNXiC#j
    Add-Type `
        -ReferencedAssemblies 'System.Windows.Forms' `
        -Path (Join-Path $here 'hotkeyClass.cs')

    # CL[
    $MODKEY_LIST = @{
        ALT   = 0x0001;
        CTRL  = 0x0002;
        SHIFT = 0x0004;
        _     = 0x0000;
    }

    # nbVe[u
    filter Select-HashTable
    {
        param(
            [Alias('with')][hashtable]$HashTable,
            $DefaultKey = '_'
        )

        if($HashTable.Contains($_))
        {
            return $HashTable[$_]
        }
        else
        {
            return $HashTable[$DefaultKey]
        }
    }
    Set-Alias match Select-HashTable

    # L[CL[ƃL[R[h֕ϊ
    function ConvertTo-HotKeyArguments($KeyString)
    {
        # L[Xg
        # jCtrl + A -> CTRL,A
        $KeyList = $KeyString.ToUpper().Split('+') | foreach{$_.Trim()}

        # CL[iSĎ擾j
        $modkey = ($KeyList | match -with $MODKEY_LIST) -join ' -bor ' | iex

        # L[R[hi߂̂P擾j
        $key = ($KeyList | where{-not ($MODKEY_LIST.Contains($_))} | foreach{[Windows.Forms.Keys]::"$_"})[0]

        return $modkey,$key
    }
    Set-Alias hkargs ConvertTo-HotKeyArguments

    # --------------------
    # J`
    # --------------------
    # zbgL[o^AzbgL[ꂽɎw̃R}hs
    function Watch-HotKey($HotKeyList,$CloseKey){
        $ctl = New-Object HotKeyController

        # ezbgL[̓o^
        $HotKeyList | foreach{
            $modKey,$key = hkargs $_.KeyString
            $proc        = $_.Procedure
            $ctl.HotKeyFormList.Add((New-Object HotKeyForm($modKey,$key,$proc)))
        }

        # IpzbgL[̓o^
        $modKey,$key = hkargs $CloseKey
        $proc        = {$ctl.Close()}
        $ctl.HotKeyFormList.Add((New-Object HotKeyForm($modKey,$key,$proc)))    

        # zbgL[ĎiIpzbgL[܂Ŏj
#        [void]$ctl.Show()
        [void]$ctl.ShowDialog()
    }

    Export-ModuleMember -Function Watch-HotKey # ֐̌J
}
#/*zbgL[o^ *****************************************************************************************************#
