#====================================================================
# Loadp
#====================================================================
#!/usr/bin/env pwsh

#====================================================================
# 
#====================================================================
Param(
    [String]$fileName="save.txt"   # t@C
)

#====================================================================
# 萔`
#====================================================================
$elemNum = 6                   # ێvf
$compLen = 6                   # EBhE^Cĝv镶

#====================================================================
# DllImport
#====================================================================
Add-Type -AssemblyName UIAutomationClient 
Add-Type -Assembly System.Windows.Forms 
Add-Type @"
using System;
using System.Runtime.InteropServices;

// EnumWindowŝ
using System.Text;

public struct RECT
{
    public int Left;
    public int Top;
    public int Right;
    public int Bottom;
}

public class Win32 {
    [DllImport("user32.dll")]
    [return: MarshalAs(UnmanagedType.Bool)]
    public static extern bool EnumWindows(EnumWindowsProc lpEnumFunc, IntPtr lParam);

    [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
    public static extern int GetWindowText(IntPtr hWnd, StringBuilder lpString, int nMaxCount);

    [DllImport("user32.dll", SetLastError=true, CharSet=CharSet.Auto)]
    public static extern int GetWindowTextLength(IntPtr hWnd);

    [DllImport("user32.dll")]
    public static extern bool IsWindowVisible(IntPtr hWnd);

    [DllImport("user32.dll", SetLastError = true)]
    public static extern bool MoveWindow(IntPtr hWnd, int X, int Y, int nWidth, int nHeight, bool bRepaint);

    [DllImport("user32.dll")]
    public static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);

    public delegate bool EnumWindowsProc(IntPtr hWnd, IntPtr lParam);
}
"@

#====================================================================
# ΏۂƂȂEChEIATCY𕜌
#====================================================================
try
{
$inBuf = Get-Content $fileName
$cnt = 0

foreach ($str in $inBuf) {
    $cnt++
}
$savedWinNum = $cnt / $elemNum

$windowInfo = New-Object System.Collections.Generic.List[PSObject]

$enumWindowsCallback = {
    param([IntPtr]$hWnd, [IntPtr]$lParam)

    $length = [Win32]::GetWindowTextLength($hWnd)
    if ([Win32]::IsWindowVisible($hWnd) -and $length -ne 0) {
        $sb = New-Object System.Text.StringBuilder($length + 1)
        [void][Win32]::GetWindowText($hWnd, $sb, $sb.Capacity)
        $title = $sb.ToString()
        if (![string]::IsNullOrWhiteSpace($title)) {
            $windowInfo.Add([PSCustomObject]@{
                Handle = $hWnd
                Title = $title
            })
        }
    }
    return $true
}

$enumWindowsDelegate = [Win32+EnumWindowsProc]$enumWindowsCallback

[Win32]::EnumWindows($enumWindowsDelegate, [IntPtr]::Zero) | Out-Null

# Output all window titles and move windows
$offsetX = 0
$offsetY = 0

foreach ($window in $windowInfo)
{
#    Write-Output $window.Title
    if ($window.Title -notlike "*Microsoft Text Input Application*" -and $window.Title -notlike "explorer*"  -and $window.Title.Length -ge 6 -and $window.Title -notlike "*GNXv[[" -and $window.Title -notlike "Windows PowerShell" -and $window.Title -notlike "PsWinPos") {
        $tail = $window.Title.Substring( $window.Title.Length - $compLen, $compLen )        # 6Ŕ肷

        for( $i = 0; $savedWinNum -gt $i; $i++ )
        {
            If( $inBuf[$i * $elemNum].Substring( $inBuf[$i * $elemNum].Length - $compLen, $compLen ) -eq $tail )   # 6vꍇ
            {
                $windowElem = [System.Windows.Automation.AutomationElement]::FromHandle( $window.Handle )
                $windowPattern = $windowElem.GetCurrentPattern( [System.Windows.Automation.WindowPattern]::Pattern ) # ő剻Ԃ擾
                $res = [Win32]::ShowWindow($window.Handle, 1) # ő剻Ԃ

                [Win32]::MoveWindow($window.Handle, $inBuf[$i * $elemNum + 1], $inBuf[$i * $elemNum + 2], $inBuf[$i * $elemNum@+ 3], $inBuf[$i * $elemNum + 4], $true) > $null # EBhETCY̕(ő剻Ή1)
                [Win32]::MoveWindow($window.Handle, $inBuf[$i * $elemNum + 1], $inBuf[$i * $elemNum + 2], $inBuf[$i * $elemNum@+ 3], $inBuf[$i * $elemNum + 4], $true) > $null # EBhETCY̕(ő剻Ή2)
                # ő剻Ԃ𕜌
                if($inBuf[$i * $elemNum + 5] -eq "Maximized")
                {
                    $res = [Win32]::ShowWindow($window.Handle, 3)
                }
                elseif ($inBuf[$i * $elemNum + 5] -eq "Minimized")
                {
                    $res = [Win32]::ShowWindow($window.Handle, 6)
                }
            }
        }
    }
}
    0
    exit
}
catch
{
    1
    exit
}
