#====================================================================
# Savep
#====================================================================
#!/usr/bin/env pwsh

#====================================================================
# 
#====================================================================
Param(
    [String]$fileName="save.txt"   # ftHg̃t@C
)

#====================================================================
# 萔`
#====================================================================
$compLen = 6                   # EBhE^Cĝv镶

#====================================================================
# DllImport
#====================================================================
Add-Type -AssemblyName UIAutomationClient
Add-Type @"
using System;
using System.Runtime.InteropServices;

public struct RECT
{
    public int Left;
    public int Top;
    public int Right;
    public int Bottom;
}

public class WinAPI
{
    // EChĚ݂̍Wf[^擾APIC|[g
    [DllImport("user32.dll")]
    public static extern bool GetWindowRect(IntPtr hWnd, out RECT lpRect);

    // EChE̍WύXAPIC|[g
    [DllImport("user32.dll")]
    public static extern bool MoveWindow(IntPtr hWnd, int X, int Y, int nWidth, int nHeight, bool bRepaint);
}
"@

#====================================================================
# EBhETCY̎擾
#====================================================================
function Get-WindowSize {
    param (
        $wh  # EChEnh
    )

    # EChEWf[^\
    $rc = New-Object RECT

    # EChĚ݂̍Wf[^擾
    [WinAPI]::GetWindowRect($wh, [ref]$rc) > $null
#    If( $rc.Left -lt 0 ) { $rc.Left = 0 }                      # ŏl̃`FbN(eXgp)
#    Write-Host $rc.Left                                        # ʕ\(eXgp)
    Write-Output $rc.Left | Out-File -Append $fileName         # t@Co
#    If( $rc.Top -lt 0 ) { $rc.Top = 0 }                        # ŏl̃`FbN
#    Write-Host $rc.Top                                         # ʕ\(eXgp)
    Write-Output $rc.Top | Out-File -Append $fileName          # t@Co
    $width = $rc.Right - $rc.Left                              # Zo
#    Write-Host $width                                          # ʕ\(eXgp)
    Write-Output $width | Out-File -Append $fileName           # t@Co
    $height = $rc.Bottom - $rc.Top                             # Zo
#    Write-Host $height                                         # ʕ\(eXgp)
    Write-Output $height | Out-File -Append $fileName          # t@Co
}

#====================================================================
# ΏۂƂȂEChEIATCY擾
#====================================================================
try
{
If( Test-Path $fileName )
{
    Clear-Content $fileName
}

Get-Process -Name "*" |
  ? { $_.MainWindowHandle -ne 0 } |
  ? { $_.MainWindowTitle -match "$windowTitle" -and $_.MainWindowTitle -ne ""} |
  % {
        If( $_.MainWindowTitle.length -ge $compLen -and $_.MainWindowTitle -notmatch "Microsoft Text Input Application" -and  $_.MainWindowTitle -notlike "explorer*" -and  $_.MainWindowTitle -notlike "Windows ̓GNXyGX*" -and  $_.MainWindowTitle -notlike "^XN*}l[W*" -and  $_.MainWindowTitle -notlike "Bang*" -and  $_.MainWindowTitle -ne "Windows PowerShell" -and  $_.MainWindowTitle -notlike "PsWinPos*" ) # Ώۂ珜ÖȊȌꍇ
        {
#            Write-Host $_.MainWindowTitle                                # ʕ\(eXgp)
            Write-Output $_.MainWindowTitle | Out-File -Append $fileName                                     # t@Co
            $window = [System.Windows.Automation.AutomationElement]::FromHandle( $_.MainWindowHandle )
            $windowPattern = $window.GetCurrentPattern( [System.Windows.Automation.WindowPattern]::Pattern ) # ő剻Ԃ擾
            $state = $windowPattern.Current.WindowVisualState                                                # ő剻Ԃێ
            If( "Maximized" -eq $state )
            {
                $windowPattern.SetWindowVisualState("Normal")                                                # ő剻Ԃ
                Get-WindowSize($_.MainWindowHandle);                                                         # EChETCY擾ێ
                $windowPattern.SetWindowVisualState("Maximized")                                             # ő剻Ԃ𕜌
            }
            ElseIf( "Minimized" -eq $state )
            {
                $windowPattern.SetWindowVisualState("Normal")                                                # ő剻Ԃ
                Get-WindowSize($_.MainWindowHandle);                                                         # EChETCY擾ێ
                $windowPattern.SetWindowVisualState("Minimized")                                             # ő剻Ԃ𕜌
            }
            Else
            {
                Get-WindowSize($_.MainWindowHandle);                                                         # EChETCY擾ێ
            }

#            Write-Host $state                                    # ʕ\(eXgp)
            Write-Output $state | Out-File -Append $fileName                                                 # t@Co
        }
    }
    0
    exit
}
catch # O
{
    1
    exit
}
