/** mystrings.cpp
 * ėp񏈗֐Ȃǁi\[Xj
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++
 * @QlURL		http://www.pahoo.org/e-soul/webtech/cpp01-12-01.shtm
 */
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <string>
#include <vector>
#include <locale>
#include <regex>
#include <winsock2.h>
#include <windows.h>
#include <shlwapi.h>
#include <curl/curl.h>
#include "mystrings.h"

using namespace std;

// Oϐ ================================================================
// eEBhE
extern HWND hParent;

// t@C֘A ========================================================
/**
 * AppDatãpX擾
 * @param	char* appname AvP[V
 * @return	string pX
 */
string getMyPath(const char* appname) {
	static TCHAR myPath[MAX_PATH] = "";

	if (strlen(myPath) == 0) {
		if (SHGetSpecialFolderPath(NULL, myPath, CSIDL_APPDATA, 0)) {
			TCHAR *ptmp = _tcsrchr(myPath, _T('\\'));
			if (ptmp != NULL) {
				ptmp = _tcsinc(ptmp);
				*ptmp = _T('\0');
			}
			strcat(myPath, _T("Roaming"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\pahoo.org"));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
			strcat(myPath, _T(appname));
			CreateDirectory((LPCTSTR)myPath, NULL);
			strcat(myPath, _T("\\"));
		} else {
		}
	}
	return (string)myPath;
}

/**
 * svÕpX擾D
 * @param	Ȃ
 * @return	string pX^""F擾s
 */
string getModulePath(void) {
	// obt@mۂĎs\t@C̃pX擾D
	TCHAR buffer[MAX_PATH];
	GetModuleFileName(NULL, buffer, MAX_PATH);

	// pXfBNg擾D
	std::string _fullPath(buffer);
	std::string::size_type pos = _fullPath.find_last_of("\\/");
	if (pos != std::string::npos) {
		std::string directory = _fullPath.substr(0, pos);
		return directory;
	} else {
		return "";
	}
}

// Nbv{[h֘A ======================================================
/**
 * Nbv{[hɕZbg
 * @param	string str 
 * @return	Ȃ
 */
void setClipboardData(string str) {
	char buff[str.size() + 1];
	char_traits<char>::copy(buff, str.c_str(), str.size() + 1);

	OpenClipboard(NULL);
	EmptyClipboard();

	HGLOBAL hText = GlobalAlloc(GHND | GMEM_SHARE, str.size() + 1);
	PTSTR pText = (PTSTR) GlobalLock(hText);
	lstrcpy(pText, buff);
	GlobalUnlock(hText);
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();
}

/**
 * Nbv{[h當擾
 * @param	Ȃ
 * @return	^NULL擾s
 */
char* getClipboardData(void) {
	static char buff[SIZE_BUFF + 1];

	OpenClipboard(NULL);
	HGLOBAL hText = GetClipboardData(CF_TEXT);

	if (hText == NULL) {
		return NULL;
	} else {
		PTSTR pText = (PTSTR) GlobalLock(hText);
		lstrcpy(buff, pText);
		GlobalUnlock(hText);
	}
	CloseClipboard();

	return buff;
}

// Windowso[W擾 ===================================================
typedef void (WINAPI *RtlGetVersion_FUNC)(OSVERSIONINFOEXW*);

/**
 * Windowso[W擾
 * @param	OSVERSIONINFOEX* os o[Wi[
 * @return	bool TRUE/FALSEȂ
 */
BOOL GetVersion2(OSVERSIONINFOEX* os) {
	HMODULE hMod;
	RtlGetVersion_FUNC func;
#ifdef UNICODE
	OSVERSIONINFOEXW* osw = os;
#else
	OSVERSIONINFOEXW o;
	OSVERSIONINFOEXW* osw = &o;
#endif

	hMod = LoadLibrary(TEXT("ntdll.dll"));
	if (hMod) {
		func = (RtlGetVersion_FUNC)GetProcAddress(hMod, "RtlGetVersion");
		if (func == 0) {
			FreeLibrary(hMod);
			return FALSE;
		}
		ZeroMemory(osw, sizeof(*osw));
		osw->dwOSVersionInfoSize = sizeof(*osw);
		func(osw);
#ifndef UNICODE
		os->dwBuildNumber = osw->dwBuildNumber;
		os->dwMajorVersion = osw->dwMajorVersion;
		os->dwMinorVersion = osw->dwMinorVersion;
		os->dwPlatformId = osw->dwPlatformId;
		os->dwOSVersionInfoSize = sizeof(*os);
//		DWORD sz = sizeof(os->szCSDVersion);
		WCHAR* src = osw->szCSDVersion;
		unsigned char* dtc = (unsigned char*)os->szCSDVersion;
		while (*src) {
			*dtc++ = (unsigned char)*src++;
		}
		*dtc = '\0';
#endif

	} else {
		return FALSE;
	}
	FreeLibrary(hMod);

return TRUE;
}

// R[hϊ =========================================================
/**
 * eLXgER[hϊFSJISwstringiWindows APIgpj
 * @param  string src SJISeLXg
 * @return string ϊeLXg
*/
std::wstring __sjis_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');

	if (::MultiByteToWideChar(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}
#define _SW(s)	__sjis_wstring(s)

/**
 * eLXgER[hϊFwstringSJISiWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiSJISj
*/
std::string __wstring_sjis(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');
	if (::WideCharToMultiByte(CP_ACP, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}
#define _WS(s)	__wstring_sjis(s)

/**
 * eLXgER[hϊFUTF-8wstringiWindows APIgpj
 * @param  string src UTF-8eLXg
 * @return string ϊeLXg
*/
std::wstring __utf8_wstring(std::string src) {
	auto const dest_size = ::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, nullptr, 0U);
	std::vector<wchar_t> dest(dest_size, L'\0');
	if (::MultiByteToWideChar(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size()) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<wchar_t>::length(dest.data()));
	dest.shrink_to_fit();

	return std::wstring(dest.begin(), dest.end());
}
#define _UW(s)	__utf8_wstring(s)

/**
 * eLXgER[hϊFwstringUTF-8iWindows APIgpj
 * @param  wstring src eLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string __wstring_utf8(std::wstring src) {
	auto const dest_size = ::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, nullptr, 0, nullptr, nullptr);
	std::vector<char> dest(dest_size, '\0');

	if (::WideCharToMultiByte(CP_UTF8, 0U, src.data(), -1, dest.data(), dest.size(), nullptr, nullptr) == 0) {
		throw std::system_error{static_cast<int>(::GetLastError()), std::system_category()};
	}
	dest.resize(std::char_traits<char>::length(dest.data()));
	dest.shrink_to_fit();

	return std::string(dest.begin(), dest.end());
}
#define _WU(s)	__wstring_utf8(s)

/**
 * eLXgER[hϊFSJISUTF-8iWindows APIgpj
 * @param  wstring src SJISeLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string sjis_utf8(std::string src) {
	wstring const wide = __sjis_wstring(src);
	return __wstring_utf8(wide);
}

/**
 * eLXgER[hϊFUTF-8SJISiWindows APIgpj
 * @param  wstring src UTF-8eLXg
 * @return string ϊeLXgiUTF-8j
*/
std::string utf8_sjis(std::string src) {
	wstring const wide = __utf8_wstring(src);
	return __wstring_sjis(wide);
}
/**
 * {eLXgϊiWin32 APIpj
 * @param	wstring sour   ϊeLXg
 * @param	DWORD   method ϊ
 * @return	wstring ϊeLXg
 */
wstring wconvString(wstring wsour, DWORD method) {
	// _E_͑Spp2ɑ̂ŕϊ̈͗]T
	wchar_t wdest[wsour.length() * 2 + 1];
	for (size_t i = 0; i < wsour.length() * 2 + 1; i++) {
		wdest[i] = 0L;
	}
	// ϊs
	LCMapStringW(LOCALE_SYSTEM_DEFAULT, method, (LPWSTR) wsour.c_str(),
			wsour.length(), (LPWSTR) wdest, wsour.length() * 2);

	return (wstring) wdest;
}

/**
 * iwstringj𐔒lidoublejɕϊ
 * @param	wstring sour   ϊeLXg
 * @return	double  ϊ㐔l
 */
double w2f(wstring sour) {
	return atof(_WS(wconvString(sour, LCMAP_HALFWIDTH)).c_str());
}

/**
 * HTML^O菜
 * @param  wstring html  HTMLRec
 * @return wstring ^O菜̃eLXg
 */
wstring wstrip_tags(wstring html) {
	bool inflag = FALSE;
	bool done = FALSE;
	size_t i, j;
	while (!done) {
		if (inflag) {
			i = html.find('>');
			if (i != wstring::npos) {
				inflag = FALSE;
				html.erase(0, i + 1);
			} else {
				done = TRUE;
				html.erase();
			}
		} else {
			i = html.find('<');
			if (i != wstring::npos) {
				j = html.find('>');
				if (j == string::npos) {
					inflag = TRUE;
					done = TRUE;
					html.erase(i);
				} else {
					html.erase(i, j - i + 1);
				}
			} else {
				done = TRUE;
			}
		}
	}
	return html;
}

/**
 * Ch񒆂̉s𑼂̕ɒu
 * @param  wstring str uΏۂ̕
 * @param  wstring rep u
 * @return wstring u̕
 */
wstring wrepNL(wstring str, wstring rep) {
	wstring strRet;
	wstring::iterator ite = str.begin();
	wstring::iterator iteEnd = str.end();

	if (0 < str.size()) {
		wchar_t bNextChar = *ite++;
		while (1) {
			if (L'\r' == bNextChar) {
				// sm
				strRet += rep;
				// EOF
				if (ite == iteEnd) {
					break;
				}
				// 1擾
				bNextChar = *ite++;
				if (L'\n' == bNextChar) {
					// EOF
					if (ite == iteEnd) {
						break;
					}
					// 1擾
					bNextChar = *ite++;
				}
			} else if (L'\n' == bNextChar) {
				// sm
				strRet += rep;
				// EOF
				if (ite == iteEnd) {
					break;
				}
				// 1擾
				bNextChar = *ite++;
				if (L'\r' == bNextChar) {
					// EOF
					if (ite == iteEnd) {
						break;
					}
					// 1擾
					bNextChar = *ite++;
				}
			} else {
				// sȊO
				strRet += bNextChar;
				// EOF
				if (ite == iteEnd) {
					break;
				}
				// 1擾
				bNextChar = *ite++;
			}
		};
	}
	return strRet;
}

/**
 * f~^ŕiChj
 * @param  wstring src  
 * @param  wstring deim f~^
 * @return vector<wstring> ゎ
 */
vector<wstring> wsplit(const wstring src, const wchar_t delim) {
	vector<wstring> vec;
	size_t len = src.length();
	size_t n;

	for (size_t i = 0; i < len; i = n + 1) {
		n = src.find_first_of(delim, i);
		if (n == wstring::npos) {
			n = len;
		}
		vec.push_back(src.substr(i, n - i));
	}
    return vec;
}

/**
 * Ch񒆂̓ꕶHTMLGeBeBɕϊ
 * @param  wstring str uΏۂ̕
 * @return wstring u̕
 */
wstring htmlspecialchars(wstring str) {
	wregex re1(_SW("\""));
	wregex re2(_SW("'"));
	wregex re3(_SW("&"));
	wregex re4(_SW("<"));
	wregex re5(_SW(">"));
	wsmatch mt;

	str = regex_replace(str, re1, L"&quot;");
	str = regex_replace(str, re2, L"&#039;");
	str = regex_replace(str, re3, L"&amp;");
	str = regex_replace(str, re4, L"&lt;");
	str = regex_replace(str, re5, L"&gt;");

	return str;
}

/**
 * ChURLGR[h
 * @param  wstring str Ch
 * @return string GR[h
 */
string urlencode(wstring str) {
	static char buff1[SIZE_BUFF + 1], buff2[SIZE_BUFF + 1];

	strncpy(buff1, _WU(str).c_str(), SIZE_BUFF);
	CURL *curl = curl_easy_init();
	strncpy(buff2, curl_easy_escape(curl, (const char *)buff1, strlen(buff1)), SIZE_BUFF);
	curl_easy_cleanup(curl);

	return (string)buff2;
}

/**
 * cURLpR[obN֐
 */
size_t callBackFuncCURL(char* ptr, size_t size, size_t nmemb, string* stream) {
	int realsize = size * nmemb;
	stream->append(ptr, realsize);
	return realsize;
}

/**
 * cURLɂWebRec擾
 * @param  string url ANZXURL
 * @param  string ua  UserAgent
 * @param  string*    contents Reci[
 * @param  char*      post POSTn镶i user=pahoo&psw=1234j
 * @param  int*       htpStatus HTTPXe[^XR[hi[
 * @return bool TRUEFǂݍݐ^FALSEFs
 */
bool readWebContents(const string url, const string ua, string* contents, int* httpStatus, char* post) {
	// cURLɂǂݍ
	bool ret = FALSE;
	CURL *curl;
	CURLcode res = (CURLcode)0;
	*httpStatus = 0;

	curl = curl_easy_init();
	if (curl) {
		struct curl_slist *hs=NULL;
		hs = curl_slist_append(hs, "Content-Type: application/x-www-form-urlencoded");
		curl_easy_setopt(curl, CURLOPT_URL, url.c_str());
		curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1L);	// _CNgL
		curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);
		curl_easy_setopt(curl, CURLOPT_USERAGENT, ua.c_str());
		curl_easy_setopt(curl, CURLOPT_HTTPHEADER, hs);
		if (post != NULL) {
			curl_easy_setopt(curl, CURLOPT_POST, 1);
			curl_easy_setopt(curl, CURLOPT_POSTFIELDS, post);
			curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, strlen(post));
		}
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, callBackFuncCURL);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, contents);
		res = curl_easy_perform(curl);
		curl_easy_cleanup(curl);
	}
	// G[E`FbNCHTTPXe[^XR[h擾
    if (res == CURLE_OK) {
		curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, httpStatus);
        ret = TRUE;
	}
	return ret;
}

/**
 * e|t@C擾iWindows APIgp{gq.gifj
 * @param	char* tpmname  e|t@Ci[itpXj
 * @return	Ȃ
 */
void getTempFname(char *tmpname) {
	char szTempPath[MAX_PATH + 1];

	GetTempPath(sizeof(szTempPath) / sizeof(szTempPath[0]), szTempPath);
	GetTempFileName(szTempPath, "map", 0, tmpname);
	remove(tmpname);		// ݃t@C폜
	strcat(tmpname, ".html");
}

// GUI =================================================================
/**
 * eLXg{bNXɕ
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @param  string	s     ݒl
 * @return Ȃ
 */
void setStrEditBox(HWND hDlg, unsigned id, string s) {
	char buff[s.length() + 1];
	char_traits<char>::copy(buff, s.c_str(), s.size() + 1);
	SetDlgItemText(hDlg, id, buff);
}

/**
 * eLXg{bNX當擾
 * @param  HWND		hDlg  _CAOID
 * @param  unsigned	id    eLXg{bNXID
 * @return string 擾
 */
string getStrEditBox(HWND hDlg, unsigned id) {
	char buff[SIZE_BUFF];
	GetDlgItemText(hDlg, id, buff, sizeof(buff));
	return (string) buff;
}

/**
 * _CAOeEBhE̒ɔzu
 * @param	HWND hDlg		̃nh
 * @global	HWND hParent	eEBhẼnh
 * @return	Ȃ
 */
void CenterWindow(HWND hDlg) {
	int x, y;
	RECT rc;

	GetWindowRect(hParent, &rc);
	x = rc.left + (rc.right - rc.left) / 2;
	y = rc.top + (rc.bottom - rc.top) / 2;

	SetWindowPos(hDlg, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
}

/*
 ** o[WAbv =====================================================
 *
 * @version 1.3.1 2025/03/16 readWebContents() _CNgL
 * @version 1.3.0 2025/03/16 readWebContents() httpStatusǉ
 * @version 1.2.0 2024/05/06 getModulePath() ǉ 
 * @version 1.12  2021/01/31 readWebContents() postǉ
 * @version 1.11  2020/10/17 htmlspecialchars() ǉ
 * @version 1.1   2020/10/17 GetVersion2()ǉCreadWebContents() uaǉ
 * @version 1.01  2020/10/03 setClipboardData() bug-fix
 * @version 1.0   2020/09/22 
 */
