/** photomapwin.cpp
 * Beꏊ}bsO
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @J	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 *					+ tinyxml2 + TinyEXIF
 *					+ WebView2Loader.dll + Leaflet + OSM (+ GoogleMap)
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-13-01.shtm
*/

//  ======================================================
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <boost/format.hpp>
#include <gdiplus/gdiplus.h>
#include <ole2.h>
#include <richedit.h>
#include <regex> 
#include <boost/property_tree/xml_parser.hpp>
#include <boost/algorithm/string.hpp>
#include "mystrings.h"
#include "apikey.h"
#include "WebView2.h"
#include "pahooWebView2.hpp"
#include "pahooGeocode.hpp"
#include "resource.h"
#include "TinyEXIF.h"

using namespace std;
using namespace Gdiplus;
using namespace boost;
using namespace boost::property_tree;

// 萔Ȃ ==================================================================
#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"photomapwin"			// AvP[V
#define APPNAMEJP	"Beꏊ}bsO"	// AvP[Vi{j
#define APPVERSION	"2.4.1"					// o[W
#define APPYEAR		"2020-25"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-13-01.shtm"	// QlTCg

// char*obt@TCY
#define SIZE_BUFF		512

// ListViewItem̍ő啶FύXs
#define MAX_LISTVIEWITEM	258

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"photomapwin.csv"

// }bvID
#define MAP_ID			"map_id"
// n}̑傫
#define MAP_WIDTH		650		// n}̕isNZj
#define MAP_HEIGHT		345		// n}̍isNZj
// oxEܓxilj
#define DEF_LONGITUDE	139.766667
double Longitude = DEF_LONGITUDE;
#define DEF_LATITUDE	35.681111
double Latitude  = DEF_LATITUDE;
// n}g嗦ilj
#define DEF_ZOOM	13
int Zoom = DEF_ZOOM;
// n}̎ށilj
#define DEF_MAPTYPE		"GSISTD"
string Maptype = DEF_MAPTYPE;

// G[EbZ[Wi[p
string ErrorMessage;

// UserAgent
string UserAgent;

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// WebView2EBhE
HWND hWebView2;

// ICoreWebView2FpahooWebView2.cpp Œ`D
extern ICoreWebView2* webView2;

// e|t@C
char tmpFname[MAX_PATH + 1];
wchar_t wUri[MAX_PATH * 2 + 1];

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// GDI+p
ULONG_PTR lpToken;

// pahooGeocodeIuWFNg
pahooGeocode* pGC;

// WebView2nh̓w肷DyύXsz
enum class eAction {
	GetLatLong,				// ܓxEox擾ăuEU\
	GetZoomType,			// g嗦E}bv^Cv擾ăuEU\
	GetLatLongZoomType,		// ܓxEoxEg嗦E}bv^Cv擾ăuEU\
	Finish					// vOI
};
eAction selectAction = eAction::GetLatLongZoomType;

// EXIFStreamFileNX
class EXIFStreamFile : public TinyEXIF::EXIFStream {
public:
	explicit EXIFStreamFile(const char* fileName)
		: file(fileName, std::ifstream::in|std::ifstream::binary) {}
	bool IsValid() const override {
		return file.is_open();
	}
	const uint8_t* GetBuffer(unsigned desiredLength) override {
		buffer.resize(desiredLength);
		if (!file.read((char*)buffer.data(), desiredLength))
			return NULL;
		return buffer.data();
	}
	bool SkipBuffer(unsigned desiredLength) override {
		return (bool)file.seekg(desiredLength,std::ios::cur);
	}
private:
	std::ifstream file;
	std::vector<uint8_t> buffer;
};

// Exifi[NX
#define SIZE_EXIFS		100		// ői[
class _Exif {
public:
	wstring label = L"";		// f[^
	wstring data  = L"";		// f[^{
	wstring unit  = L"";		// P
} Exif[SIZE_EXIFS];

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
lł̖p\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DWebAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGWig++j^Boost C++Cu^libcurl^OpenSSL+^
@WebView2Loader.dll^TinyEXIF
@Leaflet^OpenStreetMap^Google}bv
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// TuEvO =====================================================
/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	Longitude	= DEF_LONGITUDE;
	Latitude	= DEF_LATITUDE;
	Zoom		= DEF_ZOOM;
	Maptype		= DEF_MAPTYPE;
	hParent_X	= 0;
	hParent_Y	= 0;
}

/**
 * p[^̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "latitude") {
					Latitude = stod(it.second.data());
				} else if (type == "longitude") {
					Longitude = stod(it.second.data());
				} else if (type == "zoom") {
					Zoom = stoi(it.second.data());
				} else if (type == "maptype") {
					Maptype = (string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			initParameter();
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		initParameter();
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * p[^̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	char lng[SIZE_BUFF + 1], lat[SIZE_BUFF + 1];
	snprintf(lng, SIZE_BUFF, "%.5f", Longitude);
	snprintf(lat, SIZE_BUFF, "%.5f", Latitude);

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", lat);
	child1.add("<xmlattr>.type", "latitude");
	ptree& child2 = pt.add("parameter.param", lng);
	child2.add("<xmlattr>.type", "longitude");
	ptree& child3 = pt.add("parameter.param", to_string(Zoom));
	child3.add("<xmlattr>.type", "zoom");
	ptree& child4 = pt.add("parameter.param", Maptype);
	child4.add("<xmlattr>.type", "maptype");
	ptree& child5 = pt.add("parameter.param", hParent_X);
	child5.add("<xmlattr>.type", "wx");
	ptree& child6 = pt.add("parameter.param", hParent_Y);
	child6.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	string help;

	switch(uMsg){
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
	break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
			// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
	// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
    return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// ۑERs[ =============================================================
/**
 * t@CitpXjt@Cigqjo
 * @param	wstring path t@CitpXj
 * @return	wstring t@Cigqj
*/
wstring wgetBasename(wstring path) {
	wstring basename = L"";

	// Ō̃fBNgʎqT
	size_t pos = path.rfind(_SW("\\"));
	if (pos == string::npos) {
		return basename;
	}
	// t@C{gq
	wstring fname = path.substr(pos + 1);

	// gq
	pos = fname.rfind(_SW("."));
	if (pos == string::npos) {
		basename = fname;
	} else {
		basename = fname.substr(0, pos);
	}
	return basename;
}

/**
 * ʂCSVt@Cɕۑ
 * @param	const char *fname ۑt@C
 * @return	Ȃ
*/
void __saveCSV(const char *fname) {
	ofstream outputfile(fname);

	// x
	outputfile << "\"" << "" << "\",";
	outputfile << "\"" << "f[^" << "\",";
	outputfile << "\"" << "P" << "\"" << endl;

	// f[^{
	regex pattern(R"(^[^0].[0-9\.\+\-]+$)");	// lǂ
	for (int i = 0; i < SIZE_EXIFS; i++) {
		if (Exif[i].label.length() == 0)	break;
		outputfile << "\"" << _WS(Exif[i].label) << "\",";
		if (regex_match(_WS(Exif[i].data), pattern)) {
			outputfile << _WS(Exif[i].data) << ",";
		} else {
			outputfile << "\"" << _WS(Exif[i].data) << "\",";
		}
		if (! Exif[i].unit.empty()) {
			outputfile << "\"" << _WS(Exif[i].unit) << "\"" << endl;
		} else {
			outputfile << endl;
		}
		if (outputfile.bad()) {
			ErrorMessage = "CSVt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * ʂCSVt@Cɕۑ
 * @param	char *fname ۑt@C
 * @return	Ȃ
*/
void saveCSV(char *savefname) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, savefname);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("CSVt@C(*.csv;*.txt)\0*.csv;*.txt\0ׂẴt@C(*.txt)\0*.txt\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname;
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("csv");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveCSV(fname);
}

// 摜 =================================================================
/**
 * 摜t@CGDI+gēǂݍ
 * Orientation񂪂΁C摜]
 * @param	TCHAR* szFile	摜t@C
 * @param	HDC* hdcBMP		ItXN[pfoCXReLXgi[
 * @param	HDC  hdc		foCXReLXg
 * @param	int* ix, iy		ǂݍ񂾉摜̉EcsNZ
 * @return	Ȃ
*/
bool loadImageOnMemory(TCHAR* szFile, HDC* hdcBMP, HDC hdc, int* ix, int* iy) {
	Image* imageP;
	WCHAR wTitle[MAX_PATH];
	BITMAPINFOHEADER bmih;
	HBITMAP hBitmap;
	BYTE *pBits;

	// ǂݍރt@C
	MultiByteToWideChar(932, 0, szFile, -1, wTitle, sizeof(wTitle) / sizeof(TCHAR));
	imageP = Bitmap::FromFile(wTitle);
	if (imageP == 0) {
		*ix = 0;
		*iy = 0;
		*hdcBMP = 0;
		return FALSE;
	}

	// ExifOrientation擾
	UINT size = imageP->GetPropertyItemSize(PropertyTagOrientation);
	if (size > 0) {
		PropertyItem* prop = (PropertyItem*)malloc(size);
		// malloc̏ꍇ
		if (prop) {
			// sizePropertyItem\̂valuë܂ސTCY̏ꍇ
			if (imageP->GetPropertyItem(PropertyTagOrientation, size, prop) == Ok) {
				// prop->valuenullptrłȂꍇ
				if (! prop->value) {
					int orientation = *(short*)prop->value;
					cout << "GetPropertyItem" << endl;

					// OrientationɊÂĉ]
					switch (orientation) {
					case 3:		// 180x]
						imageP->RotateFlip(Rotate180FlipNone);
						break;
					case 6:		// 90xv
						imageP->RotateFlip(Rotate90FlipNone);
						break;
					case 8:		// 90xv
						imageP->RotateFlip(Rotate270FlipNone);
						break;
					case 2:		// ɔ]
						imageP->RotateFlip(RotateNoneFlipX);
						break;
					case 4:		// ɔ]
						imageP->RotateFlip(RotateNoneFlipY);
						break;
					case 5:		// 90xv{]
						imageP->RotateFlip(Rotate270FlipX);
						break;
					case 7:		// 90xv{]
						imageP->RotateFlip(Rotate90FlipX);
						break;
					default:	// Orientation1̏ꍇ͂̂܂
						break;
					}
				}
			}
			free(prop);
		}
	}

	// 摜TCY擾
	bmih.biSize = sizeof(bmih);
	bmih.biWidth = *ix = imageP->GetWidth();
	bmih.biHeight = *iy = imageP->GetHeight();
	bmih.biPlanes = 1;
	bmih.biBitCount = 32;
	bmih.biCompression = BI_RGB;
	bmih.biSizeImage = 0;
	bmih.biXPelsPerMeter = 0;
	bmih.biYPelsPerMeter = 0;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;
	hBitmap = CreateDIBSection(NULL, (BITMAPINFO*)&bmih, 0, (void**)&pBits, NULL, 0);
	cout << "CreateDIBSection" << endl;
	if (pBits == NULL) {
		ErrorMessage = "s";
		DeleteObject(hBitmap);
		delete imageP;
		*ix = 0;
		*iy = 0;
		return FALSE;
	}
	*hdcBMP = CreateCompatibleDC(hdc);
//	HOldBitmap = (HBITMAP)SelectObject(*hdcBMP, hBitmap);
	SelectObject(*hdcBMP, hBitmap);
	Graphics MyGraphics(*hdcBMP);
	MyGraphics.DrawImage(imageP, 0, 0, imageP->GetWidth(), imageP->GetHeight());
	delete imageP;

	return TRUE;
}

/**
 * cۂ摜TCYvZ
 * @param	int* sx, sy  ϊ摜TCYi[
 * @param	int  px, py  摜̏cTCY
 * @param	int  dx, dy  ϊ̈̏cTCY
 * @return	Ȃ
*/
void reSizeImage(int* sx, int* sy, int px, int py, int dx, int dy) {
	double pxy = double(px) / double(py);	// 摜̉c
	double dxy = double(dx) / double(dy);	// ϊ̉c
	int dx2, dy2;

	// ɏck
	if(pxy > dxy) {
		dx2 = dx;
		dy2 = (int)double(dx / pxy);
	} else {
		dy2 = dy;
		dx2 = (int)double(dy * pxy);
	}
	*sx = dx2;
	*sy = dy2;
}

/**
 * 摜t@C̕\
 * @param	HWND  hWnd \EBhEEnh
 * @param	const char *fname 摜t@C
 * @return	bool TRUEF\^FALSEFs
*/
bool onPaint(HWND hWnd, const char *fname) {
	HDC hdc;
	PAINTSTRUCT ps;
	static HDC hdcBMP;
	static int ix,iy;
	int sx, sy;
	RECT rect;
	bool ret = TRUE;

	// 摜t@Cǂݍ
	hdc = GetDC(hWnd);
	if(loadImageOnMemory((TCHAR*)fname, &hdcBMP, hdc, &ix, &iy) == FALSE) {
		ErrorMessage = "摜t@C " + (string)fname + " ̓ǂݍ݂Ɏs";
		return FALSE;
	}
	InvalidateRect(hWnd, 0, TRUE);
	hdc = BeginPaint(hWnd, &ps);
	GetClientRect(hWnd, &rect);

	// ̈NA
	HPEN   hNewPen   = (HPEN)CreatePen(PS_INSIDEFRAME, 4, RGB(255, 255, 255));
	HPEN   hOldPen   = (HPEN)SelectObject(hdc,hNewPen);
	HBRUSH hNewBrush = (HBRUSH)CreateSolidBrush(RGB(255, 255, 255));
	HBRUSH hOldBrush = (HBRUSH)SelectObject(hdc, hNewBrush);
	Rectangle(hdc, 0, 0, rect.right, rect.bottom);
	DeleteObject(SelectObject(hdc, hOldBrush));
	DeleteObject(SelectObject(hdc, hOldPen));

	// k\
	reSizeImage(&sx, &sy, ix, iy, (rect.right - rect.left), (rect.bottom - rect.top));
	SetStretchBltMode(hdc, HALFTONE);
	StretchBlt(hdc, 0, 0, sx, sy, hdcBMP, 0, 0, ix, iy, SRCCOPY);
	EndPaint(hWnd, &ps);
	ReleaseDC(hWnd, hdc);

	return ret;
}

// Exif񏈗 =============================================================
/**
 * 摜t@CJExif擾iƁj
 * @param	const char *fname ۑt@C
 * @return	bool TRUEF擾^FALSEFs
*/
bool loadExif(const char *fname) {
	double f;
	string ss;
	char buff[SIZE_BUFF + 1];
	bool ret = TRUE;

	// 摜t@C̃I[v
	EXIFStreamFile stream(fname);
	if (! stream.IsValid()) {
		ErrorMessage = "摜t@C " + (string)fname + " ̓ǂݍ݂Ɏs";
		return FALSE;
	}
	// Exif̎擾
	TinyEXIF::EXIFInfo imageEXIF(stream);

	// ExifzExif֑
	// 
	for (int i = 0; i < SIZE_EXIFS; i++) {
		Exif[i].label = L"";
		Exif[i].data  = L"";
		Exif[i].unit  = L"";
	}
	// 
	int i = 0;

	// ʒu
	if (imageEXIF.GeoLocation.hasLatLon()) {
		Exif[i].label = _SW("ܓx");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.Latitude));
		Exif[i].unit  = _SW("x");
		Latitude = imageEXIF.GeoLocation.Latitude;
		i++;
		Exif[i].label = _SW("ox");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.Longitude));
		Exif[i].unit  = _SW("x");
		Longitude = imageEXIF.GeoLocation.Longitude;
		i++;
	} else {
		ErrorMessage = "摜t@C " + (string)fname + " Ɉʒu񂪑݂Ȃ";
		ret = FALSE;
	}
	if (imageEXIF.GeoLocation.hasAltitude()) {
		snprintf(buff, SIZE_BUFF, "%.1f", imageEXIF.GeoLocation.Altitude);
		switch (imageEXIF.GeoLocation.AltitudeRef) {
			case 0:
				Exif[i].unit  = _SW("[g(C)");
				break;
			case 1:
				Exif[i].unit  = _SW("[g(Cʉ)");
				break;
			default:
				Exif[i].unit  = _SW("[g");
				break;
		}
		Exif[i].label = _SW("x");
		Exif[i].data  = _SW((string)buff);
		i++;
	}
	if (! imageEXIF.GeoLocation.GPSMapDatum.empty()) {
		Exif[i].label = _SW("nn");
		Exif[i].data  = _SW(imageEXIF.GeoLocation.GPSMapDatum);
		i++;
	}
	// 摜
	if (imageEXIF.ImageWidth || imageEXIF.ImageHeight) {
		Exif[i].label = _SW("摜̕");
		Exif[i].data  = _SW(to_string(imageEXIF.ImageWidth));
		Exif[i].unit  = _SW("sNZ");
		i++;
		Exif[i].label = _SW("摜̍");
		Exif[i].data  = _SW(to_string(imageEXIF.ImageHeight));
		Exif[i].unit  = _SW("sNZ");
		i++;
	}
	if (imageEXIF.RelatedImageWidth || imageEXIF.RelatedImageHeight) {
		Exif[i].label = _SW("摜̕");
		Exif[i].data  = _SW(to_string(imageEXIF.RelatedImageWidth));
		Exif[i].unit  = _SW("sNZ");
		i++;
		Exif[i].label = _SW("摜̍");
		Exif[i].data  = _SW(to_string(imageEXIF.RelatedImageHeight));
		Exif[i].unit  = _SW("sNZ");
		i++;
	}
	if (! imageEXIF.ImageDescription.empty()) {
		Exif[i].label = _SW("摜^Cg");
		Exif[i].data  = _SW(imageEXIF.ImageDescription);
		i++;
	}
	if (! imageEXIF.Make.empty() || ! imageEXIF.Model.empty()) {
		Exif[i].label = _SW("J̃[J[");
		Exif[i].data  = _SW(imageEXIF.Make);
		i++;
		Exif[i].label = _SW("J̃f");
		Exif[i].data  = _SW(imageEXIF.Model);
		i++;
	}
	if (! imageEXIF.SerialNumber.empty()) {
		Exif[i].label = _SW("VAԍ");
		Exif[i].data  = _SW(imageEXIF.SerialNumber);
		i++;
	}
	if (imageEXIF.Orientation) {
		Exif[i].label = _SW("摜");
		switch (imageEXIF.Orientation) {
			case 1:
				Exif[i].data  = _SW("");
				break;
			case 3:
				Exif[i].data  = _SW("E");
				break;
			case 6:
				Exif[i].data  = _SW("E");
				break;
			case 8:
				Exif[i].data  = _SW("");
				break;
			default:
				Exif[i].data  = _SW("s");
				break;
		}
		i++;
	}
	if (imageEXIF.XResolution || imageEXIF.YResolution || imageEXIF.ResolutionUnit) {
		ss = "";
		switch (imageEXIF.ResolutionUnit) {
			case 2:
				ss = "C`";
				break;
			case 3:
				ss = "Z`";
				break;
			default:
				ss = "";
				break;
		}
		Exif[i].label = _SW("̉𑜓x");
		Exif[i].data  = _SW(to_string((int)imageEXIF.XResolution));
		Exif[i].unit  = _SW(ss);
		i++;
		Exif[i].label = _SW("̉𑜓x");
		Exif[i].data  = _SW(to_string((int)imageEXIF.YResolution));
		Exif[i].unit  = _SW(ss);
		i++;
	}
	if (imageEXIF.BitsPerSample) {
		Exif[i].label = _SW("摜̃rbg̐[");
		Exif[i].data  = _SW(to_string(imageEXIF.BitsPerSample));
		i++;
	}
	if (! imageEXIF.Software.empty()) {
		Exif[i].label = _SW("\\tgEFA");
		Exif[i].data  = _SW(imageEXIF.Software);
		i++;
	}

	// Be֌W
	regex pattern(R"((\d{4}):(\d{2}):(\d{2})\s+(\d{2}:\d{2}:\d{2}))");
	if (! imageEXIF.DateTime.empty()) {
		Exif[i].label = _SW("Be");
		string ss = regex_replace(imageEXIF.DateTime, pattern, "$1-$2-$3T$4");
		if (! imageEXIF.OffsetTime.empty()) {
			ss += imageEXIF.OffsetTime;
		}
		Exif[i].data  = _SW(ss);
		i++;
	}
	if (! imageEXIF.DateTimeOriginal.empty()) {
		string ss = regex_replace(imageEXIF.DateTimeOriginal, pattern, "$1-$2-$3T$4");
		Exif[i].label = _SW("Be(IWi)");
		if (! imageEXIF.OffsetTimeOriginal.empty()) {
			ss += imageEXIF.OffsetTimeOriginal;
		}
		Exif[i].data  = _SW(ss);
		i++;
	}
	if (! imageEXIF.DateTimeDigitized.empty()) {
		string ss = regex_replace(imageEXIF.DateTimeDigitized, pattern, "$1-$2-$3T$4");
		Exif[i].label = _SW("Be(fW^CY)");
		if (! imageEXIF.OffsetTimeDigitized.empty()) {
			ss += imageEXIF.OffsetTimeDigitized;
		}
		Exif[i].data  = _SW(ss);
		i++;
	}
	if (! imageEXIF.SubSecTimeOriginal.empty()) {
		Exif[i].label = _SW("Be");
		Exif[i].data  = _SW(imageEXIF.SubSecTimeOriginal);
		Exif[i].unit  = _SW("~b");
		i++;
	}

	if (! imageEXIF.Copyright.empty()) {
		Exif[i].label = _SW("쌠");
		Exif[i].data  = _SW(imageEXIF.Copyright);
		i++;
	}
	Exif[i].label = _SW("I");
	switch (imageEXIF.ExposureProgram) {
		case 1:
			Exif[i].data  = _SW("}jAݒ");
			break;
		case 2:
			Exif[i].data  = _SW("ʏ̃vOAE");
			break;
		case 3:
			Exif[i].data  = _SW("iD");
			break;
		case 4:
			Exif[i].data  = _SW("Vb^[xD");
			break;
		case 5:
			Exif[i].data  = _SW("ᑬvO");
			break;
		case 6:
			Exif[i].data  = _SW("vO");
			break;
		case 7:
			Exif[i].data  = _SW("|[g[g[h");
			break;
		case 8:
			Exif[i].data  = _SW("i[h");
			break;
		default:
			Exif[i].data  = _SW("s");
			break;
	}
	i++;
	Exif[i].label = _SW("ISOx");
	Exif[i].data  = _SW(to_string(imageEXIF.ISOSpeedRatings));
	i++;
	Exif[i].label = _SW("Vb^[x");
	f = 1.0 / imageEXIF.ShutterSpeedValue;
	Exif[i].data  = _SW("1/" + to_string((int)f));
	Exif[i].unit  = _SW("b");
	i++;
	Exif[i].label = _SW("Io");
	f = 1.0 / imageEXIF.ExposureTime;
	Exif[i].data  = _SW("1/" + to_string((int)f));
	Exif[i].unit  = _SW("b");
	i++;
	Exif[i].label = _SW("il");
	Exif[i].data  = _SW(to_string(imageEXIF.ApertureValue));
	i++;
	Exif[i].label = _SW("Fl");
	snprintf(buff, SIZE_BUFF, "%g", imageEXIF.FNumber);
	Exif[i].data  = _SW(buff);
	i++;
	Exif[i].label = _SW("Yœ_");
	Exif[i].data  = _SW(to_string((int)imageEXIF.FocalLength));
	Exif[i].unit  = _SW("~");
	i++;
	if ((float)imageEXIF.BrightnessValue > 0) {
		Exif[i].label = _SW("Pxl");
		Exif[i].data  = _SW(to_string(imageEXIF.BrightnessValue));
		i++;
	}
	if ((float)imageEXIF.ExposureBiasValue > 0) {
		Exif[i].label = _SW("Io␳l");
		Exif[i].data  = _SW(to_string(imageEXIF.ExposureBiasValue));
		i++;
	}
	if ((float)imageEXIF.SubjectDistance > 0) {
		Exif[i].label = _SW("ʑ̋");
		Exif[i].data  = _SW(to_string(imageEXIF.SubjectDistance));
		i++;
	}
	Exif[i].label = _SW("tbV");
	switch (imageEXIF.Flash) {
		case 0:
			Exif[i].data  = _SW("񔭌");
			break;
		case 1:
			Exif[i].data  = _SW("");
			break;
		case 5:
			Exif[i].data  = _SW("ˌoł");
			break;
		case 6:
			Exif[i].data  = _SW("Ĕˌo");
			break;
		default:
			Exif[i].data  = _SW("s");
			break;
	}
	i++;
	Exif[i].label = _SW("[h");
	switch (imageEXIF.MeteringMode) {
		case 0:
			Exif[i].data  = _SW("ϑ");
			break;
		case 1:
			Exif[i].data  = _SW("d_");
			break;
		case 2:
			Exif[i].data  = _SW("X|bg");
			break;
		case 4:
			Exif[i].data  = _SW("_X|bg");
			break;
		case 5:
			Exif[i].data  = _SW("}`ZOg");
			break;
		case 6:
			Exif[i].data  = _SW("");
			break;
		default:
			Exif[i].data  = _SW("s");
			break;
	}
	i++;
	Exif[i].label = _SW("");
	switch (imageEXIF.LightSource) {
		case 1:
			Exif[i].data  = _SW("");
			break;
		case 2:
			Exif[i].data  = _SW("u");
			break;
		case 3:
			Exif[i].data  = _SW("Md");
			break;
		case 4:
			Exif[i].data  = _SW("tbV");
			break;
		case 9:
			Exif[i].data  = _SW("");
			break;
		case 10:
			Exif[i].data  = _SW("ܓV");
			break;
		case 11:
			Exif[i].data  = _SW("A");
			break;
		case 12:
			Exif[i].data  = _SW("F");
			break;
		case 13:
			Exif[i].data  = _SW("F");
			break;
		case 14:
			Exif[i].data  = _SW("uF");
			break;
		case 15:
			Exif[i].data  = _SW("F");
			break;
		case 17:
			Exif[i].data  = _SW("WCgA");
			break;
		case 18:
			Exif[i].data  = _SW("WCgB");
			break;
		case 19:
			Exif[i].data  = _SW("WCgC");
			break;
		case 20:
			Exif[i].data  = _SW("D55");
			break;
		case 21:
			Exif[i].data  = _SW("D65");
			break;
		case 22:
			Exif[i].data  = _SW("D75");
			break;
		case 23:
			Exif[i].data  = _SW("D50");
			break;
		case 24:
			Exif[i].data  = _SW("ISOMd");
			break;
		default:
			Exif[i].data  = _SW("s");
			break;
	}
	i++;
	if (imageEXIF.Calibration.FocalLength != 0) {
		Exif[i].label = _SW("(sNZ)");
		Exif[i].data  = _SW(to_string(imageEXIF.Calibration.FocalLength));
		i++;
	}
	if (imageEXIF.Calibration.OpticalCenterX != 0) {
		Exif[i].label = _SW("(sNZ)");
		Exif[i].data  = _SW(to_string(imageEXIF.Calibration.OpticalCenterX));
		i++;
	}
	if (imageEXIF.Calibration.OpticalCenterY != 0) {
		Exif[i].label = _SW("(sNZ)");
		Exif[i].data  = _SW(to_string(imageEXIF.Calibration.OpticalCenterY));
		i++;
	}
	// Y
	if ((int)imageEXIF.LensInfo.FStopMin > 0) {
		Exif[i].label = _SW("ŏil");
		Exif[i].data  = _SW(to_string((int)imageEXIF.LensInfo.FStopMin));
		i++;
	}
	if ((int)imageEXIF.LensInfo.FStopMax > 0) {
		Exif[i].label = _SW("őil");
		Exif[i].data  = _SW(to_string((int)imageEXIF.LensInfo.FStopMax));
		i++;
	}
	if ((int)imageEXIF.LensInfo.FocalLengthMin > 0) {
		Exif[i].label = _SW("Lp");
		Exif[i].data  = _SW(to_string((int)imageEXIF.LensInfo.FocalLengthMin));
		Exif[i].unit  = _SW("~");
		i++;
	}
	if ((int)imageEXIF.LensInfo.FocalLengthMax > 0) {
		Exif[i].label = _SW("]");
		Exif[i].data  = _SW(to_string((int)imageEXIF.LensInfo.FocalLengthMax));
		Exif[i].unit  = _SW("~");
		i++;
	}
	if ((int)imageEXIF.LensInfo.DigitalZoomRatio > 0) {
		Exif[i].label = _SW("fW^Y[{");
		Exif[i].data  = _SW(to_string((int)imageEXIF.LensInfo.DigitalZoomRatio));
		i++;
	}
	if ((int)imageEXIF.LensInfo.FocalLengthIn35mm > 0) {
		Exif[i].label = _SW("œ_(35~");
		Exif[i].data  = _SW(to_string((int)imageEXIF.LensInfo.FocalLengthIn35mm));
		Exif[i].unit  = _SW("~");
		i++;
	}
	ss = "";
	switch (imageEXIF.LensInfo.FocalPlaneResolutionUnit) {
		case 2:
			ss = "C`";
			break;
		case 3:
			ss = "Z`";
			break;
		default:
			ss = "";
			break;
	}
	Exif[i].label = _SW("œ_ʂ̉̕𑜓x");
	Exif[i].data  = _SW(to_string(imageEXIF.LensInfo.FocalPlaneXResolution));
	Exif[i].unit  = _SW(ss);
	i++;
	Exif[i].label = _SW("œ_ʂ̍̉𑜓x");
	Exif[i].data  = _SW(to_string(imageEXIF.LensInfo.FocalPlaneYResolution));
	Exif[i].unit  = _SW(ss);
	i++;

	// Y֌W̏
	if (! imageEXIF.LensInfo.Make.empty()) {
		Exif[i].label = _SW("Ỹ[J[");
		Exif[i].data  = _SW(imageEXIF.LensInfo.Make);
		i++;
	}
	if (! imageEXIF.LensInfo.Model.empty()) {
		Exif[i].label = _SW("Ỹf");
		Exif[i].data  = _SW(imageEXIF.LensInfo.Model);
		i++;
	}

	// ʒu
	if (imageEXIF.GeoLocation.hasRelativeAltitude()) {
		Exif[i].label = _SW("΍x");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.RelativeAltitude));
		Exif[i].unit  = _SW("[g");
		i++;
	}
	if (imageEXIF.GeoLocation.hasOrientation()) {
		Exif[i].label = _SW("[p");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.RollDegree));
		Exif[i].unit  = _SW("x");
		i++;
		Exif[i].label = _SW("sb`p");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.PitchDegree));
		Exif[i].unit  = _SW("x");
		i++;
		Exif[i].label = _SW("[p");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.YawDegree));
		Exif[i].unit  = _SW("x");
		i++;
	}
	if (imageEXIF.GeoLocation.hasSpeed()) {
		Exif[i].label = _SW("sx(X)");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.SpeedX));
		Exif[i].unit  = _SW("[g/b");
		i++;
		Exif[i].label = _SW("sx(Y)");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.SpeedY));
		Exif[i].unit  = _SW("[g/b");
		i++;
		Exif[i].label = _SW("sx(Z)");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.SpeedZ));
		Exif[i].unit  = _SW("[g/b");
		i++;
	}
	if (imageEXIF.GeoLocation.AccuracyXY > 0) {
		Exif[i].label = _SW("GPSx(XY)");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.AccuracyXY));
		Exif[i].unit  = _SW("[g");
		i++;
	}
	if (imageEXIF.GeoLocation.AccuracyZ > 0) {
		Exif[i].label = _SW("GPSx(Z)");
		Exif[i].data  = _SW(to_string(imageEXIF.GeoLocation.AccuracyZ));
		Exif[i].unit  = _SW("[g");
		i++;
	}

	if (imageEXIF.GeoLocation.GPSDOP >= 0) {
		Exif[i].label = _SW("GPSxቺ");
		snprintf(buff, SIZE_BUFF, "%g", imageEXIF.GeoLocation.GPSDOP);
		Exif[i].data  = _SW(buff);
		i++;
	}
	if (imageEXIF.GeoLocation.GPSDifferential >= 0) {
		Exif[i].label = _SW("GPS␳");
		switch (imageEXIF.GeoLocation.GPSDifferential) {
			case 0:
				ss = "␳Ȃ";
				break;
			case 1:
				ss = "␳Kp";
				break;
			default:
				ss = "s";
				break;
		}
		Exif[i].data  = _SW(ss);
		i++;
	}

	// GPS֌W
	if (! imageEXIF.GeoLocation.GPSDateStamp.empty()) {
		regex pattern(R"((\d{4}):(\d{2}):(\d{2}))");
		string ss = regex_replace(imageEXIF.GeoLocation.GPSDateStamp, pattern, "$1-$2-$3T");
		if (! imageEXIF.GeoLocation.GPSTimeStamp.empty()) {
			istringstream iss((string)imageEXIF.GeoLocation.GPSTimeStamp);
			int hour, min, sec;
			iss >> hour >> min >> sec;
			snprintf(buff, SIZE_BUFF, "T%02d:%02d:%02dZ", hour, min, sec);
			ss += buff;
		}
		Exif[i].label = _SW("GPS");
		Exif[i].data  = _SW(ss);
		i++;
	}

	return ret;
}

/**
 * 摜t@CJExif擾i_CAOj
 * @param	HWND  hWnd      \EBhEEnh
 * @param	char *loadfname 摜t@Ci[
 * @return	bool TRUEFExif擾^FALSEFs
*/
bool loadImageAndExif(HWND hWnd, char *loadfname) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, "");
	OPENFILENAME of;
	bool ret = TRUE;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("JPEGt@C(*.jpg;*.jpeg)\0*.jpg;*.jpeg\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname;
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("jpg");
	// R_CAO̕\
	GetOpenFileName(&of);

	// 摜\
	ret = onPaint(hWnd, fname);
	if (ret == TRUE) {
		// 摜t@Cǂݍ
		ret = loadExif(fname);
	}
	// t@CRs[
	strncpy(loadfname, fname, MAX_PATH);

	return ret;
}

// n}\iuEUj ======================================================
/**
 * n}\pHTML
 * @param	int cnt \CtH[V
 * @return	string HTML
 */
string makeMapHTML(int cnt=0) {
//	if (pGC->GoogleAPIkey.length() == 0) {
//		Maptype = DEF_MAPTYPE;
//	}
	string script = pGC->makeMapLeaflet(MAP_ID, Longitude, Latitude, Zoom, Maptype, pGC->Ppoints, cnt);
	string html = (boost::format(R"(<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>tHg}bv</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
%8%
</head>
<body>
<div id="%1%" style="width:%2%px; height:%3%px;"></div>
<form>
<input id="latitude"  type="hidden" value="%4%" />
<input id="longitude" type="hidden" value="%5%" />
<input id="zoom"      type="hidden" value="%6%" />
<input id="maptype"   type="hidden" value="%7%" />
</form>
</body>
</html>
)")
% MAP_ID						// n}ID
% MAP_WIDTH						// n}̕
% MAP_HEIGHT					// n}̍
% Latitude						// ܓx
% Longitude						// ox
% Zoom							// n}g嗦
% Maptype						// n}^Cv
% script						// n}`XNvg
).str();

	return html;
}

/**
 * G[bZ[WHTMLɂ
 * @param	Ȃ
 * @return	string HTML
*/
string makeErrorHTML(void) {
	string msg;
	if (pGC->isError()) {
		msg = _WS(pGC->getError());
	} else {
		msg = ErrorMessage;
	}
	return (boost::format(R"(<!DOCTYPE html>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>G[</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
</head>
<body>
<p style="color:red; font-size:large;">%1%</p>
</body>
</html>
)")
% ErrorMessage
).str();
}

/**
 * uEUERg[\
 * @param	const char* tmpname ǂݍHTMLt@C
 * @return	Ȃ
*/
void viewBrowser(const char* tmpname) {
	string html;
	string fname;
	ofstream ofs;

	// \pHTMLt@C쐬
	if ((ErrorMessage == "") && (! pGC->isError())) {
		html = makeMapHTML(0);
	} else {
		html = makeErrorHTML();
	}
	ofs.open(tmpname);
	ofs << html;
	ofs.close();

	fname = (string)tmpname;
	std::replace(fname.begin(), fname.end(), '\\', '/');

	if (isWeb2Ready()) {
		webView2->Reload();
	}
}

// Xgr[̗
enum {
	COL_LABEL,
	COL_DATA
};

/**
 * Exifꗗ̃t[쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListViewFrame(HWND hWnd) {
	LVCOLUMNA lvcol;
	lvcol.mask = LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH | LVCF_FMT;
	lvcol.fmt = LVCFMT_LEFT;

	lvcol.cx = 180;
	lvcol.pszText = (char *)"";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_LABEL, (WPARAM)&lvcol);
	lvcol.cx = 180;
	lvcol.pszText = (char *)"e";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_DATA, (WPARAM)&lvcol);

	// r\{1sI
	DWORD dwStyle = ListView_GetExtendedListViewStyle(hWnd);
	dwStyle = dwStyle | LVS_EX_GRIDLINES | LVS_EX_ONECLICKACTIVATE | LVS_EX_FULLROWSELECT;
	ListView_SetExtendedListViewStyle(hWnd, dwStyle);
}

/**
 * Exifꗗ쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListView(HWND hWnd) {
	LVITEMA item;

	// 
	for (int i = 0; i < SIZE_EXIFS; i++) {
		item.iItem = i;
		SendMessage(hWnd, LVM_DELETEITEM, 0,(WPARAM)&item);
	}

	// f[^s
	for (int i = 0; i < SIZE_EXIFS; i++) {
		if (Exif[i].label.length() == 0)	break;
		// f[^
		item.mask = LVIF_TEXT;
		item.iItem = i;
		item.iSubItem = COL_LABEL;
		item.pszText = (LPSTR)_WS(Exif[i].label).c_str();
		SendMessage(hWnd, LVM_INSERTITEMA, 0,(WPARAM)&item);
		// f[^{
		item.iSubItem = COL_DATA;
		item.pszText = (LPSTR)_WS(Exif[i].data + Exif[i].unit).c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
	}
}

/**
 * ʒuRs[
 * @param	Ȃ
 * @return	Ȃ
*/
void copyLocationData(void) {
	string str = "";

	str = "ܓx(x)F" + to_string(Latitude);
	str += "\nox(x)F" + to_string(Longitude);

	setClipboardData(str);
}

/**
 * SRs[
 * @param	Ȃ
 * @return	Ȃ
*/
void copyAllData(void) {
	string str = "";

	// f[^s
	for (int i = 0; i < SIZE_EXIFS; i++) {
		if (Exif[i].label.length() == 0)	break;
		// f[^
		str += _WS(Exif[i].label) + "F" + _WS(Exif[i].data) + _WS(Exif[i].unit) + "\n";
	}
	setClipboardData(str);
}

// WebView2p֐Q ======================================================
/**
 * WebView2F_CAO
 * @param	HWND hDlg	eEBhEEnh
 * @return	Ȃ
*/
void initDialog(HWND hDlg) {
	HICON hIcon;
	ULONG_PTR lpToken;
	GdiplusStartupInput gpSI;
	hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
	ErrorMessage = "";

	// J[\v
	SetCursor(LoadCursor(NULL, IDC_WAIT));
	// IvVǂݍ
	loadParameter();
	// AvP[VEEBhEړ
	SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));

	SendMessage(hParent, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
	makeListViewFrame(GetDlgItem(hDlg, IDC_LISTVIEW_EXIF));
	// GDI+
	if (GdiplusStartup(&lpToken, &gpSI, NULL) != Gdiplus::Ok) {
		return;
	}

	// e|Et@C擾
	getTempFname(tmpFname);
	size_t wLen = 0;
	mbstowcs_s(&wLen, wUri, MAX_PATH * 2, tmpFname, MAX_PATH);
	// WebView2
	hWebView2 = createWebView2(hInst, hDlg, 10, 235, MAP_WIDTH + 20, MAP_HEIGHT + 20, wUri);

	// Leafletp\ǂׂ
	const string url = "https://unpkg.com/leaflet@latest/";
	string contents = "";
	int httpStatus = 0;
	bool res = readWebContents(url, UserAgent, &contents, &httpStatus);
	if (res == FALSE) {
		ErrorMessage = "n}`惉CuiLeafletjpł܂";
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		ErrorMessage = "n}`惉CuiLeafletjpł܂";
	}

	// bZ[WE[v
	MSG msg;
	static bool flagWebView2 = false;
	while (GetMessage(&msg, nullptr, 0, 0)) {
		if (msg.message == WM_QUIT) {
			// IvVۑ
			// saveOption();
			DestroyWindow(hDlg);
		}
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		if (!flagWebView2 && isWeb2Ready()) {
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// uEUERg[ɕ\
			viewBrowser(tmpFname);
			webView2->Reload();
			flagWebView2 = true;
		}
	}
}

/**
 * WebView2̃p[^oD
 * selectAction̒lɂēςB
 * @param	char* result	JavaScriptInhnf[^
 * @return	Ȃ
*/
void execScriptCompleted(string result) {
	// p[^ǂݍ
	vector<string> tokens;
	split(tokens, result, is_any_of(",\""));
	int cnt = 0;
	for (string ss: tokens) {
		switch (cnt) {
			case 1:
				Longitude = stod(ss);
				break;
			case 2:
				Latitude = stod(ss);
				break;
			case 3:
				Zoom = stoi(ss);
				break;
			case 4:
				Maptype = ss;
				break;
		}
		cnt++;
	}

	switch (selectAction) {
		// vOID
		case eAction::Finish:
			// e|Et@C폜D
			remove(tmpFname);
			// p[^ۑD
			saveParameter();
			// GDI+I
			GdiplusShutdown(lpToken);
			// vOI
			EndDialog(hParent, 0);
			DestroyWindow(hParent);
			break;
		// uEUERg[ɕ\
		default:
			viewBrowser(tmpFname);
			break;
	}
//	cout << "Longitude: " << Longitude << endl;
//	cout << "Latitude: " << Latitude << endl;
//	cout << "Zoom: " << Zoom << endl;
//	cout << "Maptype: " << Maptype << endl;
}

/**
 * WebView2FJavaScriptInh
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
class MyScriptCompletedHandler : public ICoreWebView2ExecuteScriptCompletedHandler {
public:
	HRESULT STDMETHODCALLTYPE Invoke(HRESULT error, PCWSTR result) override {
		if (SUCCEEDED(error)) {
			// PCWSTR  char* ϊ
			int requiredSize = WideCharToMultiByte(CP_UTF8, 0, result, -1, nullptr, 0, nullptr, nullptr);
			char* buffer = new char[requiredSize];
			WideCharToMultiByte(CP_UTF8, 0, result, -1, buffer, requiredSize, nullptr, nullptr);
			std::string res(buffer);
			// JavaScriptIɎs֐
			execScriptCompleted(res);
		}
		return S_OK;
	}

	HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void** ppvObject) override {
		return E_NOINTERFACE;
	}

	ULONG STDMETHODCALLTYPE AddRef(void) override {
		return 1;
	}

	ULONG STDMETHODCALLTYPE Release(void) override {
		return 1;
	}
};

// WebView2JavaScriptsDOMvf擾
MyScriptCompletedHandler* scriptCompletedHandler = new MyScriptCompletedHandler();

/**
 * WebView2ŃXNvgsCselectActionŎw肵ANVsD
 * @param	Ȃ
 * @param	Ȃ
 * @return	Ȃ
*/
void execScriptAndAction(void) {
	// vOIɎsJavaScript
	LPCWSTR js = L"document.getElementById('longitude').value + ',' + document.getElementById('latitude').value + ',' + document.getElementById('zoom').value + ',' + document.getElementById('maptype').value;";

	webView2->ExecuteScript(js, scriptCompletedHandler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HWND hImage;
	GdiplusStartupInput gpSI;
	static char fname[MAX_PATH + 1];
	wstring basename;
	wstring val;

	switch(uMsg) {
	// _CAO
	case WM_INITDIALOG:
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// 摜t@Cǂݍ
		case IDM_LOAD:
		case IDC_BUTTON_LOAD:
			ErrorMessage = "";
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// WebView2̃p[^擾D
			execScriptAndAction();
			// 摜\Exif擾
			hImage = GetDlgItem(hDlg, IDC_TEXT_IMAGE);
			loadImageAndExif(hImage, fname);
			// ꗗ\
			makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_EXIF));
			// uEUERg[ɕ\
			viewBrowser(tmpFname);
			// G[EZbg
			ErrorMessage = "";
			pGC->resetError();
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			basename = wgetBasename(_SW(fname)) + _SW(".csv");
			saveCSV((char *)_WS(basename).c_str());
			break;
		// GoogleAPIL[ۑ
		case IDM_GOOGLE_APIKEY:
			createSetAPIkey(hDlg, LABEL_GOOGLE_API, FNAME_GOOGLE_API, URL_GOOGLE_API, &pGC->GoogleAPIkey);
			pGC->readGoogleApiKey();
			// G[EZbg
			ErrorMessage = "";
			pGC->resetError();
			// GoogleAPIL[o^ȂftHg̃}bv^Cvɖ߂D
			Maptype = pGC->isGoogleApiKey() ? "GMRD" : DEF_MAPTYPE;
			// uEUERg[ɕ\
			viewBrowser(tmpFname);
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			// e|Et@C폜
			remove(tmpFname);
			// GDI+I
			GdiplusShutdown(lpToken);
			EndDialog(hDlg, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hDlg, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hDlg, processHelp);
			break;
		// Zp
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// ʒuRs[
		case IDC_BUTTON_COPY1:
		case IDM_COPY1:
			copyLocationData();
			break;
		// SRs[
		case IDC_BUTTON_COPY2:
		case IDM_COPY2:
			copyAllData();
			break;
		// vOI
		case IDM_QUIT:
			selectAction = eAction::Finish;
			execScriptAndAction();
			break;
		default:
			return 1;
		}
		break;

	// vOI
	case WM_CLOSE:
		selectAction = eAction::Finish;
		execScriptAndAction();
		break;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	// pahooGeocodeIuWFNg
	pGC = new pahooGeocode(APPNAME);

	// CE_CAO
	HWND hDlg = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	hInst = hInstance;
	hParent = hDlg;
	// CE_CAOD
	initDialog(hDlg);

	// IuWFNg
	delete pGC;

	return 0;
}

/*
** o[WAbv =====================================================
 *
 * @version 2.4.2  2025/10/25 gpCuXV
 * @version 2.4.1  2025/06/07 gpCuXV
 * @version 2.4.0  2025/03/15 LeafletANZXۃ`FbNǉ, UserAgentǉ, gpCuXV
 * @version 2.3.0  2024/10/26 loadImageOnMemory()--Orientation񂪂Ε\摜]
 * @version 2.2.0  2024/10/13 UTCƂ̎C̑\L@CgpCuXV
 * @version 2.1.1  2024/08/17 gpCuXV
 * @version 2.1.0  2024/05/03 enum eActionNXCAPI͏
 * @version 2.0.0  2024/04/27 EdgeuEUΉC64rbgΉ
 * @version 1.5.5  2024/03/23 gpCuXV
 * @version 1.5.4  2023/09/20 gpCuXV
 * @version 1.5.3  2023/07/02 gpCuXV
 * @version 1.5.2  2023/03/18 gpCuXV
 * @version 1.5.1  2022/11/20 gpCuXV
 * @version 1.5.0  2022/09/24 ݒNA@\ǉCCuXV
 * @version 1.4.2  2022/04/16 libcurlEOpenSSLŐVłɍXVC`̈NA
 * @version 1.4.1  2022/02/26 n}̎ނۑłȂƂsC
 * @version 1.4    2021/12/05 EBhEʒuۑ
 * @version 1.3    2021/11/13 Google}bvgpmaptypeۑł悤
 * @version 1.2    2020/12/20 leafletXNvg̎QURLύX
 * @version 1.1    2020/11/22 p[^ۑ@\ǉ
 * @version 1.0.1  2020/11/22 apikey.cpp, mystrings.cpp, pahooGeocode.cpp 
 * @version 1.0    2020/09/20 
*/
