/** earthquakewin.cpp
 * ŋ߂̒nk\
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @J	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 *					+ WebView2Loader.dll + Leaflet + OSM (+ GoogleMap)
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-12-01.shtm
*/
//  ======================================================
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <locale>
#include <regex>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <objbase.h>
#include <wrl.h>
#include <richedit.h>

#include <curl/curl.h>
#include <boost/format.hpp>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/algorithm/string.hpp>
#include "mystrings.h"
#include "apikey.h"
#include "WebView2.h"
#include "pahooWebView2.hpp"
#include "pahooCache.hpp"
#include "pahooGeocode.hpp"
#include "resource.h"

using namespace std;
using namespace boost;
using namespace boost::property_tree;

// 萔Ȃ ==================================================================
#define MAKER		"pahoo.org"				// 쐬
#define APPNAME		"earthquakewin"			// AvP[V
#define APPNAMEJP	"ŋ߂̒nk"		// AvP[Vi{j
#define APPVERSION	"4.2.2"					// o[W
#define APPYEAR		"2020-25"				// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-12-01.shtm"	// QlTCg

// ListViewItem̍ő啶yύXsz
#define MAX_LISTVIEWITEM	259

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"eq_%04d%02d%02d_%02d%02d.csv"

// LbVEfBNg
#define DIR_CACHE_FEED		"pcache1\\"
#define DIR_CACHE_FEED_L	"pcache2\\"
#define DIR_CACHE_DATA		"pcache3\\"

// LbVێԁiftHgGj(0FLbVȂ)
#define LIFE_CACHE_FEED		5		// pxtB[hɑ΂
#define LIFE_CACHE_FEED_L	120		// tB[hɑ΂
#define LIFE_CACHE_DATA		720		// nkɑ΂

// CےhЏXMLFpxtB[h - nkΎRyύXsz
#define FEED_EVOL	"https://www.data.jma.go.jp/developer/xml/feed/eqvol.xml"

// CےhЏXMLFtB[h - nkΎRyύXsz
#define FEED_EVOL_L	"https://www.data.jma.go.jp/developer/xml/feed/eqvol_l.xml"

// }bvID
#define MAP_ID			"map_id"
// n}̑傫
#define MAP_WIDTH		600		// n}̕isNZj
#define MAP_HEIGHT		400		// n}̍isNZj
// oxEܓxilj
#define DEF_LONGITUDE	139.766667
double Longitude = DEF_LONGITUDE;
#define DEF_LATITUDE	35.681111
double Latitude  = DEF_LATITUDE;
// n}g嗦ilj
#define DEF_ZOOM		6
int Zoom = DEF_ZOOM;
// n}̎ށilj
#define DEF_MAPTYPE		"GSISTD"
string Maptype = DEF_MAPTYPE;
#define INFO_WIDTH	(int)(MAP_WIDTH * 0.75)	// EBhE̍ő啝
#define INFO_OFFSET_X	0				// EBhẼItZbgʒuiX)
#define INFO_OFFSET_Y	-10				// EBhẼItZbgʒuiY)

// nk̍ői[
#define MAX_EARTHQUAKE	100

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

// WebView2EBhE
HWND hWebView2;

// vOItO
bool flagFinishProgram = false;

// ICoreWebView2FpahooWebView2.cpp Œ`D
extern ICoreWebView2* webView2;

// e|t@C
char tmpFname[MAX_PATH + 1];
wchar_t wUri[MAX_PATH * 2 + 1];

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// G[EbZ[Wi[p
string ErrorMessage;

// UserAgent
string UserAgent;

// pahooGeocodeIuWFNg
pahooGeocode* pGC;

// WebView2nh̓w肷DyύXsz
enum class eAction {
	GetLatLong,				// ܓxEox擾ăuEU\
	GetZoomType,			// g嗦E}bv^Cv擾ăuEU\
	GetLatLongZoomType,		// ܓxEoxEg嗦E}bv^Cv擾ăuEU\
	Finish					// vOI
};
eAction selectAction = eAction::GetLatLongZoomType;

// nk
wstring infoEarthquake;

// nki[\
struct _Earthquake {
	int id				= 0;			// }bsOID
	int year			= 0;			// N
	int month 			= 0;			// 
	int day				= 0;			// 
	int hour			= 0;			// 
	int minuite			= 0;			// 
	wstring location	= L"";			// kn
	double latitude		= 0.0;			// ܓx
	double longitude	= 0.0;			// ox
	double depth		= 0.0;			// [
	double magnitude	= -1.0;			// }Oj`[h
	int maxintensity	= -1;			// őkx
} Earthquake[MAX_EARTHQUAKE];

// TuEvO =====================================================
/**
 * p[^̏
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	Longitude = DEF_LONGITUDE;
	Latitude  = DEF_LATITUDE;
	Zoom      = DEF_ZOOM;
	Maptype   = DEF_MAPTYPE;
	hParent_X = 0;
	hParent_Y = 0;
}

/**
 * p[^̓ǂݍ
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "latitude") {
					Latitude = stod(it.second.data());
				} else if (type == "longitude") {
					Longitude = stod(it.second.data());
				} else if (type == "zoom") {
					Zoom = stoi(it.second.data());
				} else if (type == "maptype") {
					Maptype = (string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			initParameter();
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		initParameter();
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * p[^̕ۑ
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	char lng[SIZE_BUFF + 1], lat[SIZE_BUFF + 1];
	snprintf(lng, SIZE_BUFF, "%.5f", Longitude);
	snprintf(lat, SIZE_BUFF, "%.5f", Latitude);

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", lat);
	child1.add("<xmlattr>.type", "latitude");
	ptree& child2 = pt.add("parameter.param", lng);
	child2.add("<xmlattr>.type", "longitude");
	ptree& child3 = pt.add("parameter.param", to_string(Zoom));
	child3.add("<xmlattr>.type", "zoom");
	ptree& child4 = pt.add("parameter.param", Maptype);
	child4.add("<xmlattr>.type", "maptype");
	ptree& child5 = pt.add("parameter.param", (string)to_string(hParent_X));
	child5.add("<xmlattr>.type", "wx");
	ptree& child6 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child6.add("<xmlattr>.type", "wy");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^̍폜
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	string help;

	switch(uMsg){
		// _CAO
		case WM_INITDIALOG:
			CenterWindow(hDlg);
			// bZ[W쐬
			help = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
p܂ޖp\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

Copyright by (c)studio pahoo, %3%
https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DCےhЏXML̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCC^[lbg̃\[X𗘗pĂ܂D
@MinGWig++j^Boost C++Cu^libcurl^OpenSSL+^
@WebView2Loader.dll^@Leaflet^OpenStreetMap^Google}bv^
@CےhЏXML
)")
% APPNAME
% APPVERSION
% APPYEAR
).str();
			setStrEditBox(hDlg, IDC_TEXT_HELP, help);
			break;

		// {^
		case WM_COMMAND:
			 switch (LOWORD(wParam)) {
				// s
				case IDC_BUTTON_OK:
					EndDialog(hDlg, 0);
					DestroyWindow(hDlg);
					break;
				default:
					return 1;
			}
			break;
		// vOI
		case WM_CLOSE:
			EndDialog(hDlg, 0);
			DestroyWindow(hDlg);
			break;
	}
    return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
*/
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC)handler);
}

// 擾iC^[lbgj ===============================================
/**
 * CےhЏXMLŐV̐kEkxɊւURL擾
 * @param	string* urls URLi[z
 * @return	bool TRUEF擾^FALSEF擾s
*/
bool jma_getLastEarthquakeURLs(string* urls) {
	// URLp^[
	regex re01("https?\\:\\/\\/www\\.data\\.jma\\.go\\.jp\\/developer\\/xml\\/data\\/([0-9\\_]+)VXSE53\\_[0-9]+\\.xml");
	smatch mt1;
	int cnt = 0;
	bool flag;
	static string contents = "";
	pahooCache* pCC;	// pahooCacheIuWFNg

	// pxtB[h̉
	pCC = new pahooCache(LIFE_CACHE_FEED, getMyPath(APPNAME) + DIR_CACHE_FEED, UserAgent);
	if (pCC->load(FEED_EVOL, &contents) == FALSE) {
		ErrorMessage = _WS(pCC->getError());
		return FALSE;
	}
	// XMLǂݍ
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		xml_parser::read_xml(ss, pt);

		// XML
		wstring co = L"";
		try {
			for (auto it : pt.get_child("feed")) {
				// URL
				if (optional<string>url = it.second.get_optional<string>("link.<xmlattr>.href")) {
					flag = TRUE;
					if (regex_search(url.value(), mt1, re01)) {
						// dURLłȂΓo^
						flag = TRUE;
						for (int i = 0; i < cnt; i++) {
							if (urls[i] == mt1[0].str()) {
								flag = FALSE;
								break;
							}
						}
						if (flag) {
							urls[cnt] = mt1[0].str();
//							cout << urls[cnt] << endl;
							cnt++;
						}
						if (cnt >= MAX_EARTHQUAKE) {
							break;
						}
					}
				}
			}
		// XML߃G[
		} catch(ptree_bad_path& e) {
			ErrorMessage = "CےhЏXMLɃANZXł܂";
		return FALSE;
		}
	// ǂݍ݃G[
	} catch(xml_parser_error& e) {
		ErrorMessage = "CےhЏXMLɃANZXł܂";
		return FALSE;
	}
	contents.clear();
	delete pCC;

	// tB[h̉
	pCC = new pahooCache(LIFE_CACHE_FEED, getMyPath(APPNAME) + DIR_CACHE_FEED_L, UserAgent);
	int httpStatus = 0;
	readWebContents(FEED_EVOL_L, UserAgent, &contents, &httpStatus);
	if (pCC->load(FEED_EVOL_L, &contents) == FALSE) {
		ErrorMessage = _WS(pCC->getError());
		return FALSE;
	}
	// XMLǂݍ
	try {
		std::stringstream ss;
		ss << contents;
		ptree pt;
		xml_parser::read_xml(ss, pt);

		// XML
		wstring co = L"";
		try {
			for (auto it : pt.get_child("feed")) {
				// URL
				if (optional<string>url = it.second.get_optional<string>("link.<xmlattr>.href")) {
					flag = TRUE;
					if (regex_search(url.value(), mt1, re01)) {
						// dURLłȂΓo^
						flag = TRUE;
						for (int i = 0; i < cnt; i++) {
							if (urls[i] == mt1[0].str()) {
								flag = FALSE;
								break;
							}
						}
						if (flag) {
							urls[cnt] = mt1[0].str();
//							cout << urls[cnt] << endl;
							cnt++;
						}
						if (cnt >= MAX_EARTHQUAKE) {
							break;
						}
					}
				}
			}
		// XML߃G[
		} catch(ptree_bad_path& e) {
			ErrorMessage = "CےhЏXMLɃANZXł܂";
		return FALSE;
		}
	// ǂݍ݃G[
	} catch(xml_parser_error& e) {
		ErrorMessage = "CےhЏXMLɃANZXł܂";
		return FALSE;
	}
	contents.clear();
	delete pCC;

	if (cnt == 0) {
		ErrorMessage = "ŋ߂̒nk͂܂";
		return FALSE;
	}

	// URL̐VɃ\[g
	sort(urls, urls + MAX_EARTHQUAKE, greater<>());

	return TRUE;
}

/**
 * nk擾iCےhЏXMLj
 * @param	Ȃ
 * @return	bool TRUEF擾^FALSEFs
*/
bool getEarthquake(void) {
	// N
	regex re1("([0-9]+)\\-([0-9]+)\\-([0-9]+)T([0-9]+)\\:([0-9]+)");
	// ܓxEoxE[
	regex re2("([\\+\\-][0-9\\.]+)([\\+\\-][0-9\\.]+)([\\-\\+\\/])([0-9]*)");
	smatch mt1, mt2;
	double lng, lat;
	pahooCache* pCC;	// pahooCacheIuWFNg

	// nkURL擾
	static string urls[MAX_EARTHQUAKE];
	bool res = jma_getLastEarthquakeURLs(urls);
	if (res == FALSE) {
		return FALSE;
	}

	static string contents = "";
	pCC = new pahooCache(LIFE_CACHE_DATA, getMyPath(APPNAME) + DIR_CACHE_DATA, UserAgent);
	for (int i = 0; i < MAX_EARTHQUAKE; i++) {
		if (urls[i] == "") {
//			cout << "count = " << i << endl;
			break;
		}
		int httpStatus = 0;
		readWebContents(urls[i], UserAgent, &contents, &httpStatus);
		if (pCC->load(urls[i], &contents) == FALSE) {
			ErrorMessage = _WS(pCC->getError());
			return FALSE;
		}
		// XMLǂݍ
		try {
			std::stringstream ss;
			ss << contents;
			ptree pt;
			xml_parser::read_xml(ss, pt);

			// XML
			// nk̎擾
			if (optional<string>str = pt.get_optional<string>("Report.Body.Earthquake.OriginTime")) {
//				cout << str.value() << " ";
				if (regex_search(str.value(), mt1, re1)) {
					Earthquake[i].year    = stoi(mt1[1].str());
					Earthquake[i].month   = stoi(mt1[2].str());
					Earthquake[i].day     = stoi(mt1[3].str());
					Earthquake[i].hour    = stoi(mt1[4].str());
					Earthquake[i].minuite = stoi(mt1[5].str());
				}
			}
			// kn̎擾
			if (optional<string>str = pt.get_optional<string>("Report.Body.Earthquake.Hypocenter.Area.Name")) {
				Earthquake[i].location = _UW(str.value());
//				cout << _WS(Earthquake[i].location) << "  ";
			}
			if (optional<string>str = pt.get_optional<string>("Report.Body.Earthquake.Hypocenter.Area.jmx_eb:Coordinate")) {
				if (regex_search(str.value(), mt2, re2)) {
					pGC->tokyo_wgs84(stod(mt2[2].str()), stod(mt2[1].str()), &lng, &lat);
					Earthquake[i].latitude  = lat;
					Earthquake[i].longitude = lng;
					if (mt2[3].str() == "/") {
						Earthquake[i].depth = (-1.0);
					} else {
						Earthquake[i].depth = stod(mt2[4].str());
					}
//					cout << "lat=" << lat << " lng=" << lng << " ";
				}
			}
			// }Oj`[h̎擾
			if (optional<string>str = pt.get_optional<string>("Report.Body.Earthquake.jmx_eb:Magnitude")) {
				Earthquake[i].magnitude = stod(str.value());
//				cout << "M=" << Earthquake[i].magnitude << " ";
			}
			// őkx̎擾
			if (optional<string>str = pt.get_optional<string>("Report.Body.Intensity.Observation.MaxInt")) {
				Earthquake[i].maxintensity = stoi(str.value());
//				cout << "max=" << Earthquake[i].maxintensity << endl;
			}
		// ǂݍ݃G[
		} catch(xml_parser_error& e) {
			ErrorMessage = "CےhЏXMLɃANZXł܂";
			return FALSE;
		}
		contents.clear();
	}
	delete pCC;

	return TRUE;
}

// n}\iuEUj ======================================================
/**
 * \pϊFܓxEox
 * @param	char*  buff   o͐
 * @param	double latlng ܓx܂͌ox
 * @param	char*  prefix ̑Oɕt镶iFk܁j
 * @return	Ȃ
*/
void printLatLng(char* buff, double latlng, char* prefix) {
	if (latlng <= 0.0) {
		snprintf(buff, SIZE_BUFF, "s");
	} else {
		snprintf(buff, SIZE_BUFF, "%s%.1f", prefix, latlng);
	}
}

/**
 * \pϊFk̐[
 * @param	char* buff  o͐
 * @param	double depth k̐[i[gj
 * @return	Ȃ
*/
void printDepth(char* buff, double depth) {
	if (depth < 0.0) {
		snprintf(buff, SIZE_BUFF, "s");
	} else if (depth == 0.0) {
		snprintf(buff, SIZE_BUFF, "");
	} else {
		snprintf(buff, SIZE_BUFF, "%.0fkm", depth / 1000.0);
	}
}

/**
 * \pϊF}Oj`[h
 * @param	char* buff       o͐
 * @param	double magnitude }Oj`[h
 * @param	char* prefix     ̑Oɕt镶iF}Oj`[hj
 * @return	Ȃ
*/
void printMagnitude(char* buff, double magnitude, char* prefix) {
	if (magnitude < 0.0) {
		snprintf(buff, SIZE_BUFF, "s");
	} else {
		snprintf(buff, SIZE_BUFF, "%s%.1f", prefix, magnitude);
	}
}

/**
 * \pϊFkx
 * @param	char* buff      o͐
 * @param	int   intensity kx
 * @return	Ȃ
*/
void printIntensity(char* buff, int intensity) {
	if (intensity < 0) {
		snprintf(buff, SIZE_BUFF, "s");
	} else {
		snprintf(buff, SIZE_BUFF, "%d", intensity);
	}
}

/**
 * nkeLXg擾
 * @param	int i   nkԍ
 * @return	wstring nk
*/
wstring makeInfo(int i) {
	char buff1[SIZE_BUFF + 1], buff2[SIZE_BUFF + 1], buff3[SIZE_BUFF + 1];
	char buff4[SIZE_BUFF + 1], buff5[SIZE_BUFF + 1];

	// k̈ʒu
	if ((Earthquake[i].latitude <= 0.0) || (Earthquake[i].longitude <= 0.0)) {
		snprintf(buff2, SIZE_BUFF, "s");
	} else {
		snprintf(buff2, SIZE_BUFF, "k %.1fxCo %.1fx", Earthquake[i].latitude, Earthquake[i].longitude);
	}

	// k̐[
	printDepth(buff3, Earthquake[i].depth);

	// }Oj`[h
	printMagnitude(buff4, Earthquake[i].magnitude, (char*)"}Oj`[h ");

	// őkx
	printIntensity(buff5, Earthquake[i].maxintensity);

	// \eLXg쐬
	snprintf(buff1, SIZE_BUFF, "F%04dN%02d%02d %02d%02d\nknF%s\nk̈ʒuF%s\nk̐[F%s\nnk̋ḰF%s\nőkxF%s", Earthquake[i].year, Earthquake[i].month, Earthquake[i].day, Earthquake[i].hour, Earthquake[i].minuite, _WS(Earthquake[i].location).c_str(), buff2, buff3, buff4, buff5);

	return _SW(buff1);
}

/**
 * nk}bsOɕϊ
 * @param	Ȃ
 * @return	int ϊ}bsǑ
*/
int info2points(void) {
	int j = 0;
	int k = 0;
	for (int i = 0; i < MAX_EARTHQUAKE; i++) {
		if (Earthquake[i].year == 0) {
			break;
		}
		// }bsOʒu邩ǂ
		bool flag = FALSE;
		for (k = 0; k < j; k++) {
			if ((Earthquake[i].latitude == pGC->Ppoints[k].latitude) && (Earthquake[i].longitude == pGC->Ppoints[k].longitude)) {
				flag = TRUE;
				pGC->Ppoints[k].description += _SW("<br><hr>");
				break;
			}
		}
		// VK̃}bsOʒu
		if (flag == FALSE) {
			k = j;
			pGC->Ppoints[k].latitude  = Earthquake[i].latitude;
			pGC->Ppoints[k].longitude = Earthquake[i].longitude;
			pGC->Ppoints[k].title = pGC->Ppoints[k].address = pGC->Ppoints[k].description = L"";
			pGC->Ppoints[k].icon = "";
			j++;
		}
		Earthquake[i].id = k + 1;

		pGC->Ppoints[k].description += wrepNL(makeInfo(i), _SW("<br>"));

		// ł؂
		if (j >= 26) {
			break;
		}
	}

	return j;
}

/**
 * n}\pHTML
 * @param	string \CtH[V
 * @return	string HTML
 */
string makeMapHTML(wstring info) {
	int cnt = info2points();
	string script = pGC->makeMapLeaflet(MAP_ID, Earthquake[0].longitude, Earthquake[0].latitude, Zoom, Maptype, pGC->Ppoints, cnt, "", "", INFO_WIDTH, INFO_OFFSET_X, INFO_OFFSET_Y);

	string html = (boost::format(R"(<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>%9%</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
%8%
</head>
<body>
<div id="%1%" style="width:%2%px; height:%3%px;"></div>
<form>
<input id="latitude"  type="hidden" value="%4%" />
<input id="longitude" type="hidden" value="%5%" />
<input id="zoom"      type="hidden" value="%6%" />
<input id="maptype"   type="hidden" value="%7%" />
</form>
</body>
</html>
)")
% MAP_ID						// n}ID
% MAP_WIDTH						// n}̕
% MAP_HEIGHT					// n}̍
% Earthquake[0].latitude		// ܓx
% Earthquake[0].longitude		// ox
% Zoom							// n}g嗦
% Maptype						// n}^Cv
% script						// n}`XNvg
% APPNAMEJP						// AvP[V
).str();

	return html;
}

/**
 * G[bZ[WHTMLɂ
 * @param	Ȃ
 * @return	string HTML
*/
string makeErrorHTML(void) {
	return (boost::format(R"(
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>%2%</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
</head>
<body>
<p style="color:red; font-size:large;">%1%</p>
</body>
</html>
)")
% ErrorMessage
% APPNAMEJP
).str();
}

/**
 * uEUERg[\
 * @param	wstring info EBhEɕ\eLXg
 * @param	char* tmpname ǂݍHTMLt@C
 * @return	Ȃ
*/
void viewBrowser(wstring info, const char* tmpname) {
	string html;
	string fname;
	ofstream ofs;

	// \pHTMLt@C쐬
	if ((ErrorMessage == "") && (! pGC->isError())) {
		html = makeMapHTML(info);
	} else {
		html = makeErrorHTML();
	}
	ofs.open(tmpname);
	ofs << html;
	ofs.close();

	fname = (string)tmpname;
	std::replace(fname.begin(), fname.end(), '\\', '/');

	if (isWeb2Ready()) {
		webView2->Reload();
	}
}

// nkꗗ쐬iXgr[j =========================================
// Xgr[̗
enum {
	COL_ID,
	COL_DATETIME,
	COL_LOCATION,
	COL_LATITUDE,
	COL_LONGITUDE,
	COL_DEPTH,
	COL_MAGNITUDE,
	COL_MAXINTENSITY
};

/**
 * nkꗗt[쐬
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListViewFrame(HWND hWnd) {
	LVCOLUMNA lvcol;
	lvcol.mask = LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH | LVCF_FMT;

	lvcol.cx = 25;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"ID";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_ID, (WPARAM)&lvcol);
	lvcol.cx = 140;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_DATETIME, (WPARAM)&lvcol);
	lvcol.cx = 120;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"ꏊ";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_LOCATION, (WPARAM)&lvcol);
	lvcol.cx = 50;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"k";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_LATITUDE, (WPARAM)&lvcol);
	lvcol.cx = 50;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"o";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_LONGITUDE, (WPARAM)&lvcol);
	lvcol.cx = 80;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"[";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_DEPTH, (WPARAM)&lvcol);
	lvcol.cx = 50;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"l";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_MAGNITUDE, (WPARAM)&lvcol);
	lvcol.cx = 70;
	lvcol.fmt = LVCFMT_CENTER;
	lvcol.pszText = (char *)"őkx";
	SendMessage(hWnd, LVM_INSERTCOLUMNA, COL_MAXINTENSITY, (WPARAM)&lvcol);

	// r\
	DWORD dwStyle = ListView_GetExtendedListViewStyle(hWnd);
	dwStyle = dwStyle | LVS_EX_GRIDLINES | LVS_EX_ONECLICKACTIVATE | LVS_EX_FULLROWSELECT;;
	ListView_SetExtendedListViewStyle(hWnd, dwStyle);
}

/**
 * nkꗗ\
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void makeListView(HWND hWnd) {
	LVITEMA item;
	char buff[SIZE_BUFF + 1];

	// 
	for (int i = 0; i < __SIZE_PPOINTS; i++) {
		item.iItem = i;
		SendMessage(hWnd, LVM_DELETEITEM, 0, (WPARAM)&item);
	}

	// f[^s
	for (int i = 0; i < MAX_EARTHQUAKE; i++) {
		if (Earthquake[i].year == 0) {
			break;
		}
		// ID
		item.mask = LVIF_TEXT;
		item.iItem = i;
		item.iSubItem = COL_ID;
		string s = {(char)(64 + Earthquake[i].id)};
		item.pszText = (LPSTR)(s.c_str());
		SendMessage(hWnd, LVM_INSERTITEMA, 0, (WPARAM)&item);
		// 
		snprintf(buff, SIZE_BUFF, "%02d%02d %02d%02d",
			Earthquake[i].month, Earthquake[i].day,
			Earthquake[i].hour, Earthquake[i].minuite);
		item.iSubItem = COL_DATETIME;
		item.pszText  = (LPSTR)buff;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// ꏊ
		item.iSubItem = COL_LOCATION;
		item.pszText  = (LPSTR)_WS(Earthquake[i].location).c_str();
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// k
		printLatLng(buff, Earthquake[i].latitude, (char*)"");
		item.iSubItem = COL_LATITUDE;
		item.pszText  = (LPSTR)buff;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// o
		printLatLng(buff, Earthquake[i].longitude, (char*)"");
		item.iSubItem = COL_LONGITUDE;
		item.pszText  = (LPSTR)buff;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// k̐[
		printDepth(buff, Earthquake[i].depth);
		item.iSubItem = COL_DEPTH;
		item.pszText  = (LPSTR)buff;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// }Oj`[h
		printMagnitude(buff, Earthquake[i].magnitude, (char*)"");
		item.iSubItem = COL_MAGNITUDE;
		item.pszText  = (LPSTR)buff;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
		// őkx
		printIntensity(buff, Earthquake[i].maxintensity);
		item.iSubItem = COL_MAXINTENSITY;
		item.pszText  = (LPSTR)buff;
		SendMessage(hWnd, LVM_SETITEMA, 0,(WPARAM)&item);
	}
}

// ۑERs[ =============================================================
/**
 * ꗗCSVt@CɕۑFۑ
 * @param	const char* fname ۑt@C
 * @return	Ȃ
 */
void __saveCSV(const char *fname) {
	char buff1[SIZE_BUFF + 1], buff2[SIZE_BUFF + 1], buff3[SIZE_BUFF + 1];
	char buff4[SIZE_BUFF + 1], buff5[SIZE_BUFF + 1], buff6[SIZE_BUFF + 1];
	string str;
	ofstream outputfile(fname);

	// x
	outputfile << "\"" << "ID" << "\",";
	outputfile << "\"" << "" << "\",";
	outputfile << "\"" << "ꏊ" << "\",";
	outputfile << "\"" << "ܓx" << "\",";
	outputfile << "\"" << "ox" << "\",";
	outputfile << "\"" << "[" << "\",";
	outputfile << "\"" << "}Oj`[h" << "\",";
	outputfile << "\"" << "őkx" << "\"";
	outputfile << endl;

	// f[^{
	for (int i = 0; i < MAX_EARTHQUAKE; i++) {
		if (Earthquake[i].year != 0) {
			// 
			snprintf(buff1, SIZE_BUFF, "%04d-%02d-%02dT%02d:%02d:00+09:00",
				Earthquake[i].year, Earthquake[i].month, Earthquake[i].day,
				Earthquake[i].hour, Earthquake[i].minuite);
			// ܓx
			printLatLng(buff2, Earthquake[i].latitude, (char*)"");
			// ox
			printLatLng(buff3, Earthquake[i].longitude, (char*)"");
			// k̐[
			printDepth(buff4, Earthquake[i].depth);
			// }Oj`[h
			printMagnitude(buff5, Earthquake[i].magnitude, (char*)"");
			// őkx
			printIntensity(buff6, Earthquake[i].maxintensity);

			outputfile << "\"" << (char)(64 + Earthquake[i].id) << "\",";
			outputfile << "\"" << buff1 << "\",";
			outputfile << "\"" << _WS(Earthquake[i].location) << "\",";
			outputfile << "\"" << buff2 << "\",";
			outputfile << "\"" << buff3 << "\",";
			outputfile << "\"" << buff4 << "\",";
			outputfile << "\"" << buff5 << "\",";
			outputfile << "\"" << buff6 << "\"";
			outputfile << endl;
		}
		if (outputfile.bad()) {
			ErrorMessage = "CSVt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * ꗗCSVt@CɕۑFt@C_CAO
 * @param	Ȃ
 * @return	Ȃ
 */
void saveCSV(void) {
	static char fname[MAX_PATH + 1];
	snprintf(fname, MAX_PATH, SAVEFILE, Earthquake[0].year, Earthquake[0].month, Earthquake[0].day, Earthquake[0].hour, Earthquake[0].minuite);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("CSVt@C(*.csv;*.txt)\0*.csv;*.txt\0ׂẴt@C(*.txt)\0*.txt\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("csv");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveCSV(fname);
}

/**
 * Nbv{[hɃRs[镶𐶐
 * @param	Ȃ
 * @return	string Rs[镶
 */
string copyText(void) {
	char buff1[SIZE_BUFF + 1], buff2[SIZE_BUFF + 1], buff3[SIZE_BUFF + 1];
	char buff4[SIZE_BUFF + 1], buff5[SIZE_BUFF + 1], buff6[SIZE_BUFF + 1];
	string str;
	ostringstream oss;

	// x
	oss << "ID" << "\t";
	oss << "" << "\t";
	oss << "ꏊ" << "\t";
	oss << "ܓx" << "\t";
	oss << "ox" << "\t";
	oss << "[" << "\t";
	oss << "}Oj`[h" << "\t";
	oss << "őkx" << endl;

	// f[^{
	for (int i = 0; i < MAX_EARTHQUAKE; i++) {
		if (Earthquake[i].year != 0) {
			// 
			snprintf(buff1, SIZE_BUFF, "%04d-%02d-%02dT%02d:%02d:00+09:00",
				Earthquake[i].year, Earthquake[i].month, Earthquake[i].day,
				Earthquake[i].hour, Earthquake[i].minuite);
			// ܓx
			printLatLng(buff2, Earthquake[i].latitude, (char*)"");
			// ox
			printLatLng(buff3, Earthquake[i].longitude, (char*)"");
			// k̐[
			printDepth(buff4, Earthquake[i].depth);
			// }Oj`[h
			printMagnitude(buff5, Earthquake[i].magnitude, (char*)"");
			// őkx
			printIntensity(buff6, Earthquake[i].maxintensity);

			oss << (char)(64 + Earthquake[i].id) << "\t";
			oss << buff1 << "\t";
			oss << _WS(Earthquake[i].location) << "\t";
			oss << buff2 << "\t";
			oss << buff3 << "\t";
			oss << buff4 << "\t";
			oss << buff5 << "\t";
			oss << buff6 << endl;
		}
	}
	return oss.str();
}

// WebView2p֐Q ======================================================
/**
 * WebView2F_CAO
 * @param	HWND hDlg	eEBhEEnh
 * @return	Ȃ
*/
void initDialog(HWND hDlg) {
	HICON hIcon;
	hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
	ErrorMessage = "";

	// J[\v
	SetCursor(LoadCursor(NULL, IDC_WAIT));
	// IvVǂݍ
	loadParameter();
	// AvP[VEEBhEړ
	SetWindowPos(hDlg, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));

	// e|Et@C擾
	getTempFname(tmpFname);
	size_t wLen = 0;
	mbstowcs_s(&wLen, wUri, MAX_PATH * 2, tmpFname, MAX_PATH);
	// WebView2
	hWebView2 = createWebView2(hInst, hDlg, 10, 10, MAP_WIDTH + 20, MAP_HEIGHT + 20, wUri);

	// Leafletp\ǂׂ
	const string url = "https://unpkg.com/leaflet@latest/";
	string contents = "";
	int httpStatus = 0;
	bool res = readWebContents(url, UserAgent, &contents, &httpStatus);
	if (res == FALSE) {
		ErrorMessage = "n}`惉CuiLeafletjpł܂";
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		ErrorMessage = "n}`惉CuiLeafletjpł܂";
	}

	// bZ[WE[v
	MSG msg;
	static bool flagWebView2 = false;
	while (GetMessage(&msg, nullptr, 0, 0)) {
		if (msg.message == WM_QUIT) {
			// IvVۑ
			// saveOption();
			DestroyWindow(hDlg);
		}
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		if (!flagWebView2 && isWeb2Ready()) {
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// nk擾
			getEarthquake();
			// uEUERg[ɕ\
			viewBrowser(infoEarthquake, tmpFname);
			webView2->Reload();
			flagWebView2 = true;
			// nkꗗt[쐬
			makeListViewFrame(GetDlgItem(hDlg, IDC_LISTVIEW_EARTHQUAKE));
			// nkꗗ\
			makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_EARTHQUAKE));
		}
	}
}

/**
 * WebView2̃p[^oD
 * selectAction̒lɂēςB
 * @param	string result	JavaScriptInhnf[^
 * @return	Ȃ
*/
void execScriptCompleted(string result) {
	// p[^ǂݍ
	vector<string> tokens;
	split(tokens, result, is_any_of(",\""));
	int cnt = 0;
	for (string ss: tokens) {
		switch (cnt) {
			case 1:
				Longitude = stod(ss);
				break;
			case 2:
				Latitude = stod(ss);
				break;
			case 3:
				Zoom = stoi(ss);
				break;
			case 4:
				Maptype = ss;
				break;
		}
		cnt++;
	}

	switch (selectAction) {
		// vOID
		case eAction::Finish:
			// e|Et@C폜D
			remove(tmpFname);
			// p[^ۑD
			saveParameter();
			// vOI
			EndDialog(hParent, 0);
			DestroyWindow(hParent);
			break;
		// uEUERg[ɕ\
		default:
			viewBrowser(infoEarthquake, tmpFname);
			break;
	}
//	cout << "Longitude: " << Longitude << endl;
//	cout << "Latitude: " << Latitude << endl;
//	cout << "Zoom: " << Zoom << endl;
//	cout << "Maptype: " << Maptype << endl;
}

/**
 * WebView2FJavaScriptInh
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
class MyScriptCompletedHandler : public ICoreWebView2ExecuteScriptCompletedHandler {
public:
	HRESULT STDMETHODCALLTYPE Invoke(HRESULT error, PCWSTR result) override {
		if (SUCCEEDED(error)) {
			// PCWSTR  char* ϊ
			int requiredSize = WideCharToMultiByte(CP_UTF8, 0, result, -1, nullptr, 0, nullptr, nullptr);
			char* buffer = new char[requiredSize];
			WideCharToMultiByte(CP_UTF8, 0, result, -1, buffer, requiredSize, nullptr, nullptr);
			std::string res(buffer);
			// JavaScriptIɎs֐
			execScriptCompleted(res);
		}
		return S_OK;
	}

	HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void** ppvObject) override {
		return E_NOINTERFACE;
	}

	ULONG STDMETHODCALLTYPE AddRef(void) override {
		return 1;
	}

	ULONG STDMETHODCALLTYPE Release(void) override {
		return 1;
	}
};

// WebView2JavaScriptsDOMvf擾
MyScriptCompletedHandler* scriptCompletedHandler = new MyScriptCompletedHandler();

/**
 * WebView2̃p[^ۑD
 * selectAction̒lɂēςB
 * @param	Ȃ
 * @return	Ȃ
*/
void execScriptAndAction(void) {
	// vOIɎsJavaScript
	LPCWSTR js = L"document.getElementById('longitude').value + ',' + document.getElementById('latitude').value + ',' + document.getElementById('zoom').value + ',' + document.getElementById('maptype').value;";

	webView2->ExecuteScript(js, scriptCompletedHandler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	pahooCache* pCC;	// pahooCacheIuWFNg

    switch(uMsg) {
	// _CAO
	case WM_INITDIALOG:
		break;

	// {^
	case WM_COMMAND:
		 switch (LOWORD(wParam)) {
		// s
		case IDM_EXEC:
		case IDC_BUTTON_EXEC:
			ErrorMessage = "";
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// nk擾
			getEarthquake();
			// WebView2̃p[^擾D
			execScriptAndAction();
			// nkꗗ\
			makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_EARTHQUAKE));
            break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveCSV();
			break;
		// GoogleAPIL[ۑ
		case IDM_GOOGLE_APIKEY:
			createSetAPIkey(hDlg, LABEL_GOOGLE_API, FNAME_GOOGLE_API, URL_GOOGLE_API, &pGC->GoogleAPIkey);
			pGC->readGoogleApiKey();
			// G[EZbg
			ErrorMessage = "";
			pGC->resetError();
			// GoogleAPIL[o^ȂftHg̃}bv^Cvɖ߂D
			Maptype = pGC->isGoogleApiKey() ? "GMRD" : DEF_MAPTYPE;
			// uEUERg[ɕ\
			viewBrowser(infoEarthquake, tmpFname);
			// nkꗗ\
			makeListView(GetDlgItem(hDlg, IDC_LISTVIEW_EARTHQUAKE));
			break;
		// LbVENA
		case IDM_CLEAR_CACHE:
			pCC = new pahooCache(LIFE_CACHE_FEED_L, getMyPath(APPNAME) + DIR_CACHE_FEED_L, UserAgent);
			pCC->delCache(".+", 0);
			delete pCC;
			pCC = new pahooCache(LIFE_CACHE_FEED, getMyPath(APPNAME) + DIR_CACHE_FEED, UserAgent);
			pCC->delCache(".+", 0);
			delete pCC;
			pCC = new pahooCache(LIFE_CACHE_DATA, getMyPath(APPNAME) + DIR_CACHE_DATA, UserAgent);
			pCC->delCache(".+", 0);
			delete pCC;
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			// ݒt@C폜D
			delParameter();
			// e|Et@C폜D
			remove(tmpFname);
			EndDialog(hParent, 0);
			DestroyWindow(hDlg);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hParent, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hParent, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
		case IDC_BUTTON_COPY:
			setClipboardData(copyText());
			break;
		// vOI
		case IDM_QUIT:
			selectAction = eAction::Finish;
			execScriptAndAction();
			break;
		default:
			return 1;
		}
		break;

	// vOI
	case WM_CLOSE:
		selectAction = eAction::Finish;
		execScriptAndAction();
		break;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	// pahooGeocodeIuWFNg
	pGC = new pahooGeocode(APPNAME);

	// CE_CAO
	HWND hDlg = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	hInst = hInstance;
	hParent = hDlg;
	// CE_CAOD
	initDialog(hDlg);

	// IuWFNg
	delete pGC;

	return 0;
}

/*
** o[WAbv =====================================================
 *
 * @version 4.2.2  2025/10/25 gpCuXV
 * @version 4.2.1  2025/07/17 gpCuXV
 * @version 4.2.0  2025/03/15 LeafletANZXۃ`FbNǉCgpCuXV
 * @version 4.1.2  2024/11/23 gpCuXV
 * @version 4.1.1  2024/08/17 gpCuXV
 * @version 4.1.0  2024/05/03 enum eActionNXCAPI͏
 * @version 4.0.0  2024/04/27 EdgeuEUΉC64rbgΉ
 * @version 3.4.5  2024/03/16 gpCuXV
 * @version 3.4.4  2023/11/11 gpCuXV
 * @version 3.4.3  2023/07/02 gpCuXV
 * @version 3.4.2  2023/03/18 gpCuXV
 * @version 3.4.1  2022/11/12 gpCuXV
 * @version 3.4.0  2022/09/03 ep[^̕ۑ
 * @version 3.3.1  2022/09/03 ŐVŃCuɍXV
 * @version 3.3    2022/03/19 CےhЏXMLhttpsɑΉ
 * @version 3.2    2021/05/24 sCF[s̃p^[ǉC
 * @version 3.1    2021/05/01 LbVEVXeC
 * @version 3.0    2021/03/30 ŋ߂̒nkijꗗ\C
 * @version 2.0    2021/03/07 CےhЏXML擾ɕύX
 * @version 1.1    2021/01/02 pahooGeocodeNXȂǑ啝
 * @version 1.0    2020/09/19 
*/
