/** pahooCache.cpp
 * LbVɊւNXFC++\[X
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01-16-01.shtm
 */
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <direct.h>
#include <sys/stat.h>
#include <dirent.h>
#include <sstream>
#include <string>
#include <regex>
#include <locale>
#include <math.h>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/date_time/gregorian/gregorian.hpp>
#include <boost/format.hpp>
#include <boost/algorithm/hex.hpp>
#include <boost/uuid/detail/md5.hpp>
#include "mystrings.h"
#include "pahooCache.hpp"

using namespace std;
using namespace boost;
using namespace boost::property_tree;
using namespace boost::uuids::detail;

/**
 * RXgN^
 * @param	unsigned int life LbVێԁij
 * @param	string dir        LbVEfBNg
 * @param   string ua         UserAgent
 * @return	Ȃ
 */
pahooCache::pahooCache(unsigned int life, string dir, const string ua) {
	// dir̍ŌɃfBNg؂蕶ȂΒǉ
	smatch mt;
	regex re("\\\\$");
	if (regex_search(dir, mt, re) == FALSE) {
		dir = dir + "\\";
	}
	this->errmsg = L"";
	this->lifeCache = life;
	this->dirCache  = dir;
	this->userAgent = ua;

	// LbVEfBNg΍쐬
	struct stat statBuf;
	if (stat(this->dirCache.c_str(), &statBuf) != 0) {
		if (_mkdir(this->dirCache.c_str()) != 0) {
			errmsg = _SW("LbVEfBNg \"") + _SW(this->dirCache) + _SW("\" ̍쐬Ɏs܂");
		}
	}
}

// fXgN^
pahooCache::~pahooCache() {
}

// e폈 ==================================================================
/**
 * G[
 * @param	Ȃ
 * @return	bool TRUE:ُ^FALSE:
*/
bool pahooCache::isError(void) {
	return this->errmsg.length() > 0;
}

/**
 * G[bZ[W擾
 * @param	Ȃ
 * @return	wstring ݔĂG[bZ[W
*/
wstring pahooCache::getError(void) {
	return this->errmsg;
}

/**
 * G[Zbg
 * @param	Ȃ
 * @return	Ȃ
*/
void pahooCache::resetError(void) {
	this->errmsg = L"";
}

/**
 * LbVEfBNg擾
 * @param	Ȃ
 * @return	string LbVEfBNg
*/
string pahooCache::getDirCache(void) {
	return this->dirCache;
}

/**
 * LbV̍폜
 * @param	string pat 폜t@CiK\w\j
 * @param	unsigned int life  LbVێԁij
 * @return	unsigned int 폜t@C
*/
unsigned int pahooCache::delCache(string pat, unsigned int life) {
	int cnt = 0;
	string fullname;
	struct stat st;
	smatch mt;
	regex re(pat);

	// ݎ(UTC)
	time_t t;
	time(&t);
	std::tm* localTime = std::localtime(&t); 
	// ݎ([J)
	std::time_t localEpoch = std::mktime(localTime);

	// fBNg
	DIR *dp;
	dp = opendir(this->dirCache.c_str());
	if (dp == NULL) {
		return 0;
	}
	dirent* entry = readdir(dp);
	while (entry != NULL){
		if (entry != NULL) {
			string fname = (string)entry->d_name;
			// patɈvt@C
			if (regex_search(fname, mt, re)) {
				fullname = this->dirCache + fname;
				if (stat(fullname.c_str(), &st) == 0) {
					// ێԂ߂LbVEt@C͍폜
					if ((long unsigned int)localEpoch - (long unsigned int)st.st_mtime > (life * 60)) {
						unlink(fullname.c_str());
						cnt++;
					}
				}
			}
		}
		entry = readdir(dp);
	}
	closedir(dp);

	return cnt;
}

/**
 * cURLɂRec擾
 * @param	string url URL
 * @param	string* contents Reci[
 * @return	bool TRUEFǂݍݐ^FALSEFs
*/
bool pahooCache::cLoad(string url, string* contents) {
	int httpStatus = 0;
	bool res = readWebContents(url, (const string)this->userAgent, contents, &httpStatus);
	if (res == FALSE) {
		this->errmsg  = _SW("\"") + _SW(url) + _SW("\" 擾ł܂");
		return FALSE;
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		this->errmsg = _SW("yn@WIR[fBOAPI̐ڑG[܂iHTTPXe[^XR[h" + to_string(httpStatus) + "j");
		return FALSE;
	}
	return TRUE;
}

/**
 * MD5nbVlԂ
 * @param	string str 
 * @return	string MD5nbVl
*/
string pahooCache::md5(string str) {
	boost::uuids::detail::md5 hash;
	md5::digest_type digest;
	hash.process_bytes(str.data(), str.size());
	hash.get_digest(digest);

	const auto intDigest = reinterpret_cast<const int *>(&digest);
	std::string result;
	boost::algorithm::hex(intDigest, intDigest + (sizeof(md5::digest_type) / sizeof(int)), std::back_inserter(result));

	return result;
}

/**
 * lbgRecǂݍ
 * @param	string url   URL
 * @param	string* contents Reci[
 * @return	bool TRUEFǂݍݐ^FALSEFs
*/
bool pahooCache::forceLoad(string url, string* contents) {
	// LbVt@C
	string fname = this->md5(url);
	string fullname = this->dirCache + fname;

	bool ret = this->cLoad(url, contents);
	ofstream fout;
	fout.open(fullname, ios::out);
	fout << *contents;

	if (ret == FALSE) {
		return FALSE;
	}
	this->debug += url + "\n";

	return TRUE;
}

/**
 * Recǂݍ
 * @param	string url   URL
 * @param	string* contents Reci[
 * @return	bool TRUEFǂݍݐ^FALSEFs
*/
bool pahooCache::load(string url, string* contents) {
	bool res = FALSE;
	string fname, fullname;
	string buff;
	ifstream fin;

	// LbVL
	if (this->lifeCache > 0) {
		this->delCache("[0-9a-f]+", this->lifeCache);	// ÂLbV폜
		fname = this->md5(url);						// LbVt@C
		fullname = this->dirCache + fname;
		// LbV݂
		*contents = "";
		fin.open(fullname, ios::binary);
		if (fin) {
//			cout << "from file: " << fname << endl;
			getline(fin, *contents, '\0');
			if (contents->length() <= 0) {
				this->errmsg = _SW("LbVt@C \"") + _SW(fullname) + _SW("\" ̓ǂݍ݂Ɏs܂");
//				cout << _WS(this->errmsg) << endl;
				return FALSE;
			}
			this->debug += fname + "\n";
			res = TRUE;
		// lbg擾
		} else {
//			cout << "from URL: " << url << endl;
			res = this->forceLoad(url, contents);
		}

	// LbV
	} else {
//		cout << "uncache from URL: " << url << endl;
		res = this->forceLoad(url, contents);
	}

	return res;
}

/*
 ** o[WAbv =====================================================
 *
 * @version 1.1.0 2025/03/16 sC
 * @version 1.0   2021/04/14 
 */
