#ifndef WEBBROWSER_H
#define WEBBROWSER_H
#include <tchar.h>


/**************************************************\
Control class by:	Mr. Ali Imran (apitalk.com)
Backbone DLL by: 	Mr. Jeff Glatt (codeproject.com)
Support: support@apitalk.com
Usage Rights : NONE
Copyrights Limited to this resources 
\**************************************************/

typedef long WINAPI EmbedBrowserObjectPtr(HWND);
typedef long WINAPI UnEmbedBrowserObjectPtr(HWND);
typedef long WINAPI DisplayHTMLPagePtr(HWND, LPCTSTR);
typedef long WINAPI DisplayHTMLStrPtr(HWND, LPCTSTR);

BOOL CALLBACK WebBrowserPProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

class WebBrowser {
	static bool dll_loaded;
	HINSTANCE cwebdll; 
	EmbedBrowserObjectPtr		*lpEmbedBrowserObject;
	UnEmbedBrowserObjectPtr		*lpUnEmbedBrowserObject;
	DisplayHTMLPagePtr			*lpDisplayHTMLPage;
	DisplayHTMLStrPtr			*lpDisplayHTMLStr;
    
    HWND control,parent;	
	
	void loadOnce() {
		if(dll_loaded) return;
		cwebdll = LoadLibrary(_T("cwebpage.dll")); 
		if(cwebdll) {
			lpEmbedBrowserObject = (EmbedBrowserObjectPtr *)GetProcAddress((HINSTANCE)cwebdll, "EmbedBrowserObject");
			lpUnEmbedBrowserObject = (UnEmbedBrowserObjectPtr *)GetProcAddress((HINSTANCE)cwebdll, "UnEmbedBrowserObject");
			lpDisplayHTMLPage = (DisplayHTMLPagePtr *)GetProcAddress((HINSTANCE)cwebdll, "DisplayHTMLPage");
			lpDisplayHTMLStr = (DisplayHTMLStrPtr *)GetProcAddress((HINSTANCE)cwebdll, "DisplayHTMLStr");   
			
			if(!lpEmbedBrowserObject || !lpUnEmbedBrowserObject || !lpDisplayHTMLPage || !lpDisplayHTMLStr)
				return;
						    
			dll_loaded=1;
		}	
	}
      
	public:
		WebBrowser() {
			loadOnce();
		}
		WebBrowser(char *basic,int x,int y, int w, int h, HWND &par, int exStyle=WS_EX_CLIENTEDGE) {
           create(basic,x,y,w,h,par,exStyle);
		}
		void create(char *basic,int x,int y, int w, int h, HWND &par, int exStyle=WS_EX_CLIENTEDGE) {
		   loadOnce();
		   parent=par;
		   control = CreateWindowEx(
                     0,WC_DIALOG,NULL,
                     WS_VISIBLE | WS_CHILD | WS_CLIPCHILDREN,
                     x,y,w,h,parent,NULL,NULL,NULL
           );
           if(control) {
                SetWindowLongA(control, DWLP_DLGPROC, (WPARAM)WebBrowserPProc);   
                SetWindowLongA(control, GWLP_USERDATA, (WPARAM)this);  
                if ((*lpEmbedBrowserObject)(control)) return; 
                HWND br = FindWindowEx(control, NULL,NULL,NULL);
                if(br) {
			      //SetWindowLong(br, GWL_EXSTYLE, exStyle);
			      //SetWindowPos(br, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED|SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER);	                       
                }
           }             
        }
		void resize(int w, int h) {
                 MoveWindow(control,0,0,w,h,true);
			     UpdateWindow(control);               
        }
        void move(int x, int y) {
		   RECT rcWindow;
		   GetWindowRect(control, &rcWindow);
           MoveWindow(control,x,y,x+rcWindow.right,y+rcWindow.bottom,true);
		   UpdateWindow(control);               
        }
        void fitToParent() {
		   RECT rcWindow;
		   GetClientRect(parent, &rcWindow);
           MoveWindow(control,0,0,rcWindow.right,rcWindow.bottom,true);
		   UpdateWindow(control);             
        }
        void setString(char *_txt) {
             (*lpDisplayHTMLStr)(control,(LPCTSTR)_txt);
        }
        void loadPage(char *_url) {
             (*lpDisplayHTMLPage)(control,(LPCTSTR)_url);
        }
		
		~WebBrowser() {
			if(control)
			           (*lpUnEmbedBrowserObject)(control);
            if(dll_loaded)
			              FreeLibrary(cwebdll);
		}
             
};
bool WebBrowser::dll_loaded(0);

BOOL CALLBACK WebBrowserPProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam) {
    WebBrowser *me = reinterpret_cast<WebBrowser*>(GetWindowLongA(hwnd,GWLP_USERDATA));
    if(message == WM_SIZE) {
            HWND br = FindWindowEx(hwnd, NULL,NULL,NULL);
            if(br){
                 MoveWindow(br,0,0,LOWORD(lParam),HIWORD(lParam),true);
			     UpdateWindow(br);                 
            }               
    }	
	return 0; 
}

#endif
