/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.ne.sk_mine.util.SettingsBase;

public class LocalSettings
extends SettingsBase {
    private boolean mIsAvailable;
    private String mFilename = "setting.properties";
    private Map<String, String> mParamMap = new HashMap<String, String>();

    @Override
    public void setFilename(String filename) {
        this.mFilename = filename;
    }

    @Override
    public void addCommonName(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        this.mIsAvailable = true;
        this.mParamMap.clear();
        File file = new File(this.mFilename);
        if (!file.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                String[] tokens;
                if (line.charAt(0) == '#' || (tokens = line.split("=")).length < 2) continue;
                String name = tokens[0];
                String value = tokens[1];
                if (2 < tokens.length) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(tokens[1]);
                    for (int i = 2; i < tokens.length; ++i) {
                        buf.append("=");
                        buf.append(tokens[i]);
                    }
                    value = buf.toString();
                }
                this.mParamMap.put(name, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (!this.mIsAvailable) {
            return;
        }
        try (PrintWriter writer = null;){
            StringBuilder buf = new StringBuilder();
            for (Map.Entry<String, String> entry : this.mParamMap.entrySet()) {
                buf.append(entry.getKey());
                buf.append("=");
                buf.append(entry.getValue());
                buf.append("\n");
            }
            writer = new PrintWriter(new FileWriter(this.mFilename));
            writer.write(buf.toString());
            writer.flush();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.mIsAvailable;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    @Override
    public String get(String name, String defaultValue) {
        if (!this.mIsAvailable) {
            return defaultValue;
        }
        if (this.mParamMap.containsKey(name)) {
            return this.mParamMap.get(name);
        }
        return defaultValue;
    }

    @Override
    public String[] getKeys(String commonName) {
        Iterator<String> keys = this.mParamMap.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (keys.hasNext()) {
            String key = keys.next();
            if (commonName != null && !commonName.equals("") && !key.startsWith(commonName)) continue;
            list.add(key);
        }
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (String)list.get(i);
        }
        return ret;
    }

    @Override
    public void set(String name, String value) {
        if (!this.mIsAvailable) {
            return;
        }
        this.mParamMap.put(name, value);
    }

    @Override
    public void remove(String name) {
        this.mParamMap.remove(name);
    }

    @Override
    public void clear(String commonName) {
        Iterator<String> keys = this.mParamMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            if (commonName != null && !commonName.equals("") && !key.startsWith(commonName)) continue;
            keys.remove();
        }
    }
}

