/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKMMath;

public abstract class SKMCTool {
    private static String[] sKeys = new String[]{"GPCq35oTLBOXyvi29RdwkbplsmKnxZuN6aD8U0YHtShJVM4e7f1", "xWYi5Ez1doBUhsZSM207raVujmRXwKyD6tlGeQTNcJIvkCOpgF3", "czx6ro1FCfZy8n3BUXGbgNsP9SweqYtKAHmkuadWI2EJiQ5pDvl", "NwPjatQH8rS1VTn9XlFhUukAMB4emEbdW73xsKpqYfZIyzJR5cD", "iblWOLd4Rx3yNgaQHhDBoYcvwPIMe5XK29fsqJGzmZj07Au1SU6", "1TnLhExPlsMcBpdXU9v8uYy2NGIjrCfo7eVJDqkz4WZgOQbA0wt", "fnLOFlYDisWzaHm4ycGIXKjxVCdM07Uo5Qp8gkbrtAE16STRh3e", "PxtEAsoLX3r0udFIY1hT6eHgBCOnZJwSl2ikpRaW8j5UGc9MbvK", "O9rtsXDo6VmcuCJI8inx4FG3lT5KBWkpjSqPgQLdY72zywfN0aU", "arfPWHNGD0SVJO7wuEoAv4dTijMnQRB6zqCs5x2LlpKcmFYIyg1", "9NCLQES3rUMHdjTFymeknh5Glgox16IRYzvcZWD47sOb8iVXKJa", "DKPTgrIwEQmpAi9Ze5tdVl3LBY6Mvhqxu7UNR28fcs1z4GabJyW"};

    public static String getRandomNumber() {
        char[] marks = new char[]{'!', '#', '$', '%', '&', '(', ')', '-', '=', '^', '~', '|', '[', '{', ']', '}', '@', ':', ';', '_', '/', '?', '>', ' '};
        int[] n = new int[62 + marks.length];
        for (int i = 0; i < n.length; ++i) {
            n[i] = i;
        }
        int[] s = SKMMath.shuffle(n);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (s[i] < 26) {
                buf.append((char)(97 + s[i]));
                continue;
            }
            if (s[i] < 52) {
                buf.append((char)(65 + (s[i] - 26)));
                continue;
            }
            if (s[i] < 62) {
                buf.append((char)(48 + (s[i] - 26 - 26)));
                continue;
            }
            buf.append(marks[s[i] - 26 - 26 - 10]);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        String number = SKMCTool.getRandomNumber();
        String s = "a%9s!d8ja9-w4jgbBjSDB(oi4jWEaoi4>3lkbjlkzdfj9iobqw3r18JBV89SD";
        System.out.println("number   : " + number);
        System.out.println("base str : " + s);
        String encrypted = SKMCTool.encrypt(s, number);
        System.out.println("encrypted: " + encrypted);
        try {
            String decrypted = SKMCTool.decrypt(encrypted, number);
            System.out.println("decrypted: " + decrypted);
            System.out.println("isCorrect: " + s.equals(decrypted));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final String encrypt(String str, String number) {
        if (str == null || number == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        String key = sKeys[number.charAt(0) % sKeys.length];
        int keyLen = key.length();
        int numberLen = number.length();
        int baseLen = str.length();
        StringBuilder crypted = new StringBuilder();
        int parity = 0;
        for (int i = 0; i < baseLen; ++i) {
            char b = str.charAt(i);
            char k = key.charAt(i % keyLen);
            int kn = 0;
            int bn = 0;
            for (int j = 0; j < numberLen; ++j) {
                if (number.charAt(j) == k) {
                    kn = j;
                }
                if (number.charAt(j) != b) continue;
                bn = j;
            }
            char n = number.charAt((bn + kn) % numberLen);
            crypted.append(n);
            parity += i % 2 == 0 ? n : -n;
        }
        if (parity < 0) {
            parity *= -1;
        }
        crypted.insert(0, str.charAt(0));
        crypted.insert(0, number.charAt(parity % numberLen));
        return crypted.toString();
    }

    public static final String decrypt(String encrypted, String number) throws Exception {
        if (encrypted == null || number == null) {
            return null;
        }
        if (encrypted.length() == 0) {
            return "";
        }
        String key = sKeys[number.charAt(0) % sKeys.length];
        int keyLen = key.length();
        int numberLen = number.length();
        int strLen = encrypted.length();
        StringBuilder decrypted = new StringBuilder();
        int parity = 0;
        for (int i = 2; i < strLen; ++i) {
            char s = encrypted.charAt(i);
            char k = key.charAt((i - 2) % keyLen);
            int kn = 0;
            int sn = 0;
            for (int j = 0; j < numberLen; ++j) {
                if (number.charAt(j) == k) {
                    kn = j;
                }
                if (number.charAt(j) != s) continue;
                sn = j;
            }
            char n = number.charAt((sn - kn + numberLen) % numberLen);
            decrypted.append(n);
            char p = encrypted.charAt(i);
            parity += i % 2 == 0 ? p : -p;
        }
        if (parity < 0) {
            parity *= -1;
        }
        if (number.charAt(parity % numberLen) != encrypted.charAt(0)) {
            throw new Exception("invalid cdata");
        }
        return decrypted.toString();
    }
}

