/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.sk_mine.util.andr_applet;

import jp.ne.sk_mine.util.andr_applet.SKM;
import jp.ne.sk_mine.util.andr_applet.SKMButton;
import jp.ne.sk_mine.util.andr_applet.SKMFont;
import jp.ne.sk_mine.util.andr_applet.SKMGraphics;
import jp.ne.sk_mine.util.andr_applet.SKMImage;
import jp.ne.sk_mine.util.andr_applet.SKMUtil;

public class SKMCheckBox
extends SKMButton {
    protected boolean mIsSelected;
    protected int mGapW;
    protected SKMImage mOnImage;
    protected SKMImage mOffImage;

    public SKMCheckBox(String text) {
        this(text, -100, -100, false, null);
    }

    public SKMCheckBox(String text, boolean isCenter) {
        this(text, -100, -100, isCenter, null);
    }

    public SKMCheckBox(String text, int x, int y, boolean isCenter) {
        this(text, x, y, isCenter, null);
    }

    public SKMCheckBox(String text, boolean isCenter, SKMFont font) {
        this(text, -100, -100, isCenter, font);
    }

    public SKMCheckBox(String text, int x, int y, boolean isCenter, SKMFont font) {
        super(text, x, y, isCenter, font);
        String basePath = SKMImage.getBasePath();
        SKMImage.setBasePath(null);
        String imagePath = "jp/ne/sk_mine/util/andr_applet/res/image/";
        this.mOnImage = new SKMImage("jp/ne/sk_mine/util/andr_applet/res/image/check_on.png");
        this.mOffImage = new SKMImage("jp/ne/sk_mine/util/andr_applet/res/image/check_off.png");
        this.mGapW = 8;
        this.mWidth += this.mOnImage.getWidth() + (text == null || text.equals("") ? 0 : this.mGapW);
        this.mHeight = this.mOnImage.getHeight();
        SKMImage.setBasePath(basePath);
    }

    @Deprecated
    public SKMCheckBox(String text, int x, int y, boolean isCenter, SKMFont font, SKMGraphics g) {
        this(text, x, y, isCenter, font);
    }

    public void setImages(SKMImage onImage, SKMImage offImage) {
        this.mOnImage = onImage;
        this.mOffImage = offImage;
        SKMGraphics g = SKM.getGraphics();
        if (this.mFont != null) {
            g.setFont(this.mFont);
        }
        this.mWidth = g.stringWidth(this.mText) + onImage.getWidth() + (this.mText == null || this.mText.equals("") ? 0 : this.mGapW);
        this.mHeight = onImage.getHeight();
    }

    @Override
    public void setFont(SKMFont font) {
        super.setFont(font);
        if (this.mOnImage != null) {
            this.mWidth += this.mOnImage.getWidth() + (this.mText == null || this.mText.equals("") ? 0 : this.mGapW);
        }
    }

    public void setSelected(boolean f) {
        this.mIsSelected = f;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    @Override
    public boolean isHit(double x, double y, boolean isPress, boolean isJudgeOnly) {
        boolean ret = super.isHit(x, y, isPress, isJudgeOnly);
        if (isPress && ret && !isJudgeOnly) {
            this.setSelected(!this.isSelected());
        }
        return ret;
    }

    @Override
    protected void myPaint(SKMGraphics g) {
        if (this.mImage != null) {
            if (this.mIsPressed && this.mPressedImage != null) {
                g.drawImage(this.mPressedImage, this.mX + this.mOnImage.getWidth(), this.mY);
            } else {
                g.drawImage(this.mImage, this.mX + this.mOnImage.getWidth(), this.mY);
            }
        }
        if (this.mText != null) {
            if (this.mFont != null) {
                g.setFont(this.mFont);
            }
            if (this.mIsEnabled) {
                if (this.mTextColor != null) {
                    g.setColor(this.mTextColor);
                }
            } else if (this.mDisabledTextColor != null) {
                g.setColor(this.mDisabledTextColor);
            }
            this.paintText(g);
        }
        g.drawImage(this.mIsSelected ? this.mOnImage : this.mOffImage, this.mX, this.mY + this.mHeight / 2 - this.mOnImage.getHeight() / 2);
        if (this.mIsDrawFrame) {
            this.paintRoundFrame(g);
        }
    }

    @Override
    protected void paintText(SKMGraphics g) {
        int lineH = SKMUtil.toInt(1.3 * (double)this.mFont.getSize());
        int baseCx = this.mX + this.mOnImage.getWidth() + this.mGapW;
        int topCy = this.mY + this.mHeight / 2 - SKMUtil.toInt(this.mTexts.length / 2) * lineH / 2;
        for (int i = this.mTexts.length - 1; 0 <= i; --i) {
            g.drawCenteringString(this.mTexts[i], baseCx + g.stringWidth(this.mTexts[i]) / 2, topCy + i * lineH);
        }
    }
}

